/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap;

import com.bbn.openmap.Layer;
import com.bbn.openmap.MapBeanRepaintPolicy;
import com.bbn.openmap.SoloMapComponent;
import com.bbn.openmap.StandardMapBeanRepaintPolicy;
import com.bbn.openmap.event.CenterEvent;
import com.bbn.openmap.event.CenterListener;
import com.bbn.openmap.event.LayerEvent;
import com.bbn.openmap.event.LayerListener;
import com.bbn.openmap.event.PaintListener;
import com.bbn.openmap.event.PaintListenerSupport;
import com.bbn.openmap.event.PanEvent;
import com.bbn.openmap.event.PanListener;
import com.bbn.openmap.event.ProjectionChangeVetoException;
import com.bbn.openmap.event.ProjectionEvent;
import com.bbn.openmap.event.ProjectionListener;
import com.bbn.openmap.event.ProjectionSupport;
import com.bbn.openmap.event.ZoomEvent;
import com.bbn.openmap.event.ZoomListener;
import com.bbn.openmap.geo.Geo;
import com.bbn.openmap.proj.Mercator;
import com.bbn.openmap.proj.Proj;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.proj.ProjectionFactory;
import com.bbn.openmap.proj.coords.LatLonPoint;
import com.bbn.openmap.util.Debug;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.beans.Beans;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.OverlayLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapBean
extends JComponent
implements ComponentListener,
ContainerListener,
ProjectionListener,
PanListener,
ZoomListener,
LayerListener,
CenterListener,
SoloMapComponent {
    private static Logger logger = Logger.getLogger(MapBean.class.getName());
    public static final String LayersProperty = "MapBean.layers";
    public static final String CursorProperty = "MapBean.cursor";
    public static final String BackgroundProperty = "MapBean.background";
    public static final String ProjectionProperty = "MapBean.projection";
    public static final String ProjectionVetoedProperty = "MapBean.projectionVetoed";
    public static final String title = "OpenMap(tm)";
    public static final String version = "5.1.3";
    public static boolean suppressCopyright = false;
    private static boolean DEBUG_TIMESTAMP = false;
    private static boolean DEBUG_THREAD = true;
    private static final String copyrightNotice = "OpenMap(tm) Version 5.1.3\r\n  Copyright (C) BBNT Solutions LLC.  All rights reserved.\r\n  See http://code.google.com/p/openmap/ for details.\r\n";
    public static final float DEFAULT_CENTER_LAT = 0.0f;
    public static final float DEFAULT_CENTER_LON = 0.0f;
    public static final float DEFAULT_SCALE = Float.MAX_VALUE;
    public static final int DEFAULT_WIDTH = 640;
    public static final int DEFAULT_HEIGHT = 480;
    protected int minHeight = 100;
    protected int minWidth = 100;
    protected Proj projection = new Mercator(new LatLonPoint.Double(0.0, 0.0), Float.MAX_VALUE, 640, 480);
    protected ProjectionSupport projectionSupport;
    protected Vector<Layer> removedLayers = new Vector(0);
    protected boolean layerRemovalDelayed = true;
    protected Vector<Layer> addedLayers = new Vector(0);
    protected PaintListenerSupport painters = null;
    protected Paint background = null;
    protected MapBeanRepaintPolicy repaintPolicy = null;
    protected double rotationAngle = 0.0;
    public static final Color DEFAULT_BACKGROUND_COLOR = new Color(191, 239, 255);
    private static final transient Insets insets = new Insets(0, 0, 0, 0);
    protected transient Layer[] currentLayers = new Layer[0];
    protected transient boolean doContainerChange = true;
    protected ProjectionFactory projectionFactory;
    protected RotationHelper rotHelper;

    public static String getCopyrightMessage() {
        return copyrightNotice;
    }

    public MapBean() {
        this(true);
    }

    public MapBean(boolean useThreadedNotification) {
        if (logger.isLoggable(Level.FINE)) {
            this.debugmsg("MapBean()");
        }
        if (!suppressCopyright) {
            Debug.output(copyrightNotice);
        }
        this.background = DEFAULT_BACKGROUND_COLOR;
        suppressCopyright = true;
        super.setLayout(new OverlayLayout(this));
        this.projectionSupport = new ProjectionSupport(this, useThreadedNotification);
        this.addComponentListener(this);
        this.addContainerListener(this);
        if (Beans.isDesignTime()) {
            this.add(new Layer(){

                public void projectionChanged(ProjectionEvent e) {
                }

                public Dimension getPreferredSize() {
                    return new Dimension(100, 100);
                }
            });
        }
        this.setPreferredSize(new Dimension(this.projection.getWidth(), this.projection.getHeight()));
        DEBUG_TIMESTAMP = logger.isLoggable(Level.FINER);
        DEBUG_THREAD = logger.isLoggable(Level.FINER);
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "@" + Integer.toHexString(this.hashCode());
    }

    public void dispose() {
        this.setLayerRemovalDelayed(false);
        if (this.projectionSupport != null) {
            this.projectionSupport.dispose();
            this.projectionSupport = null;
        }
        if (this.painters != null) {
            this.painters.clear();
            this.painters = null;
        }
        if (this.addedLayers != null) {
            this.addedLayers.removeAllElements();
            this.addedLayers = null;
        }
        this.currentLayers = null;
        this.projectionFactory = null;
        this.removeComponentListener(this);
        this.removeContainerListener(this);
        this.removeAll();
        this.purgeAndNotifyRemovedLayers();
    }

    @Override
    protected final void addImpl(Component comp, Object constraints, int index) {
        if (!(comp instanceof Layer)) {
            throw new IllegalArgumentException("only Layers can be added to a MapBean");
        }
        super.addImpl(comp, constraints, index);
    }

    @Override
    public final void setLayout(LayoutManager mgr) {
        throw new IllegalArgumentException("cannot change layout of Map");
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(this.minWidth, this.minHeight);
    }

    @Override
    public void setMinimumSize(Dimension dim) {
        this.minWidth = (int)dim.getWidth();
        this.minHeight = (int)dim.getHeight();
    }

    @Override
    public final Insets getInsets() {
        return insets;
    }

    @Override
    public void componentResized(ComponentEvent e) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Size changed: " + this.getWidth() + " x " + this.getHeight());
        }
        this.projection.setWidth(this.getWidth());
        this.projection.setHeight(this.getHeight());
        this.fireProjectionChanged();
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    public synchronized void addProjectionListener(ProjectionListener l) {
        block2: {
            this.projectionSupport.add(l);
            try {
                l.projectionChanged(new ProjectionEvent(this, this.getRotatedProjection()));
            }
            catch (Exception e) {
                if (!logger.isLoggable(Level.FINER)) break block2;
                logger.fine("ProjectionListener not handling projection well: " + l.getClass().getName() + " : " + e.getClass().getName() + " : " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    public synchronized void removeProjectionListener(ProjectionListener l) {
        this.projectionSupport.remove(l);
    }

    protected void fireProjectionChanged() {
        Projection proj = this.getRotatedProjection();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("MapBean firing projection: " + proj);
        }
        try {
            this.firePropertyChange(ProjectionProperty, null, proj);
        }
        catch (ProjectionChangeVetoException pcve) {
            this.firePropertyChange(ProjectionVetoedProperty, proj, pcve);
            pcve.updateWithParameters(this);
            return;
        }
        this.projectionSupport.fireProjectionChanged(proj);
        this.purgeAndNotifyRemovedLayers();
    }

    public void purgeAndNotifyRemovedLayers() {
        if (this.removedLayers.isEmpty()) {
            return;
        }
        for (int i = 0; i < this.removedLayers.size(); ++i) {
            Layer l = this.removedLayers.elementAt(i);
            l.removed(this);
        }
        this.removedLayers.removeAllElements();
        if (Debug.debugging("helpgc")) {
            System.gc();
        }
    }

    public float getScale() {
        return this.projection.getScale();
    }

    public void setScale(float newScale) {
        this.projection.setScale(newScale);
        this.fireProjectionChanged();
    }

    public Point2D getCenter() {
        return this.projection.getCenter();
    }

    public void setCenter(Point2D newCenter) {
        this.projection.setCenter(newCenter);
        this.fireProjectionChanged();
    }

    public void setCenter(double lat, double lon) {
        this.projection.setCenter(new Point2D.Double(lon, lat));
        this.fireProjectionChanged();
    }

    public void setCenter(float lat, float lon) {
        this.setCenter((double)lat, (double)lon);
    }

    public void setBackgroundColor(Color color) {
        this.setBackground(color);
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        this.setBckgrnd(color);
    }

    @Override
    public void paintBorder(Graphics g) {
        g.setPaintMode();
        super.paintBorder(g);
    }

    public void setBckgrnd(Paint paint) {
        this.setBufferDirty(true);
        Paint oldBackground = this.background;
        this.background = paint;
        this.firePropertyChange(BackgroundProperty, oldBackground, this.background);
        this.repaint();
    }

    @Override
    public Color getBackground() {
        Paint ret = this.getBckgrnd();
        if (ret instanceof Color) {
            return (Color)ret;
        }
        return super.getBackground();
    }

    public Paint getBckgrnd() {
        Paint ret = this.background;
        if (ret == null) {
            ret = super.getBackground();
        }
        return ret;
    }

    public Projection getProjection() {
        return this.projection;
    }

    public Projection getRotatedProjection() {
        RotationHelper rotation = this.getUpdatedRotHelper();
        Projection proj = rotation != null ? rotation.getProjection() : this.projection;
        ((Proj)proj).setRotationAngle(this.getRotationAngle());
        return proj;
    }

    public void setProjection(Projection aProjection) {
        if (aProjection != null && !aProjection.getProjectionID().contains("NaN")) {
            this.setBufferDirty(true);
            this.projection = (Proj)aProjection;
            this.setPreferredSize(new Dimension(this.projection.getWidth(), this.projection.getHeight()));
            this.fireProjectionChanged();
        }
    }

    @Override
    public void center(CenterEvent evt) {
        this.setCenter(evt.getLatitude(), evt.getLongitude());
    }

    @Override
    public void pan(PanEvent evt) {
        if (logger.isLoggable(Level.FINE)) {
            this.debugmsg("PanEvent: " + evt);
        }
        float az = evt.getAzimuth() - (float)Math.toDegrees(this.rotationAngle);
        float c = evt.getArcDistance();
        if (Float.isNaN(c)) {
            this.projection.pan(az);
        } else {
            this.projection.pan(az, c);
        }
        this.fireProjectionChanged();
    }

    @Override
    public void zoom(ZoomEvent evt) {
        float newScale;
        if (evt.isAbsolute()) {
            newScale = evt.getAmount();
        } else if (evt.isRelative()) {
            newScale = this.getScale() * evt.getAmount();
        } else {
            return;
        }
        this.setScale(newScale);
    }

    public void setDoContainerChange(boolean value) {
        if (!this.doContainerChange && value) {
            this.doContainerChange = value;
            this.changeLayers(null);
        } else {
            this.doContainerChange = value;
        }
    }

    public boolean getDoContainerChange() {
        return this.doContainerChange;
    }

    @Override
    public void componentAdded(ContainerEvent e) {
        Layer childLayer = (Layer)e.getChild();
        this.addProjectionListener(childLayer);
        if (!this.removedLayers.removeElement(childLayer)) {
            this.addedLayers.addElement(childLayer);
        }
        this.changeLayers(e);
    }

    @Override
    public void componentRemoved(ContainerEvent e) {
        Layer childLayer = (Layer)e.getChild();
        this.removeProjectionListener(childLayer);
        this.removedLayers.addElement(childLayer);
        this.changeLayers(e);
    }

    protected void changeLayers(ContainerEvent e) {
        if (!this.doContainerChange) {
            return;
        }
        Component[] comps = this.getComponents();
        int ncomponents = comps.length;
        Layer[] newLayers = new Layer[ncomponents];
        System.arraycopy(comps, 0, newLayers, 0, ncomponents);
        if (logger.isLoggable(Level.FINE)) {
            this.debugmsg("changeLayers() - firing change");
        }
        this.firePropertyChange(LayersProperty, this.currentLayers, newLayers);
        for (int i = 0; i < this.addedLayers.size(); ++i) {
            this.addedLayers.elementAt(i).added(this);
        }
        this.addedLayers.removeAllElements();
        this.currentLayers = newLayers;
    }

    @Override
    public void projectionChanged(ProjectionEvent e) {
        Projection newProj = e.getProjection();
        if (!this.projection.equals(newProj)) {
            this.setProjection(newProj);
        }
    }

    @Override
    public void setCursor(Cursor newCursor) {
        this.firePropertyChange(CursorProperty, this.getCursor(), newCursor);
        super.setCursor(newCursor);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        super.addPropertyChangeListener(pcl);
        pcl.propertyChange(new PropertyChangeEvent(this, LayersProperty, this.currentLayers, this.currentLayers));
        pcl.propertyChange(new PropertyChangeEvent(this, CursorProperty, this.getCursor(), this.getCursor()));
        pcl.propertyChange(new PropertyChangeEvent(this, BackgroundProperty, this.getBckgrnd(), this.getBckgrnd()));
    }

    protected final void debugmsg(String msg) {
        logger.fine(this.toString() + (DEBUG_TIMESTAMP ? " [" + System.currentTimeMillis() + "]" : "") + (DEBUG_THREAD ? " [" + Thread.currentThread() + "]" : "") + ": " + msg);
    }

    @Override
    public void paint(Graphics g) {
        if (this.projection != null) {
            this.drawProjectionBackground(g);
        }
        if (this.getComponentCount() > 0) {
            this.paintChildren(g, null);
        }
        this.paintPainters(g);
        this.paintBorder(g);
    }

    protected void drawProjectionBackground(Graphics g) {
        if (g instanceof Graphics2D) {
            this.projection.drawBackground((Graphics2D)g, this.getBckgrnd());
        } else {
            g.setColor(this.getBackground());
            this.projection.drawBackground(g);
        }
    }

    @Override
    public void paintChildren(Graphics g) {
        this.paintChildren(g, null);
        this.paintPainters(g);
    }

    public void paintPainters(Graphics g) {
        RotationHelper rotationHelper = this.getRotHelper();
        if (this.painters != null) {
            if (rotationHelper != null) {
                rotationHelper.paintPainters(g);
            } else {
                this.painters.paint(g);
            }
        }
    }

    public void paintChildren(Graphics g, Rectangle clip) {
        g = this.getMapBeanRepaintPolicy().modifyGraphicsForPainting(g);
        this.drawProjectionBackground(g);
        if (this.rotHelper != null) {
            this.rotHelper.paintChildren(g, clip);
        } else {
            super.paintChildren(g);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintLayers(Graphics g) {
        Object object = this.getTreeLock();
        synchronized (object) {
            int i;
            if (i < 0) {
                return;
            }
            for (i = this.getComponentCount() - 1; i >= 0; --i) {
                Component comp = this.getComponent(i);
                boolean isLayer = comp instanceof Layer;
                if (!isLayer || !comp.isVisible()) continue;
                comp.paint(g);
            }
        }
    }

    public Graphics getGraphics(boolean rotateIfSet) {
        if (rotateIfSet && this.rotHelper != null) {
            return this.rotHelper.getGraphics();
        }
        return super.getGraphics();
    }

    public void paintChildrenWithBorder(Graphics g, boolean drawBorder) {
        this.paintChildren(g);
        if (drawBorder) {
            this.paintBorder(g);
        }
    }

    public synchronized void addPaintListener(PaintListener l) {
        if (this.painters == null) {
            this.painters = new PaintListenerSupport(this);
        }
        this.painters.add(l);
    }

    public synchronized void removePaintListener(PaintListener l) {
        if (this.painters == null) {
            return;
        }
        this.painters.remove(l);
        if (this.painters.isEmpty()) {
            this.painters = null;
        }
    }

    @Override
    public void setLayers(LayerEvent evt) {
        this.setBufferDirty(true);
        Layer[] layers = evt.getLayers();
        int type = evt.getType();
        if (type == 403) {
            return;
        }
        if (layers == null) {
            if (logger.isLoggable(Level.FINE)) {
                this.debugmsg("MapBean.setLayers(): layers is null!");
            }
            return;
        }
        boolean oldChange = this.getDoContainerChange();
        this.setDoContainerChange(false);
        if (type == 402) {
            if (logger.isLoggable(Level.FINE)) {
                this.debugmsg("Replacing all layers");
            }
            this.removeAll();
            for (int i = 0; i < layers.length; ++i) {
                if (layers[i] == null) {
                    if (!logger.isLoggable(Level.FINE)) continue;
                    this.debugmsg("MapBean.setLayers(): layer " + i + " is null");
                    continue;
                }
                if (logger.isLoggable(Level.FINE)) {
                    this.debugmsg("Adding layer[" + i + "]= " + layers[i].getName());
                }
                this.add(layers[i]);
                layers[i].setVisible(true);
            }
        } else if (type == 400) {
            if (logger.isLoggable(Level.FINE)) {
                this.debugmsg("Adding new layers");
            }
            for (int i = 0; i < layers.length; ++i) {
                if (logger.isLoggable(Level.FINE)) {
                    this.debugmsg("Adding layer[" + i + "]= " + layers[i].getName());
                }
                this.add(layers[i]);
                layers[i].setVisible(true);
            }
        } else if (type == 401) {
            if (logger.isLoggable(Level.FINE)) {
                this.debugmsg("Removing layers");
            }
            for (int i = 0; i < layers.length; ++i) {
                if (logger.isLoggable(Level.FINE)) {
                    this.debugmsg("Removing layer[" + i + "]= " + layers[i].getName());
                }
                this.remove(layers[i]);
            }
        }
        if (!this.layerRemovalDelayed) {
            this.purgeAndNotifyRemovedLayers();
        }
        this.setDoContainerChange(oldChange);
        this.revalidate();
        this.repaint();
    }

    public void repaint(Layer layer) {
        this.setBufferDirty(true);
        if (logger.isLoggable(Level.FINER)) {
            String name = layer.getName();
            logger.finer((name == null ? layer.getClass().getName() : name) + " - wants a repaint()");
        }
        this.getMapBeanRepaintPolicy().repaint(layer);
    }

    public void setMapBeanRepaintPolicy(MapBeanRepaintPolicy mbrp) {
        this.repaintPolicy = mbrp;
    }

    public MapBeanRepaintPolicy getMapBeanRepaintPolicy() {
        if (this.repaintPolicy == null) {
            this.repaintPolicy = new StandardMapBeanRepaintPolicy(this);
        }
        return this.repaintPolicy;
    }

    public Point2D getCoordinates(MouseEvent event) {
        return this.getCoordinates(event, null);
    }

    public <T extends Point2D> T getCoordinates(MouseEvent event, T llp) {
        Projection proj = this.getProjection();
        if (proj == null || event == null) {
            return null;
        }
        return this.inverse(event.getX(), event.getY(), llp);
    }

    public Point2D getNonRotatedLocation(MouseEvent event) {
        return this.getNonRotatedLocation(event, null);
    }

    public Point2D getNonRotatedLocation(MouseEvent event, Point2D pnt) {
        if (event == null) {
            return null;
        }
        if (pnt == null) {
            pnt = new Point2D.Double(event.getX(), event.getY());
        } else {
            pnt.setLocation(event.getX(), event.getY());
        }
        if (this.rotHelper != null) {
            pnt = this.rotHelper.inverseTransform(pnt, pnt);
        }
        return pnt;
    }

    public Shape getNonRotatedShape(Shape shape) {
        if (this.rotHelper != null) {
            return this.rotHelper.inverseTransform(shape);
        }
        return shape;
    }

    public <T extends Point2D> T inverse(double x, double y, T ret) {
        return this.rotHelper == null ? this.getProjection().inverse(x, y, ret) : this.rotHelper.inverse(x, y, ret);
    }

    public boolean isBuffered() {
        return false;
    }

    public void setBufferDirty(boolean value) {
    }

    public boolean isBufferDirty() {
        return true;
    }

    public void setLayerRemovalDelayed(boolean set) {
        this.layerRemovalDelayed = set;
    }

    public boolean isLayerRemovalDelayed() {
        return this.layerRemovalDelayed;
    }

    public void showLayerPalettes() {
        for (Component comp : this.getComponents()) {
            Layer l = (Layer)comp;
            if (!l.autoPalette) continue;
            l.showPalette();
        }
    }

    public void hideLayerPalettes() {
        for (Component comp : this.getComponents()) {
            ((Layer)comp).hidePalette();
        }
    }

    public ProjectionFactory getProjectionFactory() {
        if (this.projectionFactory == null) {
            this.projectionFactory = ProjectionFactory.loadDefaultProjections();
        }
        return this.projectionFactory;
    }

    public void setProjectionFactory(ProjectionFactory projFactory) {
        this.projectionFactory = projFactory;
    }

    protected RotationHelper getUpdatedRotHelper() {
        double rotAngle = this.getRotationAngle();
        Projection proj = this.getProjection();
        RotationHelper rotationHelper = this.rotHelper;
        if (rotAngle != 0.0) {
            if (rotationHelper == null) {
                rotationHelper = new RotationHelper(rotAngle, proj);
                this.setRotHelper(rotationHelper);
            } else {
                rotationHelper.updateForBufferDimensions(proj);
                rotationHelper.updateAngle(rotAngle);
            }
        } else if (rotationHelper != null) {
            if (rotationHelper.isStillNeeded(rotAngle)) {
                rotationHelper.updateForBufferDimensions(proj);
                rotationHelper.updateAngle(rotAngle);
            } else {
                this.setRotHelper(null);
                rotationHelper = null;
            }
        }
        return rotationHelper;
    }

    protected RotationHelper getRotHelper() {
        return this.rotHelper;
    }

    protected void setRotHelper(RotationHelper nRotHelper) {
        if (this.rotHelper != null) {
            this.rotHelper.dispose();
        }
        this.rotHelper = nRotHelper;
    }

    public void setRotationAngle(double angle) {
        this.setRotationAngle(angle, false);
    }

    public void setRotationAngle(double angle, boolean fastRotation) {
        if (this.rotationAngle != angle) {
            RotationHelper locRotHelper;
            this.rotationAngle = angle;
            if (fastRotation && angle != 0.0 && (locRotHelper = this.getRotHelper()) != null) {
                locRotHelper.updateAngle(angle);
                this.repaint();
                return;
            }
            this.fireProjectionChanged();
        }
    }

    public double getRotationAngle() {
        return this.rotationAngle;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class RotationHelper {
        Image rotImage;
        double angle;
        Point2D rotCenter;
        int rotBufferHeight;
        int rotBufferWidth;
        int rotXOffset;
        int rotYOffset;
        Projection rotProjection;
        AffineTransform rotTransform;

        private RotationHelper(double angle, Projection currentProjection) {
            this.updateForBufferDimensions(currentProjection);
            this.updateAngle(angle);
        }

        protected boolean updateForBufferDimensions(Projection proj) {
            int currentRotBufferWidth = this.rotBufferWidth;
            int currentRotBufferHeight = this.rotBufferHeight;
            Object center = proj.getCenter();
            Object ul = proj.getUpperLeft();
            Object lr = proj.getLowerRight();
            Geo centerGeo = new Geo(((Point2D)center).getY(), ((Point2D)center).getX());
            Geo ulGeo = new Geo(((Point2D)ul).getY(), ((Point2D)ul).getX());
            Geo lrGeo = new Geo(((Point2D)lr).getY(), ((Point2D)lr).getX());
            double dist = Math.max(centerGeo.distance(ulGeo), centerGeo.distance(lrGeo));
            Geo N = Geo.offset(centerGeo, dist, 0.0);
            Geo S = Geo.offset(centerGeo, dist, Math.PI);
            Geo E = Geo.offset(centerGeo, dist, 1.5707963267948966);
            Geo W = Geo.offset(centerGeo, dist, -1.5707963267948966);
            Point2D.Double newUL = new Point2D.Double(W.getLongitude(), N.getLatitude());
            Point2D.Double newLR = new Point2D.Double(E.getLongitude(), S.getLatitude());
            Point2D newULPix = proj.forward(newUL);
            Point2D newLRPix = proj.forward(newLR);
            int reqRotBufferHeight = (int)Math.abs(newLRPix.getY() - newULPix.getY());
            int reqRotBufferWidth = (int)Math.abs(newLRPix.getX() - newULPix.getX());
            boolean needNewHeightImage = reqRotBufferHeight > currentRotBufferHeight || (double)reqRotBufferHeight < 0.9 * (double)currentRotBufferHeight;
            boolean needNewWidthImage = reqRotBufferWidth > currentRotBufferWidth || (double)currentRotBufferWidth < 0.9 * (double)currentRotBufferWidth;
            boolean bufferImageResized = false;
            if (needNewHeightImage || needNewWidthImage) {
                this.rotImage = new BufferedImage(reqRotBufferWidth, reqRotBufferHeight, 2);
                this.rotBufferWidth = reqRotBufferWidth;
                this.rotBufferHeight = reqRotBufferHeight;
                bufferImageResized = true;
            }
            this.rotProjection = MapBean.this.projectionFactory.makeProjection((Class<? extends Projection>)proj.getClass(), (Point2D)center, proj.getScale(), this.rotBufferWidth, this.rotBufferHeight);
            this.rotCenter = this.rotProjection.forward((Point2D)center);
            this.rotXOffset = (this.rotProjection.getWidth() - proj.getWidth()) / 2;
            this.rotYOffset = (this.rotProjection.getHeight() - proj.getHeight()) / 2;
            return bufferImageResized;
        }

        public void updateAngle(double angle) {
            this.angle = angle;
            this.rotTransform = AffineTransform.getRotateInstance(angle, this.rotCenter.getX(), this.rotCenter.getY());
        }

        public boolean isStillNeeded(double az) {
            return az != 0.0 || this.angle != 0.0;
        }

        public Projection getProjection() {
            return this.rotProjection;
        }

        public void paintChildren(Graphics g, Rectangle clip) {
            if (this.rotProjection == null) {
                return;
            }
            Graphics2D g2 = (Graphics2D)this.rotImage.getGraphics();
            ((Proj)this.rotProjection).drawBackground(g2, MapBean.this.getBckgrnd());
            g2.setTransform(this.rotTransform);
            MapBean.this.paintLayers(g2);
            g.drawImage(this.rotImage, -this.rotXOffset, -this.rotYOffset, null);
            g2.dispose();
        }

        public void paintPainters(Graphics g) {
            if (MapBean.this.painters != null) {
                int x = MapBean.this.getX();
                int y = MapBean.this.getY();
                Graphics2D g2 = (Graphics2D)g.create();
                AffineTransform transform = AffineTransform.getTranslateInstance(-this.rotXOffset + MapBean.this.getX(), -this.rotYOffset + MapBean.this.getY());
                transform.concatenate(this.rotTransform);
                g2.setTransform(transform);
                MapBean.this.painters.paint(g2);
                g2.dispose();
            }
        }

        public Graphics getGraphics() {
            Graphics2D g = (Graphics2D)MapBean.super.getGraphics().create();
            g.setTransform(this.rotTransform);
            return g;
        }

        public <T extends Point2D> T inverse(double x, double y, T ret) {
            Point2D pnt = new Point2D.Double(x + (double)this.rotXOffset, y + (double)this.rotYOffset);
            try {
                pnt = this.rotTransform.inverseTransform(pnt, pnt);
                return this.getProjection().inverse(pnt, ret);
            }
            catch (NoninvertibleTransformException e) {
                logger.log(Level.FINE, e.getMessage(), e);
                return ret;
            }
        }

        public Point2D inverseTransform(Point2D src, Point2D dst) {
            try {
                src.setLocation(src.getX() + (double)this.rotXOffset, src.getY() + (double)this.rotYOffset);
                dst = this.rotTransform.inverseTransform(src, dst);
            }
            catch (NoninvertibleTransformException e) {
                logger.log(Level.FINE, e.getMessage(), e);
            }
            return dst;
        }

        public Shape inverseTransform(Shape shape) {
            float[] coords = new float[6];
            GeneralPath path = new GeneralPath(0);
            PathIterator pi = shape.getPathIterator(this.getInverseRotationTransform());
            while (!pi.isDone()) {
                int type = pi.currentSegment(coords);
                if (type == 0) {
                    path.moveTo(coords[0], coords[1]);
                } else if (type == 1) {
                    path.lineTo(coords[0], coords[1]);
                } else if (type == 4) {
                    path.closePath();
                } else if (type == 2) {
                    path.quadTo(coords[0], coords[1], coords[2], coords[3]);
                } else if (type == 3) {
                    path.curveTo(coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]);
                }
                pi.next();
            }
            return path;
        }

        public AffineTransform getInverseRotationTransform() {
            try {
                AffineTransform translateOffset = AffineTransform.getTranslateInstance(this.rotXOffset, this.rotYOffset);
                AffineTransform transform = this.rotTransform.createInverse();
                translateOffset.preConcatenate(transform);
                return translateOffset;
            }
            catch (NoninvertibleTransformException e) {
                logger.log(Level.FINE, "AffineTransform problem", e);
                return new AffineTransform();
            }
        }

        public void dispose() {
            if (this.rotImage != null) {
                this.rotImage.flush();
            }
        }
    }
}

