/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.vpf;

import com.bbn.openmap.io.FormatException;
import com.bbn.openmap.layer.vpf.CoordFloatString;
import com.bbn.openmap.layer.vpf.CoverageTable;
import com.bbn.openmap.layer.vpf.PrimitiveTable;
import com.bbn.openmap.layer.vpf.TileDirectory;
import com.bbn.openmap.layer.vpf.VPFFeatureWarehouse;
import com.bbn.openmap.layer.vpf.VPFGraphicWarehouse;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.proj.coords.LatLonPoint;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextTable
extends PrimitiveTable {
    private final int coordColumn = this.whatColumn("shape_line");
    private final int textColumn;

    public TextTable(CoverageTable cov, TileDirectory tile) throws FormatException {
        super(cov, tile, "txt");
        if (this.coordColumn == -1) {
            throw new FormatException("texttable couldn't get shape_line column");
        }
        this.textColumn = this.whatColumn("string");
        if (this.textColumn == -1) {
            throw new FormatException("texttable couldn't get string column");
        }
    }

    public CoordFloatString getCoordinates(List<Object> textprim) {
        return (CoordFloatString)textprim.get(this.coordColumn);
    }

    @Override
    public void drawTile(VPFGraphicWarehouse warehouse, double dpplat, double dpplon, LatLonPoint ll1, LatLonPoint ll2) {
        double ll1lat = ll1.getY();
        double ll1lon = ll1.getX();
        double ll2lat = ll2.getY();
        double ll2lon = ll2.getX();
        try {
            ArrayList<Object> text = new ArrayList<Object>();
            while (this.parseRow(text)) {
                String textval = (String)text.get(this.textColumn);
                CoordFloatString coords = (CoordFloatString)text.get(this.coordColumn);
                double lat = coords.getYasFloat(0);
                double lon = coords.getXasFloat(0);
                if (!(lat > ll2lat) || !(lat < ll1lat) || !(lon > ll1lon) || !(lon < ll2lon)) continue;
                warehouse.createText(this.covtable, this, text, lat, lon, textval);
            }
        }
        catch (FormatException f) {
            System.out.println("Exception: " + f.getClass() + " " + f.getMessage());
        }
    }

    @Override
    public OMGraphic drawFeature(VPFFeatureWarehouse warehouse, double dpplat, double dpplon, LatLonPoint ll1, LatLonPoint ll2, List<Object> text, String featureType, int primID) {
        if (warehouse != null) {
            double ll1lat = ll1.getY();
            double ll1lon = ll1.getX();
            double ll2lat = ll2.getY();
            double ll2lon = ll2.getX();
            String textval = (String)text.get(this.textColumn);
            CoordFloatString coords = (CoordFloatString)text.get(this.coordColumn);
            double lat = coords.getYasFloat(0);
            double lon = coords.getXasFloat(0);
            if (lat > ll2lat && lat < ll1lat && lon > ll1lon && lon < ll2lon) {
                return warehouse.createText(this.covtable, this, text, lat, lon, textval, featureType, primID);
            }
        }
        return null;
    }
}

