/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.rpf;

import com.bbn.openmap.io.BinaryFile;
import com.bbn.openmap.io.FormatException;
import com.bbn.openmap.layer.rpf.RpfCoverageBox;
import com.bbn.openmap.layer.rpf.RpfFrameEntry;
import com.bbn.openmap.layer.rpf.RpfProductInfo;
import com.bbn.openmap.layer.rpf.RpfTocHandler;
import com.bbn.openmap.proj.CADRG;
import java.io.EOFException;

public class RpfTocEntry {
    public double vertInterval;
    public double horizInterval;
    public double vertResolution;
    public double horizResolution;
    public int horizFrames;
    public int vertFrames;
    public RpfFrameEntry[][] frames;
    public char zone;
    public char version;
    public boolean Cib;
    public String compressionRatio;
    public String producer;
    public String scale;
    public RpfCoverageBox coverage = new RpfCoverageBox();
    public float altScale = 0.0f;
    public String altScaleString;
    public RpfProductInfo info;

    public RpfTocEntry(BinaryFile binFile, int entryNumber) throws EOFException, FormatException {
        this(binFile, 0, entryNumber);
    }

    public RpfTocEntry(BinaryFile binFile, int TOCNumber, int entryNumber) throws EOFException, FormatException {
        this.coverage.tocNumber = TOCNumber;
        this.coverage.entryNumber = entryNumber;
        this.read(binFile);
        this.coverage.zone = CADRG.getProjZone(this.zone);
    }

    public void setInfo(String seriesCode) {
        this.info = RpfProductInfo.get(seriesCode.toUpperCase());
        if (this.info != null) {
            this.Cib = this.info.dataType.equalsIgnoreCase("CIB");
            this.coverage.chartCode = this.info.seriesCode;
        } else {
            this.info = RpfProductInfo.UK;
        }
    }

    public void read(BinaryFile binFile) throws EOFException, FormatException {
        binFile.readFixedLengthString(5);
        this.compressionRatio = binFile.readFixedLengthString(5);
        this.scale = binFile.readFixedLengthString(12);
        this.coverage.scale = RpfTocHandler.textScaleToLong(this.scale);
        this.zone = binFile.readChar();
        this.producer = binFile.readFixedLengthString(5);
        this.coverage.nw_lat = binFile.readDouble();
        this.coverage.nw_lon = binFile.readDouble();
        binFile.readDouble();
        binFile.readDouble();
        binFile.readDouble();
        binFile.readDouble();
        this.coverage.se_lat = binFile.readDouble();
        this.coverage.se_lon = binFile.readDouble();
        this.vertResolution = binFile.readDouble();
        this.horizResolution = binFile.readDouble();
        this.vertInterval = binFile.readDouble();
        this.horizInterval = binFile.readDouble();
        this.vertFrames = binFile.readInteger();
        this.horizFrames = binFile.readInteger();
        this.coverage.subframeLatInterval = this.vertInterval * 256.0;
        this.coverage.subframeLonInterval = this.horizInterval * 256.0;
    }

    protected boolean isFramesLoaded() {
        return this.frames != null;
    }

    protected RpfFrameEntry[][] getFrames() {
        if (this.frames == null) {
            this.frames = new RpfFrameEntry[this.vertFrames][this.horizFrames];
            for (int j = 0; j < this.vertFrames; ++j) {
                for (int k = 0; k < this.horizFrames; ++k) {
                    this.frames[j][k] = new RpfFrameEntry();
                }
            }
        }
        return this.frames;
    }

    protected RpfFrameEntry getFrame(int row, int column) {
        RpfFrameEntry[][] frames = this.getFrames();
        return frames[row][column];
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("RpfTocEntry ##################").append("\n");
        s.append(" vertInterval ").append(this.vertInterval).append(", horizInterval ").append(this.horizInterval).append("\n");
        s.append(" vertResolution ").append(this.vertResolution).append(", horizResolution ").append(this.horizResolution).append("\n");
        s.append(" horizFrames ").append(this.horizFrames).append(", vertFrames ").append(this.vertFrames).append("\n");
        s.append(" zone ").append(this.zone).append("\n");
        s.append(" scale ").append(this.scale).append("\n");
        s.append(" version ").append(this.version).append("\n");
        s.append(" Cib ").append(this.Cib).append("\n");
        s.append(" compressionRatio ").append(this.compressionRatio).append("\n");
        s.append(" producer ").append(this.producer).append("\n");
        s.append(this.coverage);
        return s.toString();
    }
}

