/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.rpf;

import com.bbn.openmap.io.BinaryBufferedFile;
import com.bbn.openmap.io.BinaryFile;
import com.bbn.openmap.io.FormatException;
import com.bbn.openmap.layer.nitf.NitfHeader;
import com.bbn.openmap.util.Debug;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public class RpfHeader {
    public static final int RPF_DATE_LOCATION = 31;
    public static final int HEADER_SECTION_LENGTH = 48;
    public static final int TOC_NITF_HEADER_LENGTH = 410;
    public static final int FRAME_SHORT_NITF_HEADER_LENGTH = 413;
    public static final int FRAME_LONG_NITF_HEADER_LENGTH = 426;
    public boolean endian = false;
    public short headerSectionLength;
    public String filename;
    public byte neww;
    public String standardNumber;
    public String standardDate;
    public char classification;
    public String country;
    public String release;
    public int locationSectionLocation;

    public boolean read(BinaryFile binFile) {
        boolean nitf = new NitfHeader().read(binFile);
        if (!nitf) {
            try {
                binFile.seek(0L);
                int headerOffset = this.handleNITFHeader(binFile);
                if (headerOffset < 0) {
                    return false;
                }
                binFile.seek(headerOffset);
            }
            catch (IOException e) {
                Debug.error("RpfHeader: File IO Error while reading header information:\n" + e);
                return false;
            }
        }
        return this.readHeader(binFile);
    }

    public boolean readHeader(BinaryFile binFile) {
        try {
            byte[] endianByte = binFile.readBytes(1, false);
            if (endianByte[0] > 0) {
                this.endian = true;
            }
            binFile.byteOrder(!this.endian);
            this.headerSectionLength = binFile.readShort();
            byte[] filenameArray = binFile.readBytes(12, false);
            this.filename = new String(filenameArray);
            byte[] newwByte = binFile.readBytes(1, false);
            this.neww = newwByte[0];
            byte[] standardNumberArray = binFile.readBytes(15, false);
            this.standardNumber = new String(standardNumberArray);
            byte[] standardDateArray = binFile.readBytes(8, false);
            this.standardDate = new String(standardDateArray);
            this.classification = binFile.readChar();
            byte[] countryArray = binFile.readBytes(2, false);
            this.country = new String(countryArray);
            byte[] releaseArray = binFile.readBytes(2, false);
            this.release = new String(releaseArray);
            this.locationSectionLocation = binFile.readInteger();
            if (Debug.debugging("rpfheader")) {
                Debug.output(this.toString());
            }
        }
        catch (IOException e) {
            Debug.error("RpfHeader: File IO Error while reading header information:\n" + e);
            return false;
        }
        catch (FormatException f) {
            Debug.error("RpfHeader: File IO Format error while reading header information:\n" + f);
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("RpfHeader: endian is ").append(this.endian).append("\n");
        s.append("RpfHeader: header section length = ").append(this.headerSectionLength).append("\n");
        s.append("RpfHeader: filename = ").append(this.filename).append("\n");
        s.append("RpfHeader: neww = ").append(this.neww).append("\n");
        s.append("RpfHeader: standard number = ").append(this.standardNumber).append("\n");
        s.append("RpfHeader: standard date = ").append(this.standardDate).append("\n");
        s.append("RpfHeader: classification = ").append(this.classification).append("\n");
        s.append("RpfHeader: country = ").append(this.country).append("\n");
        s.append("RpfHeader: release = ").append(this.release).append("\n");
        s.append("RpfHeader: location section location = ").append(this.locationSectionLocation).append("\n");
        return s.toString();
    }

    public int handleNITFHeader(BinaryFile binFile) {
        try {
            byte[] nitfArray = binFile.readBytes(4, false);
            String nitf = new String(nitfArray);
            binFile.seek(31L);
            nitfArray = binFile.readBytes(2, false);
            nitf = new String(nitfArray);
            if (nitf.equalsIgnoreCase("19") || nitf.equalsIgnoreCase("20")) {
                return 0;
            }
            binFile.seek(441L);
            nitfArray = binFile.readBytes(2, false);
            nitf = new String(nitfArray);
            if (nitf.equalsIgnoreCase("19") || nitf.equalsIgnoreCase("20")) {
                return 410;
            }
            binFile.seek(444L);
            nitfArray = binFile.readBytes(2, false);
            nitf = new String(nitfArray);
            if (nitf.equalsIgnoreCase("19") || nitf.equalsIgnoreCase("20")) {
                return 413;
            }
            binFile.seek(457L);
            nitfArray = binFile.readBytes(2, false);
            nitf = new String(nitfArray);
            if (nitf.equalsIgnoreCase("19") || nitf.equalsIgnoreCase("20")) {
                return 426;
            }
        }
        catch (IOException e) {
            Debug.error("RpfHeader: File IO Error while handling NITF header:\n" + e);
            return -1;
        }
        catch (FormatException f) {
            Debug.error("RpfHeader: File IO Format error while reading header information:\n" + f);
            return -1;
        }
        return -1;
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("Usage: java RpfHeader <path to A.TOC or RPF frame file>");
            return;
        }
        File file = new File(args[0]);
        BinaryBufferedFile binFile = null;
        try {
            binFile = new BinaryBufferedFile(file);
            RpfHeader header = new RpfHeader();
            if (header.read(binFile)) {
                System.out.println(header);
            } else {
                System.out.println("RpfHeader: NOT read successfully!");
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("RpfHeader: file " + args[0] + " not found");
            System.exit(1);
        }
        catch (IOException ioe) {
            System.err.println("RpfHeader: File IO Error while handling NITF header:");
            System.err.println(ioe);
        }
    }
}

