/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.event;

import com.bbn.openmap.util.Attributable;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class OMEvent
implements Attributable {
    public static Logger logger = Logger.getLogger("com.bbn.openmap.event.OMEvent");
    public static final String ATT_KEY_DETAILED_INFORMATION = "DETAILS";
    public static final String ATT_KEY_SELECTED = "SELECTED";
    public static final String ATT_KEY_PLAY_FILTER = "PLAY_FILTER";
    public static final String ATT_KEY_RATING = "RATING";
    public static final String ATT_VAL_GOOD_RATING = "+";
    public static final String ATT_VAL_BAD_RATING = "-";
    public static final String ATT_VAL_SELECTED_START_RANGE = "AVSSR";
    public static final String ATT_VAL_SELECTED_END_RANGE = "AVSER";
    public static final String ATT_VAL_SELECTED = "SELECTED";
    protected String description = "";
    protected long timeStamp;
    protected short timeStampComparator = 0;
    protected boolean sorted = false;
    protected Point2D location;
    protected Rectangle range;
    protected Object source;
    protected boolean atCurrentTime = false;
    protected boolean selected = false;
    protected Map attributes;

    public OMEvent(Object src, String desc, long tStamp) {
        this(src, desc, tStamp, null, null);
    }

    public OMEvent(Object src, String desc, long tStamp, Point2D loc) {
        this(src, desc, tStamp, loc, null);
    }

    public OMEvent(Object src, String desc, long tStamp, Point2D loc, Rectangle rect) {
        this.description = desc;
        this.timeStamp = tStamp;
        this.location = loc;
        this.range = rect;
        this.source = src;
        if (src instanceof Attributable) {
            this.attributes = ((Attributable)src).getAttributes();
        }
    }

    public void setTimeStamp(long tStamp) {
        this.timeStamp = tStamp;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public void setDescription(String desc) {
        this.description = desc;
    }

    public String getDescription() {
        return this.toString();
    }

    public String toString() {
        return this.description;
    }

    public void setLocation(Point2D loc) {
        this.location = loc;
    }

    public Point2D getLocation() {
        return this.location;
    }

    public void setRange(Rectangle rect) {
        this.range = rect;
    }

    public Rectangle getRange() {
        return this.range;
    }

    public Object getSource() {
        return this.source;
    }

    public void setSource(Object src) {
        this.source = src;
    }

    public String getDetailedInformation() {
        return (String)this.getAttribute(ATT_KEY_DETAILED_INFORMATION);
    }

    public void setDetailedInformation(String di) {
        this.putAttribute(ATT_KEY_DETAILED_INFORMATION, di);
    }

    public boolean isAtCurrentTime() {
        return this.atCurrentTime;
    }

    public void setAtCurrentTime(boolean atCurrentTime) {
        this.atCurrentTime = atCurrentTime;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public boolean passesMacroFilters(List filters) {
        return true;
    }

    public void putAttribute(Object key, Object value) {
        if (key == null) {
            return;
        }
        if (this.attributes == null) {
            this.attributes = new Hashtable();
        }
        if (value != null) {
            this.attributes.put(key, value);
        } else {
            this.attributes.remove(key);
        }
    }

    public Object getAttribute(Object key) {
        Object ret = null;
        if (this.attributes != null && key != null) {
            ret = this.attributes.get(key);
        }
        return ret;
    }

    public void clearAttributes() {
        if (this.attributes != null) {
            this.attributes.clear();
        }
    }

    public Map getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map map) {
        this.attributes = map;
    }

    public short getTimeStampComparator() {
        return this.timeStampComparator;
    }

    public void setTimeStampComparator(short timeStampComparator) {
        this.timeStampComparator = timeStampComparator;
    }

    protected boolean isSorted() {
        return this.sorted;
    }

    protected void setSorted(boolean sorted) {
        this.sorted = sorted;
    }
}

