/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.dataAccess.shape;

import com.bbn.openmap.dataAccess.shape.DbfTableModel;
import com.bbn.openmap.dataAccess.shape.EsriGraphic;
import com.bbn.openmap.dataAccess.shape.EsriGraphicFactory;
import com.bbn.openmap.dataAccess.shape.EsriShapeExport;
import com.bbn.openmap.dataAccess.shape.ShapeConstants;
import com.bbn.openmap.dataAccess.shape.input.ShpInputStream;
import com.bbn.openmap.dataAccess.shape.input.ShxInputStream;
import com.bbn.openmap.io.FormatException;
import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.proj.coords.GeoCoordTransformation;
import com.bbn.openmap.util.ArgParser;
import com.bbn.openmap.util.PropUtils;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EsriGraphicList
extends OMGraphicList
implements ShapeConstants,
EsriGraphic {
    public static Logger logger = Logger.getLogger("com.bbn.openmap.dataAccess.shape.EsriGraphicList");
    protected double[] extents;
    protected int type;

    @Override
    public boolean add(OMGraphic shape) {
        return super.add(shape);
    }

    public boolean addOMGraphic(OMGraphic g) {
        return this.add(g);
    }

    @Override
    public void setType(int type) {
        this.type = type;
    }

    @Override
    public int getType() {
        return this.type;
    }

    public EsriGraphicList() {
    }

    public EsriGraphicList(int initialCapacity) {
        super(initialCapacity);
    }

    public EsriGraphicList(int initialCapacity, int capacityIncrement) {
        super(initialCapacity);
    }

    @Override
    public void setExtents(double[] extents) {
        this.extents = extents;
    }

    @Override
    public double[] getExtents() {
        if (this.extents == null) {
            this.extents = new double[]{90.0, 180.0, -90.0, -180.0};
        }
        return this.extents;
    }

    public void addExtents(double[] graphicExtents) {
        double[] ex = this.getExtents();
        for (int i = 0; i < graphicExtents.length; i += 2) {
            if (ex[0] > graphicExtents[i]) {
                ex[0] = graphicExtents[i];
            }
            if (ex[1] > graphicExtents[i + 1]) {
                ex[1] = graphicExtents[i + 1];
            }
            if (ex[2] < graphicExtents[i]) {
                ex[2] = graphicExtents[i];
            }
            if (!(ex[3] < graphicExtents[i + 1])) continue;
            ex[3] = graphicExtents[i + 1];
        }
    }

    public void setTable(DbfTableModel dtm) {
        if (dtm != null) {
            this.putAttribute("DBF_ATTRIBUTE", dtm);
        } else {
            this.removeAttribute("DBF_ATTRIBUTE");
        }
    }

    public DbfTableModel getTable() {
        Object obj = this.getAttribute("DBF_ATTRIBUTE");
        if (obj instanceof DbfTableModel) {
            return (DbfTableModel)obj;
        }
        return null;
    }

    public void createTable() {
        this.putAttribute("DBF_ATTRIBUTE", EsriShapeExport.createDefaultModel(this));
    }

    public static EsriGraphicList getEsriGraphicList(URL shp, URL shx, DrawingAttributes drawingAttributes, DbfTableModel dbf) {
        return EsriGraphicList.getEsriGraphicList(shp, drawingAttributes, dbf, null);
    }

    public static EsriGraphicList getEsriGraphicList(URL shp, DrawingAttributes drawingAttributes, DbfTableModel dbf, GeoCoordTransformation coordTranslator) {
        EsriGraphicList list = null;
        try {
            InputStream is = shp.openStream();
            ShpInputStream pis = new ShpInputStream(is);
            if (drawingAttributes != null) {
                pis.setDrawingAttributes(drawingAttributes);
            }
            EsriGraphicFactory egf = new EsriGraphicFactory(3, coordTranslator);
            list = pis.getGeometry(egf);
            is.close();
        }
        catch (Exception e) {
            logger.warning("Not able to stream SHP file");
            if (logger.isLoggable(Level.FINE)) {
                e.printStackTrace();
            }
            return null;
        }
        if (list != null && dbf != null && dbf.getRowCount() == list.size()) {
            list.setTable(dbf);
        }
        return list;
    }

    public static EsriGraphicList getEsriGraphicList(URL shp, DrawingAttributes drawingAttributes, GeoCoordTransformation coordTranslator) {
        DbfTableModel dbf = null;
        if (shp != null) {
            String shpPath = shp.getFile();
            String protocol = shp.getProtocol();
            String host = shp.getHost();
            if (shpPath != null && shpPath.endsWith(".shp")) {
                String dbfPath = shpPath.replace(".shp", ".dbf");
                try {
                    URL dbfURL = new URL(protocol, host, dbfPath);
                    dbf = DbfTableModel.getDbfTableModel(dbfURL);
                    dbfURL = null;
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            }
        }
        return EsriGraphicList.getEsriGraphicList(shp, drawingAttributes, dbf, coordTranslator);
    }

    public List<EsriGraphic> getGraphicsWithValueInColumn(Object value, String columnName) throws FormatException {
        ArrayList<EsriGraphic> ret = new ArrayList<EsriGraphic>();
        DbfTableModel dbf = this.getTable();
        int colIndex = dbf.findColumn(columnName);
        if (colIndex != -1) {
            for (OMGraphic eg : this) {
                Integer index = (Integer)eg.getAttribute("SHAPE_INDEX_ATTRIBUTE");
                List<Object> atts = dbf.getRecord(index);
                if (!atts.get(colIndex).equals(value)) continue;
                ret.add((EsriGraphic)((Object)eg));
            }
        } else {
            throw new FormatException("Column " + columnName + " not found");
        }
        return ret;
    }

    public static void main(String[] args) {
        String[] printit;
        String[] fixit;
        ArgParser ap = new ArgParser("EsriGraphicList");
        ap.add("fixcl", "Check and fix content length of Shape file", 1);
        ap.add("print", "Display text structure of shapes in Shape file", 1);
        if (!ap.parse(args)) {
            ap.printUsage();
            System.exit(0);
        }
        if ((fixit = ap.getArgValues("fixcl")) != null) {
            String shape = fixit[0];
            if (shape.endsWith(".shp")) {
                shape = shape.substring(0, shape.length() - 4);
                try {
                    URL shx = PropUtils.getResourceOrFileOrURL(shape + ".shx");
                    InputStream is = shx.openStream();
                    ShxInputStream pis = new ShxInputStream(is);
                    int[][] index = pis.getIndex();
                    is.close();
                    RandomAccessFile raf = new RandomAccessFile(shape + ".shp", "rw");
                    raf.seek(24L);
                    int contentLength = raf.readInt();
                    int indexedContentLength = index[0][index[0].length - 1] + index[1][index[1].length - 1];
                    if (contentLength != indexedContentLength) {
                        System.out.println(shape + " content length - shp: " + contentLength + ", shx: " + indexedContentLength);
                        raf.seek(24L);
                        raf.writeInt(indexedContentLength);
                    }
                    raf.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                System.out.println("Shape " + shape + " doesn't look like a shape file");
            }
        }
        if ((printit = ap.getArgValues("print")) != null) {
            try {
                logger.setLevel(Level.FINER);
                EsriGraphicFactory.logger.setLevel(Level.FINER);
                URL eglURL = PropUtils.getResourceOrFileOrURL(printit[0]);
                EsriGraphicList egl = EsriGraphicList.getEsriGraphicList(eglURL, null, null);
                if (egl != null) {
                    System.out.println(egl.getDescription());
                }
            }
            catch (Exception e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }
    }
}

