/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.dataAccess.image.geotiff;

import com.bbn.openmap.dataAccess.image.ImageTile;
import com.bbn.openmap.dataAccess.image.geotiff.GeoTIFFImageReader;
import com.bbn.openmap.dataAccess.image.geotiff.GeoTIFFModelFactory;
import com.bbn.openmap.omGraphics.OMRaster;
import com.bbn.openmap.proj.CADRG;
import com.bbn.openmap.proj.coords.LatLonPoint;
import com.bbn.openmap.util.PropUtils;
import com.sun.media.jai.codec.ImageDecodeParam;
import com.sun.media.jai.codec.SeekableStream;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotiff.image.KeyRegistry;
import org.geotiff.image.jai.GeoTIFFDescriptor;
import org.geotiff.image.jai.GeoTIFFDirectory;
import org.geotiff.image.jai.GeoTIFFFactory;
import org.libtiff.jai.codec.XTIFFDecodeParam;
import org.libtiff.jai.codec.XTIFFField;
import org.libtiff.jai.codecimpl.XTIFFImageDecoder;

public class GeoTIFFFile {
    public static Logger logger = Logger.getLogger("com.bbn.openmap.dataAccess.image.geotiff.GeoTIFFFile");
    protected GeoTIFFDirectory gtfDirectory;
    protected XTIFFField[] geoKeys;
    protected URL fileURL;

    public GeoTIFFFile(String filePath) throws MalformedURLException, IOException, IllegalArgumentException {
        this(PropUtils.getResourceOrFileOrURL(filePath));
    }

    public GeoTIFFFile(URL fileURL) throws MalformedURLException, IOException, IllegalArgumentException {
        if (fileURL == null) {
            throw new MalformedURLException("Null file provided as URL");
        }
        this.init(fileURL);
    }

    public void init(URL fileURL) throws IOException, IllegalArgumentException {
        this.fileURL = fileURL;
        SeekableStream ss = SeekableStream.wrapInputStream((InputStream)fileURL.openStream(), (boolean)true);
        GeoTIFFDescriptor.register();
        GeoTIFFFactory gtFactory = new GeoTIFFFactory();
        this.gtfDirectory = (GeoTIFFDirectory)gtFactory.createDirectory(ss, 0);
        this.geoKeys = this.gtfDirectory.getGeoKeys();
        ss.close();
    }

    public BufferedImage getBufferedImage() throws IOException {
        if (this.fileURL == null) {
            throw new IOException("Image Decoder not created for retrieving image, need to init() GeoTIFFFile.");
        }
        SeekableStream ss = SeekableStream.wrapInputStream((InputStream)this.fileURL.openStream(), (boolean)true);
        XTIFFImageDecoder xtffImageDecoder = new XTIFFImageDecoder(ss, (ImageDecodeParam)new XTIFFDecodeParam());
        RenderedImage ri = xtffImageDecoder.decodeAsRenderedImage();
        BufferedImage bi = new BufferedImage(ri.getColorModel(), ri.copyData(null), false, new Hashtable());
        ss.close();
        return bi;
    }

    public XTIFFField getFieldWithTag(int tagNumber) {
        XTIFFField ret = null;
        XTIFFField[] gtfFields = this.gtfDirectory.getFields();
        for (int i = 0; i < gtfFields.length; ++i) {
            XTIFFField xtff = gtfFields[i];
            int tag = xtff.getTag();
            if (tag != tagNumber) continue;
            ret = xtff;
            break;
        }
        return ret;
    }

    public GeoTIFFDirectory getGtfDirectory() {
        return this.gtfDirectory;
    }

    public XTIFFField[] getGeoKeys() {
        return this.geoKeys;
    }

    protected XTIFFField getGeoFieldForCode(int code) {
        if (this.geoKeys != null) {
            for (int i = 0; i < this.geoKeys.length; ++i) {
                XTIFFField f = this.geoKeys[i];
                if (f.getTag() != code) continue;
                return f;
            }
        }
        return null;
    }

    public int getRasterType() {
        return this.getGeoKeyIntValue(KeyRegistry.getCode(KeyRegistry.GEOKEY, "GTRasterTypeGeoKey"));
    }

    public int getModelType() {
        return this.getGeoKeyIntValue(KeyRegistry.getCode(KeyRegistry.GEOKEY, "GTModelTypeGeoKey"));
    }

    public int getProjectedCSType() {
        return this.getGeoKeyIntValue(KeyRegistry.getCode(KeyRegistry.GEOKEY, "ProjectedCSTypeGeoKey"));
    }

    public int getGeographicType() {
        return this.getGeoKeyIntValue(KeyRegistry.getCode(KeyRegistry.GEOKEY, "GeographicTypeGeoKey"));
    }

    protected int getGeoKeyIntValue(int codeFromKeyRegistry) {
        XTIFFField field = this.getGeoFieldForCode(codeFromKeyRegistry);
        if (field != null) {
            int type = field.getType();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("field type is " + this.getStringOfType(type));
            }
            if (type == 3) {
                return field.getAsInt(0);
            }
        }
        return -1;
    }

    protected int getFieldIntValue(int tiffCode) {
        int type;
        XTIFFField field = this.getFieldWithTag(tiffCode);
        if (field != null && (type = field.getType()) == 3) {
            return field.getAsInt(0);
        }
        return -1;
    }

    public void dumpTags(XTIFFField[] gtfFields) {
        StringBuffer buf = new StringBuffer();
        block11: for (int i = 0; i < gtfFields.length; ++i) {
            XTIFFField xtff = gtfFields[i];
            int type = xtff.getType();
            int tag = xtff.getTag();
            buf.append("\n\tfield (").append(i).append(") - ").append(tag).append(" (").append(KeyRegistry.getKey(KeyRegistry.GEOKEY, tag)).append("): [");
            switch (type) {
                case 2: {
                    String[] fieldStrings = xtff.getAsStrings();
                    for (int j = 0; j < fieldStrings.length; ++j) {
                        buf.append(fieldStrings[j]);
                        if (j >= fieldStrings.length - 1) continue;
                        buf.append(", ");
                    }
                    buf.append("]");
                    continue block11;
                }
                case 12: {
                    double[] fieldDoubles = xtff.getAsDoubles();
                    for (int j = 0; j < fieldDoubles.length; ++j) {
                        buf.append(fieldDoubles[j]);
                        if (j >= fieldDoubles.length - 1) continue;
                        buf.append(", ");
                    }
                    buf.append("]");
                    continue block11;
                }
                case 11: {
                    double[] fieldFloats = xtff.getAsDoubles();
                    for (int j = 0; j < fieldFloats.length; ++j) {
                        buf.append(fieldFloats[j]);
                        if (j >= fieldFloats.length - 1) continue;
                        buf.append(", ");
                    }
                    buf.append("]");
                    continue block11;
                }
                case 1: 
                case 6: {
                    byte[] fieldBytes = xtff.getAsBytes();
                    for (int j = 0; j < fieldBytes.length; ++j) {
                        buf.append(fieldBytes[j]);
                        if (j >= fieldBytes.length - 1) continue;
                        buf.append(", ");
                    }
                    buf.append("]");
                    continue block11;
                }
                case 8: {
                    short[] fieldShorts = xtff.getAsShorts();
                    for (int j = 0; j < fieldShorts.length; ++j) {
                        buf.append(fieldShorts[j]);
                        if (j >= fieldShorts.length - 1) continue;
                        buf.append(", ");
                    }
                    buf.append("]");
                    continue block11;
                }
                case 3: 
                case 4: {
                    long[] fieldLongs = xtff.getAsLongs();
                    for (int j = 0; j < fieldLongs.length; ++j) {
                        buf.append(fieldLongs[j]);
                        if (j >= fieldLongs.length - 1) continue;
                        buf.append(", ");
                    }
                    buf.append("]");
                    continue block11;
                }
                case 9: {
                    int[] fieldInts = xtff.getAsInts();
                    for (int j = 0; j < fieldInts.length; ++j) {
                        buf.append(fieldInts[j]);
                        if (j >= fieldInts.length - 1) continue;
                        buf.append(", ");
                    }
                    buf.append("]");
                    continue block11;
                }
                case 5: {
                    long[][] fieldRationals = xtff.getAsRationals();
                    for (int k = 0; k < fieldRationals.length; ++k) {
                        buf.append("\n\t");
                        for (int j = 0; j < fieldRationals[0].length; ++j) {
                            buf.append(fieldRationals[k][j]);
                            if (j >= fieldRationals[k].length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    buf.append("\n]");
                    continue block11;
                }
                case 10: {
                    int[][] fieldSRationals = xtff.getAsSRationals();
                    for (int k = 0; k < fieldSRationals.length; ++k) {
                        buf.append("\n\t");
                        for (int j = 0; j < fieldSRationals[0].length; ++j) {
                            buf.append(fieldSRationals[k][j]);
                            if (j >= fieldSRationals[k].length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    buf.append("\n]");
                    continue block11;
                }
                default: {
                    buf.append("Can't handle ").append(type).append(" type.]");
                }
            }
        }
        logger.info(buf.toString());
    }

    public String getStringOfType(int type) {
        switch (type) {
            case 2: {
                return "ASCII";
            }
            case 12: {
                return "double";
            }
            case 11: {
                return "float";
            }
            case 1: {
                return "byte";
            }
            case 6: {
                return "sbyte";
            }
            case 8: {
                return "sshort";
            }
            case 4: {
                return "long";
            }
            case 3: {
                return "short";
            }
            case 9: {
                return "slong";
            }
            case 5: {
                return "rational";
            }
            case 10: {
                return "srational";
            }
        }
        return "unknown";
    }

    public ImageTile getImageTile() throws IOException {
        GeoTIFFModelFactory gtmf = new GeoTIFFModelFactory(this);
        return gtmf.getImageTile();
    }

    public ImageTile getImageTile(GeoTIFFImageReader id, ImageTile.Cache cache) throws IOException {
        GeoTIFFModelFactory gtmf = new GeoTIFFModelFactory(this);
        return gtmf.getImageTile(id, cache);
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("GeoTIFFFile:  Need a path/filename");
            System.exit(0);
        }
        logger.info("GeoTIFFFile: " + args[0]);
        String filePath = null;
        if (args.length > 0) {
            filePath = args[0];
        }
        if (filePath != null) {
            try {
                URL fileURL = PropUtils.getResourceOrFileOrURL(filePath);
                if (fileURL != null) {
                    GeoTIFFFile gtfFile = new GeoTIFFFile(fileURL);
                    BufferedImage bi = gtfFile.getBufferedImage();
                    GeoTIFFDirectory gtfd = gtfFile.getGtfDirectory();
                    double[] tiePoints = gtfd.getTiepoints();
                    System.out.println("------ Tie Point Values ------");
                    for (int i = 0; i < tiePoints.length; ++i) {
                        System.out.println(tiePoints[i]);
                    }
                    double[] scaleMatrix = gtfd.getPixelScale();
                    System.out.println("------ Pixel Scale Values ------");
                    for (int i = 0; i < scaleMatrix.length; ++i) {
                        System.out.println(scaleMatrix[i]);
                    }
                    System.out.println("----- Geo Keys -------");
                    gtfFile.dumpTags(gtfFile.getGeoKeys());
                    System.out.println("------------");
                    System.out.println("----- All Keys -------");
                    gtfFile.dumpTags(gtfFile.getGtfDirectory().getFields());
                    System.out.println("------------");
                    CADRG crg = new CADRG(new LatLonPoint.Double(0.0, 0.0), 1500000.0f, 600, 600);
                    final OMRaster omsr = new OMRaster(0, 0, (Image)bi);
                    omsr.generate(crg);
                    Frame window = new Frame(filePath){

                        public void paint(Graphics g) {
                            if (omsr != null) {
                                omsr.render(g);
                            }
                        }
                    };
                    window.addWindowListener(new WindowAdapter(){

                        public void windowClosing(WindowEvent e) {
                            System.exit(0);
                        }
                    });
                    window.setSize(omsr.getWidth(), omsr.getHeight());
                    window.setVisible(true);
                    window.repaint();
                }
            }
            catch (MalformedURLException murle) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

