/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.tools.beanbox;

import com.bbn.openmap.tools.beanbox.GenericPropertyEditorInterface;
import com.bbn.openmap.tools.beanbox.GenericPropertySheet;
import com.bbn.openmap.tools.beanbox.PropertyCanvas;
import com.bbn.openmap.tools.beanbox.PropertySelector;
import com.bbn.openmap.tools.beanbox.PropertyText;
import java.awt.Component;
import java.awt.GridLayout;
import java.beans.BeanInfo;
import java.beans.Beans;
import java.beans.Customizer;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.beans.PropertyVetoException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;

class PropertySheetPanel
extends JPanel {
    private GenericPropertySheet _frame;
    private Object targetBean;
    private PropertyDescriptor[] properties;
    private PropertyEditor[] editors;
    private Object[] values;
    private Component[] views;
    private JLabel[] labels;
    private boolean processEvents;

    PropertySheetPanel(GenericPropertySheet frame) {
        this._frame = frame;
        this.setLayout(null);
        this.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
    }

    synchronized void setTarget(Object targ) {
        int i;
        this.setVisible(false);
        this.removeAll();
        this.targetBean = targ;
        try {
            BeanInfo bi = Introspector.getBeanInfo(this.targetBean.getClass());
            this.properties = bi.getPropertyDescriptors();
        }
        catch (IntrospectionException ex) {
            this.error("GenericPropertySheet: Couldn't introspect", ex);
            return;
        }
        this.editors = new PropertyEditor[this.properties.length];
        this.values = new Object[this.properties.length];
        this.views = new Component[this.properties.length];
        this.labels = new JLabel[this.properties.length];
        int numEditorsToDisplay = 0;
        for (i = 0; i < this.properties.length; ++i) {
            Component view;
            String name;
            block20: {
                name = this.properties[i].getDisplayName();
                if (this.properties[i].isHidden() || this.properties[i].isExpert()) {
                    System.out.println("Ignoring hidden or expert property " + name);
                    continue;
                }
                Class<?> type = this.properties[i].getPropertyType();
                Method getter = this.properties[i].getReadMethod();
                Method setter = this.properties[i].getWriteMethod();
                if (getter == null || setter == null) {
                    System.out.println("Ignoring read-only/write-only property " + name);
                    continue;
                }
                view = null;
                try {
                    Object value;
                    Object[] args = new Object[]{};
                    this.values[i] = value = getter.invoke(this.targetBean, args);
                    PropertyEditor editor = null;
                    Class<?> pec = this.properties[i].getPropertyEditorClass();
                    if (pec != null) {
                        try {
                            editor = (PropertyEditor)pec.newInstance();
                        }
                        catch (Exception ex) {
                            System.out.println("Cannot instantiate editor class: " + pec);
                            System.out.println("Will try to find editor using PropertyEditorManager");
                        }
                    }
                    if (editor == null) {
                        editor = PropertyEditorManager.findEditor(type);
                    }
                    this.editors[i] = editor;
                    if (editor == null) {
                        String getterClass = this.properties[i].getReadMethod().getDeclaringClass().getName();
                        if (getterClass.indexOf("java.") == 0) continue;
                        System.err.println("Warning: Can't find public property editor for property \"" + name + "\".  Skipping.");
                        continue;
                    }
                    editor.setValue(value);
                    editor.addPropertyChangeListener(this._frame);
                    if (editor.isPaintable() && editor.supportsCustomEditor()) {
                        view = new PropertyCanvas(this._frame, editor);
                    } else if (editor.getTags() != null) {
                        view = new PropertySelector(editor);
                    } else if (editor.getAsText() != null) {
                        view = new PropertyText(editor);
                    } else {
                        System.err.println("Warning: Property \"" + name + "\" has non-displayabale editor. Skipping.");
                        continue;
                    }
                    if (!(editor instanceof GenericPropertyEditorInterface)) break block20;
                    ((GenericPropertyEditorInterface)((Object)editor)).setTargetBean(this.targetBean);
                }
                catch (InvocationTargetException ex) {
                    System.err.println("Skipping property " + name + " ; exception on target: " + ex.getTargetException());
                    ex.getTargetException().printStackTrace();
                    continue;
                }
                catch (Exception ex) {
                    System.err.println("Skipping property " + name + "; exception: " + ex);
                    ex.printStackTrace();
                    continue;
                }
            }
            this.labels[i] = new JLabel(name, 2);
            this.views[i] = view;
            ++numEditorsToDisplay;
        }
        this.setLayout(new GridLayout(numEditorsToDisplay, 2));
        for (i = 0; i < this.properties.length; ++i) {
            if (this.views[i] == null) continue;
            this.add(this.labels[i]);
            this.add(this.views[i]);
        }
        this._frame.setNumEditorsToDisplay(numEditorsToDisplay);
        this._frame.setFrameSize();
        this.processEvents = true;
        this.setVisible(true);
    }

    synchronized void setCustomizer(Customizer c) {
        if (c != null) {
            c.addPropertyChangeListener(this._frame);
        }
    }

    synchronized void wasModified(PropertyChangeEvent evt) {
        if (!this.processEvents) {
            return;
        }
        if (evt.getSource() instanceof PropertyEditor) {
            PropertyEditor editor = (PropertyEditor)evt.getSource();
            for (int i = 0; i < this.editors.length; ++i) {
                if (this.editors[i] != editor) continue;
                PropertyDescriptor property = this.properties[i];
                Object value = editor.getValue();
                if (value != null && value instanceof String && ((String)value).trim().equalsIgnoreCase("null")) {
                    value = null;
                }
                this.values[i] = value;
                Method setter = property.getWriteMethod();
                try {
                    Object[] args = new Object[]{value};
                    args[0] = value;
                    setter.invoke(this.targetBean, args);
                }
                catch (InvocationTargetException ex) {
                    if (ex.getTargetException() instanceof PropertyVetoException) {
                        System.err.println("WARNING: Vetoed; reason is: " + ex.getTargetException().getMessage());
                    } else {
                        this.error("InvocationTargetException while updating " + property.getName(), ex.getTargetException());
                    }
                }
                catch (Exception ex) {
                    this.error("Unexpected exception while updating " + property.getName(), ex);
                }
                if (this.views[i] == null || !(this.views[i] instanceof PropertyCanvas)) break;
                this.views[i].repaint();
                break;
            }
        }
        for (int i = 0; i < this.properties.length; ++i) {
            Object o;
            try {
                Method getter = this.properties[i].getReadMethod();
                Object[] args = new Object[]{};
                o = getter.invoke(this.targetBean, args);
            }
            catch (Exception ex) {
                o = null;
            }
            if (o instanceof Object[] && this.values[i] instanceof Object[]) {
                Object[] newVal = (Object[])o;
                Object[] oldVal = (Object[])this.values[i];
                if (newVal.length == oldVal.length) {
                    for (int j = 0; j < newVal.length && newVal[j].equals(oldVal[j]); ++j) {
                    }
                    continue;
                }
            } else if (o == this.values[i] || o != null && o.equals(this.values[i])) continue;
            this.values[i] = o;
            if (this.editors[i] == null) continue;
            this.editors[i].setValue(o);
            if (this.views[i] == null) continue;
            this.views[i].repaint();
        }
        if (Beans.isInstanceOf(this.targetBean, Component.class)) {
            ((Component)Beans.getInstanceOf(this.targetBean, Component.class)).repaint();
        }
    }

    private void error(String message, Throwable th) {
        String mess = message + ":\n" + th;
        System.err.println(message);
        th.printStackTrace();
        System.out.println(mess);
    }
}

