/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics;

import com.bbn.openmap.omGraphics.EditableOMGraphic;
import com.bbn.openmap.omGraphics.GraphicAttributes;
import com.bbn.openmap.omGraphics.OMAbstractLine;
import com.bbn.openmap.omGraphics.OMColor;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;

public abstract class EditableOMAbstractLine
extends EditableOMGraphic {
    protected JMenu arrowheadMenu = null;

    public Component getGUI(GraphicAttributes graphicAttributes) {
        if (graphicAttributes != null) {
            JMenu ahm = this.getArrowHeadMenu();
            graphicAttributes.setLineMenuAdditions(new JMenu[]{ahm});
        }
        return null;
    }

    public JMenu getArrowHeadMenu() {
        if (this.arrowheadMenu == null) {
            this.arrowheadMenu = new JMenu(this.i18n.get(EditableOMAbstractLine.class, "Arrows", "Arrows"));
            ActionListener listener = new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    String command = ae.getActionCommand();
                    try {
                        int what = Integer.parseInt(command);
                        if (what < 0) {
                            ((OMAbstractLine)EditableOMAbstractLine.this.getGraphic()).addArrowHead(false);
                        } else {
                            ((OMAbstractLine)EditableOMAbstractLine.this.getGraphic()).addArrowHead(what);
                        }
                        EditableOMAbstractLine.this.generate(EditableOMAbstractLine.this.getProjection());
                        EditableOMAbstractLine.this.repaint();
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            };
            boolean doArrowHead = ((OMAbstractLine)this.getGraphic()).hasArrowHead();
            int currentDirection = 0;
            if (doArrowHead) {
                currentDirection = ((OMAbstractLine)this.getGraphic()).getArrowHead().getArrowDirectionType();
            }
            int descDir = -1;
            ButtonGroup group = new ButtonGroup();
            ImageIcon ii = this.createArrowIcon(new BasicStroke(1.0f), 50, 20, descDir);
            JRadioButtonMenuItem button = new JRadioButtonMenuItem(ii, !doArrowHead);
            button.setActionCommand(String.valueOf(descDir));
            group.add(button);
            button.addActionListener(listener);
            this.arrowheadMenu.add(button);
            for (descDir = 0; descDir <= 2; ++descDir) {
                ii = this.createArrowIcon(new BasicStroke(1.0f), 50, 20, descDir);
                button = new JRadioButtonMenuItem(ii, doArrowHead && currentDirection == descDir);
                button.setActionCommand(String.valueOf(descDir));
                group.add(button);
                button.addActionListener(listener);
                this.arrowheadMenu.add(button);
            }
        }
        return this.arrowheadMenu;
    }

    public ImageIcon createArrowIcon(BasicStroke stroke, int width, int height, int arrowHeadType) {
        BufferedImage bigImage = new BufferedImage(width, height, 2);
        Graphics2D g = (Graphics2D)bigImage.getGraphics();
        int middleY = height / 2;
        g.setBackground(OMColor.clear);
        g.setPaint(OMColor.clear);
        g.fillRect(0, 0, width, height);
        g.setPaint(Color.black);
        g.setStroke(stroke);
        g.drawLine(0, middleY, width, middleY);
        int upTip = (int)((double)height * 0.25);
        int downTip = (int)((double)height * 0.75);
        Polygon poly = null;
        if (arrowHeadType == 0 || arrowHeadType == 2) {
            int rightWingX = (int)((double)width * 0.75);
            poly = new Polygon(new int[]{width, rightWingX, rightWingX}, new int[]{middleY, upTip, downTip}, 3);
            g.fill(poly);
            g.draw(poly);
        }
        if (arrowHeadType == 1 || arrowHeadType == 2) {
            int leftWingX = (int)((double)width * 0.25);
            poly = new Polygon(new int[]{0, leftWingX, leftWingX}, new int[]{middleY, upTip, downTip}, 3);
            g.fill(poly);
            g.draw(poly);
        }
        return new ImageIcon(bigImage);
    }
}

