/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.rpf;

import com.bbn.openmap.util.ArgParser;
import com.bbn.openmap.util.Debug;
import java.io.File;

public class ChangeCase {
    public static void handleEntry(File file, boolean toUpper) {
        try {
            String parent;
            String[] filenames = file.list();
            if (filenames != null) {
                int i;
                File[] contents = new File[filenames.length];
                for (i = 0; i < contents.length; ++i) {
                    contents[i] = new File(file.getAbsolutePath() + File.separator, filenames[i]);
                }
                for (i = 0; i < contents.length; ++i) {
                    ChangeCase.handleEntry(contents[i], toUpper);
                }
            }
            File newFile = (parent = file.getParent()) != null ? (toUpper ? new File(parent, file.getName().toUpperCase()) : new File(parent, file.getName().toLowerCase())) : (toUpper ? new File(file.getName().toUpperCase()) : new File(file.getName().toLowerCase()));
            if (file.renameTo(newFile)) {
                System.out.println("Renamed " + (file.getParent() == null ? "." : file.getParent()) + File.separator + file.getName() + " to " + (newFile.getParent() == null ? "." : newFile.getParent()) + File.separator + newFile.getName());
            } else {
                System.out.println("Renaming " + (file.getParent() == null ? "." : file.getParent()) + File.separator + file.getName() + " to " + (newFile.getParent() == null ? "." : newFile.getParent()) + File.separator + newFile.getName() + " FAILED");
            }
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public static void main(String[] argv) {
        Debug.init();
        boolean toUpper = true;
        ArgParser ap = new ArgParser("ChangeCase");
        ap.add("upper", "Change file and directory names to UPPER CASE (default). <path> <path> ...", -1);
        ap.add("lower", "Change file and directory names to lower case. <path> <path> ...", -1);
        if (argv.length == 0) {
            ap.bail("", true);
        }
        ap.parse(argv);
        String[] dirs = ap.getArgValues("lower");
        if (dirs != null) {
            Debug.output("Converting to lower case names...");
            toUpper = false;
        } else {
            dirs = ap.getArgValues("upper");
            if (dirs == null) {
                dirs = argv;
            }
            Debug.output("Converting to UPPER CASE names...");
        }
        for (int i = 0; i < dirs.length; ++i) {
            ChangeCase.handleEntry(new File(dirs[i]), toUpper);
        }
    }
}

