/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.policy;

import com.bbn.openmap.event.ProjectionEvent;
import com.bbn.openmap.layer.OMGraphicHandlerLayer;
import com.bbn.openmap.layer.policy.AbstractProjectionChangePolicy;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.proj.Projection;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ListResetPCPolicy
extends AbstractProjectionChangePolicy {
    public ListResetPCPolicy() {
    }

    public ListResetPCPolicy(OMGraphicHandlerLayer layer) {
        this.setLayer(layer);
    }

    public void projectionChanged(ProjectionEvent pe) {
        Logger logger = ListResetPCPolicy.getLogger();
        if (this.layer != null) {
            Projection proj = this.layer.setProjection(pe);
            if (proj != null) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(this.getLayer().getName() + ": projectionChanged with NEW projection, resetting list.");
                }
                if (this.layer.getList() != null) {
                    this.layer.setList(new OMGraphicList());
                }
                if (this.layer.isProjectionOK(proj)) {
                    this.layer.doPrepare();
                }
            } else {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(this.getLayer().getName() + ": projectionChanged with OLD projection, repainting.");
                }
                if (!this.layer.isWorking()) {
                    this.layer.repaint();
                    this.layer.fireStatusUpdate(8359);
                }
            }
        } else {
            logger.warning("NULL layer, can't do anything.");
        }
    }

    private static Logger getLogger() {
        return LoggerHolder.LOGGER;
    }

    private static final class LoggerHolder {
        private static final Logger LOGGER = Logger.getLogger(ListResetPCPolicy.class.getName());

        private LoggerHolder() {
            throw new AssertionError((Object)"This should never be instantiated");
        }
    }
}

