/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.image;

import com.bbn.openmap.image.ImageServerConstants;
import com.bbn.openmap.omGraphics.OMColor;
import com.bbn.openmap.proj.Proj;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.proj.ProjectionFactory;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.awt.Color;
import java.awt.Paint;
import java.awt.geom.Point2D;
import java.util.Properties;

public class ImageServerUtils
implements ImageServerConstants {
    public static Proj createOMProjection(Properties props, Projection defaultProj) {
        float scale = PropUtils.floatFromProperties(props, "SCALE", defaultProj.getScale());
        int height = PropUtils.intFromProperties(props, "HEIGHT", defaultProj.getHeight());
        int width = PropUtils.intFromProperties(props, "WIDTH", defaultProj.getWidth());
        Object llp = defaultProj.getCenter();
        float longitude = PropUtils.floatFromProperties(props, "LON", (float)((Point2D)llp).getX());
        float latitude = PropUtils.floatFromProperties(props, "LAT", (float)((Point2D)llp).getY());
        Class<Projection> projClass = null;
        String projType = props.getProperty("PROJTYPE");
        ProjectionFactory projFactory = ProjectionFactory.loadDefaultProjections();
        if (projType != null) {
            projClass = projFactory.getProjClassForName(projType);
        }
        if (projClass == null) {
            projClass = defaultProj.getClass();
        }
        if (Debug.debugging("imageserver")) {
            Debug.output("ImageServerUtils.createOMProjection: projection " + projClass.getName() + ", with HEIGHT = " + height + ", WIDTH = " + width + ", lat = " + latitude + ", lon = " + longitude + ", scale = " + scale);
        }
        Proj proj = (Proj)projFactory.makeProjection(projClass, (Point2D)new Point2D.Float(longitude, latitude), scale, width, height);
        return proj;
    }

    public static Color getBackground(Properties props) {
        return (Color)ImageServerUtils.getBackground(props, Color.white);
    }

    public static Paint getBackground(Properties props, Paint defPaint) {
        boolean transparent = PropUtils.booleanFromProperties(props, "TRANSPARENT", false);
        Paint backgroundColor = PropUtils.parseColorFromProperties(props, "BGCOLOR", defPaint);
        if (backgroundColor == null) {
            backgroundColor = Color.white;
        }
        if (transparent) {
            if (backgroundColor instanceof Color) {
                Color bgc = (Color)backgroundColor;
                backgroundColor = new Color(bgc.getRed(), bgc.getGreen(), bgc.getBlue(), 0);
            } else {
                backgroundColor = OMColor.clear;
            }
        }
        if (Debug.debugging("imageserver")) {
            Debug.output("ImageServerUtils.createOMProjection: projection color: " + (backgroundColor instanceof Color ? Integer.toHexString(((Color)backgroundColor).getRGB()) : backgroundColor.toString()) + ", transparent(" + transparent + ")");
        }
        return backgroundColor;
    }
}

