/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.event;

import com.bbn.openmap.MapBean;
import com.bbn.openmap.dataAccess.shape.EsriGraphicList;
import com.bbn.openmap.geo.Geo;
import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMLine;
import com.bbn.openmap.proj.Proj;
import com.bbn.openmap.proj.Projection;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.net.URL;

public abstract class AzimuthPanner {
    OMGraphicList omGraphics;
    int oX;
    int oY;
    DrawingAttributes azDrawing;

    private AzimuthPanner(int oX, int oY, DrawingAttributes azDrawing) {
        this.oX = oX;
        this.oY = oY;
        this.azDrawing = azDrawing;
    }

    public abstract void handlePan(MapBean var1, MouseEvent var2);

    public abstract void handleUnpan(MouseEvent var1);

    public void render(Graphics g) {
        if (this.omGraphics != null) {
            this.omGraphics.render(g);
        }
    }

    public DrawingAttributes getAzDrawing() {
        return this.azDrawing;
    }

    public void setAzDrawing(DrawingAttributes azDrawing) {
        this.azDrawing = azDrawing;
    }

    public void listenerPaint(Object source, Graphics graphics) {
        if (this.omGraphics != null) {
            this.omGraphics.render(graphics);
        }
    }

    public static class Shapefile
    extends Standard {
        EsriGraphicList list = null;

        public Shapefile(int oX, int oY, DrawingAttributes azDrawing, URL shapefile) {
            super(oX, oY, azDrawing);
            this.list = EsriGraphicList.getEsriGraphicList(shapefile, this.getAzDrawing(), null);
        }

        public void handlePan(MapBean mapBean, MouseEvent me) {
            Projection proj = mapBean.getRotatedProjection();
            Point2D pnt0 = mapBean.inverse(this.oX, this.oY, null);
            Point2D pnt = mapBean.inverse(me.getX(), me.getY(), null);
            Geo g0 = new Geo(pnt0.getY(), pnt0.getX());
            Geo g = new Geo(pnt.getY(), pnt.getX());
            double distance = g0.distance(g);
            double az = g.azimuth(g0);
            Object c = proj.getCenter();
            Geo ngc = new Geo(((Point2D)c).getY(), ((Point2D)c).getX()).offset(distance, az);
            Proj newProj = (Proj)mapBean.getProjectionFactory().makeProjection(proj.getClass().getName(), proj);
            newProj.setRotationAngle(proj.getRotationAngle());
            newProj.setCenter(ngc.getLatitude(), ngc.getLongitude());
            if (this.list != null) {
                OMGraphicList newList = new OMGraphicList(this.list);
                newList.generate(newProj);
                this.omGraphics = newList;
                mapBean.repaint();
            }
        }
    }

    public static class Standard
    extends AzimuthPanner {
        public Standard(int oX, int oY, DrawingAttributes azDrawing) {
            super(oX, oY, azDrawing);
        }

        public void handlePan(MapBean mapBean, MouseEvent me) {
            Point2D pnt0 = mapBean.inverse(this.oX, this.oY, null);
            Point2D llp = mapBean.inverse(me.getX(), me.getY(), null);
            if (llp != null && !llp.equals(pnt0)) {
                OMLine line3;
                OMGraphicList list = new OMGraphicList();
                OMLine line1 = new OMLine(90.0, llp.getX(), llp.getY(), llp.getX(), 3);
                OMLine line2 = new OMLine(llp.getY(), llp.getX(), -90.0, llp.getX(), 3);
                list.add(line1);
                list.add(line2);
                if (llp.getX() < 0.0) {
                    line3 = new OMLine(llp.getY(), -180.0, llp.getY(), llp.getX(), 2);
                    OMLine line4 = new OMLine(llp.getY(), llp.getX(), llp.getY(), 0.0, 2);
                    OMLine line5 = new OMLine(llp.getY(), 0.0, llp.getY(), 179.9, 2);
                    list.add(line3);
                    list.add(line4);
                    list.add(line5);
                } else {
                    line3 = new OMLine(llp.getY(), 0.0, llp.getY(), llp.getX(), 2);
                    OMLine line4 = new OMLine(llp.getY(), llp.getX(), llp.getY(), 180.0, 2);
                    OMLine line5 = new OMLine(llp.getY(), -179.0, llp.getY(), 0.0, 2);
                    list.add(line3);
                    list.add(line4);
                    list.add(line5);
                }
                OMLine line6 = new OMLine(pnt0.getY(), pnt0.getX(), llp.getY(), llp.getX(), 3);
                line6.addArrowHead(true);
                list.add(line6);
                this.getAzDrawing().setTo(list);
                this.omGraphics = list;
                list.generate(mapBean.getRotatedProjection());
                mapBean.repaint();
            }
        }

        public void handleUnpan(MouseEvent me) {
            this.omGraphics = null;
        }
    }
}

