/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.dataAccess.shape;

import com.bbn.openmap.dataAccess.shape.DbfTableModel;
import com.bbn.openmap.dataAccess.shape.DrawingToolRenderException;
import com.bbn.openmap.dataAccess.shape.EsriGraphicList;
import com.bbn.openmap.dataAccess.shape.EsriPointList;
import com.bbn.openmap.dataAccess.shape.EsriPolygonList;
import com.bbn.openmap.dataAccess.shape.EsriPolylineList;
import com.bbn.openmap.dataAccess.shape.ShapeConstants;
import com.bbn.openmap.dataAccess.shape.output.DbfOutputStream;
import com.bbn.openmap.dataAccess.shape.output.ShpOutputStream;
import com.bbn.openmap.dataAccess.shape.output.ShxOutputStream;
import com.bbn.openmap.omGraphics.BasicStrokeEditor;
import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.omGraphics.OMAreaList;
import com.bbn.openmap.omGraphics.OMCircle;
import com.bbn.openmap.omGraphics.OMGeometry;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicConstants;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMLine;
import com.bbn.openmap.omGraphics.OMList;
import com.bbn.openmap.omGraphics.OMPoint;
import com.bbn.openmap.omGraphics.OMPoly;
import com.bbn.openmap.omGraphics.OMRangeRings;
import com.bbn.openmap.omGraphics.OMRect;
import com.bbn.openmap.proj.ProjMath;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.proj.coords.GeoCoordTransformation;
import com.bbn.openmap.util.ArgParser;
import com.bbn.openmap.util.ColorFactory;
import com.bbn.openmap.util.FileUtils;
import com.bbn.openmap.util.PropUtils;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EsriShapeExport
implements ShapeConstants,
OMGraphicConstants {
    public static Logger logger = Logger.getLogger("com.bbn.openmap.dataAccess.shape.EsriShapeExport");
    protected OMGraphicList graphicList = null;
    protected DbfTableModel masterDBF = null;
    protected Projection projection;
    protected String filePath;
    protected boolean DEBUG = false;
    protected ArrayList<ESEInterface> eseInterfaces = new ArrayList();
    protected boolean writeDBF = true;
    protected boolean dbfHasRenderingInfo = false;
    protected GeoCoordTransformation transform;
    protected EsriPolygonList polyList = null;
    protected EsriPolylineList lineList = null;
    protected EsriPointList pointList = null;
    int badGraphics;
    public static final String LineSuffix = "Lines";
    public static final String PointSuffix = "Pts";
    protected JFrame frame = null;

    public EsriShapeExport(OMGraphicList list, Projection proj, String pathToFile) {
        this.setGraphicList(list);
        this.projection = proj;
        this.filePath = pathToFile;
        this.DEBUG = logger.isLoggable(Level.FINE);
    }

    public EsriShapeExport(EsriGraphicList list, DbfTableModel dbf, String pathToFile) {
        this.setGraphicList(list);
        this.setMasterDBF(dbf);
        this.filePath = pathToFile;
        this.DEBUG = logger.isLoggable(Level.FINE);
    }

    public void setGraphicList(OMGraphicList list) {
        this.graphicList = list;
        if (list != null) {
            Object obj = list.getAttribute("DBF_ATTRIBUTE");
            if (obj == null) {
                obj = list.getAppObject();
            }
            if (obj instanceof DbfTableModel) {
                this.masterDBF = (DbfTableModel)obj;
                logger.fine("Setting master DBF in ESE");
            }
        }
    }

    public OMGraphicList getGraphicList() {
        return this.graphicList;
    }

    public void setProjection(Projection proj) {
        this.projection = proj;
    }

    public Projection getProjection() {
        return this.projection;
    }

    public void setFilePath(String pathToFile) {
        this.filePath = pathToFile;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public GeoCoordTransformation getTransform() {
        return this.transform;
    }

    public void setTransform(GeoCoordTransformation transform) {
        this.transform = transform;
    }

    protected EsriPolygonList getPolyList() {
        if (this.polyList == null) {
            this.polyList = new EsriPolygonList();
            this.polyList.setTable(this.getMasterDBFHeaderClone());
        }
        return this.polyList;
    }

    protected EsriPolylineList getLineList() {
        if (this.lineList == null) {
            this.lineList = new EsriPolylineList();
            this.lineList.setTable(this.getMasterDBFHeaderClone());
        }
        return this.lineList;
    }

    protected EsriPointList getPointList() {
        if (this.pointList == null) {
            this.pointList = new EsriPointList();
            this.pointList.setTable(this.getMasterDBFHeaderClone());
        }
        return this.pointList;
    }

    protected void addGraphic(EsriGraphicList egl, OMGraphic graphic, List<Object> record) {
        egl.add(graphic);
        DbfTableModel dtm = egl.getTable();
        if (dtm != null && record != null) {
            dtm.addRecord(record);
        }
    }

    protected void addPolygon(OMGraphic graphic, List<Object> record) {
        this.addGraphic(this.getPolyList(), graphic, record);
    }

    protected void addLine(OMGraphic graphic, List<Object> record) {
        this.addGraphic(this.getLineList(), graphic, record);
    }

    protected void addPoint(OMGraphic graphic, List<Object> record) {
        this.addGraphic(this.getPointList(), graphic, record);
    }

    protected void addAreaList(OMAreaList omal, List<Object> record) {
        double[] coords = this.gatherCoords(omal, null);
        if (coords != null) {
            this.addLine(new OMPoly(coords, 0, 1), record);
        }
    }

    protected double[] gatherCoords(OMGeometry omg, double[] current) {
        if (omg instanceof OMList) {
            OMList oml = (OMList)omg;
            for (OMGeometry omgy : oml) {
                current = this.gatherCoords(omgy, current);
            }
            return current;
        }
        if (omg.getRenderType() == 1) {
            if (omg instanceof OMPoly) {
                current = this.combineCoords(current, ProjMath.arrayRadToDeg(((OMPoly)omg).getLatLonArrayCopy()));
            } else if (omg instanceof OMLine) {
                current = this.combineCoords(current, ((OMLine)omg).getLL());
            } else if (omg instanceof OMPoint) {
                OMPoint omp = (OMPoint)omg;
                double lat = omp.getLat();
                double lon = omp.getLon();
                current = this.combineCoords(current, new double[]{lat, lon});
            }
        }
        return current;
    }

    protected double[] combineCoords(double[] orig, double[] addCoords) {
        if (orig != null && addCoords != null) {
            System.out.println("creating double array size " + (orig.length + addCoords.length));
            double[] newCoords = new double[orig.length + addCoords.length];
            System.arraycopy(orig, 0, newCoords, 0, orig.length);
            System.arraycopy(addCoords, 0, newCoords, orig.length, addCoords.length);
            return newCoords;
        }
        if (orig == null && addCoords == null) {
            return new double[0];
        }
        if (orig != null) {
            return orig;
        }
        return addCoords;
    }

    public void setMasterDBF(DbfTableModel dbf) {
        this.masterDBF = dbf;
    }

    public DbfTableModel getMasterDBF() {
        return this.masterDBF;
    }

    public void setWriteDBF(boolean value) {
        this.writeDBF = value;
    }

    public boolean getWriteDBF() {
        return this.writeDBF;
    }

    public void setDBFHasRenderingInfo(boolean value) {
        this.dbfHasRenderingInfo = value;
    }

    public boolean getDBFHasRenderingInfo() {
        return this.dbfHasRenderingInfo;
    }

    protected DbfTableModel getMasterDBFHeaderClone() {
        if (this.masterDBF != null) {
            return this.masterDBF.headerClone();
        }
        return null;
    }

    protected List<Object> getMasterDBFRecord(int index) {
        try {
            if (this.masterDBF != null) {
                return this.masterDBF.getRecord(index);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return null;
    }

    public void export() {
        OMGraphicList list = this.getGraphicList();
        if (list == null) {
            logger.warning("no graphic list to export!");
            return;
        }
        this.export(list, null, true);
    }

    protected void export(OMGraphicList list, List<Object> record) {
        this.export(list, record, true);
    }

    protected void export(OMGraphicList list, List<Object> masterRecord, boolean writeFiles) {
        this.badGraphics = 0;
        if (list == null) {
            return;
        }
        if (list instanceof EsriGraphicList) {
            this.export((EsriGraphicList)list);
            return;
        }
        int dbfIndex = 0;
        for (OMGraphic dtlGraphic : list) {
            List<Object> record = masterRecord;
            Integer recIndex = (Integer)dtlGraphic.getAttribute("SHAPE_INDEX_ATTRIBUTE");
            if (recIndex == null) {
                recIndex = dbfIndex;
            }
            if (record == null) {
                record = this.getMasterDBFRecord(recIndex);
            }
            ++dbfIndex;
            if (dtlGraphic instanceof OMGraphicList) {
                if (this.DEBUG) {
                    logger.fine("ESE: handling OMGraphicList");
                }
                this.export((OMGraphicList)dtlGraphic, record, false);
                continue;
            }
            if (dtlGraphic.getRenderType() != 1) {
                ++this.badGraphics;
                continue;
            }
            if (dtlGraphic instanceof OMAreaList) {
                if (this.DEBUG) {
                    logger.fine("ESE: handling OMAreaList");
                }
                this.addAreaList((OMAreaList)dtlGraphic, record);
            }
            if (dtlGraphic instanceof OMPoly) {
                OMPoly omPoly = (OMPoly)dtlGraphic;
                if (EsriShapeExport.isPolygon(omPoly)) {
                    if (this.DEBUG) {
                        logger.fine("ESE: handling OMPoly polygon");
                    }
                    this.addPolygon(dtlGraphic, record);
                    continue;
                }
                if (this.DEBUG) {
                    logger.fine("ESE: handling OMPoly line");
                }
                this.addLine(dtlGraphic, record);
                continue;
            }
            if (dtlGraphic instanceof OMRect) {
                if (this.DEBUG) {
                    logger.fine("ESE: handling OMRect");
                }
                this.addPolygon(EsriPolygonList.convert((OMRect)dtlGraphic), record);
                continue;
            }
            if (dtlGraphic instanceof OMCircle) {
                if (this.DEBUG) {
                    logger.fine("ESE: handling OMCircle");
                }
                this.addPolygon(EsriPolygonList.convert((OMCircle)dtlGraphic, this.projection), record);
                continue;
            }
            if (dtlGraphic instanceof OMRangeRings) {
                if (this.DEBUG) {
                    logger.fine("ESE: handling OMRangeRings");
                }
                this.export(EsriPolygonList.convert((OMRangeRings)dtlGraphic, this.projection), record, false);
                continue;
            }
            if (dtlGraphic instanceof OMLine) {
                if (this.DEBUG) {
                    logger.fine("ESE: handling OMLine");
                }
                this.addLine(EsriPolylineList.convert((OMLine)dtlGraphic), record);
                continue;
            }
            if (!(dtlGraphic instanceof OMPoint)) continue;
            if (this.DEBUG) {
                logger.fine("ESE: handling OMPoint");
            }
            this.addPoint(dtlGraphic, record);
        }
        if (this.badGraphics > 0) {
            DrawingToolRenderException.notifyUserOfNonLatLonGraphics(this.badGraphics);
        }
        if (!writeFiles) {
            return;
        }
        boolean needConfirmation = false;
        if (this.filePath == null) {
            this.filePath = this.getFilePathFromUser();
            if (this.filePath == null) {
                return;
            }
            needConfirmation = true;
        }
        if (this.DEBUG) {
            logger.fine("ESE: writing files...");
        }
        boolean needTypeSuffix = false;
        if (this.polyList != null) {
            this.eseInterfaces.add(new ESEInterface(this.polyList, this.filePath, null));
            needTypeSuffix = true;
        }
        if (this.lineList != null) {
            this.eseInterfaces.add(new ESEInterface(this.lineList, this.filePath, needTypeSuffix ? LineSuffix : null));
            needTypeSuffix = true;
        }
        if (this.pointList != null) {
            this.eseInterfaces.add(new ESEInterface(this.pointList, this.filePath, needTypeSuffix ? PointSuffix : null));
        }
        if (needConfirmation) {
            this.showGUI();
        } else {
            this.writeFiles();
        }
    }

    protected void export(EsriGraphicList egList) {
        Object obj = egList.getAttribute("DBF_ATTRIBUTE");
        if (obj == null) {
            obj = egList.getAppObject();
        }
        if (obj == null) {
            egList.putAttribute("DBF_ATTRIBUTE", this.getMasterDBF());
        }
        this.eseInterfaces.add(new ESEInterface(egList, this.filePath, null));
        this.writeFiles();
    }

    protected Iterator<ESEInterface> getInterfaces() {
        return this.eseInterfaces.iterator();
    }

    protected void writeFiles() {
        for (ESEInterface eseInterface : this.eseInterfaces) {
            eseInterface.write();
        }
    }

    public void showGUI() {
        if (this.frame == null) {
            this.frame = new JFrame("Saving Shape Files");
            this.frame.getContentPane().add(this.getGUI(), "Center");
            this.frame.pack();
        }
        this.frame.setVisible(true);
    }

    public void hideGUI() {
        if (this.frame != null) {
            this.frame.setVisible(false);
        }
    }

    public Component getGUI() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        JPanel interfacePanel = new JPanel();
        interfacePanel.setLayout(new GridLayout(0, 1));
        int count = 0;
        for (ESEInterface eseInterface : this.eseInterfaces) {
            interfacePanel.add(eseInterface.getGUI());
            ++count;
        }
        panel.add((Component)interfacePanel, "Center");
        if (count > 1) {
            JLabel notification = new JLabel("  " + count + " Shape file sets needed:");
            panel.add((Component)notification, "North");
        }
        JButton saveButton = new JButton("Save");
        saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                EsriShapeExport.this.writeFiles();
                EsriShapeExport.this.hideGUI();
            }
        });
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                EsriShapeExport.this.hideGUI();
            }
        });
        JPanel controlPanel = new JPanel();
        controlPanel.add(saveButton);
        controlPanel.add(cancelButton);
        panel.add((Component)controlPanel, "South");
        return panel;
    }

    public static DbfTableModel createDefaultModel(EsriGraphicList list) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("ESE: creating DbfTableModel");
        }
        DbfTableModel _model = new DbfTableModel(7);
        _model.setLength(0, 50);
        _model.setColumnName(0, "Description");
        _model.setType(0, (byte)67);
        _model.setDecimalCount(0, (byte)0);
        _model.setLength(1, 10);
        _model.setColumnName(1, "lineColor");
        _model.setType(1, (byte)67);
        _model.setDecimalCount(1, (byte)0);
        _model.setLength(2, 10);
        _model.setColumnName(2, "fillColor");
        _model.setType(2, (byte)67);
        _model.setDecimalCount(2, (byte)0);
        _model.setLength(3, 10);
        _model.setColumnName(3, "selectColor");
        _model.setType(3, (byte)67);
        _model.setDecimalCount(3, (byte)0);
        _model.setLength(4, 4);
        _model.setColumnName(4, "lineWidth");
        _model.setType(4, (byte)78);
        _model.setDecimalCount(4, (byte)0);
        _model.setLength(5, 20);
        _model.setColumnName(5, "dashPattern");
        _model.setType(5, (byte)67);
        _model.setDecimalCount(5, (byte)0);
        _model.setLength(6, 10);
        _model.setColumnName(6, "dashPhase");
        _model.setType(6, (byte)78);
        _model.setDecimalCount(6, (byte)4);
        int count = 0;
        for (OMGraphic omg : list) {
            Object index = omg.getAttribute("SHAPE_INDEX_ATTRIBUTE");
            if (index == null) {
                index = new Integer(count);
                omg.putAttribute("SHAPE_INDEX_ATTRIBUTE", index);
            }
            ++count;
            ArrayList<Object> record = new ArrayList<Object>();
            Object obj = omg.getAppObject();
            if (obj instanceof String) {
                record.add(obj);
            } else {
                record.add("");
            }
            record.add(ColorFactory.getHexColorString(omg.getLineColor()));
            record.add(ColorFactory.getHexColorString(omg.getFillColor()));
            record.add(ColorFactory.getHexColorString(omg.getSelectColor()));
            BasicStroke bs = (BasicStroke)omg.getStroke();
            record.add(new Double(bs.getLineWidth()));
            String dp = BasicStrokeEditor.dashArrayToString(bs.getDashArray());
            if (dp == "No Dash Pattern") {
                dp = "";
            }
            record.add(dp);
            record.add(new Double(bs.getDashPhase()));
            _model.addRecord(record);
            if (!logger.isLoggable(Level.FINER)) continue;
            logger.finer("ESE: adding record: " + record);
        }
        return _model;
    }

    public static void syncDrawingAttributesToTableModel(DbfTableModel model, OMGraphicList list, boolean clearUpdatedStatus) {
        int count = 0;
        for (OMGraphic omg : list) {
            String dp;
            Object indexObj = omg.getAttribute("SHAPE_INDEX_ATTRIBUTE");
            if (indexObj == null || !(indexObj instanceof Integer)) {
                indexObj = new Integer(count);
                omg.putAttribute("SHAPE_INDEX_ATTRIBUTE", indexObj);
            }
            ++count;
            int index = (Integer)indexObj;
            Object updatedStatus = omg.getAttribute("Updated");
            if (updatedStatus != Boolean.TRUE) continue;
            List<Object> record = model.getRecord(index);
            index = model.getColumnIndexForName("lineColor");
            if (index >= 0) {
                record.set(index, ColorFactory.getHexColorString(omg.getLineColor()));
            }
            if ((index = model.getColumnIndexForName("fillColor")) >= 0) {
                record.set(index, ColorFactory.getHexColorString(omg.getFillColor()));
            }
            if ((index = model.getColumnIndexForName("selectColor")) >= 0) {
                record.set(index, ColorFactory.getHexColorString(omg.getSelectColor()));
            }
            BasicStroke bs = (BasicStroke)omg.getStroke();
            index = model.getColumnIndexForName("lineWidth");
            if (index >= 0) {
                record.set(index, new Double(bs.getLineWidth()));
            }
            if ((dp = BasicStrokeEditor.dashArrayToString(bs.getDashArray())) == "No Dash Pattern") {
                dp = "";
            }
            if ((index = model.getColumnIndexForName("dashPattern")) >= 0) {
                record.set(index, dp);
            }
            if ((index = model.getColumnIndexForName("dashPhase")) >= 0) {
                record.set(index, new Double(bs.getDashPhase()));
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("ESE: updating record for OMGraphic: " + indexObj);
            }
            if (!clearUpdatedStatus) continue;
            omg.removeAttribute("Updated");
        }
    }

    public static boolean isPolygon(OMPoly omPoly) {
        double[] points = omPoly.getLatLonArray();
        int i = points.length;
        boolean isPolygon = false;
        if (points != null && i > 5) {
            isPolygon = points[0] == points[i - 2] && points[1] == points[i - 1];
            isPolygon = isPolygon && omPoly.isPolygon();
        }
        return isPolygon;
    }

    protected void handleException(Exception e) {
        StringBuffer sb = new StringBuffer("ShapeFile Export Error:");
        sb.append("\nProblem with creating the shapefile set.");
        sb.append("\n").append(e.toString());
        JOptionPane.showMessageDialog(null, sb.toString(), "ESRI Shape Export to File", 0);
        e.printStackTrace();
    }

    public String getFilePathFromUser() {
        return FileUtils.getFilePathToSaveFromUser("Select Name for Shape File Set...");
    }

    public static void main(String[] argv) {
        ArgParser ap = new ArgParser("EsriShapeExport");
        ap.add("shp", "A URL to a shape file (.shp).", 1);
        if (argv.length < 1) {
            ap.bail("", true);
        }
        ap.parse(argv);
        String[] files = ap.getArgValues("shp");
        if (files != null && files[0] != null) {
            String shp = files[0];
            String dbf = null;
            try {
                dbf = shp.substring(0, shp.lastIndexOf(46) + 1) + "dbf";
                DbfTableModel model = DbfTableModel.getDbfTableModel(PropUtils.getResourceOrFileOrURL(dbf));
                EsriGraphicList list = EsriGraphicList.getEsriGraphicList(PropUtils.getResourceOrFileOrURL(shp), null, null);
                logger.info(list.getDescription());
                EsriShapeExport ese = new EsriShapeExport(list, model, null);
                ese.export();
            }
            catch (MalformedURLException murle) {
                logger.warning("EsriShapeExport: Malformed URL Exception\n" + murle.getMessage());
            }
            catch (NullPointerException npe) {
                logger.warning("EsriShapeExport: Path to shape file isn't good enough to find .dbf file and .shx file.");
            }
            catch (Exception exception) {
                logger.warning("EsriShapeExport: Exception\n" + exception.getMessage());
                exception.printStackTrace();
            }
        } else {
            ap.bail("Need a path to a Shape file (.shp)", true);
        }
        System.exit(0);
    }

    public static OMGraphicList read(URL shpFileURL, DrawingAttributes drawingAttributes, GeoCoordTransformation coordTransform) {
        OMGraphicList ret = null;
        if (shpFileURL != null) {
            EsriGraphicList regList = EsriGraphicList.getEsriGraphicList(shpFileURL, drawingAttributes, coordTransform);
            ret = new OMGraphicList();
            ret.addAll(regList);
            DbfTableModel regDbf = (DbfTableModel)regList.getAttribute("DBF_ATTRIBUTE");
            ret.putAttribute("DBF_ATTRIBUTE", regDbf);
            String shpFilePath = shpFileURL.getPath();
            if (shpFilePath.endsWith(".shp")) {
                String linesPath = shpFilePath.replace(".shp", "_Lines.shp");
                String pntsPath = shpFilePath.replace(".shp", "_Pts.shp");
                logger.fine("looking for " + linesPath + " and " + pntsPath);
                try {
                    EsriGraphicList pntsList;
                    URL pntsURL;
                    EsriGraphicList lineList;
                    URL linesURL = PropUtils.getResourceOrFileOrURL(linesPath);
                    if (linesURL != null && (lineList = EsriGraphicList.getEsriGraphicList(linesURL, drawingAttributes, coordTransform)) != null) {
                        DbfTableModel dbf = (DbfTableModel)lineList.getAttribute("DBF_ATTRIBUTE");
                        if (regDbf != null && dbf != null && regDbf.matches(dbf)) {
                            regDbf.append(dbf);
                            ret.addAll(lineList);
                        }
                    }
                    if ((pntsURL = PropUtils.getResourceOrFileOrURL(pntsPath)) != null && (pntsList = EsriGraphicList.getEsriGraphicList(pntsURL, drawingAttributes, coordTransform)) != null) {
                        DbfTableModel dbf = (DbfTableModel)pntsList.getAttribute("DBF_ATTRIBUTE");
                        if (regDbf != null && dbf != null && regDbf.matches(dbf)) {
                            regDbf.append(dbf);
                            ret.addAll(pntsList);
                        }
                    }
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            }
        }
        return ret;
    }

    public class ESEInterface {
        protected EsriGraphicList list;
        protected DbfTableModel model;
        protected String suffix;
        protected String filePath;
        File shpFile = null;
        File shxFile = null;
        File dbfFile = null;
        protected JTextField filePathField;

        public ESEInterface(EsriGraphicList eglist, String filePathString, String fileNameSuffix) {
            this.list = eglist;
            this.filePath = filePathString;
            this.model = eglist.getTable();
            if (this.model == null) {
                this.model = EsriShapeExport.createDefaultModel(this.list);
            } else {
                EsriShapeExport.syncDrawingAttributesToTableModel(this.model, this.list, true);
            }
            this.model.setWritable(true);
            String string = this.suffix = fileNameSuffix == null ? "" : "_" + fileNameSuffix;
            if (EsriShapeExport.this.DEBUG) {
                logger.fine("suffix being used for " + filePathString + ": " + this.suffix);
            }
        }

        public Component getGUI() {
            String sectionTitle;
            JPanel panel = new JPanel();
            int type = this.list.getType();
            switch (type) {
                case 1: {
                    sectionTitle = "Point Shape File";
                    break;
                }
                case 3: {
                    sectionTitle = "Line Shape File";
                    break;
                }
                case 5: {
                    sectionTitle = "Polygon Shape File";
                    break;
                }
                default: {
                    sectionTitle = "Shape File";
                }
            }
            panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), sectionTitle));
            panel.setLayout(new GridLayout(0, 1));
            JPanel pathPanel = new JPanel();
            this.filePathField = new JTextField(20);
            this.filePathField.setText(this.filePath + this.suffix);
            JButton filePathChooserLauncher = new JButton("Change Path");
            filePathChooserLauncher.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    ESEInterface.this.setFilePath(EsriShapeExport.this.getFilePathFromUser());
                }
            });
            panel.add(this.filePathField);
            JButton editDBFButton = new JButton("Edit the Attribute File...");
            editDBFButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    ESEInterface.this.model.showGUI(EsriShapeExport.this.getFilePath() + " Attributes", 10);
                }
            });
            pathPanel.add(editDBFButton);
            pathPanel.add(filePathChooserLauncher);
            panel.add(pathPanel);
            return panel;
        }

        protected void setFilePath(String path) {
            this.filePath = path;
        }

        public void write() {
            if (this.filePathField != null) {
                this.filePath = this.filePathField.getText();
            }
            if (this.filePath == null) {
                this.filePath = EsriShapeExport.this.getFilePathFromUser();
                if (this.filePath == null) {
                    return;
                }
            }
            if (this.filePath.endsWith(".shp") || this.filePath.endsWith(".shx") || this.filePath.endsWith(".dbf")) {
                this.filePath = this.filePath.substring(0, this.filePath.length() - 4);
            }
            this.filePath = this.filePath + this.suffix;
            this.shpFile = new File(this.filePath + ".shp");
            this.shxFile = new File(this.filePath + ".shx");
            this.dbfFile = new File(this.filePath + ".dbf");
            try {
                if (EsriShapeExport.this.DEBUG) {
                    logger.fine("ESE writing: " + this.list.size() + " elements in " + this.shpFile.getAbsolutePath());
                }
                ShpOutputStream pos = new ShpOutputStream(new FileOutputStream(this.shpFile));
                if (EsriShapeExport.this.transform != null) {
                    pos.setTransform(EsriShapeExport.this.transform);
                }
                int[][] indexData = pos.writeGeometry(this.list);
                ShxOutputStream xos = new ShxOutputStream(new FileOutputStream(this.shxFile));
                xos.writeIndex(indexData, this.list.getType());
                if (EsriShapeExport.this.getWriteDBF()) {
                    FileOutputStream fos = new FileOutputStream(this.dbfFile);
                    DbfOutputStream dos = new DbfOutputStream(fos);
                    dos.writeModel(this.model);
                    fos.close();
                }
            }
            catch (Exception e) {
                EsriShapeExport.this.handleException(e);
            }
        }
    }
}

