/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.dataAccess.cgm;

import com.bbn.openmap.dataAccess.cgm.CGM;
import com.bbn.openmap.dataAccess.cgm.CGMPanel;
import com.bbn.openmap.omGraphics.OMColor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class CGMDisplay {
    Graphics G;
    protected double X = 0.0;
    protected double Y = 0.0;
    protected double DX = 1.0;
    protected double DY = 1.0;
    protected int W;
    protected int H;
    protected CGM Cgm;
    Color FillColor = OMColor.clear;
    Color EdgeColor = Color.black;
    Color LineColor = Color.black;
    Color TextColor = Color.black;
    boolean Filled = true;
    boolean Edge = true;
    int TextSize = 10;
    protected int[] Extent = new int[]{-30000, -30000, 30000, 30000};

    public CGMDisplay(CGM cgm) {
        this.load(cgm);
    }

    public void load(CGM cgm) {
        this.Cgm = cgm;
        int[] extent = cgm.extent();
        if (extent != null) {
            this.Extent = extent;
        }
    }

    public void paint(Graphics g) {
        this.G = g;
        this.Cgm.paint(this);
    }

    public int x(int x) {
        return this.W + (int)(this.X + (double)x * this.DX);
    }

    public int y(int y) {
        return this.H - (int)(this.Y + (double)y * this.DY);
    }

    public Graphics graphics() {
        return this.G;
    }

    public void setFillColor(Color c) {
        this.FillColor = c;
    }

    public Color getFillColor() {
        return this.FillColor;
    }

    public void setFilled(boolean flag) {
        this.Filled = flag;
    }

    public boolean getFilled() {
        return this.Filled;
    }

    public void setEdgeColor(Color c) {
        this.EdgeColor = c;
    }

    public Color getEdgeColor() {
        return this.EdgeColor;
    }

    public void setEdge(boolean flag) {
        this.Edge = flag;
    }

    public boolean getEdge() {
        return this.Edge;
    }

    public void setLineColor(Color c) {
        this.LineColor = c;
    }

    public Color getLineColor() {
        return this.LineColor;
    }

    public void setTextColor(Color c) {
        this.TextColor = c;
    }

    public Color getTextColor() {
        return this.TextColor;
    }

    public void setTextSize(int h) {
        this.TextSize = h;
    }

    public int getTextSize() {
        return this.TextSize;
    }

    public double factorX() {
        return this.DX;
    }

    public double factorY() {
        return this.DY;
    }

    public void scale(int w, int h) {
        if (this.Extent == null) {
            return;
        }
        double fx = (double)w / (double)(this.Extent[2] - this.Extent[0]);
        if (fx * (double)(this.Extent[3] - this.Extent[1]) > (double)h) {
            fx = (double)h / (double)(this.Extent[3] - this.Extent[1]);
        }
        this.DX = fx *= 1.0;
        this.DY = fx;
        this.X = (double)(-this.Extent[0]) * fx;
        this.Y = (double)(-this.Extent[1]) * fx;
        this.W = (int)((double)w - fx * (double)(this.Extent[2] - this.Extent[0])) / 2;
        this.H = (int)((double)h - ((double)h - fx * (double)(this.Extent[3] - this.Extent[1])) / 2.0);
        this.Cgm.scale(this);
    }

    public BufferedImage getBufferedImage(int w, int h) {
        BufferedImage image = new BufferedImage(w, h, 2);
        Graphics g = image.getGraphics();
        this.scale(w, h);
        this.paint(g);
        return image;
    }

    public void frame(Graphics g) {
        if (this.Extent == null) {
            return;
        }
        g.setColor(Color.black);
        g.drawRect(this.x(this.Extent[0]) - 1, this.y(this.Extent[3]) - 1, (int)Math.abs((double)(this.Extent[2] - this.Extent[0]) * this.DX) + 1, (int)Math.abs((double)(this.Extent[3] - this.Extent[1]) * this.DY) + 1);
    }

    public static void main(String[] args) throws IOException {
        File cgmFile;
        File file;
        if (args.length == 0) {
            System.out.println("Need a path to a cgm file or directory containing cgm files.");
            System.exit(-1);
        }
        if (!(file = new File(args[0])).exists()) {
            System.out.println("Can't find file: " + args[0]);
        }
        JPanel choicePanel = null;
        JComboBox<String> comboBox = null;
        JButton nextButton = null;
        JButton prevButton = null;
        String[] files = null;
        if (file.isDirectory()) {
            files = file.list();
            cgmFile = new File(file, files[0]);
            choicePanel = new JPanel();
            comboBox = new JComboBox<String>(files);
            nextButton = new JButton("Next");
            nextButton.setName("Next");
            prevButton = new JButton("Previous");
            prevButton.setName("Previous");
            choicePanel.add(prevButton);
            choicePanel.add(comboBox);
            choicePanel.add(nextButton);
        } else {
            cgmFile = file;
        }
        DataInputStream in = new DataInputStream(new FileInputStream(cgmFile));
        CGM cgm = new CGM();
        cgm.read(in);
        in.close();
        CGMDisplay d = new CGMDisplay(cgm);
        CGMPanel p = new CGMPanel(d);
        Frame f = new Frame();
        f.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        f.setSize(600, 450);
        f.setLayout(new BorderLayout());
        f.add("Center", p);
        if (choicePanel != null) {
            f.add("North", choicePanel);
        }
        if (comboBox != null && nextButton != null && prevButton != null) {
            ServeChoice sc = new ServeChoice(file, comboBox, d);
            comboBox.addActionListener(sc);
            nextButton.addActionListener(sc);
            prevButton.addActionListener(sc);
            sc.setRepainter(p);
        }
        f.setVisible(true);
    }

    public void changeColor(Color oldc, Color newc) {
        this.Cgm.changeColor(oldc, newc);
    }

    protected static class ServeChoice
    implements ActionListener {
        JButton label;
        File parent;
        CGMDisplay d;
        JComboBox jcb;
        Component repainter;

        public ServeChoice(File parent, JComboBox jcb, CGMDisplay d) {
            this.parent = parent;
            this.d = d;
            this.jcb = jcb;
        }

        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source instanceof JButton) {
                int index;
                String name = ((JButton)source).getName();
                if (name.equals("Next")) {
                    int index2;
                    if (this.jcb != null && (index2 = this.jcb.getSelectedIndex()) < this.jcb.getItemCount() - 1) {
                        this.jcb.setSelectedIndex(index2 + 1);
                    }
                } else if (name.equals("Previous") && this.jcb != null && (index = this.jcb.getSelectedIndex()) > 1) {
                    this.jcb.setSelectedIndex(index - 1);
                }
            } else if (source instanceof JComboBox) {
                JComboBox jcb = (JComboBox)source;
                String newName = (String)jcb.getSelectedItem();
                File cgmFile = new File(this.parent, newName);
                try {
                    DataInputStream in = new DataInputStream(new FileInputStream(cgmFile));
                    CGM cgm = new CGM();
                    cgm.read(in);
                    in.close();
                    System.out.println("*********************");
                    System.out.println(cgm.toString());
                    System.out.println("*********************");
                    this.d.load(cgm);
                    Component repainter = this.getRepainter();
                    if (repainter != null) {
                        repainter.repaint();
                    }
                }
                catch (FileNotFoundException e1) {
                    e1.printStackTrace();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }

        public Component getRepainter() {
            return this.repainter;
        }

        public void setRepainter(Component repainter) {
            this.repainter = repainter;
        }
    }
}

