/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.tools.roads;

import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.proj.GreatCircle;
import com.bbn.openmap.proj.coords.LatLonPoint;
import com.bbn.openmap.tools.roads.Intersection;
import com.bbn.openmap.tools.roads.RoadClass;
import com.bbn.openmap.tools.roads.RoadLayer;
import com.bbn.openmap.tools.roads.RoadLine;
import com.bbn.openmap.tools.roads.RoadObject;
import com.bbn.openmap.tools.roads.RoadPoint;
import com.bbn.openmap.tools.roads.Waypoint;
import java.awt.Point;
import java.io.Serializable;
import java.util.logging.Logger;

public class Road
implements RoadObject,
Serializable {
    transient Logger logger = Logger.getLogger(this.getClass().getName());
    private Waypoint[] points;
    private RoadLine[] lines;
    private RoadClass roadClass;
    private boolean isRoute = false;
    private boolean blocked = false;
    private int id;
    private String name;
    private boolean modified = false;
    private transient RoadLayer roadLayer;
    private boolean selected = false;
    private boolean blinkState = false;

    public Road(int id, String name, Intersection from, Intersection to, RoadClass roadClass, RoadLayer roadLayer) {
        this.id = id;
        this.name = name;
        this.roadLayer = roadLayer;
        this.points = new Waypoint[2];
        this.setIntersections(from, to);
        this.roadClass = roadClass;
        this.createLines();
        this.modified = false;
    }

    public double getLengthInKilometers() {
        double kilometers = 0.0;
        LatLonPoint prevPoint = this.points[0].getLocation();
        for (int i = 1; i < this.points.length; ++i) {
            LatLonPoint thisPoint = this.points[i].getLocation();
            kilometers += GreatCircle.sphericalDistance(prevPoint.getLatitude(), prevPoint.getLongitude(), thisPoint.getLatitude(), thisPoint.getLongitude());
            prevPoint = thisPoint;
        }
        return kilometers;
    }

    public double getTraverseHours() {
        if (this.isBlocked()) {
            return 3.4028234663852886E38;
        }
        return this.getLengthInKilometers() / (double)this.getRoadClass().getConvoySpeed();
    }

    public LatLonPoint getLocationAtKilometer(double kilometers) {
        LatLonPoint prevPoint = this.points[0].getLocation();
        double prevLat = prevPoint.getLatitude();
        double prevLon = prevPoint.getLongitude();
        for (int i = 1; i < this.points.length; ++i) {
            double thisLon;
            LatLonPoint thisPoint = this.points[i].getLocation();
            double thisLat = thisPoint.getLatitude();
            double thisLength = GreatCircle.sphericalDistance(prevLat, prevLon, thisLat, thisLon = (double)thisPoint.getLongitude());
            if (thisLength >= kilometers) {
                double fraction = kilometers / thisLength;
                double deltaLat = thisLat - prevLat;
                double deltaLon = thisLon - prevLon;
                if (deltaLon < -180.0) {
                    deltaLon += 360.0;
                } else if (deltaLon > 180.0) {
                    deltaLon -= 360.0;
                }
                return new LatLonPoint.Double(prevLat + fraction * deltaLat, prevLon + fraction * deltaLon);
            }
            kilometers -= thisLength;
            prevPoint = thisPoint;
            prevLat = thisLat;
            prevLon = thisLon;
        }
        return prevPoint;
    }

    private void createLines() {
        this.lines = new RoadLine[this.points.length - 1];
        for (int i = 0; i < this.lines.length; ++i) {
            this.lines[i] = new RoadLine(this, i);
        }
        this.blinkLines();
    }

    private void blinkLines() {
        for (int i = 0; i < this.lines.length; ++i) {
            this.lines[i].blink(this.blinkState);
        }
    }

    public void setModified(boolean newValue) {
        this.modified = newValue;
        if (!newValue) {
            for (int i = 0; i < this.points.length; ++i) {
                this.points[i].setModified(false);
            }
        }
    }

    public boolean getModified() {
        if (this.modified) {
            return true;
        }
        for (int i = 0; i < this.points.length; ++i) {
            if (!this.points[i].getModified()) continue;
            return true;
        }
        return false;
    }

    public void block() {
        this.blocked = true;
        this.updateLines();
    }

    public void unblock() {
        this.blocked = false;
        this.updateLines();
    }

    public boolean isBlocked() {
        return this.blocked;
    }

    public void blink(boolean newState) {
        this.blinkState = newState;
        if (this.lines != null) {
            this.blinkLines();
        }
        this.blinkPoints();
    }

    public int getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public RoadClass getRoadClass() {
        return this.roadClass;
    }

    public void setRoadClass(RoadClass newClass) {
        this.roadClass = newClass;
        this.setModified(true);
        this.updateLines();
    }

    public String getRoadClassName() {
        return this.roadClass.getName().toString();
    }

    public void isRoute(boolean yes) {
        this.isRoute = yes;
        this.updateLines();
    }

    public boolean isRoute() {
        return this.isRoute;
    }

    public RoadLayer getRoadLayer() {
        return this.roadLayer;
    }

    public void setIntersections(Intersection from, Intersection to) {
        if (from == null) {
            this.logger.warning("from is null.");
            Thread.dumpStack();
        }
        if (to == null) {
            this.logger.warning("to is null.");
            Thread.dumpStack();
        }
        this.points[0] = from;
        this.points[this.points.length - 1] = to;
        this.checkPoints();
        this.createLines();
        this.setModified(true);
    }

    public void setRoadPoints(RoadPoint[] innerPoints) {
        Waypoint[] oldPoints = this.points;
        this.points = new Waypoint[2 + innerPoints.length];
        this.points[0] = oldPoints[0];
        System.arraycopy(innerPoints, 0, this.points, 1, innerPoints.length);
        this.points[this.points.length - 1] = oldPoints[oldPoints.length - 1];
        if (this.points[this.points.length - 1] == null) {
            this.logger.warning("to is null.");
            Thread.dumpStack();
        }
        this.checkPoints();
        this.createLines();
        this.setModified(true);
    }

    public void checkPoints() {
        for (int i = 0; i < this.points.length; ++i) {
            if (this.points[i] != null) continue;
            this.logger.warning("found null point at " + i);
            Thread.dumpStack();
        }
    }

    public RoadPoint[] getRoadPoints() {
        RoadPoint[] innerPoints = new RoadPoint[this.points.length - 2];
        System.arraycopy(this.points, 1, innerPoints, 0, innerPoints.length);
        return innerPoints;
    }

    public void insertRoadPointAt(RoadPoint wp, int ix) {
        Waypoint[] oldPoints = this.points;
        this.points = new Waypoint[1 + oldPoints.length];
        System.arraycopy(oldPoints, 0, this.points, 0, ix);
        this.points[ix] = wp;
        if (wp == null) {
            this.logger.warning("wp is null.");
            Thread.dumpStack();
        }
        this.checkPoints();
        System.arraycopy(oldPoints, ix, this.points, ix + 1, oldPoints.length - ix);
        this.createLines();
        this.setModified(true);
    }

    public void deleteRoadPoint(RoadPoint rp) {
        for (int ix = 1; ix < this.points.length - 1; ++ix) {
            if (this.points[ix] != rp) continue;
            Waypoint[] oldPoints = this.points;
            this.points = new Waypoint[oldPoints.length - 1];
            System.arraycopy(oldPoints, 0, this.points, 0, ix);
            System.arraycopy(oldPoints, ix + 1, this.points, ix, oldPoints.length - ix - 1);
            this.createLines();
            this.setModified(true);
            return;
        }
        this.checkPoints();
    }

    public Intersection getFirstIntersection() {
        return (Intersection)this.points[0];
    }

    public Intersection getSecondIntersection() {
        return (Intersection)this.points[this.points.length - 1];
    }

    public Intersection getOtherIntersection(Intersection intersection) {
        if (intersection == this.points[0]) {
            return (Intersection)this.points[this.points.length - 1];
        }
        return (Intersection)this.points[0];
    }

    public void changeIntersection(Intersection oldIntersection, Intersection newIntersection) {
        if (oldIntersection == this.points[0]) {
            this.setIntersections(newIntersection, this.getSecondIntersection());
        } else if (oldIntersection == this.points[this.points.length - 1]) {
            this.setIntersections(this.getFirstIntersection(), newIntersection);
        }
        this.checkPoints();
    }

    public Waypoint getWaypoint(int ix) {
        return this.points[ix];
    }

    public Waypoint[] getPoints() {
        return this.points;
    }

    public RoadPoint[] getPointsBefore(RoadPoint wp) {
        for (int i = 1; i < this.points.length - 1; ++i) {
            if (this.points[i] != wp) continue;
            RoadPoint[] answer = new RoadPoint[i - 1];
            System.arraycopy(this.points, 1, answer, 0, answer.length);
            return answer;
        }
        return new RoadPoint[0];
    }

    public RoadPoint[] getPointsAfter(RoadPoint wp) {
        for (int i = 1; i < this.points.length - 1; ++i) {
            if (this.points[i] != wp) continue;
            RoadPoint[] answer = new RoadPoint[this.points.length - i - 2];
            System.arraycopy(this.points, i + 1, answer, 0, answer.length);
            return answer;
        }
        RoadPoint[] answer = new RoadPoint[this.points.length - 2];
        System.arraycopy(this.points, 1, answer, 0, answer.length);
        return answer;
    }

    private void blinkPoints() {
        for (int i = 1; i < this.points.length - 1; ++i) {
            this.points[i].blink(this.blinkState);
        }
    }

    public synchronized void updateLines() {
        for (int i = 0; i < this.lines.length; ++i) {
            this.lines[i].update();
        }
    }

    public void moveTo(Point loc) {
    }

    public synchronized void render(OMGraphicList gl, boolean projectionIsNew) {
        int i;
        if (this.roadLayer.isEditing()) {
            for (i = 1; i < this.points.length - 1; ++i) {
                this.points[i].render(gl, projectionIsNew);
            }
        }
        for (i = 0; i < this.lines.length; ++i) {
            this.lines[i].render(gl, projectionIsNew);
        }
    }

    public String toString() {
        return this.name + " from " + this.getFirstIntersection() + " to " + this.getSecondIntersection() + " " + this.points.length + " points.";
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }
}

