/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.vpf;

import com.bbn.openmap.io.Closable;
import com.bbn.openmap.io.FormatException;
import com.bbn.openmap.layer.vpf.CoverageTable;
import com.bbn.openmap.layer.vpf.DcwColumnInfo;
import com.bbn.openmap.layer.vpf.DcwRecordFile;
import com.bbn.openmap.layer.vpf.DcwThematicIndex;
import com.bbn.openmap.layer.vpf.MutableInt;
import com.bbn.openmap.layer.vpf.TerminatingRunnable;
import com.bbn.openmap.layer.vpf.TilingAdapter;
import com.bbn.openmap.layer.vpf.VPFUtil;
import com.bbn.openmap.util.Debug;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureClassInfo
extends DcwRecordFile
implements TerminatingRunnable,
Closable {
    private final CoverageTable ctable;
    private final String columnname;
    private int mycolumn = -1;
    private boolean fullInit = false;
    private final List<Object> tmpVec = new ArrayList<Object>();
    protected String tileFileName;
    protected String tileFileColName;
    protected char featureType;
    public static final String TILE_ID_COLUMN_NAME = "tile_id";
    protected DcwThematicIndex thematicIndex = null;

    public FeatureClassInfo(CoverageTable cthis, String colname, String tablepath, String ftname) throws FormatException {
        super(tablepath + ftname, true);
        if (Debug.debugging("vpf.fci")) {
            Debug.output("FCI: set to peruse (" + this.filename + ")\n\tcreated with colname (" + colname + ")\n\ttablepath (" + tablepath + ")\n\tftname (" + ftname + ")");
        }
        this.ctable = cthis;
        this.columnname = colname.toLowerCase().intern();
    }

    public FeatureClassInfo(CoverageTable cthis, String colname, String tablepath, String ftname, String tileDirFile, String tileDirFileColName) throws FormatException {
        super(tablepath + ftname, false);
        this.fullInit = true;
        this.ctable = cthis;
        this.columnname = colname.toLowerCase().intern();
        this.tileFileName = tileDirFile;
        this.tileFileColName = tileDirFileColName;
        this.featureType = "fac".equals(this.tileFileName) ? (char)65 : ("end".equals(this.tileFileName) ? (char)69 : ("cnd".equals(this.tileFileName) ? (char)78 : ("txt".equals(this.tileFileName) ? (char)84 : ("edg".equals(this.tileFileName) ? (char)76 : (char)83))));
        if (Debug.debugging("vpf.fci")) {
            Debug.output("FCI: set to peruse (" + this.filename + ")\n\tcreated with column name (" + colname + ")\n\ttile directory file (" + tileDirFile + ")\n\ttile id column (" + tileDirFileColName + ")");
        }
    }

    public TilingAdapter getTilingAdapter() {
        return this.getTilingAdapter(TILE_ID_COLUMN_NAME, this.tileFileColName);
    }

    public String getTileThematicFileName() {
        int colId;
        if (this.columnInfo != null && (colId = this.getTileIdIndex()) != -1) {
            return this.columnInfo[colId].getThematicIndexName();
        }
        return null;
    }

    public synchronized boolean initThematicIndex(String path) {
        try {
            String thematicIndexName;
            if (this.thematicIndex == null && (thematicIndexName = this.getTileThematicFileName()) != null) {
                this.thematicIndex = new DcwThematicIndex(path + thematicIndexName, this.byteorder);
            }
        }
        catch (FormatException fe) {
            if (Debug.debugging("vpf.FormatException")) {
                Debug.output("FeatureClassInfo.initTI: " + fe.getClass() + " " + fe.getMessage());
            }
            return false;
        }
        return this.thematicIndex != null;
    }

    public DcwThematicIndex getThematicIndex() {
        return this.thematicIndex;
    }

    public int getTileIdIndex() {
        return this.whatColumn(TILE_ID_COLUMN_NAME);
    }

    public int getFaccIndex() {
        return this.whatColumn("f_code");
    }

    public int getTilePrimitiveIdColIndex() {
        return this.whatColumn(this.tileFileColName);
    }

    public char getFeatureType() {
        return this.featureType;
    }

    @Override
    public synchronized void run() {
        if (this.fullInit) {
            return;
        }
        try {
            this.fullInit = true;
            this.finishInitialization();
        }
        catch (FormatException formatException) {
            // empty catch block
        }
        this.close();
    }

    @Override
    public boolean close(boolean done) {
        this.close();
        if (this.thematicIndex != null) {
            try {
                this.thematicIndex.close();
            }
            catch (FormatException formatException) {
                // empty catch block
            }
        }
        return true;
    }

    public void findYourself(DcwRecordFile rf) {
        this.mycolumn = rf.whatColumn(this.columnname);
    }

    public synchronized String getDescription(List<Object> l, MutableInt type) {
        this.checkInit();
        if (this.mycolumn == -1) {
            return null;
        }
        int i = VPFUtil.objectToInt(l.get(this.mycolumn));
        if (i <= 0) {
            return null;
        }
        return this.getDescription(i, type);
    }

    public synchronized String getAttribute(int ftid, int colIndex, MutableInt type) {
        block4: {
            this.checkInit();
            if (ftid <= 0) {
                return null;
            }
            try {
                if (!this.getRow(this.tmpVec, ftid)) {
                    return null;
                }
            }
            catch (FormatException fe) {
                if (!Debug.debugging("vpf")) break block4;
                fe.printStackTrace();
            }
        }
        return this.getAttribute(this.columnInfo[colIndex], this.tmpVec.get(colIndex), type);
    }

    public synchronized void checkInit() {
        if (!this.fullInit) {
            if (Debug.debugging("vpf")) {
                Debug.output("FCI.checkInit() forcing init " + this.columnname + " " + this.tablename);
            }
            this.run();
        }
    }

    private synchronized String getDescription(int ftid, MutableInt type) {
        StringBuffer retval;
        block5: {
            retval = null;
            try {
                if (!this.getRow(this.tmpVec, ftid)) {
                    return null;
                }
                for (int i = 0; i < this.columnInfo.length; ++i) {
                    DcwColumnInfo dci = this.columnInfo[i];
                    String s = this.getAttribute(dci, this.tmpVec.get(i), type);
                    if (s == null) continue;
                    if (retval == null) {
                        retval = new StringBuffer(s);
                        continue;
                    }
                    retval.append("; ").append(s);
                }
            }
            catch (FormatException e) {
                if (!Debug.debugging("vpf")) break block5;
                e.printStackTrace();
            }
        }
        return retval == null ? null : retval.toString();
    }

    protected String getAttribute(DcwColumnInfo dci, Object colObj, MutableInt type) {
        if (colObj == null) {
            return null;
        }
        String dciVDT = dci.getVDT();
        if ("int.vdt".equals(dciVDT)) {
            int val = VPFUtil.objectToInt(colObj);
            if (val == Integer.MIN_VALUE) {
                return null;
            }
            if (type != null) {
                type.value = (short)val;
            }
            return this.ctable.getDescription(this.tablename, dci.getColumnName(), val);
        }
        if ("char.vdt".equals(dciVDT)) {
            return (String)colObj;
        }
        return colObj.toString();
    }

    public String columnNameString() {
        StringBuffer sBuf = new StringBuffer();
        for (DcwColumnInfo dci : this.getColumnInfo()) {
            sBuf.append(dci.getColumnName()).append(' ');
        }
        return sBuf.toString().trim();
    }
}

