/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.event;

import com.bbn.openmap.MapBean;
import com.bbn.openmap.event.AzimuthPanner;
import com.bbn.openmap.event.CoordMouseMode;
import com.bbn.openmap.event.OMMouseMode;
import com.bbn.openmap.event.ProjectionEvent;
import com.bbn.openmap.event.ProjectionListener;
import com.bbn.openmap.image.ImageScaler;
import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.omGraphics.OMRaster;
import com.bbn.openmap.proj.Cartesian;
import com.bbn.openmap.proj.Cylindrical;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.PropUtils;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import javax.swing.ImageIcon;

public class PanMouseMode
extends CoordMouseMode
implements ProjectionListener {
    public static final String OPAQUENESS_PROPERTY = "opaqueness";
    public static final String LEAVE_SHADOW_PROPERTY = "leaveShadow";
    public static final String USE_CURSOR_PROPERTY = "useCursor";
    public static final String AZ_PANNING_SHAPEFILE_PROPERTY = "azPanningShapefile";
    public static final String AZ_PANNING_PROPERTY = "azPanning";
    public static final float DEFAULT_OPAQUENESS = 0.5f;
    public static final transient String modeID = "Pan";
    private boolean isPanning = false;
    private BufferedImage bufferedMapImage = null;
    private OMRaster paintedImage = null;
    private int beanBufferWidth = 0;
    private int beanBufferHeight = 0;
    private int oX;
    private int oY;
    private MouseEvent lastMouseEvent;
    private float opaqueness;
    private boolean leaveShadow;
    private boolean useCursor;
    private AzimuthPanner azPanner = null;
    private String azPanningShapefile = null;
    private DrawingAttributes azDrawing = null;

    public PanMouseMode() {
        super(modeID, true);
        this.setUseCursor(true);
        this.setLeaveShadow(false);
        this.setOpaqueness(0.5f);
        DrawingAttributes da = DrawingAttributes.getDefaultClone();
        da.setMatted(true);
        da.setMattingPaint(Color.LIGHT_GRAY);
        this.setAzDrawing(da);
    }

    public void setActive(boolean val) {
        if (!val) {
            if (this.bufferedMapImage != null) {
                this.bufferedMapImage.flush();
            }
            this.beanBufferWidth = 0;
            this.beanBufferHeight = 0;
            this.bufferedMapImage = null;
        }
    }

    public boolean isUseCursor() {
        return this.useCursor;
    }

    public void setUseCursor(boolean useCursor) {
        this.useCursor = useCursor;
        if (useCursor) {
            try {
                Toolkit tk = Toolkit.getDefaultToolkit();
                ImageIcon pointer = new ImageIcon(this.getClass().getResource("pan.gif"));
                Dimension bestSize = tk.getBestCursorSize(pointer.getIconWidth(), pointer.getIconHeight());
                Image pointerImage = ImageScaler.getOptimalScalingImage(pointer.getImage(), (int)bestSize.getWidth(), (int)bestSize.getHeight());
                Cursor cursor = tk.createCustomCursor(pointerImage, new Point(0, 0), "PP");
                this.setModeCursor(cursor);
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.setModeCursor(Cursor.getPredefinedCursor(1));
    }

    public void setProperties(String prefix, Properties props) {
        super.setProperties(prefix, props);
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.opaqueness = PropUtils.floatFromProperties(props, prefix + OPAQUENESS_PROPERTY, this.opaqueness);
        this.leaveShadow = PropUtils.booleanFromProperties(props, prefix + LEAVE_SHADOW_PROPERTY, this.leaveShadow);
        this.azPanningShapefile = props.getProperty(prefix + AZ_PANNING_SHAPEFILE_PROPERTY, this.azPanningShapefile);
        this.setUseCursor(PropUtils.booleanFromProperties(props, prefix + USE_CURSOR_PROPERTY, this.isUseCursor()));
        this.azDrawing.setProperties(prefix + AZ_PANNING_PROPERTY, props);
    }

    public Properties getProperties(Properties props) {
        props = super.getProperties(props);
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        props.put(prefix + OPAQUENESS_PROPERTY, Float.toString(this.getOpaqueness()));
        props.put(prefix + LEAVE_SHADOW_PROPERTY, Boolean.toString(this.isLeaveShadow()));
        props.put(prefix + USE_CURSOR_PROPERTY, Boolean.toString(this.isUseCursor()));
        props.put(prefix + AZ_PANNING_SHAPEFILE_PROPERTY, PropUtils.unnull(this.azPanningShapefile));
        this.azDrawing.getProperties(props);
        return props;
    }

    public Properties getPropertyInfo(Properties props) {
        props = super.getPropertyInfo(props);
        PropUtils.setI18NPropertyInfo(this.i18n, props, PanMouseMode.class, OPAQUENESS_PROPERTY, "Transparency", "Transparency level for moving map, between 0 (clear) and 1 (opaque).", null);
        PropUtils.setI18NPropertyInfo(this.i18n, props, PanMouseMode.class, LEAVE_SHADOW_PROPERTY, "Leave Shadow", "Display current map in background while panning.", "com.bbn.openmap.util.propertyEditor.YesNoPropertyEditor");
        PropUtils.setI18NPropertyInfo(this.i18n, props, PanMouseMode.class, USE_CURSOR_PROPERTY, "Use Cursor", "Use hand cursor for mouse mode.", "com.bbn.openmap.util.propertyEditor.YesNoPropertyEditor");
        PropUtils.setI18NPropertyInfo(this.i18n, props, OMMouseMode.class, AZ_PANNING_SHAPEFILE_PROPERTY, "Az Projection Panning Shapefile", "Use a shapefile for azimuthal projection panning.", "com.bbn.openmap.util.propertyEditor.FUPropertyEditor");
        this.azDrawing.getPropertyInfo(props);
        return props;
    }

    public void listenerPaint(Object source, Graphics g) {
        MapBean mapBean;
        MapBean mapBean2 = mapBean = source instanceof MapBean ? (MapBean)source : null;
        if (this.azPanner != null) {
            this.azPanner.render(g);
        } else if (mapBean != null) {
            if (this.isPanning && this.lastMouseEvent != null && this.bufferedMapImage != null) {
                Graphics2D gr2d = (Graphics2D)g.create();
                Projection proj = mapBean.getRotatedProjection();
                if (!this.leaveShadow) {
                    gr2d.setPaint(mapBean.getBckgrnd());
                    gr2d.fillRect(0, 0, proj.getWidth(), proj.getHeight());
                }
                Point2D pnt0 = proj.forward(mapBean.inverse(this.oX, this.oY, null));
                int startX = (int)pnt0.getX();
                int startY = (int)pnt0.getY();
                Point2D pnt = mapBean.getNonRotatedLocation(this.lastMouseEvent);
                int x = (int)pnt.getX();
                int y = (int)pnt.getY();
                gr2d.setComposite(AlphaComposite.getInstance(3, this.opaqueness));
                this.paintedImage.setX(x - startX);
                this.paintedImage.setY(y - startY);
                this.paintedImage.setRotationAngle(-proj.getRotationAngle());
                this.paintedImage.generate(proj);
                this.paintedImage.render(gr2d);
            } else {
                mapBean.removePaintListener(this);
            }
        }
    }

    public void mousePressed(MouseEvent arg0) {
        MapBean mapBean;
        MapBean mapBean2 = mapBean = arg0.getSource() instanceof MapBean ? (MapBean)arg0.getSource() : null;
        if (mapBean != null) {
            this.lastMouseEvent = arg0;
            this.oX = arg0.getX();
            this.oY = arg0.getY();
            Projection proj = mapBean.getRotatedProjection();
            int w = proj.getWidth();
            int h = proj.getHeight();
            if ((proj instanceof Cylindrical || proj instanceof Cartesian) && proj.getRotationAngle() == 0.0) {
                if (this.bufferedMapImage == null) {
                    this.createBuffer(w, h);
                }
                Graphics2D g = (Graphics2D)this.bufferedMapImage.getGraphics();
                mapBean.paintChildren(g, null);
                Point2D ul = mapBean.inverse(0.0, 0.0, null);
                this.paintedImage = new OMRaster(ul.getY(), ul.getX(), 0, 0, this.bufferedMapImage);
                this.paintedImage.putAttribute("norotate", Boolean.TRUE);
            } else {
                URL url = null;
                try {
                    url = PropUtils.getResourceOrFileOrURL(this.azPanningShapefile);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
                this.azPanner = url != null ? new AzimuthPanner.Shapefile(this.oX, this.oY, this.getAzDrawing(), url) : new AzimuthPanner.Standard(this.oX, this.oY, this.getAzDrawing());
            }
            this.isPanning = true;
            mapBean.addPaintListener(this);
        }
    }

    public void mouseDragged(MouseEvent arg0) {
        MapBean mapBean = arg0.getSource() instanceof MapBean ? (MapBean)arg0.getSource() : null;
        this.lastMouseEvent = arg0;
        if (mapBean != null) {
            if (this.azPanner != null) {
                this.azPanner.handlePan(mapBean, arg0);
            }
            mapBean.repaint();
        }
        super.mouseDragged(arg0);
    }

    public void mouseReleased(MouseEvent arg0) {
        MapBean mapBean;
        MapBean mapBean2 = mapBean = arg0.getSource() instanceof MapBean ? (MapBean)arg0.getSource() : null;
        if (this.azPanner != null) {
            this.azPanner.handleUnpan(arg0);
            this.azPanner = null;
        }
        if (this.isPanning && mapBean != null) {
            Projection proj = mapBean.getProjection();
            Point2D center = proj.forward((Point2D)proj.getCenter());
            int x = arg0.getX();
            int y = arg0.getY();
            center.setLocation(center.getX() - (double)x + (double)this.oX, center.getY() - (double)y + (double)this.oY);
            this.isPanning = false;
            mapBean.setCenter(mapBean.inverse(center.getX(), center.getY(), null));
        }
        this.oX = 0;
        this.oY = 0;
        this.isPanning = false;
        super.mouseReleased(arg0);
    }

    public boolean isLeaveShadow() {
        return this.leaveShadow;
    }

    public void setLeaveShadow(boolean leaveShadow) {
        this.leaveShadow = leaveShadow;
    }

    public float getOpaqueness() {
        return this.opaqueness;
    }

    public void setOpaqueness(float opaqueness) {
        this.opaqueness = opaqueness;
    }

    public boolean isPanning() {
        return this.isPanning;
    }

    public int getOX() {
        return this.oX;
    }

    public int getOY() {
        return this.oY;
    }

    public String getAzPanningShapefile() {
        return this.azPanningShapefile;
    }

    public void setAzPanningShapefile(String azPanningShapefile) {
        this.azPanningShapefile = azPanningShapefile;
    }

    public DrawingAttributes getAzDrawing() {
        return this.azDrawing;
    }

    public void setAzDrawing(DrawingAttributes azDrawing) {
        this.azDrawing = azDrawing;
    }

    public void projectionChanged(ProjectionEvent e) {
        Object obj = e.getSource();
        if (obj instanceof MapBean) {
            MapBean mb = (MapBean)obj;
            int w = mb.getWidth();
            int h = mb.getHeight();
            this.createBuffer(w, h);
        }
    }

    public synchronized void createBuffer(int w, int h) {
        if (w > 0 && h > 0 && (w != this.beanBufferWidth || h != this.beanBufferHeight)) {
            this.beanBufferWidth = w;
            this.beanBufferHeight = h;
            this.createBufferImpl(w, h);
        }
    }

    protected void createBufferImpl(int w, int h) {
        if (this.bufferedMapImage != null) {
            this.bufferedMapImage.flush();
        }
        this.bufferedMapImage = new BufferedImage(w, h, 2);
    }
}

