/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.util.quadtree;

import java.io.Serializable;

public class QuadTreeRect
implements Serializable {
    static final long serialVersionUID = -5585535433679092922L;
    public double north;
    public double south;
    public double west;
    public double east;

    public QuadTreeRect(double n, double w, double s, double e) {
        this.north = n;
        this.west = w;
        this.south = s;
        this.east = e;
    }

    public boolean within(QuadTreeRect rect) {
        return this.within(rect.north, rect.west, rect.south, rect.east);
    }

    public boolean within(double n, double w, double s, double e) {
        if (s >= this.north) {
            return false;
        }
        if (n < this.south) {
            return false;
        }
        if (w > this.east) {
            return false;
        }
        return !(e <= this.west);
    }

    public boolean pointWithinBounds(double lat, double lon) {
        return lon >= this.west && lon < this.east && lat <= this.north && lat > this.south;
    }

    public double borderDistance(double lat, double lon) {
        double nsdistance = this.south <= lat && lat <= this.north ? 0.0 : Math.min(Math.abs(lat - this.north), Math.abs(lat - this.south));
        double ewdistance = this.west <= lon && lon <= this.east ? 0.0 : Math.min(Math.abs(lon - this.east), Math.abs(lon - this.west));
        return Math.sqrt(Math.pow(nsdistance, 2.0) + Math.pow(ewdistance, 2.0));
    }

    public double borderDistanceSqr(double lat, double lon) {
        double nsdistance = this.south <= lat && lat <= this.north ? 0.0 : Math.min(Math.abs(lat - this.north), Math.abs(lat - this.south));
        double ewdistance = this.west <= lon && lon <= this.east ? 0.0 : Math.min(Math.abs(lon - this.east), Math.abs(lon - this.west));
        if (nsdistance == 0.0 && ewdistance == 0.0) {
            return 0.0;
        }
        double dx = ewdistance * ewdistance;
        double dy = nsdistance * nsdistance;
        return dx * dx + dy * dy;
    }
}

