/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.proj.coords;

import com.bbn.openmap.proj.Ellipsoid;
import com.bbn.openmap.proj.coords.LatLonPoint;
import com.bbn.openmap.proj.coords.UTMPoint;
import com.bbn.openmap.proj.coords.ZonedUTMPoint;
import com.bbn.openmap.util.ArgParser;
import com.bbn.openmap.util.Debug;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MGRSPoint
extends ZonedUTMPoint {
    protected static final int NUM_100K_SETS = 6;
    public static final int[] SET_ORIGIN_COLUMN_LETTERS = new int[]{65, 74, 83, 65, 74, 83};
    public static final int[] SET_ORIGIN_ROW_LETTERS = new int[]{65, 70, 65, 70, 65, 70};
    public static final int[] BESSEL_SET_ORIGIN_COLUMN_LETTERS = new int[]{65, 74, 83, 65, 74, 83};
    public static final int[] BESSEL_SET_ORIGIN_ROW_LETTERS = new int[]{76, 82, 76, 82, 76, 82};
    public static final int SET_NORTHING_ROLLOVER = 20000000;
    public static final int ACCURACY_1_METER = 5;
    public static final int ACCURACY_10_METER = 4;
    public static final int ACCURACY_100_METER = 3;
    public static final int ACCURACY_1000_METER = 2;
    public static final int ACCURACY_10000_METER = 1;
    protected int[] originColumnLetters = SET_ORIGIN_COLUMN_LETTERS;
    protected int[] originRowLetters = SET_ORIGIN_ROW_LETTERS;
    public static final int A = 65;
    public static final int I = 73;
    public static final int O = 79;
    public static final int V = 86;
    public static final int Z = 90;
    protected boolean DEBUG = false;
    protected static final Logger logger = Logger.getLogger("com.bbn.openmap.proj.coords.MGRSPoint");
    protected String mgrs;
    protected int accuracy = 5;

    public MGRSPoint() {
        this.DEBUG = logger.isLoggable(Level.FINE);
    }

    public MGRSPoint(String mgrsString) throws NumberFormatException {
        this();
        this.setMGRS(mgrsString);
    }

    public MGRSPoint(MGRSPoint point) {
        this();
        this.mgrs = point.mgrs;
        this.northing = point.northing;
        this.easting = point.easting;
        this.zone_number = point.zone_number;
        this.zone_letter = point.zone_letter;
        this.accuracy = point.accuracy;
    }

    public MGRSPoint(double northing, double easting, int zoneNumber, char zoneLetter) {
        super(northing, easting, zoneNumber, zoneLetter);
    }

    public MGRSPoint(LatLonPoint llpoint) {
        this(llpoint, Ellipsoid.WGS_84);
    }

    public MGRSPoint(LatLonPoint llpoint, Ellipsoid ellip) {
        this();
        MGRSPoint.LLtoMGRS(llpoint, ellip, this);
    }

    public void setMGRS(String mgrsString) throws NumberFormatException {
        try {
            this.mgrs = mgrsString.toUpperCase();
            this.decode(this.mgrs);
        }
        catch (StringIndexOutOfBoundsException sioobe) {
            throw new NumberFormatException("MGRSPoint has bad string: " + mgrsString);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public String getMGRS() {
        if (this.mgrs == null) {
            this.resolve();
        }
        return this.mgrs;
    }

    public LatLonPoint toLatLonPoint() {
        return this.toLatLonPoint(Ellipsoid.WGS_84, new LatLonPoint.Double());
    }

    public LatLonPoint toLatLonPoint(Ellipsoid ellip) {
        return this.toLatLonPoint(ellip, new LatLonPoint.Double());
    }

    public LatLonPoint toLatLonPoint(Ellipsoid ellip, LatLonPoint llpoint) {
        return MGRSPoint.MGRStoLL(this, ellip, llpoint);
    }

    public String toString() {
        return "MGRSPoint[" + this.mgrs + "]";
    }

    public static LatLonPoint MGRStoLL(MGRSPoint mgrsp, Ellipsoid ellip, LatLonPoint llp) {
        return MGRSPoint.UTMtoLL(ellip, mgrsp.northing, mgrsp.easting, mgrsp.zone_number, MGRSPoint.MGRSZoneToUTMZone(mgrsp.zone_letter), llp);
    }

    public static LatLonPoint MGRStoLL(Ellipsoid ellip, double northing, double easting, int zoneNumber, char zoneLetter, LatLonPoint llp) {
        return MGRSPoint.UTMtoLL(ellip, northing, easting, zoneNumber, MGRSPoint.MGRSZoneToUTMZone(zoneLetter), llp);
    }

    public static MGRSPoint LLtoMGRS(LatLonPoint llpoint) {
        return MGRSPoint.LLtoMGRS(llpoint, Ellipsoid.WGS_84, new MGRSPoint());
    }

    public static MGRSPoint LLtoMGRS(LatLonPoint llpoint, MGRSPoint mgrsp) {
        return MGRSPoint.LLtoMGRS(llpoint, Ellipsoid.WGS_84, mgrsp);
    }

    public static MGRSPoint LLtoMGRS(LatLonPoint llp, Ellipsoid ellip, MGRSPoint mgrsp) {
        if (mgrsp == null || !(mgrsp instanceof MGRSPoint)) {
            mgrsp = new MGRSPoint();
        }
        mgrsp = (MGRSPoint)MGRSPoint.LLtoUTM(llp, ellip, mgrsp);
        mgrsp.zone_letter = mgrsp.getLetterDesignator(llp.getLatitude());
        mgrsp.resolve();
        return mgrsp;
    }

    public static char MGRSZoneToUTMZone(char mgrsZone) {
        if (Character.toUpperCase(mgrsZone) >= 'N') {
            return 'N';
        }
        return 'S';
    }

    protected char checkZone(char zone) {
        if ((zone = Character.toUpperCase(zone)) <= 'A' || zone == 'B' || zone == 'Y' || zone >= 'Z' || zone == 'I' || zone == 'O') {
            throw new NumberFormatException("Invalid MGRSPoint zone letter: " + zone);
        }
        return zone;
    }

    public void setAccuracy(int value) {
        this.accuracy = value;
        this.mgrs = null;
    }

    public int getAccuracy() {
        return this.accuracy;
    }

    protected void decode(String mgrsString) throws NumberFormatException {
        float north100k;
        char testChar;
        if (mgrsString == null || mgrsString.length() == 0) {
            throw new NumberFormatException("MGRSPoint coverting from nothing");
        }
        mgrsString = mgrsString.toUpperCase();
        int length = mgrsString.length();
        String hunK = null;
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (!Character.isLetter(testChar = mgrsString.charAt(i))) {
            if (i >= 2) {
                throw new NumberFormatException("MGRSPoint bad conversion from: " + mgrsString + ", first two characters need to be a number between 1-60.");
            }
            sb.append(testChar);
            ++i;
        }
        this.zone_number = Integer.parseInt(sb.toString());
        if (this.zone_number < 1 || this.zone_number > 60) {
            throw new NumberFormatException("MGRSPoint bad conversion from: " + mgrsString + ", first two characters need to be a number between 1-60.");
        }
        if (i == 0 || i + 3 > length) {
            throw new NumberFormatException("MGRSPoint bad conversion from: " + mgrsString + ", MGRS string must be at least 4-5 digits long");
        }
        this.zone_letter = mgrsString.charAt(i++);
        if (this.zone_letter <= 'A' || this.zone_letter == 'B' || this.zone_letter == 'Y' || this.zone_letter >= 'Z' || this.zone_letter == 'I' || this.zone_letter == 'O') {
            throw new NumberFormatException("MGRSPoint zone letter " + this.zone_letter + " not handled: " + mgrsString);
        }
        hunK = mgrsString.substring(i, i += 2);
        char char1 = hunK.charAt(0);
        char char2 = hunK.charAt(1);
        if (char1 < 'A' || char2 < 'A' || char1 > 'Z' || char2 > 'Z' || char1 == 'I' || char2 == 'I' || char1 == 'O' || char2 == 'O') {
            throw new NumberFormatException("MGRSPoint bad conversion from " + mgrsString + ", invalid 100k designator");
        }
        int set = this.get100kSetForZone(this.zone_number);
        float east100k = this.getEastingFromChar(char1, set);
        for (north100k = this.getNorthingFromChar(char2, set); north100k < this.getMinNorthing(this.zone_letter); north100k += 2000000.0f) {
        }
        int remainder = length - i;
        if (remainder % 2 != 0) {
            throw new NumberFormatException("MGRSPoint has to have an even number \nof digits after the zone letter and two 100km letters - front \nhalf for easting meters, second half for \nnorthing meters" + mgrsString);
        }
        int sep = remainder / 2;
        float sepEasting = 0.0f;
        float sepNorthing = 0.0f;
        if (sep > 0) {
            if (this.DEBUG) {
                logger.fine(" calculating e/n from " + this.mgrs.substring(i));
            }
            float accuracyBonus = 100000.0f / (float)Math.pow(10.0, sep);
            if (this.DEBUG) {
                logger.fine(" calculated accuracy bonus as  " + accuracyBonus);
            }
            String sepEastingString = mgrsString.substring(i, i + sep);
            if (this.DEBUG) {
                logger.fine(" parsed easting as " + sepEastingString);
            }
            sepEasting = Float.parseFloat(sepEastingString) * accuracyBonus;
            String sepNorthingString = mgrsString.substring(i + sep);
            if (this.DEBUG) {
                logger.fine(" parsed northing as " + sepNorthingString);
            }
            sepNorthing = Float.parseFloat(sepNorthingString) * accuracyBonus;
        }
        this.easting = sepEasting + east100k;
        this.northing = sepNorthing + north100k;
        if (this.DEBUG) {
            logger.fine("Decoded " + mgrsString + " as zone number: " + this.zone_number + ", zone letter: " + this.zone_letter + ", easting: " + this.easting + ", northing: " + this.northing + ", 100k: " + hunK);
        }
    }

    public void resolve(int digitAccuracy) {
        this.setAccuracy(digitAccuracy);
        this.resolve();
    }

    public void resolve() {
        if (this.zone_letter == 'Z') {
            this.mgrs = "Latitude limit exceeded";
        } else {
            StringBuffer sb = new StringBuffer(Integer.toString(this.zone_number)).append(this.zone_letter).append(this.get100kID(this.easting, this.northing, this.zone_number));
            StringBuffer seasting = new StringBuffer(Integer.toString((int)this.easting));
            StringBuffer snorthing = new StringBuffer(Integer.toString((int)this.northing));
            if (this.DEBUG) {
                logger.fine(" Resolving MGRS from easting: " + seasting + " derived from " + this.easting + ", and northing: " + snorthing + " derived from " + this.northing);
            }
            while (this.accuracy + 1 > seasting.length()) {
                seasting.insert(0, '0');
            }
            while (this.accuracy + 1 > snorthing.length()) {
                snorthing.insert(0, '0');
            }
            while (snorthing.length() > 6) {
                snorthing.deleteCharAt(0);
            }
            if (this.DEBUG) {
                logger.fine(" -- modified easting: " + seasting + " and northing: " + snorthing);
            }
            try {
                sb.append(seasting.substring(1, this.accuracy + 1)).append(snorthing.substring(1, this.accuracy + 1));
                this.mgrs = sb.toString();
            }
            catch (IndexOutOfBoundsException ioobe) {
                this.mgrs = null;
            }
        }
    }

    protected int get100kSetForZone(int i) {
        int set = i % 6;
        if (set == 0) {
            set = 6;
        }
        return set;
    }

    protected int[] getOriginColumnLetters() {
        return this.originColumnLetters;
    }

    protected void setOriginColumnLetters(int[] letters) {
        this.originColumnLetters = letters;
    }

    protected int[] getOriginRowLetters() {
        return this.originRowLetters;
    }

    protected void setOriginRowLetters(int[] letters) {
        this.originRowLetters = letters;
    }

    protected String get100kID(double easting, double northing, int zone_number) {
        int set = this.get100kSetForZone(zone_number);
        int setColumn = (int)easting / 100000;
        int setRow = (int)northing / 100000 % 20;
        return this.get100kID(setColumn, setRow, set);
    }

    protected float getEastingFromChar(char e, int set) {
        int[] baseCol = this.getOriginColumnLetters();
        int curCol = baseCol[set - 1];
        float eastingValue = 100000.0f;
        boolean rewindMarker = false;
        while (curCol != e) {
            if (++curCol == 73) {
                ++curCol;
            }
            if (curCol == 79) {
                ++curCol;
            }
            if (curCol > 90) {
                if (rewindMarker) {
                    throw new NumberFormatException("Bad character: " + e);
                }
                curCol = 65;
                rewindMarker = true;
            }
            eastingValue += 100000.0f;
        }
        if (this.DEBUG) {
            logger.fine("Easting value for " + e + " from set: " + set + ", col: " + curCol + " is " + eastingValue);
        }
        return eastingValue;
    }

    protected float getNorthingFromChar(char n, int set) {
        if (n > 'V') {
            throw new NumberFormatException("MGRSPoint given invalid Northing " + n);
        }
        int[] baseRow = this.getOriginRowLetters();
        int curRow = baseRow[set - 1];
        float northingValue = 0.0f;
        boolean rewindMarker = false;
        while (curRow != n) {
            if (++curRow == 73) {
                ++curRow;
            }
            if (curRow == 79) {
                ++curRow;
            }
            if (curRow > 86) {
                if (rewindMarker) {
                    throw new NumberFormatException("Bad character: " + n);
                }
                curRow = 65;
                rewindMarker = true;
            }
            northingValue += 100000.0f;
        }
        if (this.DEBUG) {
            logger.fine("Northing value for " + n + " from set: " + set + ", row: " + curRow + " is " + northingValue);
        }
        return northingValue;
    }

    protected String get100kID(int setColumn, int setRow, int set) {
        if (this.DEBUG) {
            System.out.println("set (" + set + ") column = " + setColumn + ", row = " + setRow);
        }
        int[] baseCol = this.getOriginColumnLetters();
        int[] baseRow = this.getOriginRowLetters();
        int colOrigin = baseCol[set - 1];
        int rowOrigin = baseRow[set - 1];
        if (this.DEBUG) {
            System.out.println("starting at = " + (char)colOrigin + (char)rowOrigin);
        }
        int colInt = colOrigin + setColumn - 1;
        int rowInt = rowOrigin + setRow;
        boolean rollover = false;
        if (colInt > 90) {
            colInt = colInt - 90 + 65 - 1;
            rollover = true;
            if (this.DEBUG) {
                System.out.println("rolling over col, new value: " + (char)colInt);
            }
        }
        if (colInt == 73 || colOrigin < 73 && colInt > 73 || (colInt > 73 || colOrigin < 73) && rollover) {
            ++colInt;
            if (this.DEBUG) {
                System.out.println("skipping I in col, new value: " + (char)colInt);
            }
        }
        if (colInt == 79 || colOrigin < 79 && colInt > 79 || (colInt > 79 || colOrigin < 79) && rollover) {
            ++colInt;
            if (this.DEBUG) {
                System.out.println("skipping O in col, new value: " + (char)colInt);
            }
            if (colInt == 73) {
                ++colInt;
                if (this.DEBUG) {
                    System.out.println("  hit I, new value: " + (char)colInt);
                }
            }
        }
        if (colInt > 90) {
            colInt = colInt - 90 + 65 - 1;
            if (this.DEBUG) {
                System.out.println("rolling(2) col, new value: " + (char)rowInt);
            }
        }
        if (rowInt > 86) {
            rowInt = rowInt - 86 + 65 - 1;
            rollover = true;
            if (this.DEBUG) {
                System.out.println("rolling over row, new value: " + (char)rowInt);
            }
        } else {
            rollover = false;
        }
        if (rowInt == 73 || rowOrigin < 73 && rowInt > 73 || (rowInt > 73 || rowOrigin < 73) && rollover) {
            ++rowInt;
            if (this.DEBUG) {
                System.out.println("skipping I in row, new value: " + (char)rowInt);
            }
        }
        if (rowInt == 79 || rowOrigin < 79 && rowInt > 79 || (rowInt > 79 || rowOrigin < 79) && rollover) {
            ++rowInt;
            if (this.DEBUG) {
                System.out.println("skipping O in row, new value: " + (char)rowInt);
            }
            if (rowInt == 73) {
                ++rowInt;
                if (this.DEBUG) {
                    System.out.println("  hit I, new value: " + (char)rowInt);
                }
            }
        }
        if (rowInt > 86) {
            rowInt = rowInt - 86 + 65 - 1;
            if (this.DEBUG) {
                System.out.println("rolling(2) row, new value: " + (char)rowInt);
            }
        }
        String twoLetter = (char)colInt + "" + (char)rowInt;
        if (this.DEBUG) {
            System.out.println("ending at = " + twoLetter);
        }
        return twoLetter;
    }

    protected void print100kSets() {
        StringBuffer sb = null;
        for (int set = 1; set <= 6; ++set) {
            System.out.println("-------------\nFor 100K Set " + set + ":\n-------------\n");
            for (int i = 19; i >= 0; --i) {
                sb = new StringBuffer(Integer.toString(i * 100000)).append("\t| ");
                for (int j = 1; j <= 8; ++j) {
                    sb.append(" ").append(this.get100kID(j, i, set));
                }
                sb.append(" |");
                System.out.println(sb);
            }
        }
    }

    protected float getMinNorthing(char zoneLetter) throws NumberFormatException {
        float northing;
        switch (zoneLetter) {
            case 'C': {
                northing = 1100000.0f;
                break;
            }
            case 'D': {
                northing = 2000000.0f;
                break;
            }
            case 'E': {
                northing = 2800000.0f;
                break;
            }
            case 'F': {
                northing = 3700000.0f;
                break;
            }
            case 'G': {
                northing = 4600000.0f;
                break;
            }
            case 'H': {
                northing = 5500000.0f;
                break;
            }
            case 'J': {
                northing = 6400000.0f;
                break;
            }
            case 'K': {
                northing = 7300000.0f;
                break;
            }
            case 'L': {
                northing = 8200000.0f;
                break;
            }
            case 'M': {
                northing = 9100000.0f;
                break;
            }
            case 'N': {
                northing = 0.0f;
                break;
            }
            case 'P': {
                northing = 800000.0f;
                break;
            }
            case 'Q': {
                northing = 1700000.0f;
                break;
            }
            case 'R': {
                northing = 2600000.0f;
                break;
            }
            case 'S': {
                northing = 3500000.0f;
                break;
            }
            case 'T': {
                northing = 4400000.0f;
                break;
            }
            case 'U': {
                northing = 5300000.0f;
                break;
            }
            case 'V': {
                northing = 6200000.0f;
                break;
            }
            case 'W': {
                northing = 7000000.0f;
                break;
            }
            case 'X': {
                northing = 7900000.0f;
                break;
            }
            default: {
                northing = -1.0f;
            }
        }
        if ((double)northing >= 0.0) {
            return northing;
        }
        throw new NumberFormatException("Invalid zone letter: " + this.zone_letter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runTests(String fName, String inType) {
        BufferedReader lnr = null;
        PrintStream pos = null;
        String record = null;
        StringBuffer outStr1 = new StringBuffer();
        StringBuffer outStr2 = new StringBuffer();
        try {
            pos = new PrintStream(new FileOutputStream(new File(fName + ".out")));
            lnr = new LineNumberReader(new InputStreamReader(new BufferedInputStream(new FileInputStream(new File(fName)))));
            if (inType.equalsIgnoreCase("MGRS")) {
                outStr1.append("MGRS to LatLonPoint\n\tMGRS\t\tLatitude   Longitude\n");
                outStr2.append("MGRS to UTM\n\tMGRS\t\tZone Easting Northing\n");
            } else if (inType.equalsIgnoreCase("UTM")) {
                outStr1.append("UTM to LatLonPoint\n\tUTM\t\tLatitude   Longitude\n");
                outStr2.append("UTM to MGRS\n\tUTM\t\tMGRS\n");
            } else if (inType.equalsIgnoreCase("LatLon")) {
                outStr1.append("LatLonPoint to UTM\nLatitude   Longitude\t\tZone Easting Northing     \n");
                outStr2.append("LatLonPoint to MGRS\nLatitude   Longitude\t\tMGRS\n");
            }
            while ((record = ((LineNumberReader)lnr).readLine()) != null) {
                if (inType.equalsIgnoreCase("MGRS")) {
                    try {
                        MGRSPoint mgrsp = new MGRSPoint(record);
                        record = record.trim();
                        mgrsp.decode(record);
                        outStr1.append(record).append(" is ").append(mgrsp.toLatLonPoint()).append("\n");
                        outStr2.append(record).append(" to UTM: ").append(mgrsp.zone_number).append(" ").append(mgrsp.easting).append(" ").append(mgrsp.northing).append("\n");
                    }
                    catch (NumberFormatException nfe) {
                        logger.warning(nfe.getMessage());
                    }
                    continue;
                }
                if (inType.equalsIgnoreCase("UTM")) {
                    record = record.trim();
                    String tmp = record.substring(0, 2);
                    int z = Integer.parseInt(tmp);
                    tmp = record.substring(5, 11);
                    float e = Float.parseFloat(tmp);
                    tmp = record.substring(12, 19);
                    float n = Float.parseFloat(tmp);
                    char zl = record.charAt(3);
                    UTMPoint utmp = new UTMPoint(n, e, z, zl);
                    LatLonPoint llp = utmp.toLatLonPoint();
                    MGRSPoint mgrsp = MGRSPoint.LLtoMGRS(llp);
                    outStr1.append(record).append(" is ").append(llp).append(" back to ").append(MGRSPoint.LLtoUTM(llp)).append("\n");
                    outStr2.append(record).append(" is ").append(mgrsp).append("\n");
                    continue;
                }
                if (!inType.equalsIgnoreCase("LatLon")) continue;
                int index = (record = record.trim()).indexOf(" ");
                if (index < 0) {
                    index = record.indexOf("\t");
                }
                String tmp = record.substring(0, index);
                float lat = Float.parseFloat(tmp);
                tmp = record.substring(index);
                float lon = Float.parseFloat(tmp);
                LatLonPoint.Double llp = new LatLonPoint.Double(lat, lon);
                MGRSPoint mgrsp = MGRSPoint.LLtoMGRS(llp);
                outStr1.append(record).append(" to UTM: ").append(mgrsp.zone_number).append(" ").append(mgrsp.easting).append(" ").append(mgrsp.northing).append("\n");
                outStr2.append(record).append("    ->    ").append(mgrsp.mgrs).append("\n");
            }
        }
        catch (IOException e) {
            System.out.println("IO error: " + e.getMessage());
        }
        finally {
            if (pos != null) {
                pos.print(outStr1.toString());
                pos.print("\n");
                pos.print(outStr2.toString());
                pos.close();
            }
            if (lnr != null) {
                try {
                    lnr.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    public static void main(String[] argv) {
        MGRSPoint mgrsp;
        String[] arg;
        Debug.init();
        ArgParser ap = new ArgParser("MGRSPoint");
        ap.add("mgrs", "Print Latitude and Longitude for MGRS value", 1);
        ap.add("latlon", "Print MGRS for Latitude and Longitude values", 2, true);
        ap.add("sets", "Print the MGRS 100k table");
        ap.add("altsets", "Print the MGRS 100k table for the Bessel ellipsoid");
        ap.add("rtc", "Run test case, with filename and input data type [MGRS | UTM | LatLon]", 2);
        if (!ap.parse(argv)) {
            ap.printUsage();
            System.exit(0);
        }
        if ((arg = ap.getArgValues("sets")) != null) {
            new MGRSPoint().print100kSets();
        }
        if ((arg = ap.getArgValues("altsets")) != null) {
            mgrsp = new MGRSPoint();
            mgrsp.setOriginColumnLetters(BESSEL_SET_ORIGIN_COLUMN_LETTERS);
            mgrsp.setOriginRowLetters(BESSEL_SET_ORIGIN_ROW_LETTERS);
            mgrsp.print100kSets();
        }
        if ((arg = ap.getArgValues("mgrs")) != null) {
            try {
                mgrsp = new MGRSPoint(arg[0]);
                Debug.output(arg[0] + " is " + mgrsp.toLatLonPoint());
            }
            catch (NumberFormatException nfe) {
                Debug.error(nfe.getMessage());
            }
        }
        if ((arg = ap.getArgValues("latlon")) != null) {
            try {
                float lat = Float.parseFloat(arg[0]);
                float lon = Float.parseFloat(arg[1]);
                LatLonPoint.Double llp = new LatLonPoint.Double(lat, lon);
                MGRSPoint mgrsp2 = MGRSPoint.LLtoMGRS(llp);
                UTMPoint utmp = MGRSPoint.LLtoUTM(llp);
                if (utmp.zone_letter == 'Z') {
                    Debug.output(llp + "to UTM: latitude limit exceeded.");
                } else {
                    Debug.output(llp + " is " + utmp);
                }
                Debug.output(llp + " is " + mgrsp2);
            }
            catch (NumberFormatException nfe) {
                Debug.error("The numbers provided:  " + argv[0] + ", " + argv[1] + " aren't valid");
            }
        }
        if ((arg = ap.getArgValues("rtc")) != null) {
            MGRSPoint.runTests(arg[0], arg[1]);
        }
    }
}

