/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.proj.coords;

import com.bbn.openmap.proj.ProjMath;
import com.bbn.openmap.proj.coords.LatLonPoint;

public class EnuFrame {
    protected float x;
    protected float y;
    protected float z;

    public EnuFrame() {
        this.x = 0.0f;
        this.y = 0.0f;
        this.z = 0.0f;
    }

    public EnuFrame(double[] ecefv, LatLonPoint llpt) {
        double lat_ = llpt.getY();
        double lon_ = llpt.getX();
        double latitude = ProjMath.degToRad(lat_);
        double longitude = ProjMath.degToRad(lon_);
        double[] ecefVector = new double[3];
        double[] enuVector = new double[3];
        ecefVector[0] = ecefv[0];
        ecefVector[1] = ecefv[1];
        ecefVector[2] = ecefv[2];
        this.ecef2enu(ecefVector, latitude, longitude, enuVector);
        this.x = (float)enuVector[0];
        this.y = (float)enuVector[1];
        this.z = (float)enuVector[2];
    }

    public double[] toGeocentricFrame(LatLonPoint llpt) {
        double lat_ = llpt.getY();
        double lon_ = llpt.getX();
        double latitude = ProjMath.degToRad(lat_);
        double longitude = ProjMath.degToRad(lon_);
        double[] enuVector = new double[3];
        double[] ecefVector = new double[3];
        enuVector[0] = this.x;
        enuVector[1] = this.y;
        enuVector[2] = this.z;
        this.enu2ecef(ecefVector, latitude, longitude, enuVector);
        return ecefVector;
    }

    public void ecef2enu(double[] ecefVector, double latitude, double longitude, double[] enuVector) {
        double[][] temp = new double[3][3];
        double slat = Math.sin(latitude);
        double clat = Math.cos(latitude);
        double slon = Math.sin(longitude);
        double clon = Math.cos(longitude);
        temp[0][0] = -slon;
        temp[0][1] = clon;
        temp[0][2] = 0.0;
        temp[1][0] = -clon * slat;
        temp[1][1] = -slon * slat;
        temp[1][2] = clat;
        temp[2][0] = clon * clat;
        temp[2][1] = slon * clat;
        temp[2][2] = slat;
        for (int j = 0; j < 3; ++j) {
            enuVector[j] = 0.0;
            for (int i = 0; i < 3; ++i) {
                int n = j;
                enuVector[n] = enuVector[n] + temp[j][i] * ecefVector[i];
            }
        }
    }

    protected void enu2ecef(double[] ecefVector, double latitude, double longitude, double[] enuVector) {
        double[][] temp = new double[3][3];
        double clat = Math.cos(latitude);
        double slat = Math.sin(latitude);
        double clon = Math.cos(longitude);
        double slon = Math.sin(longitude);
        temp[0][0] = -slon;
        temp[0][1] = -clon * slat;
        temp[0][2] = clon * clat;
        temp[1][0] = clon;
        temp[1][1] = -slon * slat;
        temp[1][2] = slon * clat;
        temp[2][0] = 0.0;
        temp[2][1] = clat;
        temp[2][2] = slat;
        for (int j = 0; j < 3; ++j) {
            ecefVector[j] = 0.0;
            for (int i = 0; i < 3; ++i) {
                int n = j;
                ecefVector[n] = ecefVector[n] + temp[j][i] * enuVector[i];
            }
        }
    }

    public void setX(float pX) {
        this.x = pX;
    }

    public void setY(float pY) {
        this.y = pY;
    }

    public void setZ(float pZ) {
        this.z = pZ;
    }

    public void setXYZ(float v1, float v2, float v3) {
        this.x = v1;
        this.y = v2;
        this.z = v3;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getZ() {
        return this.z;
    }

    public void toDirectionVector(double degrees, double latitude, double longitude, double[] ecefVector) {
        double radians = Math.toRadians(degrees) - 360.0;
        double east = Math.sin(radians);
        double north = Math.cos(radians);
        double lat_ = Math.toRadians(latitude);
        double lon_ = Math.toRadians(longitude);
        double up = 0.0;
        double[] enuVector = new double[]{east, north, up};
        this.enu2ecef(ecefVector, lat_, lon_, enuVector);
    }
}

