/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics.util;

import com.bbn.openmap.geo.Geo;
import com.bbn.openmap.geo.GeoArray;
import com.bbn.openmap.geo.Intersection;
import com.bbn.openmap.geo.Ribbon;
import com.bbn.openmap.geo.RibbonIterator;
import com.bbn.openmap.omGraphics.OMAreaList;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMPoly;
import com.bbn.openmap.proj.Length;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RibbonMaker {
    protected GeoArray geoCoords;
    private static final Logger logger = Logger.getLogger("com.bbn.openmap.omGraphics.util.RibbonMaker");
    protected static final int STRAIGHT = 0;
    protected static final int BENDS_LEFT = -1;
    protected static final int BENDS_RIGHT = 1;
    protected double bufferLimit = 4.778825E-10;

    protected RibbonMaker(GeoArray gCoords) {
        this.geoCoords = gCoords;
    }

    public static RibbonMaker createFromDecimalDegrees(double[] coords) {
        return new RibbonMaker(GeoArray.Double.createFromLatLonDegrees(coords));
    }

    public static RibbonMaker createFromRadians(double[] coords) {
        return new RibbonMaker(GeoArray.Double.createFromLatLonRadians(coords));
    }

    public OMAreaList getOuterRing(double dist) {
        OMAreaList ret = new OMAreaList();
        if (dist <= this.bufferLimit) {
            return ret;
        }
        int numCoords = this.geoCoords.getSize();
        if (numCoords >= 3) {
            Geo g1 = this.geoCoords.get(0);
            Geo g2 = this.geoCoords.get(1);
            Geo g3 = this.geoCoords.get(2);
            this.handlePointsForOuterRing(g1, g2, g3, dist, ret);
            for (int i = 3; i < numCoords; ++i) {
                g1 = g2;
                g2 = g3;
                g3 = this.geoCoords.get(i);
                this.handlePointsForOuterRing(g1, g2, g3, dist, ret);
            }
            if (!this.geoCoords.get(0).equals(this.geoCoords.get(numCoords - 1))) {
                g1 = g2;
                g2 = g3;
                g3 = this.geoCoords.get(0);
                this.handlePointsForOuterRing(g1, g2, g3, dist, ret);
            }
            g1 = g2;
            g2 = g3;
            g3 = this.geoCoords.get(1);
            this.handlePointsForOuterRing(g1, g2, g3, dist, ret);
        }
        return ret;
    }

    protected void handlePointsForOuterRing(Geo g1, Geo g2, Geo g3, double dist, OMAreaList ret) {
        int bend = this.bends(g1, g2, g3);
        Geo gret = g3;
        RibbonIterator leg1 = new RibbonIterator(g1, g2, dist);
        OMPoly poly1 = this.getHalfPoly(leg1, 0, false);
        RibbonIterator leg2 = new RibbonIterator(g2, g3, dist);
        OMPoly poly2 = this.getHalfPoly(leg2, 0, true);
        if (poly1 == null || poly2 == null) {
            return;
        }
        if (bend == 0 || g2.equals(g3)) {
            ret.add(poly1);
            ret.add(poly2);
        } else if (bend == -1) {
            double dg12 = g1.distance(g2);
            double dg23 = g2.distance(g3);
            double legTestDist = dist * 2.0;
            if (dg12 < legTestDist || dg23 < legTestDist) {
                this.addShortLegPolyForIntersection(g1, g2, g3, 0, dist, ret);
            } else {
                this.addPolyForIntersection(poly1, poly2, dist, ret);
            }
        } else {
            OMGraphic oma;
            OMGraphic omp = this.getPushbackPoly(poly1, dist);
            if (omp != null) {
                ret.add(omp);
            }
            if ((oma = this.getArc(g2, poly1, poly2)) != null) {
                ret.add(oma);
            }
            if ((omp = this.getPushbackPoly(poly2, dist)) != null) {
                ret.add(omp);
            }
        }
    }

    protected int bends(Geo g1, Geo g2, Geo g3) {
        double bend = g1.crossNormalize(g2).distance(g3) - 1.5707963267948966;
        if (Math.abs(bend) < 1.0E-4) {
            return 0;
        }
        if (bend < 0.0) {
            return -1;
        }
        return 1;
    }

    protected boolean tooClose(Geo pnt, double distance) {
        return Intersection.isPointNearPoly(pnt, this.geoCoords, distance - this.bufferLimit);
    }

    protected OMGraphic getPushbackPoly(OMPoly omp, double dist) {
        double[] coords = omp.getLatLonArray();
        LinkedList<Geo> results = new LinkedList<Geo>();
        for (int i = 0; i < coords.length - 2; i += 2) {
            Geo g = new Geo(coords[i], coords[i + 1], false);
            if (this.tooClose(g, dist)) continue;
            results.add(g);
        }
        if (results.size() == 1) {
            results.add(new Geo((Geo)results.get(0)));
        }
        if (results.size() > 1) {
            return this.getOMPolyFromGeos(results);
        }
        return null;
    }

    protected void addShortLegPolyForIntersection(Geo g1, Geo g2, Geo g3, int ribbonSide, double dist, OMAreaList ret) {
        OMPoly halfPoly2;
        LinkedList<Geo> results = new LinkedList<Geo>();
        RibbonIterator leg1 = new RibbonIterator(g1, g2, dist);
        OMPoly fullPoly1 = this.getPoly(leg1, ribbonSide);
        RibbonIterator leg2 = new RibbonIterator(g2, g3, dist);
        OMPoly fullPoly2 = this.getPoly(leg2, ribbonSide);
        if (fullPoly1 == null || fullPoly2 == null) {
            return;
        }
        Geo intersection = this.getPolyIntersection(fullPoly1, fullPoly2);
        if (intersection == null) {
            return;
        }
        leg1 = new RibbonIterator(g1, g2, dist);
        OMPoly halfPoly1 = this.getHalfPoly(leg1, ribbonSide, false);
        if (halfPoly1 != null) {
            GeoArray.Double geoPoly2 = GeoArray.Double.createFromLatLonRadians(fullPoly2.getLatLonArray());
            double[] leg1Coords = halfPoly1.getLatLonArray();
            for (int i = 0; i < leg1Coords.length - 1; i += 2) {
                Geo pnt = new Geo(leg1Coords[i], leg1Coords[i + 1], false);
                if (this.tooClose(pnt, dist)) continue;
                results.add(pnt);
            }
            if (!this.tooClose(intersection, dist)) {
                results.add(intersection);
            }
        }
        if ((halfPoly2 = this.getHalfPoly(leg2 = new RibbonIterator(g2, g3, dist), ribbonSide, true)) != null) {
            GeoArray.Double geoPoly1 = GeoArray.Double.createFromLatLonRadians(fullPoly1.getLatLonArray());
            double[] leg2Coords = halfPoly2.getLatLonArray();
            for (int i = 0; i < leg2Coords.length - 1; i += 2) {
                Geo pnt = new Geo(leg2Coords[i], leg2Coords[i + 1], false);
                if (this.tooClose(pnt, dist)) continue;
                results.add(pnt);
            }
        }
        if (results.size() == 1 && !this.tooClose(intersection, dist)) {
            results.add(intersection);
        }
        if (results.size() > 1) {
            ret.add(this.getOMPolyFromGeos(results));
        }
    }

    protected Geo getPolyIntersection(OMPoly poly1, OMPoly poly2) {
        double[] p1Coords = poly1.getLatLonArray();
        double[] p2Coords = poly2.getLatLonArray();
        Geo intersect = null;
        int index1 = 0;
        int index2 = 0;
        while (index2 + 3 < p2Coords.length) {
            Geo b1 = new Geo(p2Coords[index2], p2Coords[index2 + 1], false);
            Geo b2 = new Geo(p2Coords[index2 + 2], p2Coords[index2 + 3], false);
            if (intersect == null) {
                while (index1 + 3 < p1Coords.length) {
                    Geo a1 = new Geo(p1Coords[index1], p1Coords[index1 + 1], false);
                    Geo a2 = new Geo(p1Coords[index1 + 2], p1Coords[index1 + 3], false);
                    intersect = Intersection.segmentsIntersect(a1, a2, b1, b2);
                    if (intersect != null) {
                        return intersect;
                    }
                    index1 += 2;
                }
            }
            index2 += 2;
        }
        return intersect;
    }

    protected OMPoly getOMPolyFromGeos(List<Geo> geos) {
        double[] tmpCoords = new double[geos.size() * 2];
        int index = 0;
        for (Geo geo : geos) {
            tmpCoords[index++] = geo.getLatitudeRadians();
            tmpCoords[index++] = geo.getLongitudeRadians();
        }
        return new OMPoly(tmpCoords, 1, 3);
    }

    protected void addPolyForIntersection(OMPoly poly1, OMPoly poly2, double dist, OMAreaList ret) {
        double[] p1Coords = poly1.getLatLonArray();
        double[] p2Coords = poly2.getLatLonArray();
        LinkedList<Geo> results = new LinkedList<Geo>();
        Geo intersect = null;
        int index1 = 0;
        int index2 = 0;
        while (index2 + 3 < p2Coords.length) {
            Geo b1 = new Geo(p2Coords[index2], p2Coords[index2 + 1], false);
            Geo b2 = new Geo(p2Coords[index2 + 2], p2Coords[index2 + 3], false);
            if (intersect == null) {
                while (index1 + 3 < p1Coords.length) {
                    Geo a1 = new Geo(p1Coords[index1], p1Coords[index1 + 1], false);
                    Geo a2 = new Geo(p1Coords[index1 + 2], p1Coords[index1 + 3], false);
                    intersect = Intersection.segmentsIntersect(a1, a2, b1, b2);
                    if (!this.tooClose(a1, dist)) {
                        results.add(a1);
                    }
                    if (intersect != null) {
                        if (this.tooClose(intersect, dist)) break;
                        results.add(intersect);
                        break;
                    }
                    index1 += 2;
                }
            }
            if (intersect != null && !this.tooClose(b2, dist)) {
                results.add(b2);
            }
            index2 += 2;
        }
        if (results.size() > 1) {
            ret.add(this.getOMPolyFromGeos(results));
        }
    }

    protected OMPoly getHalfPoly(RibbonIterator rIterator, int side, boolean first) {
        LinkedList<Geo> results = new LinkedList<Geo>();
        for (Ribbon rib : rIterator) {
            Geo g = rib.get(side);
            results.add(g);
        }
        int numCoords = results.size();
        if (numCoords > 0) {
            int startingIndex = 0;
            int copyLength = numCoords / 2;
            if (numCoords % 2 == 0) {
                if (!first) {
                    startingIndex = copyLength;
                }
            } else {
                if (!first) {
                    startingIndex = copyLength;
                }
                ++copyLength;
            }
            LinkedList<Geo> newGeoCoords = new LinkedList<Geo>();
            for (int index = 0; index < copyLength; ++index) {
                Geo g = (Geo)results.get(startingIndex + index);
                newGeoCoords.add(g);
            }
            return this.getOMPolyFromGeos(newGeoCoords);
        }
        return null;
    }

    protected OMPoly getPoly(RibbonIterator rIterator, int side) {
        LinkedList<Geo> bufferCoords = new LinkedList<Geo>();
        for (Ribbon rib : rIterator) {
            bufferCoords.add(rib.get(side));
        }
        if (bufferCoords.size() > 1) {
            return this.getOMPolyFromGeos(bufferCoords);
        }
        return null;
    }

    public OMGraphic getArc(Geo gc, OMPoly poly1, OMPoly poly2) {
        double[] poly1Coords = poly1.getLatLonArray();
        Geo pt1 = new Geo(poly1Coords[poly1Coords.length - 2], poly1Coords[poly1Coords.length - 1], false);
        double radAngle1 = gc.azimuth(pt1);
        double[] poly2Coords = poly2.getLatLonArray();
        Geo pt2 = new Geo(poly2Coords[0], poly2Coords[1], false);
        double radAngle2 = gc.azimuth(pt2);
        double dist = gc.distance(pt1);
        if (radAngle2 < radAngle1) {
            radAngle2 += Math.PI * 2;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Making arg starting at " + Length.DECIMAL_DEGREE.fromRadians(radAngle1) + ", " + Length.DECIMAL_DEGREE.fromRadians(radAngle2 - radAngle1));
        }
        LinkedList<Geo> points = new LinkedList<Geo>();
        double inc = Length.DECIMAL_DEGREE.toRadians(2.0);
        for (double angle = radAngle1 + inc; angle < radAngle2 - inc; angle += inc) {
            Geo g = gc.offset(dist, angle);
            if (this.tooClose(g, dist)) continue;
            points.add(g);
        }
        return this.getOMPolyFromGeos(points);
    }
}

