/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics.event;

import com.bbn.openmap.event.MapMouseEvent;
import com.bbn.openmap.layer.OMGraphicHandlerLayer;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.event.GestureResponsePolicy;
import com.bbn.openmap.omGraphics.event.MapMouseInterpreter;
import com.bbn.openmap.util.Debug;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.List;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardMapMouseInterpreter
implements MapMouseInterpreter {
    protected boolean DEBUG = false;
    protected OMGraphicHandlerLayer layer = null;
    protected String[] mouseModeServiceList = null;
    protected String lastToolTip = null;
    protected GestureResponsePolicy grp = null;
    protected GeometryOfInterest clickInterest = null;
    protected GeometryOfInterest movementInterest = null;
    protected boolean consumeEvents = false;
    protected boolean active = true;
    protected boolean noTimerOverOMGraphic = true;
    protected int mouseTimerInterval = 150;
    protected Timer mouseTimer = null;
    protected MouseTimerListener mouseTimerListener = new MouseTimerListener();
    protected MouseEvent currentMouseEvent;

    public StandardMapMouseInterpreter() {
        this.DEBUG = Debug.debugging("grp");
    }

    public StandardMapMouseInterpreter(OMGraphicHandlerLayer l) {
        this();
        this.setLayer(l);
    }

    public void setConsumeEvents(boolean consume) {
        this.consumeEvents = consume;
    }

    public boolean getConsumeEvents() {
        return this.consumeEvents;
    }

    public void setLayer(OMGraphicHandlerLayer l) {
        this.layer = l;
    }

    public OMGraphicHandlerLayer getLayer() {
        return this.layer;
    }

    public void setMouseModeServiceList(String[] list) {
        this.mouseModeServiceList = list;
    }

    public boolean isLeftMouseButton(MouseEvent me) {
        return SwingUtilities.isLeftMouseButton(me);
    }

    @Override
    public String[] getMouseModeServiceList() {
        return this.mouseModeServiceList;
    }

    protected void setClickInterest(GeometryOfInterest goi) {
        this.clickInterest = goi;
    }

    protected GeometryOfInterest getClickInterest() {
        return this.clickInterest;
    }

    protected void setMovementInterest(GeometryOfInterest goi) {
        this.movementInterest = goi;
    }

    protected GeometryOfInterest getMovementInterest() {
        return this.movementInterest;
    }

    public OMGraphic getGeometryUnder(MouseEvent me) {
        OMGraphic omg = null;
        OMGraphicList list = null;
        if (this.layer != null) {
            list = this.layer.getList();
            if (list != null) {
                int x = me.getX();
                int y = me.getY();
                if (me instanceof MapMouseEvent) {
                    Point2D pnt = ((MapMouseEvent)me).getProjectedLocation();
                    x = (int)pnt.getX();
                    y = (int)pnt.getY();
                }
                omg = (OMGraphic)list.findClosest(x, y, 4.0f);
            } else if (this.DEBUG) {
                Debug.output("SMMI: no layer to evaluate mouse event");
            }
        } else if (this.DEBUG) {
            Debug.output("SMMI: no layer to evaluate mouse event");
        }
        return omg;
    }

    @Override
    public boolean mousePressed(MouseEvent e) {
        if (this.DEBUG) {
            Debug.output("SMMI:mousePressed()");
        }
        return this.setClickInterestFromMouseEvent(e);
    }

    protected boolean setClickInterestFromMouseEvent(MouseEvent e) {
        if (!this.active) {
            return false;
        }
        if (this.DEBUG) {
            Debug.output("SMMI: setClickInterestFromMouseEvent()");
        }
        this.setCurrentMouseEvent(e);
        boolean ret = false;
        GeometryOfInterest goi = this.getClickInterest();
        OMGraphic omg = this.getGeometryUnder(e);
        if (goi != null && !goi.appliesTo(omg, e)) {
            if (goi.isLeftButton()) {
                this.leftClickOff(goi.getGeometry(), e);
            } else {
                this.rightClickOff(goi.getGeometry(), e);
            }
            this.setClickInterest(null);
        }
        if (omg != null) {
            this.setClickInterest(new GeometryOfInterest(omg, e));
        }
        ret = this.testForAndHandlePopupTrigger(e);
        if (omg != null && !ret) {
            this.select(omg);
            ret = true;
        }
        return ret && this.consumeEvents;
    }

    @Override
    public boolean mouseReleased(MouseEvent e) {
        if (!this.active) {
            return false;
        }
        this.setCurrentMouseEvent(e);
        return this.testForAndHandlePopupTrigger(e) && this.consumeEvents;
    }

    public boolean testForAndHandlePopupTrigger(MouseEvent e) {
        boolean ret = false;
        if (e.isPopupTrigger()) {
            GeometryOfInterest goi = this.getClickInterest();
            if (goi != null) {
                goi.setLeftButton(false);
                ret = this.rightClick(goi.getGeometry(), e);
            } else {
                ret = this.rightClick(e);
            }
        }
        return ret;
    }

    @Override
    public boolean mouseClicked(MouseEvent e) {
        if (!this.active) {
            return false;
        }
        this.setClickInterestFromMouseEvent(e);
        if (this.isLeftMouseButton(e)) {
            GeometryOfInterest goi = this.getClickInterest();
            if (goi != null) {
                if (goi.isLeftButton()) {
                    this.leftClick(goi.getGeometry(), e);
                } else {
                    this.rightClick(goi.getGeometry(), e);
                }
            } else {
                this.leftClick(e);
            }
            return this.consumeEvents;
        }
        return false;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (!this.active) {
            return;
        }
        this.setCurrentMouseEvent(e);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (!this.active) {
            return;
        }
        this.setCurrentMouseEvent(e);
    }

    @Override
    public boolean mouseDragged(MouseEvent e) {
        if (!this.active) {
            return false;
        }
        this.setCurrentMouseEvent(e);
        GeometryOfInterest goi = this.getClickInterest();
        if (goi != null) {
            this.setClickInterest(null);
        }
        return this.mouseMoved(e) && this.consumeEvents;
    }

    @Override
    public boolean mouseMoved(MouseEvent e) {
        if (!this.active) {
            return false;
        }
        this.setCurrentMouseEvent(e);
        if (this.noTimerOverOMGraphic && this.getMovementInterest() != null || this.mouseTimerInterval <= 0) {
            return this.updateMouseMoved(e);
        }
        if (this.mouseTimer == null) {
            this.mouseTimer = new Timer(this.mouseTimerInterval, this.mouseTimerListener);
            this.mouseTimer.setRepeats(false);
        }
        this.mouseTimerListener.setEvent(e);
        this.mouseTimer.restart();
        return false;
    }

    public void setNoTimerOverOMGraphic(boolean val) {
        this.noTimerOverOMGraphic = val;
    }

    public boolean getNoTimerOverOMGraphic() {
        return this.noTimerOverOMGraphic;
    }

    public void setMouseTimerInterval(int interval) {
        this.mouseTimerInterval = interval;
    }

    public int getMouseTimerInterval() {
        return this.mouseTimerInterval;
    }

    protected boolean updateMouseMoved(MouseEvent e) {
        boolean ret = false;
        OMGraphic omg = this.getGeometryUnder(e);
        GeometryOfInterest goi = this.getMovementInterest();
        if (omg != null && this.grp != null) {
            if (goi == null || !goi.appliesTo(omg)) {
                if (goi != null) {
                    this.mouseNotOver(goi.getGeometry());
                }
                goi = new GeometryOfInterest(omg, e);
                this.setMovementInterest(goi);
                this.setNoTimerOverOMGraphic(!omg.shouldRenderFill());
                ret = this.mouseOver(omg, e);
            }
        } else {
            if (goi != null) {
                this.mouseNotOver(goi.getGeometry());
                this.setMovementInterest(null);
            }
            ret = this.mouseOver(e);
        }
        return ret && this.consumeEvents;
    }

    @Override
    public void mouseMoved() {
        if (!this.active) {
            return;
        }
        GeometryOfInterest goi = this.getMovementInterest();
        if (goi != null) {
            this.mouseNotOver(goi.getGeometry());
            this.setMovementInterest(null);
        }
    }

    @Override
    public boolean leftClick(MouseEvent me) {
        if (this.DEBUG) {
            Debug.output("leftClick(MAP) at " + me.getX() + ", " + me.getY());
        }
        if (this.grp != null && this.grp.receivesMapEvents() && me instanceof MapMouseEvent) {
            return this.grp.leftClick((MapMouseEvent)me);
        }
        return false;
    }

    @Override
    public boolean leftClick(OMGraphic omg, MouseEvent me) {
        if (this.DEBUG) {
            Debug.output("leftClick(" + omg.getClass().getName() + ") at " + me.getX() + ", " + me.getY());
        }
        return false;
    }

    @Override
    public boolean leftClickOff(OMGraphic omg, MouseEvent me) {
        if (this.DEBUG) {
            Debug.output("leftClickOff(" + omg.getClass().getName() + ") at " + me.getX() + ", " + me.getY());
        }
        this.deselect(omg);
        return false;
    }

    @Override
    public boolean rightClick(MouseEvent me) {
        if (this.DEBUG) {
            Debug.output("rightClick(MAP) at " + me.getX() + ", " + me.getY());
        }
        if (me instanceof MapMouseEvent && this.grp != null) {
            return this.displayPopup(this.grp.getItemsForMapMenu((MapMouseEvent)me), me);
        }
        return false;
    }

    @Override
    public boolean rightClick(OMGraphic omg, MouseEvent me) {
        if (this.DEBUG) {
            Debug.output("rightClick(" + omg.getClass().getName() + ") at " + me.getX() + ", " + me.getY());
        }
        if (this.grp != null) {
            return this.displayPopup(this.grp.getItemsForOMGraphicMenu(omg), me);
        }
        return false;
    }

    protected boolean displayPopup(List<Component> contents, MouseEvent me) {
        if (this.DEBUG) {
            Debug.output("displayPopup(" + contents + ") " + me);
        }
        if (contents != null && !contents.isEmpty()) {
            JPopupMenu jpm = new JPopupMenu();
            for (Component comp : contents) {
                jpm.add(comp);
            }
            jpm.show((Component)me.getSource(), me.getX(), me.getY());
            return true;
        }
        return false;
    }

    @Override
    public boolean rightClickOff(OMGraphic omg, MouseEvent me) {
        if (this.DEBUG) {
            Debug.output("rightClickOff(" + omg.getClass().getName() + ") at " + me.getX() + ", " + me.getY());
        }
        return false;
    }

    @Override
    public boolean mouseOver(MouseEvent me) {
        if (this.DEBUG) {
            Debug.output("mouseOver(MAP) at " + me.getX() + ", " + me.getY());
        }
        if (this.grp != null && this.grp.receivesMapEvents() && me instanceof MapMouseEvent) {
            return this.grp.mouseOver((MapMouseEvent)me);
        }
        return false;
    }

    @Override
    public boolean mouseOver(OMGraphic omg, MouseEvent me) {
        if (this.DEBUG) {
            Debug.output("mouseOver(" + omg.getClass().getName() + ") at " + me.getX() + ", " + me.getY());
        }
        if (this.grp != null) {
            this.handleToolTip(this.grp.getToolTipTextFor(omg), me);
            this.handleInfoLine(this.grp.getInfoText(omg));
            if (this.grp.isHighlightable(omg)) {
                this.grp.highlight(omg);
            }
        }
        return true;
    }

    protected void handleToolTip(String tip, MouseEvent me) {
        if (this.lastToolTip != null && this.lastToolTip.equals(tip)) {
            return;
        }
        this.lastToolTip = tip;
        if (this.layer != null) {
            if (this.lastToolTip != null && this.lastToolTip.trim().length() > 0) {
                this.layer.fireRequestToolTip(this.lastToolTip);
                ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
                toolTipManager.mouseMoved(me);
            } else {
                this.layer.fireHideToolTip();
            }
        }
    }

    protected void handleInfoLine(String line) {
        if (this.layer != null) {
            this.layer.fireRequestInfoLine(line == null ? "" : line);
        }
    }

    @Override
    public boolean mouseNotOver(OMGraphic omg) {
        if (this.DEBUG) {
            Debug.output("mouseNotOver(" + omg.getClass().getName() + ")");
        }
        if (this.grp != null) {
            this.grp.unhighlight(omg);
        }
        this.handleToolTip(null, null);
        this.handleInfoLine(null);
        return false;
    }

    public void select(OMGraphic omg) {
        if (this.grp != null && this.grp.isSelectable(omg)) {
            OMGraphicList omgl = new OMGraphicList();
            omgl.add(omg);
            this.grp.select(omgl);
        }
    }

    public void deselect(OMGraphic omg) {
        if (this.grp != null && this.grp.isSelectable(omg)) {
            OMGraphicList omgl = new OMGraphicList();
            omgl.add(omg);
            this.grp.deselect(omgl);
        }
    }

    protected void setCurrentMouseEvent(MouseEvent me) {
        this.currentMouseEvent = me;
    }

    @Override
    public MouseEvent getCurrentMouseEvent() {
        return this.currentMouseEvent;
    }

    @Override
    public void setGRP(GestureResponsePolicy grp) {
        this.grp = grp;
    }

    @Override
    public GestureResponsePolicy getGRP() {
        return this.grp;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
    }

    protected class MouseTimerListener
    implements ActionListener {
        private MouseEvent event;

        protected MouseTimerListener() {
        }

        public synchronized void setEvent(MouseEvent e) {
            this.event = e;
        }

        public synchronized void actionPerformed(ActionEvent ae) {
            if (this.event != null) {
                StandardMapMouseInterpreter.this.updateMouseMoved(this.event);
            }
        }
    }

    public class GeometryOfInterest {
        OMGraphic omg;
        int button;
        boolean leftButton;

        public GeometryOfInterest(OMGraphic geom, MouseEvent me) {
            this.omg = geom;
            this.button = this.getButton(me);
            this.leftButton = StandardMapMouseInterpreter.this.isLeftMouseButton(me);
        }

        public boolean appliesTo(OMGraphic geom) {
            return geom != null && geom.equals(this.omg);
        }

        public boolean appliesTo(OMGraphic geom, MouseEvent me) {
            return geom != null && geom.equals(this.omg) && this.sameButton(me);
        }

        public boolean sameButton(MouseEvent me) {
            return this.button == this.getButton(me);
        }

        public OMGraphic getGeometry() {
            return this.omg;
        }

        public int getButton() {
            return this.button;
        }

        protected int getButton(MouseEvent me) {
            if (me.isControlDown() || SwingUtilities.isRightMouseButton(me)) {
                return 1;
            }
            if (SwingUtilities.isLeftMouseButton(me)) {
                return 0;
            }
            return 2;
        }

        public boolean isLeftButton() {
            return this.leftButton;
        }

        public void setLeftButton(boolean b) {
            this.leftButton = b;
        }
    }
}

