/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.shape;

import com.bbn.openmap.dataAccess.shape.ShapeUtils;
import com.bbn.openmap.proj.ProjMath;
import com.bbn.openmap.util.Debug;

public abstract class ESRIPoly
extends ShapeUtils {
    public int nPoints;

    public abstract int read(byte[] var1, int var2, boolean var3);

    public static class ESRIFloatPoly
    extends ESRIPoly {
        protected double[] radians;
        protected boolean isRadians = true;

        public ESRIFloatPoly(int nPts) {
            if (Debug.debugging("shape") && nPts > 50000) {
                Debug.output("ESRIPoly w/" + nPts + " points");
            }
            this.nPoints = nPts;
            this.radians = new double[this.nPoints * 2];
        }

        public ESRIFloatPoly(double[] radians) {
            this.radians = radians;
            this.isRadians = true;
            this.nPoints = radians.length / 2;
        }

        public ESRIFloatPoly(double[] radians, boolean isRadians) {
            this.radians = radians;
            this.nPoints = radians.length / 2;
            this.isRadians = isRadians;
        }

        public double[] getRadians() {
            if (!this.isRadians) {
                ProjMath.arrayDegToRad(this.radians);
                this.isRadians = true;
            }
            return this.radians;
        }

        public double[] getDecimalDegrees() {
            if (this.isRadians) {
                ProjMath.arrayRadToDeg(this.radians);
                this.isRadians = false;
            }
            return this.radians;
        }

        public int read(byte[] b, int off, boolean connect) {
            int ptr = off;
            int end = connect ? this.radians.length - 2 : this.radians.length;
            for (int i = 0; i < end; i += 2) {
                this.radians[i + 1] = ProjMath.degToRad((float)ESRIFloatPoly.readLEDouble(b, ptr));
                this.radians[i] = ProjMath.degToRad((float)ESRIFloatPoly.readLEDouble(b, ptr += 8));
                ptr += 8;
            }
            if (connect) {
                this.radians[i] = this.radians[0];
                this.radians[i + 1] = this.radians[1];
            }
            return ptr - off;
        }

        public double getX(int index) {
            return ProjMath.radToDeg(this.radians[index * 2 + 1]);
        }

        public double getY(int index) {
            return ProjMath.radToDeg(this.radians[index * 2]);
        }
    }
}

