/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.rpf;

import com.bbn.openmap.event.ProgressListener;
import com.bbn.openmap.event.ProgressSupport;
import com.bbn.openmap.gui.ProgressListenerGauge;
import com.bbn.openmap.io.BinaryBufferedFile;
import com.bbn.openmap.io.BinaryFile;
import com.bbn.openmap.layer.rpf.MakeTocException;
import com.bbn.openmap.layer.rpf.RpfConstants;
import com.bbn.openmap.layer.rpf.RpfFileSearch;
import com.bbn.openmap.layer.rpf.RpfFileSections;
import com.bbn.openmap.layer.rpf.RpfHeader;
import com.bbn.openmap.layer.rpf.RpfProductInfo;
import com.bbn.openmap.proj.coords.DMSLatLonPoint;
import com.bbn.openmap.proj.coords.LatLonPoint;
import com.bbn.openmap.util.ArgParser;
import com.bbn.openmap.util.Debug;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.util.Calendar;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MakeToc {
    public static final int DEFAULT_MAX_SIDE = 200;
    public static final double EPS = 0.01;
    public static final double EPS2 = 1.0E-4;
    public static final String ATOC_FILENAME = "A.TOC";
    protected int maxSide = 200;
    protected boolean relativeFramePaths = true;
    protected String producer = "DMAAC";
    protected ProgressSupport progressSupport = new ProgressSupport(this);

    public static void main(String[] argv) {
        Debug.init();
        boolean Dchum = false;
        ArgParser ap = new ArgParser("MakeToc");
        ap.add("absolute", "Use absolute paths in A.TOC - Use for multiple RPF Directories");
        ap.add("boundary", "Maximum frames on a boundary edge (Default 200)", 1);
        ap.add("dchum", "DCHUM files are included.");
        ap.add("log", "Pathname of log file to list A.TOC creation output.", 1);
        ap.add("output", "Path to directory to place A.TOC file. (Default is current directory)", 1);
        ap.add("producer", "The producer of the frames (Default DMAAC).  Five letter code.", 1);
        ap.add("verbose", "Print out progress");
        ap.add("extraverbose", "Print out ALL progress");
        ap.add("nw", "Don't put up swing progress window (Use this if you are getting weird exceptions)");
        ap.add("paths", "Space separated paths to RPF directory or directories.  Should be last.  If more than one directory is listed, then absolute paths are used in the A.TOC file.", -1);
        if (!ap.parse(argv)) {
            ap.printUsage();
            System.exit(0);
        }
        String outputFile = "." + File.separator + ATOC_FILENAME;
        String[] arg = ap.getArgValues("output");
        if (arg != null) {
            outputFile = arg[0] + File.separator + ATOC_FILENAME;
        }
        if ((arg = ap.getArgValues("log")) != null) {
            String logfile = arg[0];
            Debug.directOutput(logfile, false, true);
            Debug.output("MakeToc: Creating log at " + logfile + " at " + Calendar.getInstance().getTime());
        }
        if ((arg = ap.getArgValues("dchum")) != null) {
            Dchum = true;
        }
        if ((arg = ap.getArgValues("verbose")) != null) {
            Debug.put("maketoc");
        }
        if ((arg = ap.getArgValues("extraverbose")) != null) {
            Debug.put("maketoc");
            Debug.put("maketocdetail");
        }
        String[] paths = null;
        arg = ap.getArgValues("paths");
        paths = arg != null ? arg : ap.getRest();
        if (paths == null || paths.length == 0) {
            Debug.output("MakeToc: need a path to start searching for RPF frames.");
            System.exit(0);
        }
        MakeToc mt = new MakeToc();
        arg = ap.getArgValues("nw");
        if (arg == null) {
            try {
                mt.addProgressListener(new ProgressListenerGauge("RPF A.TOC File Creation"));
            }
            catch (RuntimeException re) {
                // empty catch block
            }
        }
        boolean argFlagged = false;
        arg = ap.getArgValues("absolute");
        if (arg != null) {
            argFlagged = true;
        }
        if ((arg = ap.getArgValues("producer")) != null) {
            mt.setProducer(arg[0]);
        }
        if (paths != null && paths.length > 1 || argFlagged) {
            Debug.output("MakeToc:  creating A.TOC with absolute path names.");
            mt.setRelativeFramePaths(false);
        }
        arg = ap.getArgValues("boundary");
        int max_side = 200;
        if (arg != null) {
            try {
                max_side = Integer.parseInt(arg[0]);
                if (max_side <= 200) {
                    Debug.output("MakeToc: Boundary number specified (" + max_side + ") is too small.  Using default of 200.");
                    max_side = 200;
                }
            }
            catch (NumberFormatException nfe) {
                Debug.output("MakeToc: Tried to pass a bogus integer (" + arg[0] + ") as a boundary limit.  Using default of 200.");
                max_side = 200;
            }
        }
        mt.setMaxSide(max_side);
        mt.fireProgressUpdate(0, "Searching for RPF frames", 0, 100);
        paths = mt.searchForRpfFiles(paths);
        try {
            mt.create(paths, outputFile, Dchum);
        }
        catch (MakeTocException mte) {
            Debug.error("Problem creating A.TOC file: \n" + mte.getMessage());
        }
        System.exit(0);
    }

    public void create(String[] rpfFilePaths, String outputFile) throws MakeTocException {
        this.create(rpfFilePaths, outputFile, false);
    }

    public void create(String[] rpfFilePaths, String outputFile, boolean dchum) throws MakeTocException {
        RpfHeader head = new RpfHeader();
        Vector<Frame> frames = new Vector<Frame>(rpfFilePaths.length);
        Vector<Group> groups = new Vector<Group>();
        this.fireProgressUpdate(1, "Organizing frames", 0, 100);
        this.organizeFrames(rpfFilePaths, head, frames);
        if (head.standardNumber == null) {
            throw new MakeTocException("MakeToc: No RPF frames found.");
        }
        this.groupFrames(frames, groups, dchum);
        this.fireProgressUpdate(1, "Writing A.TOC file", 100, 100);
        this.writeTOCFile(outputFile, head, frames, groups);
        this.fireProgressUpdate(2, "A.TOC file complete", 100, 100);
    }

    public String[] searchForRpfFiles(String[] startDirs) {
        RpfFileSearch search = new RpfFileSearch();
        for (int i = 0; i < startDirs.length; ++i) {
            search.handleEntry(startDirs[i]);
        }
        return search.getFiles();
    }

    public void setRelativeFramePaths(boolean setting) {
        this.relativeFramePaths = setting;
    }

    public boolean getRelativeFramePaths() {
        return this.relativeFramePaths;
    }

    public void setProducer(String setting) {
        this.producer = setting.length() != 5 ? (setting.length() >= 5 ? setting.substring(0, 5) : setting + this.createPadding(5 - setting.length(), false)) : setting;
    }

    public String getProducer() {
        return this.producer;
    }

    protected void setMaxSide(int set) {
        this.maxSide = set;
    }

    protected int getMaxSide() {
        return this.maxSide;
    }

    protected boolean near(double a, double b, double eps) {
        return Math.abs(a - b) < eps;
    }

    public void organizeFrames(String[] framePaths, RpfHeader head, Vector<Frame> frames) {
        boolean isoverview = false;
        boolean islegend = false;
        Debug.message("maketoc", "MakeToc.organizeFrames: *** initial look at frames ***");
        int nFrames = framePaths.length;
        if (Debug.debugging("maketoc")) {
            Debug.output("Number of frames: " + nFrames);
        }
        for (int i = 0; i < nFrames; ++i) {
            RpfFileSections.RpfCoverageSection coverage;
            isoverview = false;
            islegend = false;
            String framePath = framePaths[i];
            if (Debug.debugging("maketoc")) {
                Debug.output("MakeToc: frame number " + i + ", " + framePath);
            }
            try {
                BinaryBufferedFile binFile = new BinaryBufferedFile(framePath);
                String fn = binFile.getName();
                if (fn.length() != 12) {
                    if (!Debug.debugging("maketoc")) continue;
                    Debug.error("MakeToc: " + framePath + " is not a RPF image file - ignoring");
                    continue;
                }
                RpfFileSections rfs = new RpfFileSections();
                ((BinaryFile)binFile).seek(0L);
                if (!head.read(binFile)) {
                    if (!Debug.debugging("maketoc")) continue;
                    Debug.error("MakeToc: " + framePath + " is not a RPF image file - ignoring");
                    continue;
                }
                ((BinaryFile)binFile).seek(head.locationSectionLocation);
                rfs.parse(binFile);
                coverage = rfs.parseCoverageSection(binFile);
                if (coverage == null) {
                    Debug.error("MakeToc: error reading coverage section for " + framePath + ", (file " + i + ") skipping");
                    binFile.close();
                    continue;
                }
                if (Debug.debugging("maketocframedetail")) {
                    Debug.output("MakeToc.organizeFrames: coverage section for " + framePath + ", " + coverage);
                }
                binFile.close();
                binFile = null;
            }
            catch (FileNotFoundException e) {
                Debug.error("MakeToc: " + framePath + " not found, being ignored.");
                continue;
            }
            catch (IOException ioe) {
                Debug.error("MakeToc: File IO Error during read of: " + framePath + "! Being ignored. \n" + ioe);
                continue;
            }
            Frame frame = new Frame();
            frames.add(frame);
            frame.filename = framePath;
            int tail = frame.filename.lastIndexOf(File.separatorChar);
            String framename = tail == -1 ? frame.filename : frame.filename.substring(++tail);
            if (framename.length() != 12) {
                Debug.error("filename must be 12 chars long - " + framename);
                return;
            }
            boolean bl = isoverview = framename.charAt(9) == 'O';
            if (!isoverview) {
                islegend = framename.regionMatches(true, 9, "LG", 0, 2);
            }
            isoverview = false;
            islegend = false;
            String padding = null;
            String seriesCode = head.filename.substring(9, 11);
            RpfProductInfo rpi = RpfProductInfo.get(seriesCode);
            if (rpi == RpfConstants.UK) {
                String dblChkSeriesCode = framename.substring(9, 11);
                RpfProductInfo rpi2 = rpi;
                if (!seriesCode.equals(dblChkSeriesCode)) {
                    rpi2 = RpfProductInfo.get(dblChkSeriesCode);
                }
                if (rpi2 == RpfConstants.UK) {
                    Debug.output("MakeToc: " + frame.filename + " / " + head.filename + " (filename/header) unknown map type " + seriesCode + " / " + dblChkSeriesCode + " - ignoring.");
                    frames.remove(frame);
                    continue;
                }
            }
            String scaleString = rpi.scaleString;
            if (!(rpi.scale != -1.0f && scaleString != null && scaleString.length() != 0 || (scaleString = this.promptForScale("What is the scale for " + frame.filename + "? (Answer should look like: 1:XXX,XXX)")) != null && scaleString.length() != 0)) {
                Debug.error("Bad input for scale for " + frame.filename + ", skipping.");
                frames.remove(frame);
                continue;
            }
            if (rpi.dataType.equalsIgnoreCase("CIB")) {
                frame.cib = true;
            } else if (rpi.dataType.equalsIgnoreCase("CDTED")) {
                frame.cdted = true;
            }
            int scaleStringLength = 12;
            if (scaleString.length() < scaleStringLength) {
                padding = this.createPadding(scaleStringLength - scaleString.length(), false);
                scaleString = scaleString + padding;
            } else if (scaleString.length() > scaleStringLength) {
                scaleString = scaleString.substring(0, scaleStringLength);
            }
            frame.scale = scaleString;
            frame.zone = head.filename.charAt(11);
            if (isoverview) {
                coverage.selon = 0.0;
                coverage.nelon = 0.0;
                coverage.selat = 0.0;
                coverage.swlat = 0.0;
                coverage.swlon = 0.0;
                coverage.nwlon = 0.0;
                coverage.nelat = 0.0;
                coverage.nwlat = 0.0;
                coverage.ewHorRes = 0.0;
                coverage.nsVertRes = 0.0;
                coverage.lonInterval = 0.0;
                coverage.latInterval = 0.0;
            }
            if (islegend) {
                coverage.selon = 0.0;
                coverage.nelon = 0.0;
                coverage.selat = 0.0;
                coverage.swlat = 0.0;
                coverage.swlon = 0.0;
                coverage.nwlon = 0.0;
                coverage.nelat = 0.0;
                coverage.nwlat = 0.0;
                coverage.ewHorRes = 0.0;
                coverage.nsVertRes = 0.0;
                coverage.lonInterval = 0.0;
                coverage.latInterval = 0.0;
            }
            if (frame.zone == '9' || frame.zone == 'J') {
                if (frame.zone == '9') {
                    if (Debug.debugging("maketoc")) {
                        Debug.output("Processing NORTH pole");
                    }
                    frame.left = (90.0 - coverage.nwlat) * Math.sin(coverage.nwlon * Math.PI / 180.0) / coverage.latInterval;
                    frame.right = (90.0 - coverage.selat) * Math.sin(coverage.selon * Math.PI / 180.0) / coverage.latInterval;
                    frame.top = -1.0 * (90.0 - coverage.nwlat) * Math.cos(coverage.nwlon * Math.PI / 180.0) / coverage.latInterval;
                    frame.bottom = -1.0 * (90.0 - coverage.selat) * Math.cos(coverage.selon * Math.PI / 180.0) / coverage.latInterval;
                } else {
                    if (Debug.debugging("maketoc")) {
                        Debug.output("Processing SOUTH pole");
                    }
                    frame.left = (90.0 + coverage.nwlat) * Math.sin(coverage.nwlon * Math.PI / 180.0) / coverage.latInterval;
                    frame.right = (90.0 + coverage.selat) * Math.sin(coverage.selon * Math.PI / 180.0) / coverage.latInterval;
                    frame.top = (90.0 + coverage.nwlat) * Math.cos(coverage.nwlon * Math.PI / 180.0) / coverage.latInterval;
                    frame.bottom = (90.0 + coverage.selat) * Math.cos(coverage.selon * Math.PI / 180.0) / coverage.latInterval;
                }
                frame.swlat = coverage.swlat;
                frame.swlon = coverage.swlon;
                if (Debug.debugging("maketoc")) {
                    Debug.output("MakeToc: " + frame.filename + " is a Polar frame");
                }
            } else {
                frame.left = coverage.nwlon;
                frame.right = coverage.selon;
                if (coverage.selon < coverage.nwlon) {
                    frame.right = 180.0;
                }
                frame.top = coverage.nwlat;
                frame.bottom = coverage.selat;
            }
            frame.h_interval = coverage.lonInterval;
            frame.v_interval = coverage.latInterval;
            frame.h_resolution = coverage.ewHorRes;
            frame.v_resolution = coverage.nsVertRes;
            frame.marked = false;
            if (!Debug.debugging("maketocframedetail")) continue;
            Debug.output("MakeToc: nw_lon = " + coverage.nwlon + ", se_lon = " + coverage.selon + "\n         nwlat = " + coverage.nwlat + ", selat = " + coverage.selat + "\n    NEW: swlat = " + coverage.swlat + ", swlon = " + coverage.swlon + "\n         vert_interval = " + coverage.latInterval + ", horiz_interval = " + coverage.lonInterval + "\n         vertical resolution = " + coverage.nsVertRes + ", horizontal resolution = " + coverage.ewHorRes + "\n         left = " + frame.left + ", right = " + frame.right + "\n         top = " + frame.top + ", bottom = " + frame.bottom + "\n");
        }
    }

    protected String promptForScale(String query) {
        try {
            String answer = null;
            System.out.println(query);
            InputStreamReader isr = new InputStreamReader(System.in);
            BufferedReader bufr = new BufferedReader(isr);
            answer = bufr.readLine();
            return answer;
        }
        catch (IOException ioe) {
            Debug.error("MakeToc: IOException trying to get an answer from you.  Dang.");
            return null;
        }
    }

    protected void writeTOCFile(String filename, RpfHeader head, Vector<Frame> frames, Vector<Group> groups) throws MakeTocException {
        int TOC_Nitf_hdr_size = 0;
        int Frame_hdr_len = 13;
        int Frame_index_rec_len = 33;
        RandomAccessFile fout = null;
        int groupCount = groups.size();
        int nFrames = frames.size();
        int[] pathname_pos = new int[nFrames];
        String[] direct = new String[nFrames];
        int[] uniq_dir_ptr = new int[nFrames];
        int[] uniq_dir_pos = new int[nFrames];
        String[] uniq_dir = new String[nFrames];
        String georef = "AAAAAA";
        try {
            Group group;
            int j;
            int tail;
            Frame frame;
            int i;
            fout = new RandomAccessFile(filename, "rw");
            if (Debug.debugging("maketoc")) {
                Debug.output("MakeToc: *** writing TOC ***\n  at: " + filename);
            }
            if (Debug.debugging("maketoc")) {
                Debug.output("MakeToc: *** writing header section ***");
            }
            char[] nt = new char[]{'\u0000'};
            fout.writeBoolean(head.endian);
            fout.writeShort(48);
            fout.writeBytes("       A.TOC");
            fout.writeByte(head.neww);
            fout.writeBytes(head.standardNumber);
            if (head.standardNumber.length() < 15) {
                fout.writeBytes(this.createPadding(15 - head.standardNumber.length(), false));
            }
            fout.writeBytes(head.standardDate);
            if (head.standardDate.length() < 8) {
                fout.writeBytes(this.createPadding(8 - head.standardDate.length(), false));
            }
            char[] charArray = new char[]{head.classification};
            String charString = new String(charArray);
            fout.writeBytes(charString);
            Debug.message("maketoc", "MakeToc: writing country(" + head.country + ") and release(" + head.release + ")");
            fout.writeBytes(head.country);
            fout.writeBytes(head.release);
            int location_section_location = (int)fout.getFilePointer() + 4;
            fout.writeInt(location_section_location);
            if (Debug.debugging("maketoc")) {
                Debug.output("MakeToc: location section location is : " + location_section_location);
            }
            if (Debug.debugging("maketoc")) {
                Debug.output("MakeToc: *** writing location section ***");
            }
            int Loc_hdr_len = 14;
            int Loc_sec_comp_len = 10;
            int Loc_sec_len = Loc_hdr_len + 4 * Loc_sec_comp_len;
            fout.writeShort(Loc_sec_len);
            fout.writeInt(Loc_hdr_len);
            fout.writeShort(4);
            fout.writeShort(Loc_sec_comp_len);
            if (Debug.debugging("maketoc")) {
                Debug.output("MakeToc:\n  location section length: " + Loc_sec_len + "\n  location header length: " + Loc_hdr_len + "\n  number of location records: " + 4 + "\n  location section comp length: " + Loc_sec_comp_len);
            }
            long agg_loc = fout.getFilePointer();
            fout.writeInt(0);
            int Bound_hdr_len = 8;
            int Bound_rec_len = 132;
            int Bound_sec_len = Bound_hdr_len + groupCount * Bound_rec_len;
            pathname_pos[0] = 0;
            int uniq_dir_cnt = 0;
            for (i = 0; i < nFrames; ++i) {
                frame = frames.elementAt(i);
                tail = frame.filename.lastIndexOf(File.separatorChar);
                direct[i] = tail == -1 ? frame.filename : frame.filename.substring(0, ++tail).replace('\\', '/');
                if (Debug.debugging("maketocdetail")) {
                    Debug.output("MakeToc: Matching directory: " + direct[i]);
                }
                boolean uniq_dir_match = false;
                String tmpDir = null;
                if (this.relativeFramePaths) {
                    int rpfIndex = direct[i].lastIndexOf("RPF");
                    if (rpfIndex == -1) {
                        rpfIndex = direct[i].lastIndexOf("rpf");
                    }
                    if (rpfIndex != -1) {
                        if (direct[i].length() > (rpfIndex += 3) && direct[i].charAt(rpfIndex) == '/') {
                            ++rpfIndex;
                        }
                        tmpDir = "./" + direct[i].substring(rpfIndex);
                    } else {
                        if (Debug.debugging("maketoc")) {
                            Debug.output("RPF directory not found in directory path " + direct[i] + ", using absolute path");
                        }
                        tmpDir = direct[i];
                    }
                } else {
                    tmpDir = direct[i];
                }
                for (j = 0; j < uniq_dir_cnt; ++j) {
                    if (!tmpDir.equals(uniq_dir[j])) continue;
                    uniq_dir_ptr[i] = j;
                    uniq_dir_match = true;
                    if (!Debug.debugging("maketocdetail")) break;
                    Debug.output("Found match with: " + uniq_dir[j]);
                    break;
                }
                if (uniq_dir_match) continue;
                uniq_dir[uniq_dir_cnt] = tmpDir;
                uniq_dir_ptr[i] = uniq_dir_cnt;
                if (Debug.debugging("maketoc")) {
                    Debug.output("Adding Unique directory: " + uniq_dir[uniq_dir_cnt]);
                }
                ++uniq_dir_cnt;
            }
            if (Debug.debugging("maketoc")) {
                Debug.output("Uniq_dir_cnt: " + uniq_dir_cnt);
            }
            int path_table_len = 0;
            for (j = 0; j < uniq_dir_cnt; ++j) {
                path_table_len += 2 + uniq_dir[j].length();
            }
            uniq_dir_pos[0] = 0;
            for (j = 1; j < uniq_dir_cnt; ++j) {
                uniq_dir_pos[j] = uniq_dir_pos[j - 1] + 2 + uniq_dir[j - 1].length();
            }
            for (j = 0; j < uniq_dir_cnt; ++j) {
                if (!Debug.debugging("maketocdetail")) continue;
                Debug.output("j: " + j + ", uniq_dir_pos[j]: " + uniq_dir_pos[j]);
            }
            for (i = 0; i < nFrames; ++i) {
                pathname_pos[i] = uniq_dir_pos[uniq_dir_ptr[i]];
                if (!Debug.debugging("maketocdetail")) continue;
                Debug.output("i: " + i + ", pathname_pos[i]:" + pathname_pos[i]);
            }
            int Frame_sec_len = Frame_hdr_len + nFrames * Frame_index_rec_len + path_table_len;
            fout.writeShort(148);
            fout.writeInt(Bound_hdr_len);
            fout.writeInt(TOC_Nitf_hdr_size + 48 + Loc_sec_len);
            fout.writeShort(149);
            int Bound_tbl_len = groupCount * Bound_rec_len;
            fout.writeInt(Bound_tbl_len);
            fout.writeInt(TOC_Nitf_hdr_size + 48 + Loc_sec_len + Bound_hdr_len);
            Bound_sec_len = Bound_hdr_len + Bound_tbl_len;
            fout.writeShort(150);
            fout.writeInt(Frame_hdr_len);
            fout.writeInt(TOC_Nitf_hdr_size + 48 + Loc_sec_len + Bound_sec_len);
            fout.writeShort(151);
            fout.writeInt(Frame_sec_len - Frame_hdr_len);
            fout.writeInt(TOC_Nitf_hdr_size + 48 + Loc_sec_len + Bound_sec_len + Frame_hdr_len);
            if (Debug.debugging("maketoc")) {
                Debug.output("MakeToc: boundary section at : " + fout.getFilePointer());
            }
            if (Debug.debugging("maketoc")) {
                Debug.output("MakeToc: *** writing boundary rectangles ***");
            }
            fout.writeInt(0);
            fout.writeShort((short)groupCount);
            fout.writeShort((short)Bound_rec_len);
            for (i = 0; i < groupCount; ++i) {
                double right_b;
                double right_t;
                double left_b;
                double left_t;
                double bottom;
                double top;
                group = groups.elementAt(i);
                if (group.cib) {
                    fout.writeBytes("CIB  ");
                    fout.writeBytes("8:1  ");
                } else if (group.cdted) {
                    fout.writeBytes("CDTED");
                    fout.writeBytes("6.5:1");
                } else {
                    fout.writeBytes("CADRG");
                    fout.writeBytes("55:1 ");
                }
                if (group.scale.length() < 12) {
                    fout.writeBytes(group.scale);
                    fout.writeBytes(this.createPadding(12 - group.scale.length(), false));
                } else {
                    fout.writeBytes(group.scale.substring(0, 12));
                }
                charArray[0] = group.zone;
                charString = new String(charArray);
                fout.writeBytes(charString);
                fout.writeBytes(this.producer);
                if (group.zone == '9' || group.zone == 'J') {
                    double ytop = group.horiz_pos[group.top];
                    double ybottom = group.horiz_pos[group.bottom];
                    double xleft = group.vert_pos[group.left];
                    double xright = group.vert_pos[group.right];
                    if (Debug.debugging("maketoc")) {
                        Debug.output("POLAR ZONE. ytop: " + ytop + ", ybottom: " + ybottom + ", xleft: " + xleft + ", xright:" + xright);
                    }
                    if (group.zone == '9') {
                        top = 90.0 - Math.sqrt(ytop * ytop + xleft * xleft) * group.h_interval;
                        bottom = 90.0 - Math.sqrt(ybottom * ybottom + xright * xright) * group.h_interval;
                    } else {
                        top = -90.0 + Math.sqrt(ytop * ytop + xleft * xleft) * group.h_interval;
                        bottom = -90.0 + Math.sqrt(ybottom * ybottom + xright * xright) * group.h_interval;
                    }
                    if (Debug.debugging("maketoc")) {
                        Debug.output("LATS. top: " + top + ", bottom: " + bottom);
                    }
                    if (group.zone == '9') {
                        left_t = 57.29577951308232 * Math.acos(-ytop / Math.sqrt(ytop * ytop + xleft * xleft));
                        left_b = 57.29577951308232 * Math.acos(-ybottom / Math.sqrt(ybottom * ybottom + xleft * xleft));
                        right_t = 57.29577951308232 * Math.acos(-ytop / Math.sqrt(ytop * ytop + xright * xright));
                        right_b = 57.29577951308232 * Math.acos(-ybottom / Math.sqrt(ybottom * ybottom + xright * xright));
                    } else {
                        left_t = 57.29577951308232 * Math.acos(ytop / Math.sqrt(ytop * ytop + xleft * xleft));
                        left_b = 57.29577951308232 * Math.acos(ybottom / Math.sqrt(ybottom * ybottom + xleft * xleft));
                        right_t = 57.29577951308232 * Math.acos(ytop / Math.sqrt(ytop * ytop + xright * xright));
                        right_b = 57.29577951308232 * Math.acos(ybottom / Math.sqrt(ybottom * ybottom + xright * xright));
                    }
                    if (xleft < 0.0) {
                        left_t = -left_t;
                        left_b = -left_b;
                    }
                    if (xright < 0.0) {
                        right_t = -right_t;
                        right_b = -right_b;
                    }
                    if (Debug.debugging("maketoc")) {
                        Debug.output("LONGS. left_t: " + left_t + ", right_t: " + right_t);
                    }
                    if (Debug.debugging("maketoc")) {
                        Debug.output("LONGS. left_b: " + left_b + ", right_b: " + right_b);
                    }
                } else {
                    left_b = left_t = group.vert_pos[group.left];
                    right_b = right_t = group.vert_pos[group.right];
                    top = group.horiz_pos[group.top];
                    bottom = group.horiz_pos[group.bottom];
                }
                fout.writeDouble(top);
                fout.writeDouble(left_t);
                fout.writeDouble(bottom);
                fout.writeDouble(left_b);
                fout.writeDouble(top);
                fout.writeDouble(right_t);
                fout.writeDouble(bottom);
                fout.writeDouble(right_b);
                fout.writeDouble(group.v_resolution);
                fout.writeDouble(group.h_resolution);
                fout.writeDouble(group.v_interval);
                fout.writeDouble(group.h_interval);
                fout.writeInt(group.bottom - group.top);
                fout.writeInt(group.right - group.left);
            }
            if (Debug.debugging("maketoc")) {
                Debug.output("MakeToc: *** writing frame section ***");
                Debug.output("MakeToc: started with a 'U'");
            }
            charArray[0] = 85;
            charString = new String(charArray);
            fout.writeBytes(charString);
            fout.writeInt(0);
            fout.writeInt(nFrames);
            fout.writeShort(uniq_dir_cnt);
            fout.writeShort(Frame_index_rec_len);
            for (i = 0; i < nFrames; ++i) {
                frame = frames.elementAt(i);
                group = groups.elementAt(frame.group);
                if (!frame.marked) {
                    Debug.error(frame.filename + ": not in a boundary rect??");
                }
                fout.writeShort(frame.group);
                short us = (short)(group.bottom - frame.y - 1);
                if (Debug.debugging("maketocframedetail")) {
                    Debug.output("iframe: " + i + ", frame.y: " + frame.y);
                    Debug.output("frame.group: " + frame.group);
                    Debug.output("group.bottom:" + group.bottom);
                    Debug.output("group.top:" + group.top);
                    Debug.output("frame row #:" + us);
                }
                fout.writeShort(us);
                fout.writeShort((short)(frame.x - group.left));
                fout.writeInt(nFrames * Frame_index_rec_len + pathname_pos[i]);
                tail = frame.filename.lastIndexOf(File.separatorChar);
                String framename = tail == -1 ? frame.filename : frame.filename.substring(++tail);
                if (framename.length() > 12) {
                    Debug.error("MakeToc: encountered a frame name that's too long!\n" + framename);
                    framename = framename.substring(0, 12);
                }
                fout.writeBytes(framename);
                String seriesCode = framename.substring(9, 11);
                if (!(seriesCode.equalsIgnoreCase("OV") || seriesCode.equalsIgnoreCase("LG") || seriesCode.equalsIgnoreCase("OI"))) {
                    georef = frame.zone != '9' || frame.zone != 'J' ? this.latlong2GEOREF(frame.swlat, frame.swlon) : this.latlong2GEOREF(frame.bottom, frame.left);
                } else {
                    if (Debug.debugging("maketoc")) {
                        Debug.output("Overview image has no GEOREF");
                    }
                    georef = "000000";
                }
                fout.writeBytes(georef);
                fout.writeBytes(charString);
                fout.writeBytes(head.country);
                fout.writeBytes(head.release);
            }
            Debug.message("maketoc", "MakeToc: *** writing directory section ***");
            for (j = 0; j < uniq_dir_cnt; ++j) {
                fout.writeShort((short)uniq_dir[j].length());
                fout.writeBytes(uniq_dir[j]);
            }
            fout.seek(agg_loc);
            fout.writeInt(Bound_sec_len + Frame_sec_len);
            fout.close();
            Debug.message("maketoc", "MakeToc: *** Normal end of make-toc ***");
        }
        catch (IOException ioe) {
            throw new MakeTocException(ioe.getMessage());
        }
    }

    protected void groupFrames(Vector<Frame> frames, Vector<Group> groups, boolean isDchum) throws MakeTocException {
        int nFrames = frames.size();
        Debug.message("maketoc", "MakeToc: *** grouping frames ***");
        for (int i = 0; i < nFrames; ++i) {
            Debug.message("maketocdetail", "MakeToc: group addition, starting outer loop");
            Frame frame = frames.elementAt(i);
            if (!frame.marked) {
                int groupCount = groups.size();
                Group group = new Group();
                group.left = this.maxSide / 2;
                group.right = group.left + 1;
                group.top = this.maxSide / 2;
                group.bottom = group.top + 1;
                group.horiz_pos[group.top] = frame.top;
                group.horiz_pos[group.bottom] = frame.bottom;
                group.vert_pos[group.left] = frame.left;
                group.vert_pos[group.right] = frame.right;
                group.h_interval = frame.h_interval;
                group.v_interval = frame.v_interval;
                group.h_resolution = frame.h_resolution;
                group.v_resolution = frame.v_resolution;
                group.scale = frame.scale;
                group.zone = frame.zone;
                group.cib = frame.cib;
                group.cdted = frame.cdted;
                frame.x = group.left;
                frame.y = group.top;
                frame.group = groupCount;
                frame.marked = true;
                Debug.message("maketocdetail", "Maketoc.groupFrames: created group " + groupCount + " for frame " + i + ", - " + frame.filename + " checking other frames for neighbors");
                if (!isDchum) {
                    for (int j = 0; j < nFrames; ++j) {
                        if (i == j) {
                            Debug.message("maketocdetail", "Maketoc.groupFrames: inner loop, i = j = " + i + ", frame that created group added to group, expecting false return");
                            continue;
                        }
                        Frame f = frames.elementAt(j);
                        if (!this.addFrameToGroup(group, f, groupCount)) continue;
                        Debug.message("maketocdetail", "Maketoc.groupFrames: added frame " + j + " to group " + groupCount);
                    }
                }
                Debug.message("maketocdetail", "Maketoc.groupFrames: adding another group - " + groupCount + " *******************\n\n");
                groups.add(group);
            }
            this.fireProgressUpdate(1, "Organizing frames", i, nFrames);
        }
        if (Debug.debugging("maketoc")) {
            Debug.output("MakeToc: Number of boundary rectangles (groups): " + groups.size());
        }
    }

    protected boolean addFrameToGroup(Group grp, Frame frm, int index) throws MakeTocException {
        int i;
        if (frm.scale == null || grp.scale == null) {
            Debug.output("grp and frm scale is null for " + frm.filename + ", skipping");
            return false;
        }
        if (frm.marked || !frm.scale.equalsIgnoreCase(grp.scale) || frm.zone != grp.zone) {
            Debug.message("maketocframedetail", "\nMakeToc.addFrameToGroup: no action needed for frame, returning.\n  frm.marked = " + frm.marked + "\n  frm.zone(" + frm.zone + ") = grp.zone(" + grp.zone + ")\n  frm.scale(" + frm.scale + ") = grp.scale(" + grp.scale + ")\n");
            return false;
        }
        Debug.message("maketocframedetail", "MakeToc.addFrameToGroup: adding unmarked frame");
        double eps = frm.EPS();
        if (frm.left >= grp.vert_pos[grp.left] - eps && frm.right <= grp.vert_pos[grp.right] + eps && frm.bottom >= grp.horiz_pos[grp.bottom] - eps && frm.top <= grp.horiz_pos[grp.top] + eps) {
            if (Debug.debugging("maketocdetail")) {
                Debug.output(frm.filename + " is in group " + index);
            }
        } else if (this.near(frm.right, grp.vert_pos[grp.left], eps) && frm.top <= grp.horiz_pos[grp.top] + eps && frm.bottom >= grp.horiz_pos[grp.bottom] - eps) {
            if (Debug.debugging("maketocdetail")) {
                Debug.output(frm.filename + " add frame to group " + index + ": left side");
            }
            if (grp.left == 0) {
                throw new MakeTocException("Boundary rectangle too small - Increase the boundary size to be larger than " + this.maxSide);
            }
            --grp.left;
            grp.vert_pos[grp.left] = frm.left;
        } else if (this.near(frm.left, grp.vert_pos[grp.right], eps) && frm.top <= grp.horiz_pos[grp.top] + eps && frm.bottom >= grp.horiz_pos[grp.bottom] - eps) {
            if (Debug.debugging("maketocdetail")) {
                Debug.output(frm.filename + ":add frame to group " + index + ": right side");
            }
            if (grp.right == this.maxSide) {
                throw new MakeTocException("Boundary rectangle too small - Increase the boundary size to be larger than " + this.maxSide);
            }
            grp.vert_pos[grp.right] = frm.left;
            ++grp.right;
            grp.vert_pos[grp.right] = frm.right;
        } else if (this.near(frm.bottom, grp.horiz_pos[grp.top], eps) && frm.right <= grp.vert_pos[grp.right] + eps && frm.left >= grp.vert_pos[grp.left] - eps) {
            if (Debug.debugging("maketocdetail")) {
                Debug.output(frm.filename + ":add frame to group " + index + ": top");
            }
            if (grp.top == 0) {
                throw new MakeTocException("Boundary rectangle too small - Increase the boundary size to be larger than " + this.maxSide);
            }
            --grp.top;
            grp.horiz_pos[grp.top] = frm.top;
        } else if (this.near(frm.top, grp.horiz_pos[grp.bottom], eps) && frm.right <= grp.vert_pos[grp.right] + eps && frm.left >= grp.vert_pos[grp.left] - eps) {
            if (Debug.debugging("maketocdetail")) {
                Debug.output(frm.filename + ":add frame to group " + index + ": bottom");
            }
            if (grp.bottom == this.maxSide) {
                throw new MakeTocException("Boundary rectangle too small - Increase the boundary size to be larger than " + this.maxSide);
            }
            grp.horiz_pos[grp.bottom] = frm.top;
            ++grp.bottom;
            grp.horiz_pos[grp.bottom] = frm.bottom;
        } else {
            Debug.message("maketocframedetail", "MakeToc.add: frame not close enough to anything else, not adding to group.");
            return false;
        }
        int y = -1;
        int x = -1;
        for (i = grp.left; i < grp.right; ++i) {
            if (!this.near(frm.left, grp.vert_pos[i], eps)) continue;
            x = i;
            break;
        }
        for (i = grp.top; i < grp.bottom; ++i) {
            if (!this.near(frm.top, grp.horiz_pos[i], eps)) continue;
            y = i;
            break;
        }
        if (x < 0 || y < 0) {
            Debug.output("MakeToc: " + frm.filename + ": in rect but can't find boundary (horizontal" + (x < 0 ? " bad" : " OK") + ", vertical" + (y < 0 ? " bad)" : " OK)"));
            if (Debug.debugging("maketocframedetail")) {
                Debug.output(" - For frame: \n  " + frm.toString());
                Debug.output(" - Group horizontal left: " + grp.left + " vs. right: " + grp.right);
                for (i = grp.left; i < grp.right; ++i) {
                    Debug.output(" - Checking horizontal: " + frm.left + " <-> " + grp.vert_pos[i]);
                    if (!this.near(frm.left, grp.vert_pos[i], eps)) continue;
                    Debug.output(" Last one should have hit.");
                }
                Debug.output(" - Group vertical top: " + grp.horiz_pos[grp.top] + " vs. bottom: " + grp.horiz_pos[grp.bottom] + ", frame top = " + frm.top + " and frame bottom = " + frm.bottom);
                for (i = grp.top; i < grp.bottom; ++i) {
                    Debug.output(" - Checking vertical: " + frm.top + " <-> " + grp.horiz_pos[i]);
                    if (!this.near(frm.top, grp.horiz_pos[i], eps)) continue;
                    Debug.output(" Last one should have hit.");
                }
            }
            throw new MakeTocException(frm.filename + " in rect but can't find boundary (horizontal" + (x < 0 ? " bad" : " OK") + ", vertical" + (y < 0 ? " bad)" : " OK)"));
        }
        if (Math.abs(frm.h_interval - grp.h_interval) > 1.0E-4 || Math.abs(frm.v_interval - grp.v_interval) > 1.0E-4) {
            Debug.error(frm.filename + ": interval mismatch\n  frm.h_interval: " + frm.h_interval + ", grp.h_interval:" + grp.h_interval + "\n  frm.v_interval: " + frm.v_interval + ", grp.v_interval: " + grp.v_interval + "\n  frm.h_resolution: " + frm.h_resolution + ", grp.h_resolution: " + grp.h_resolution + "\n  frm.h_resolution: " + frm.h_resolution + ", grp.h_resolution: " + grp.h_resolution);
            throw new MakeTocException(frm.filename + " has mismatched frame resolution");
        }
        frm.marked = true;
        frm.group = index;
        frm.x = x;
        frm.y = y;
        grp.cib = frm.cib;
        grp.cdted = frm.cdted;
        return true;
    }

    protected String latlong2GEOREF(double latitude, double longitude) {
        int tmpi2;
        int tmpi1;
        int i;
        int tmpi;
        int tmp = 65;
        int tmp1 = 65;
        int tmp2 = 65;
        LatLonPoint.Double llp = new LatLonPoint.Double(latitude, longitude);
        DMSLatLonPoint dmsp = new DMSLatLonPoint(llp);
        char[] GEOSTRING = new char[6];
        if (longitude == 0.0) {
            tmp = 78;
            tmp1 = 65;
            tmp2 = 48;
        } else if (longitude == -180.0) {
            tmp = 65;
            tmp1 = 65;
            tmp2 = 48;
        } else if (longitude == 180.0) {
            tmp = 90;
            tmp1 = 81;
            tmp2 = 57;
        } else if (longitude > 0.0) {
            tmpi = dmsp.lon_degrees / 15;
            if ((tmpi += 78) >= 79) {
                ++tmpi;
            }
            if (tmpi > 90) {
                tmpi = 90;
            }
            tmp = (char)tmpi;
            i = 0;
            while (i * 15 < (int)(longitude + 0.9999)) {
                ++i;
            }
            tmpi1 = 15 * i - (int)longitude;
            if (tmpi1 >= 3 && tmpi1 < 8) {
                ++tmpi1;
            } else if (tmpi1 >= 8) {
                tmpi1 += 2;
            }
            if (tmpi1 != 0) {
                tmpi1 = 82 - tmpi1;
                tmp1 = (char)tmpi1;
            } else {
                tmp1 = 65;
            }
            if (tmp1 == 82) {
                tmp1 = 65;
            }
            tmpi2 = 48 + dmsp.lon_minutes / 10;
            tmp2 = (char)tmpi2;
        } else if (longitude <= 0.0) {
            tmpi = (int)((double)dmsp.lon_degrees / 15.0 - 0.999);
            if ((tmpi = 77 - Math.abs(tmpi)) >= 73) {
                ++tmpi;
            }
            if (tmpi > 77) {
                tmpi = 77;
            }
            tmp = (char)tmpi;
            i = 0;
            while (i * 15 < (int)Math.abs(longitude - 0.9999)) {
                ++i;
            }
            tmpi1 = i * 15 - (int)Math.abs(longitude - 0.9999);
            if (tmpi1 >= 8 && tmpi1 < 13) {
                ++tmpi1;
            } else if (tmpi1 >= 13) {
                tmpi1 += 2;
            }
            if (tmpi1 > 16) {
                tmpi1 = 16;
            }
            tmp1 = (char)(tmpi1 += 65);
            if (dmsp.lon_minutes / 10 != 0) {
                tmpi2 = 48 + (6 - dmsp.lon_minutes / 10);
                tmp2 = (char)tmpi2;
            } else {
                tmp2 = 48;
            }
        }
        GEOSTRING[0] = tmp;
        GEOSTRING[2] = tmp1;
        GEOSTRING[4] = tmp2;
        if (latitude == 0.0) {
            tmp = 71;
            tmp1 = 65;
            tmp2 = 48;
        } else if (latitude == 90.0) {
            tmp = 77;
            tmp1 = 81;
            tmp2 = 57;
        } else if (latitude == -90.0) {
            tmp = 65;
            tmp1 = 65;
            tmp2 = 48;
        } else if (latitude > 0.0) {
            tmpi = dmsp.lat_degrees / 15;
            if ((tmpi += 71) >= 73) {
                ++tmpi;
            }
            if (tmpi > 77) {
                tmpi = 77;
            }
            tmp = (char)tmpi;
            i = 0;
            while (i * 15 < (int)(latitude + 0.9999)) {
                ++i;
            }
            tmpi1 = 15 * i - (int)latitude;
            if (tmpi1 >= 3 && tmpi1 < 8) {
                ++tmpi1;
            } else if (tmpi1 >= 8) {
                tmpi1 += 2;
            }
            tmpi1 = 82 - tmpi1;
            tmp1 = (char)tmpi1;
            if (tmp1 == 82) {
                tmp1 = 65;
            }
            if (dmsp.lat_minutes / 10 != 0) {
                tmpi2 = 48 + dmsp.lat_minutes / 10;
                tmp2 = (char)tmpi2;
            } else {
                tmp2 = 48;
            }
        } else if (latitude < 0.0) {
            tmpi = (int)((double)dmsp.lat_degrees / 15.0 - 0.999);
            if ((tmpi = 71 - Math.abs(tmpi)) < 65) {
                tmpi = 65;
            }
            i = 0;
            while (i * 15 < (int)Math.abs(latitude - 0.9999)) {
                ++i;
            }
            tmpi1 = i * 15 - (int)Math.abs(latitude - 0.9999);
            if (tmpi1 >= 8 && tmpi1 < 13) {
                ++tmpi1;
            } else if (tmpi1 >= 13) {
                tmpi1 += 2;
            }
            if (tmpi1 > 16) {
                tmpi1 = 16;
            }
            tmpi1 = 65 + tmpi1;
            tmp1 = (char)tmpi1;
            tmpi2 = 48 + (6 - dmsp.lat_minutes / 10);
            tmp2 = (char)tmpi2;
        }
        GEOSTRING[1] = tmp;
        GEOSTRING[3] = tmp1;
        GEOSTRING[5] = tmp2;
        String ret = new String(GEOSTRING);
        if (Debug.debugging("maketocdetail")) {
            Debug.output("latlon2GEOREF: lat = " + latitude + ", lon = " + longitude + ", GEOREF = " + ret);
        }
        return ret;
    }

    public String createPadding(int length, boolean nullTerminated) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            if (i == length - 1 && nullTerminated) {
                sb.append("/0");
                continue;
            }
            sb.append(" ");
        }
        return sb.toString();
    }

    public void addProgressListener(ProgressListener list) {
        this.progressSupport.add(list);
    }

    public void removeProgressListener(ProgressListener list) {
        this.progressSupport.remove(list);
    }

    public void clearProgressListeners() {
        this.progressSupport.clear();
    }

    protected void fireProgressUpdate(int type, String task, int frameNumber, int totalFrames) {
        this.progressSupport.fireUpdate(type, task, totalFrames, frameNumber);
    }

    public class Group {
        double[] horiz_pos;
        double[] vert_pos;
        int left;
        int right;
        int top;
        int bottom;
        String scale;
        char zone;
        double h_interval;
        double v_interval;
        double h_resolution;
        double v_resolution;
        boolean cib;
        boolean cdted;

        public Group() {
            this.horiz_pos = new double[MakeToc.this.maxSide];
            this.vert_pos = new double[MakeToc.this.maxSide];
        }

        public String toString() {
            StringBuffer s = new StringBuffer();
            s.append("Group - \n");
            s.append("  zone = ").append(this.zone).append("\n");
            s.append("  scale = ").append(this.scale).append("\n");
            s.append("  left = ").append(this.left).append("\n");
            s.append("  right = ").append(this.right).append("\n");
            s.append("  top = ").append(this.top).append("\n");
            s.append("  bottom = ").append(this.bottom).append("\n");
            s.append("  is cdted = ").append(this.cdted).append("\n");
            s.append("  is cib = ").append(this.cib).append("\n");
            return s.toString();
        }
    }

    public class Frame {
        double left;
        double right;
        double top;
        double bottom;
        double swlat;
        double swlon;
        double h_interval;
        double v_interval;
        double h_resolution;
        double v_resolution;
        String scale;
        char zone;
        boolean marked;
        int group;
        int x;
        int y;
        String filename;
        boolean cib;
        boolean cdted;

        public double EPS() {
            return Math.abs(this.right - this.left) * 0.01;
        }

        public String toString() {
            StringBuffer s = new StringBuffer();
            s.append("Frame - ").append(this.filename).append("\n");
            s.append("  zone = ").append(this.zone).append("\n");
            s.append("  marked = ").append(this.marked).append("\n");
            s.append("  scale = ").append(this.scale).append("\n");
            s.append("  group = ").append(this.group).append("\n");
            if (Debug.debugging("maketocframe")) {
                s.append("  top = ").append(this.top).append("\n");
                s.append("  bottom = ").append(this.bottom).append("\n");
                s.append("  left = ").append(this.left).append("\n");
                s.append("  right = ").append(this.right).append("\n");
                s.append("  h_interval = ").append(this.h_interval).append("\n");
                s.append("  v_interval = ").append(this.v_interval).append("\n");
                s.append("  h_resolution = ").append(this.h_resolution).append("\n");
                s.append("  v_resolution = ").append(this.v_resolution).append("\n");
            }
            return s.toString();
        }
    }
}

