/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.link;

import com.bbn.openmap.proj.coords.LatLonPoint;
import com.bbn.openmap.util.Debug;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class LinkBoundingPoly {
    public float maxX;
    public float maxY;
    public float minX;
    public float minY;
    protected float[] points;

    public LinkBoundingPoly(DataInput dis) throws IOException {
        this.read(dis);
    }

    public LinkBoundingPoly(float[] poly) {
        this.points = poly;
    }

    public LinkBoundingPoly(float minX, float minY, float maxX, float maxY) {
        this.points = new float[10];
        Debug.message("link", "LinkBoundingPoly: Creating link bounding poly with " + minX + ", " + minY + ", " + maxX + ", " + maxY);
        this.points[0] = minY;
        this.points[1] = minX;
        this.points[2] = maxY;
        this.points[3] = minX;
        this.points[4] = maxY;
        this.points[5] = maxX;
        this.points[6] = minY;
        this.points[7] = maxX;
        this.points[8] = minY;
        this.points[9] = minX;
    }

    public void write(DataOutput dos) throws IOException {
        int length = this.points.length / 2 * 2;
        dos.writeInt(length);
        for (int i = 0; i < length; ++i) {
            dos.writeFloat(this.points[i]);
        }
    }

    public void read(DataInput dis) throws IOException {
        Debug.message("link", "LinkBoundingPoly: read()");
        int polyLength = dis.readInt();
        this.points = new float[polyLength];
        for (int i = 0; i < this.points.length; i += 2) {
            float y = dis.readFloat();
            float x = dis.readFloat();
            if (i == 0) {
                this.minX = x;
                this.minY = y;
                this.maxX = x;
                this.maxY = y;
            }
            this.points[i] = y;
            this.points[i + 1] = x;
            if (x < this.minX) {
                this.minX = x;
            }
            if (x > this.maxX) {
                this.maxX = x;
            }
            if (y < this.minY) {
                this.minY = y;
            }
            if (!(y > this.maxY)) continue;
            this.maxY = y;
        }
    }

    public float[] getPoints() {
        return this.points;
    }

    public LatLonPoint[] getLatLonPoints() {
        LatLonPoint[] boundingPoly = new LatLonPoint[this.points.length / 2];
        for (int i = 0; i < this.points.length; i += 2) {
            float lat = this.points[i];
            float lon = this.points[i + 1];
            boundingPoly[i] = new LatLonPoint.Double(lat, lon);
        }
        return boundingPoly;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("  LinkBoundingPoly has ").append(this.points.length / 2).append(" points.");
        for (int i = 0; i < this.points.length; i += 2) {
            s.append("\n    |Lat = ").append(this.points[i]).append(", Lon = ").append(this.points[i + 1]).append("|");
        }
        return s.toString();
    }
}

