/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.learn;

import com.bbn.openmap.layer.OMGraphicHandlerLayer;
import com.bbn.openmap.layer.policy.BufferedImageRenderPolicy;
import com.bbn.openmap.layer.policy.ListResetPCPolicy;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMPoint;
import com.bbn.openmap.omGraphics.OMText;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.DataBounds;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectionResponseLayer
extends OMGraphicHandlerLayer {
    protected List<Point2D> dataSource;

    public ProjectionResponseLayer() {
        this.setName("Projection Response Layer");
        this.setProjectionChangePolicy(new ListResetPCPolicy(this));
        this.setRenderPolicy(new BufferedImageRenderPolicy());
    }

    @Override
    public synchronized OMGraphicList prepare() {
        OMGraphicList list = new OMGraphicList();
        Projection proj = this.getProjection();
        if (proj == null) {
            return list;
        }
        Object upperLeft = proj.getUpperLeft();
        Object lowerRight = proj.getLowerRight();
        if (((Point2D)upperLeft).getX() > ((Point2D)lowerRight).getX()) {
            this.getPoints(new DataBounds((Point2D)upperLeft, new Point2D.Double(180.0, ((Point2D)lowerRight).getY())), list, proj);
            this.getPoints(new DataBounds(new Point2D.Double(-180.0, ((Point2D)upperLeft).getY()), (Point2D)lowerRight), list, proj);
        } else {
            this.getPoints(new DataBounds((Point2D)upperLeft, (Point2D)lowerRight), list, proj);
        }
        OMText statement = new OMText(10, proj.getHeight() - 10, this.getName() + " displaying " + list.size() + "/" + this.dataSource.size() + " points", 0);
        statement.setFillPaint(Color.gray);
        statement.generate(proj);
        list.add(0, statement);
        return list;
    }

    protected void getPoints(DataBounds dataBounds, OMGraphicList retList, Projection proj) {
        if (this.dataSource == null) {
            this.dataSource = this.initSource();
        }
        for (Point2D point : this.dataSource) {
            if (!dataBounds.contains(point)) continue;
            OMPoint newPoint = new OMPoint(point.getY(), point.getX());
            newPoint.setFillPaint(point.getX() < 0.0 ? Color.green : Color.yellow);
            newPoint.generate(proj);
            retList.add(newPoint);
        }
    }

    protected List<Point2D> initSource() {
        ArrayList<Point2D> source = new ArrayList<Point2D>();
        for (double y = -85.0; y <= 85.0; y += 1.0) {
            for (double x = -180.0; x < 180.0; x += 1.0) {
                source.add(new Point2D.Double(x, y));
            }
        }
        logger.fine("created source with " + source.size() + " points");
        return source;
    }
}

