/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.dted;

import com.bbn.openmap.Environment;
import com.bbn.openmap.I18n;
import com.bbn.openmap.PropertyConsumer;
import com.bbn.openmap.io.BinaryFile;
import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMRect;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.PaletteHelper;
import com.bbn.openmap.util.PropUtils;
import com.bbn.openmap.util.wanderer.Wanderer;
import com.bbn.openmap.util.wanderer.WandererCallback;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.io.File;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DTEDCoverageManager
extends OMGraphicList
implements WandererCallback,
PropertyConsumer {
    protected I18n i18n = Environment.getI18n();
    public static Logger logger = Logger.getLogger("com.bbn.openmap.layer.dted.DTEDCoverageManager");
    protected String[] paths;
    public static final String defaultLevel0ColorString = "CE4F3F";
    public static final String defaultLevel1ColorString = "339159";
    public static final String defaultLevel2ColorString = "0C75D3";
    protected boolean[][] level0Frames = null;
    protected boolean[][] level1Frames = null;
    protected boolean[][] level2Frames = null;
    protected DrawingAttributes level0Attributes = DrawingAttributes.getDefaultClone();
    protected DrawingAttributes level1Attributes = DrawingAttributes.getDefaultClone();
    protected DrawingAttributes level2Attributes = DrawingAttributes.getDefaultClone();
    protected OMGraphicList level0Rects = new OMGraphicList();
    protected OMGraphicList level1Rects = new OMGraphicList();
    protected OMGraphicList level2Rects = new OMGraphicList();
    protected int curLon = Integer.MAX_VALUE;
    protected String prefix;
    protected JPanel panel;

    public DTEDCoverageManager(String[] paths) {
        this.paths = paths;
        this.level0Attributes.setLinePaint(PropUtils.parseColor(defaultLevel0ColorString));
        this.level1Attributes.setLinePaint(PropUtils.parseColor(defaultLevel1ColorString));
        this.level2Attributes.setLinePaint(PropUtils.parseColor(defaultLevel2ColorString));
    }

    public void reset() {
        this.level0Frames = null;
        this.level1Frames = null;
        this.level2Frames = null;
        this.clear();
    }

    public void checkOutCoverage(String[] paths) {
        this.level0Frames = new boolean[180][360];
        this.level1Frames = new boolean[180][360];
        this.level2Frames = new boolean[180][360];
        int maxNumPaths = 0;
        if (paths != null) {
            maxNumPaths = paths.length;
        }
        if (paths == null || maxNumPaths == 0) {
            logger.warning("No paths for DTED data given.");
            return;
        }
        logger.fine("checking out DTED at paths:");
        for (int d1 = 0; d1 < paths.length; ++d1) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("       " + paths[d1]);
            }
            if (BinaryFile.exists(paths[d1])) continue;
            paths[d1] = null;
            logger.fine("       - path invalid, ignoring.");
        }
        Wanderer wanderer = new Wanderer(this);
        for (int pathNum = 0; pathNum < maxNumPaths; ++pathNum) {
            wanderer.handleEntry(new File(paths[pathNum]));
        }
    }

    public boolean handleDirectory(File directory) {
        String name = directory.getName().toLowerCase();
        char hemi = name.charAt(0);
        if (name.length() == 4 && (hemi == 'e' || hemi == 'w')) {
            try {
                this.curLon = (hemi == 'w' ? -1 : 1) * Integer.parseInt(name.substring(1)) + 180;
            }
            catch (NumberFormatException nfe) {
                this.curLon = Integer.MAX_VALUE;
                logger.warning("Can't process " + name);
            }
        }
        return true;
    }

    public boolean handleFile(File file) {
        if (this.curLon != Integer.MAX_VALUE) {
            String name = file.getName().toLowerCase();
            char hemi = name.charAt(0);
            char level = name.charAt(name.length() - 1);
            if (name.length() == 7 && name.charAt(name.length() - 4) == '.' && (hemi == 'n' || hemi == 's')) {
                try {
                    int curLat = (hemi == 's' ? -1 : 1) * Integer.parseInt(name.substring(1, name.length() - 4)) + 90;
                    if (level == '0') {
                        this.level0Frames[curLat][this.curLon] = true;
                    } else if (level == '1') {
                        this.level1Frames[curLat][this.curLon] = true;
                    } else if (level == '2') {
                        this.level2Frames[curLat][this.curLon] = true;
                    }
                }
                catch (NumberFormatException nfe) {
                    logger.warning("Can't process " + name);
                }
            }
        }
        return true;
    }

    public OMGraphicList getCoverageRects(Projection proj) {
        if (this.level0Frames == null) {
            logger.fine("Scanning for frames - This could take several minutes!");
            this.checkOutCoverage(this.paths);
        }
        if (this.isEmpty()) {
            this.getCoverageRects(-180, -90, 179, 89, 2, proj);
        } else {
            this.generate(proj);
        }
        return this;
    }

    public float[] getCoverage(Projection proj) {
        float[] ret = new float[3];
        if (this.level0Frames != null) {
            Point pnt1 = new Point();
            Point pnt2 = new Point();
            int height = proj.getHeight();
            int width = proj.getWidth();
            int total = 0;
            for (int x = -180; x < 180; ++x) {
                for (int y = -90; y < 89; ++y) {
                    boolean onMap;
                    proj.forward(y, x, (Point2D)pnt1);
                    proj.forward(y + 1, x + 1, (Point2D)pnt2);
                    double x1 = pnt1.getX();
                    double y1 = pnt1.getY();
                    double x2 = pnt2.getX();
                    double y2 = pnt2.getY();
                    boolean someX = x1 >= 0.0 && x1 <= (double)width || x2 >= 0.0 && x2 <= (double)width;
                    boolean someY = y1 >= 0.0 && y1 <= (double)height || y2 >= 0.0 && y2 <= (double)height;
                    boolean bl = onMap = someX && someY;
                    if (!onMap) continue;
                    int xIndex = x + 180;
                    int yIndex = y + 90;
                    ++total;
                    if (this.level0Frames[yIndex][xIndex]) {
                        ret[0] = ret[0] + 1.0f;
                    }
                    if (this.level1Frames[yIndex][xIndex]) {
                        ret[1] = ret[1] + 1.0f;
                    }
                    if (!this.level2Frames[yIndex][xIndex]) continue;
                    ret[2] = ret[2] + 1.0f;
                }
            }
            logger.info("Total frames: " + total + " " + ret[0] + ", " + ret[1] + ", " + ret[2]);
            ret[0] = ret[0] / (float)total * 100.0f;
            ret[1] = ret[1] / (float)total * 100.0f;
            ret[2] = ret[2] / (float)total * 100.0f;
        }
        return ret;
    }

    public OMGraphicList getCoverageRects(int startx, int starty, int endx, int endy, int LineType2, Projection proj) {
        this.clear();
        this.level0Rects.clear();
        this.level1Rects.clear();
        this.level2Rects.clear();
        this.level0Rects.setVague(true);
        this.level1Rects.setVague(true);
        this.level2Rects.setVague(true);
        for (int lat = starty; lat <= endy && lat < 90; ++lat) {
            for (int lon = startx; lon <= endx && lon < 180; ++lon) {
                OMRect rect;
                if (this.level0Frames[lat + 90][lon + 180]) {
                    rect = new OMRect(lat, lon, (double)lat + 1.0, (double)lon + 1.0, LineType2);
                    this.level0Attributes.setTo(rect);
                    rect.generate(proj);
                    this.level0Rects.add(rect);
                }
                if (this.level1Frames[lat + 90][lon + 180]) {
                    rect = new OMRect((double)lat + (double)0.1f, (double)lon + (double)0.1f, (double)lat + (double)0.9f, (double)lon + (double)0.9f, LineType2);
                    this.level1Attributes.setTo(rect);
                    rect.generate(proj);
                    this.level1Rects.add(rect);
                }
                if (!this.level2Frames[lat + 90][lon + 180]) continue;
                rect = new OMRect((double)lat + (double)0.2f, (double)lon + (double)0.2f, (double)lat + (double)0.8f, (double)lon + (double)0.8f, LineType2);
                this.level2Attributes.setTo(rect);
                rect.generate(proj);
                this.level2Rects.add(rect);
            }
        }
        this.add(this.level0Rects);
        this.add(this.level1Rects);
        this.add(this.level2Rects);
        return this;
    }

    public Properties getProperties(Properties getList) {
        if (getList == null) {
            getList = new Properties();
        }
        this.level0Attributes.getProperties(getList);
        this.level1Attributes.getProperties(getList);
        this.level2Attributes.getProperties(getList);
        return getList;
    }

    public Properties getPropertyInfo(Properties list) {
        return list;
    }

    public String getPropertyPrefix() {
        return this.prefix;
    }

    public void setProperties(Properties setList) {
        this.setProperties(null, setList);
    }

    public void setProperties(String prefix, Properties setList) {
        this.setPropertyPrefix(prefix);
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.level0Attributes.setProperties(prefix + "0", setList);
        this.level1Attributes.setProperties(prefix + "1", setList);
        this.level2Attributes.setProperties(prefix + "2", setList);
    }

    public void setPropertyPrefix(String prefix) {
        this.prefix = prefix;
    }

    public Component getGUI() {
        if (this.panel == null) {
            String interString = this.i18n.get(DTEDCoverageManager.class, "title", "DTED Coverage");
            this.panel = PaletteHelper.createVerticalPanel(interString);
            JPanel pane = new JPanel();
            interString = this.i18n.get(DTEDCoverageManager.class, "level0title", "Level 0: ");
            pane.add(new JLabel(interString));
            String showString = this.i18n.get(DTEDCoverageManager.class, "show", "Show");
            JCheckBox jcb = new JCheckBox(showString, this.level0Rects.isVisible());
            jcb.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    DTEDCoverageManager.this.level0Rects.setVisible(((JCheckBox)ae.getSource()).isSelected());
                }
            });
            pane.add(jcb);
            pane.add(this.level0Attributes.getGUI());
            this.panel.add(pane);
            pane = new JPanel();
            interString = this.i18n.get(DTEDCoverageManager.class, "level2title", "Level 1: ");
            pane.add(new JLabel(interString));
            jcb = new JCheckBox(showString, this.level1Rects.isVisible());
            jcb.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    DTEDCoverageManager.this.level1Rects.setVisible(((JCheckBox)ae.getSource()).isSelected());
                }
            });
            pane.add(jcb);
            pane.add(this.level1Attributes.getGUI());
            this.panel.add(pane);
            pane = new JPanel();
            interString = this.i18n.get(DTEDCoverageManager.class, "level2title", "Level 2: ");
            pane.add(new JLabel(interString));
            jcb = new JCheckBox(showString, this.level2Rects.isVisible());
            jcb.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    DTEDCoverageManager.this.level2Rects.setVisible(((JCheckBox)ae.getSource()).isSelected());
                }
            });
            pane.add(jcb);
            pane.add(this.level2Attributes.getGUI());
            this.panel.add(pane);
        }
        return this.panel;
    }
}

