/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.image;

import com.bbn.openmap.image.AbstractImageFormatter;
import com.bbn.openmap.image.ImageFormatter;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Properties;

public class PPMFormatter
extends AbstractImageFormatter {
    public static final String RawBitsProperty = "rawbits";
    public static final String regularMagicNumber = "P3";
    public static final String rawbitsMagicNumber = "P6";
    public static final int HEADER_BUFFER_SIZE = 50;
    public static final int MAX_COLOR_VALUE = 255;
    protected boolean rawbits;

    public void setProperties(String prefix, Properties props) {
        this.rawbits = PropUtils.booleanFromProperties(props, (prefix == null ? "" : prefix) + RawBitsProperty, true);
    }

    public ImageFormatter makeClone() {
        PPMFormatter formatter = new PPMFormatter();
        formatter.rawbits = this.rawbits;
        return formatter;
    }

    public boolean getRawbits() {
        return this.rawbits;
    }

    public void setRawbits(boolean rb) {
        this.rawbits = rb;
    }

    public byte[] formatImage(BufferedImage bi) {
        int height = bi.getHeight();
        int width = bi.getWidth();
        int[] data = new int[width * height];
        bi.getRGB(0, 0, width, height, data, 0, width);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            if (!this.rawbits) {
                dos.writeBytes(regularMagicNumber);
                dos.writeBytes(" " + width);
                dos.writeBytes(" " + height);
                dos.writeBytes(" 255\n");
                int count = 0;
                int lastCount = 0;
                Debug.output("PPMFormatter: Header is " + dos.size() + " bytes");
                Debug.output("PPMFormatter: Height = " + height);
                Debug.output("PPMFormatter: Width = " + width);
                Debug.output("PPMFormatter: data length = " + data.length);
                for (int i = 0; i < data.length; ++i) {
                    int pixel = data[i];
                    int r = pixel >>> 16 & 0xFF;
                    int g = pixel >>> 8 & 0xFF;
                    int b = pixel & 0xFF;
                    dos.writeBytes(" " + r);
                    dos.writeBytes(" " + g);
                    dos.writeBytes(" " + b);
                    if (count > 57) {
                        dos.writeBytes("\n");
                        count = 0;
                    } else {
                        count += dos.size() - lastCount;
                    }
                    lastCount = dos.size();
                }
                Debug.output("PPMFormatter: after data, size is " + dos.size());
            } else {
                dos.writeBytes(rawbitsMagicNumber);
                dos.writeBytes(" " + width);
                dos.writeBytes(" " + height);
                dos.writeBytes(" 255\n");
                for (int i = 0; i < data.length; ++i) {
                    int pixel = data[i];
                    dos.writeByte(pixel >>> 16);
                    dos.writeByte(pixel >>> 8);
                    dos.writeByte(pixel);
                }
            }
            return baos.toByteArray();
        }
        catch (IOException ioe) {
            System.err.println("PPMFormatter caught IOException formatting image!");
            return new byte[0];
        }
    }

    public String getFormatLabel() {
        return "PPM";
    }

    public String getContentType() {
        return "image/ppm";
    }

    protected boolean imageFormatSupportAlphaChannel() {
        return false;
    }

    protected boolean imageFormatSupportTransparentPixel() {
        return false;
    }
}

