/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.dataAccess.mapTile;

import com.bbn.openmap.Environment;
import com.bbn.openmap.Layer;
import com.bbn.openmap.dataAccess.mapTile.EmptyTileHandler;
import com.bbn.openmap.dataAccess.mapTile.MapTileCoordinateTransform;
import com.bbn.openmap.dataAccess.mapTile.OSMMapTileCoordinateTransform;
import com.bbn.openmap.dataAccess.mapTile.StandardMapTileFactory;
import com.bbn.openmap.dataAccess.mapTile.ZoomLevelInfo;
import com.bbn.openmap.dataAccess.mapTile.ZoomLevelMaker;
import com.bbn.openmap.image.ImageFormatter;
import com.bbn.openmap.image.ImageServer;
import com.bbn.openmap.image.PNG32ImageFormatter;
import com.bbn.openmap.image.SunJPEGFormatter;
import com.bbn.openmap.layer.imageTile.MapTileLayer;
import com.bbn.openmap.layer.shape.ShapeLayer;
import com.bbn.openmap.omGraphics.OMColor;
import com.bbn.openmap.proj.Mercator;
import com.bbn.openmap.proj.Proj;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.proj.coords.LatLonPoint;
import com.bbn.openmap.util.ArgParser;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Paint;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapTileMaker
extends ImageServer
implements EmptyTileHandler {
    public static final String ROOT_DIRECTORY_PROPERTY = "rootDir";
    public static final String ZOOM_LEVELS_PROPERTY = "zoomLevels";
    protected String rootDir;
    protected List<ZoomLevelMaker> zoomLevels;
    protected MapTileCoordinateTransform mtcTransform = new OSMMapTileCoordinateTransform();
    protected int TILE_SIZE = this.mtcTransform.getTileSize();

    public MapTileMaker() {
    }

    public MapTileMaker(Properties props) {
        super(props);
    }

    public MapTileMaker(String prefix, Properties props) {
        super(prefix, props, null);
    }

    public MapTileMaker(String prefix, Properties props, Map<String, Layer> instantiatedLayers) {
        super(prefix, props, instantiatedLayers);
    }

    public MapTileMaker(Layer[] layers, ImageFormatter formatter) {
        super(layers, formatter);
    }

    @Override
    public void setProperties(String prefix, Properties props) {
        super.setProperties(prefix, props);
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.rootDir = props.getProperty(prefix + ROOT_DIRECTORY_PROPERTY, this.rootDir);
        List<?> zoomLevels = PropUtils.objectsFromProperties(props, prefix + ZOOM_LEVELS_PROPERTY, "class");
        this.getZoomLevels().addAll(zoomLevels);
    }

    @Override
    public Properties getProperties(Properties props) {
        props = super.getProperties(props);
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        props.put(prefix + ROOT_DIRECTORY_PROPERTY, PropUtils.unnull(this.rootDir));
        StringBuffer buf = new StringBuffer();
        for (ZoomLevelMaker zfi : this.getZoomLevels()) {
            buf.append(zfi.getPropertyPrefix()).append(" ");
            zfi.getProperties(props);
        }
        if (buf.length() > 0) {
            props.put(prefix + ZOOM_LEVELS_PROPERTY, buf.toString().trim());
        }
        return props;
    }

    @Override
    public Properties getPropertyInfo(Properties props) {
        props = super.getPropertyInfo(props);
        PropUtils.setI18NPropertyInfo(Environment.getI18n(), props, MapTileMaker.class, ROOT_DIRECTORY_PROPERTY, "Tile Directory", "Root directory for holding tile files.", "com.bbn.openmap.util.propertyEditor.DirectoryPropertyEditor");
        return props;
    }

    public byte[] makeTile(double uvx, double uvy, ZoomLevelMaker zoomInfo, Proj proj) {
        LatLonPoint center = this.tileUVToLatLon(new Point2D.Double(uvx + 0.5, uvy + 0.5), zoomInfo.getZoomLevel());
        proj.setScale(this.mtcTransform.getScaleForZoom(zoomInfo.getZoomLevel()));
        proj.setCenter(center);
        proj.setHeight(this.TILE_SIZE);
        proj.setWidth(this.TILE_SIZE);
        return this.createImage((Projection)proj, -1, -1, zoomInfo.getLayers());
    }

    public byte[] makeTile(double uvx, double uvy, int zoomLevel, List<Layer> layers, Proj proj, Paint background) {
        LatLonPoint center = this.tileUVToLatLon(new Point2D.Double(uvx + 0.5, uvy + 0.5), zoomLevel);
        proj.setScale(this.mtcTransform.getScaleForZoom(zoomLevel));
        proj.setCenter(center);
        proj.setHeight(this.TILE_SIZE);
        proj.setWidth(this.TILE_SIZE);
        return this.createImageFromLayers(proj, -1, -1, layers, background);
    }

    public String makeTileFile(double uvx, double uvy, ZoomLevelMaker zoomInfo, Proj proj) throws IOException {
        byte[] imageBytes = zoomInfo.makeTile(uvx, uvy, this, proj);
        String filePath = zoomInfo.formatImageFilePath(this.getRootDir(), (int)uvx, (int)uvy);
        return this.writeImageFile(imageBytes, filePath, true);
    }

    @Override
    public BufferedImage getImageForEmptyTile(String imagePath, int x, int y, int zoomLevel, MapTileCoordinateTransform mtcTransform, Projection proj) {
        Layer[] layers = null;
        List<ZoomLevelMaker> zoomLevels = this.getZoomLevels();
        if (zoomLevels != null && !zoomLevels.isEmpty()) {
            for (ZoomLevelMaker zoomLevelMaker : zoomLevels) {
                if (zoomLevelMaker.getZoomLevel() != zoomLevel) continue;
                List<Layer> layerList = zoomLevelMaker.getLayerList();
                layers = layerList != null ? layerList.toArray(new Layer[layerList.size()]) : this.getLayers();
                break;
            }
        } else {
            layers = this.getLayers();
        }
        if (layers == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("There are no layers defined for zoom level" + zoomLevel + " in MapTileMaker, can't create image");
            }
            return null;
        }
        LatLonPoint center = this.tileUVToLatLon(new Point2D.Double((double)x + 0.5, (double)y + 0.5), zoomLevel);
        Mercator m = new Mercator(center, mtcTransform.getScaleForZoom(zoomLevel), this.TILE_SIZE, this.TILE_SIZE);
        BufferedImage bufferedImage = new BufferedImage(this.TILE_SIZE, this.TILE_SIZE, 2);
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Graphics2D graphics = ge.createGraphics(bufferedImage);
        graphics.setClip(0, 0, this.TILE_SIZE, this.TILE_SIZE);
        if (graphics == null) {
            return null;
        }
        m.drawBackground(graphics, this.background);
        if (layers != null) {
            for (int i = layers.length - 1; i >= 0; --i) {
                try {
                    layers[i].renderDataForProjection(proj, graphics);
                    continue;
                }
                catch (Exception e) {
                    if (!logger.isLoggable(Level.FINE)) continue;
                    logger.fine("Problem rendering layer " + i);
                }
            }
        } else if (logger.isLoggable(Level.FINE)) {
            logger.fine("no layers available for image");
        }
        graphics.dispose();
        return bufferedImage;
    }

    public void makeTiles() {
        File rd;
        if (this.rootDir != null && !(rd = new File(this.rootDir)).exists()) {
            rd.mkdir();
        }
        Mercator proj = new Mercator(new LatLonPoint.Double(), 10000.0f, 256, 256);
        List<ZoomLevelMaker> zoomLevels = this.getZoomLevels();
        for (ZoomLevelMaker zfi : zoomLevels) {
            logger.info("writing zoom level " + zfi.getName() + " tiles...");
            int zoomLevel = zfi.getZoomLevel();
            for (Rectangle2D bounds : zfi.getUVBounds(this.mtcTransform, zoomLevel)) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(" creating tiles " + bounds);
                }
                int startx = (int)bounds.getX();
                int starty = (int)bounds.getY();
                int xofflimit = (int)bounds.getWidth();
                int yofflimit = (int)bounds.getHeight();
                for (int xoff = 0; xoff < xofflimit; ++xoff) {
                    int x = startx + xoff;
                    String parentDirPath = null;
                    for (int yoff = 0; yoff < yofflimit; ++yoff) {
                        File parentDir;
                        int y = starty + yoff;
                        if (parentDirPath == null && !(parentDir = new File(parentDirPath = zfi.formatParentDirectoryName(this.getRootDir(), x, y))).exists()) {
                            parentDir.mkdirs();
                        }
                        try {
                            String outputFile = this.makeTileFile(x, y, zfi, proj);
                            if (!logger.isLoggable(Level.FINER)) continue;
                            logger.finer("wrote: " + outputFile);
                            continue;
                        }
                        catch (IOException ioe) {
                            logger.warning("Caught IOException writing " + x + ", " + y + ", " + zfi);
                        }
                    }
                }
            }
            int range = zfi.getRange();
            if (range >= zoomLevel) continue;
            Properties rangeProps = new Properties();
            MapTileLayer tileLayer = new MapTileLayer();
            StandardMapTileFactory tileFactory = new StandardMapTileFactory();
            tileFactory.setRootDir(this.getRootDir());
            tileFactory.setFileExt(this.getFormatter().getFormatLabel());
            tileLayer.setTileFactory(tileFactory);
            ArrayList<Layer> subLayers = new ArrayList<Layer>();
            subLayers.add(tileLayer);
            for (int rangeZoomLevel = zoomLevel - 1; rangeZoomLevel >= range; --rangeZoomLevel) {
                tileLayer.setZoomLevel(rangeZoomLevel);
                ZoomLevelInfo rangeZFI = new ZoomLevelInfo();
                rangeZFI.setZoomLevel(rangeZoomLevel);
                rangeZFI.setScale(this.mtcTransform.getScaleForZoom(rangeZoomLevel));
                tileLayer.setZoomLevel(rangeZoomLevel + 1);
                for (Rectangle2D rawBounds : zfi.getBounds()) {
                    Rectangle2D bounds = rangeZFI.getUVBounds(rawBounds, this.mtcTransform, rangeZoomLevel);
                    if (logger.isLoggable(Level.INFO)) {
                        logger.fine(" creating subtiles " + bounds);
                    }
                    int startx = (int)bounds.getX();
                    int starty = (int)bounds.getY();
                    int xofflimit = (int)bounds.getWidth();
                    int yofflimit = (int)bounds.getHeight();
                    for (int xoff = 0; xoff < xofflimit; ++xoff) {
                        int x = startx + xoff;
                        String parentDirPath = null;
                        for (int yoff = 0; yoff < yofflimit; ++yoff) {
                            File parentDir;
                            int y = starty + yoff;
                            if (parentDirPath == null && !(parentDir = new File(parentDirPath = rangeZFI.formatParentDirectoryName(this.getRootDir(), x, y))).exists()) {
                                parentDir.mkdirs();
                            }
                            try {
                                byte[] imageBytes = this.makeTile(x, y, rangeZoomLevel, subLayers, proj, OMColor.clear);
                                String filePath = rangeZFI.formatImageFilePath(this.getRootDir(), x, y);
                                String outputFile = this.writeImageFile(imageBytes, filePath, true);
                                if (!logger.isLoggable(Level.INFO)) continue;
                                logger.finer("wrote: " + outputFile);
                                continue;
                            }
                            catch (IOException ioe) {
                                logger.warning("Caught IOException writing " + x + ", " + y + ", " + zfi);
                            }
                        }
                    }
                }
            }
        }
        logger.info("done writing tiles");
    }

    public String getRootDir() {
        return this.rootDir;
    }

    public void setRootDir(String rootDir) {
        this.rootDir = rootDir;
    }

    public List<ZoomLevelMaker> getZoomLevels() {
        if (this.zoomLevels == null) {
            this.zoomLevels = new LinkedList<ZoomLevelMaker>();
        }
        return this.zoomLevels;
    }

    public void setZoomLevels(List<ZoomLevelMaker> zoomLevels) {
        this.zoomLevels = zoomLevels;
    }

    public void createDefaultZoomLevels(int maxZoomLevel) {
        int i;
        Layer[] layers = this.getLayers();
        List<ZoomLevelMaker> zoomLevels = this.getZoomLevels();
        LinkedList<String> layerNames = new LinkedList<String>();
        for (i = 0; i < layers.length; ++i) {
            String layerName = layers[i].getPropertyPrefix();
            if (layerName != null) {
                layerNames.add(layerName);
                continue;
            }
            logger.info("no name for layer[" + i + "]");
        }
        zoomLevels.clear();
        for (i = 0; i <= maxZoomLevel; ++i) {
            ZoomLevelMaker zfi = new ZoomLevelMaker("ZoomLayerInfo " + i, "Tiles for zoom level " + i, i);
            zfi.setLayers(layerNames);
            zfi.setPropertyPrefix("zoom" + i);
            zoomLevels.add(zfi);
        }
    }

    public Point2D latLonToTileUV(Point2D latlon, int zoom) {
        return this.mtcTransform.latLonToTileUV(latlon, zoom, null);
    }

    public Point2D latLonToTileUV(Point2D latlon, int zoom, Point2D ret) {
        return this.mtcTransform.latLonToTileUV(latlon, zoom, ret);
    }

    public LatLonPoint tileUVToLatLon(Point2D tileUV, int zoom) {
        return this.mtcTransform.tileUVToLatLon(tileUV, zoom, null);
    }

    public LatLonPoint tileUVToLatLon(Point2D tileUV, int zoom, LatLonPoint ret) {
        return this.mtcTransform.tileUVToLatLon(tileUV, zoom, ret);
    }

    public static void main(String[] args) {
        ArgParser ap = new ArgParser("MapTileMaker");
        ap.add("properties", "The properties file to use for image tiles.", 1);
        ap.add("create", "Create a sample properties file at a path", 1);
        if (!ap.parse(args)) {
            ap.printUsage();
            System.exit(0);
        }
        Properties props = null;
        String[] arg = ap.getArgValues("properties");
        if (arg != null) {
            String ps = arg[0];
            try {
                URL url = PropUtils.getResourceOrFileOrURL(null, ps);
                InputStream inputStream = url.openStream();
                props = new Properties();
                props.load(inputStream);
                MapTileMaker tim = new MapTileMaker(props);
                tim.makeTiles();
            }
            catch (MalformedURLException murle) {
                Debug.error("TileMaker can't find properties file: " + arg[0]);
            }
            catch (IOException ioe) {
                Debug.error("TileMaker can't create images: IOException");
            }
        }
        if ((arg = ap.getArgValues("create")) != null) {
            MapTileMaker tim;
            String outputFile = arg[0];
            if (props == null) {
                ShapeLayer shapeLayer = new ShapeLayer();
                props = new Properties();
                props.put("shape.prettyName", "Countries");
                props.put("shape.shapeFile", "data/shape/world/cntry02/cntry02.shp");
                props.put("shape.fillColor", "FFBBBBBB");
                shapeLayer.setProperties("shape", props);
                tim = new MapTileMaker(new Layer[]{shapeLayer}, new SunJPEGFormatter());
                tim.createDefaultZoomLevels(4);
                tim.setRootDir("<Path to top level directory for tiles>");
                tim.setFormatter(new PNG32ImageFormatter());
            } else {
                tim = new MapTileMaker(props);
            }
            Properties configurationProps = new Properties();
            configurationProps = tim.getProperties(configurationProps);
            StringBuilder sb = new StringBuilder("#### MapTileMaker Properties ####\n");
            if (!configurationProps.isEmpty()) {
                TreeMap<Object, Object> orderedProperties = new TreeMap<Object, Object>(configurationProps);
                for (String string : orderedProperties.keySet()) {
                    String value = configurationProps.getProperty(string);
                    if (value == null) continue;
                    sb.append(string).append("=").append(value).append("\n");
                }
            }
            try {
                FileOutputStream fos = new FileOutputStream(outputFile);
                PrintStream ps = new PrintStream(fos);
                ps.println(sb.toString());
                ps.close();
            }
            catch (IOException ioe) {
                logger.warning("caught IOException writing property file: " + ioe.getMessage());
            }
        }
        System.exit(0);
    }
}

