/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.proj;

import com.bbn.openmap.proj.coords.LatLonPoint;

public class RhumbCalculator {
    private RhumbCalculator() {
    }

    public static LatLonPoint calculatePointOnRhumbLine(LatLonPoint point, float azimuth, float dist) {
        double lat1 = point.getRadLat();
        double lon1 = point.getRadLon();
        double d = (double)dist / 1855.3 * Math.PI / 10800.0;
        double lat = 0.0;
        double lon = 0.0;
        lat = lat1 + d * Math.cos(azimuth);
        double dphi = Math.log((1.0 + Math.sin(lat)) / Math.cos(lat)) - Math.log((1.0 + Math.sin(lat1)) / Math.cos(lat1));
        double dlon = 0.0;
        dlon = Math.abs(Math.cos(azimuth)) > Math.sqrt(1.0E-14) ? dphi * Math.tan(azimuth) : Math.sin(azimuth) * d / Math.cos(lat1);
        lon = RhumbCalculator.mod(lon1 - dlon + Math.PI, Math.PI * 2) - Math.PI;
        LatLonPoint ret = (LatLonPoint)point.clone();
        ret.setLatLon(lat, lon, true);
        return ret;
    }

    private static double mod(double y, double x) {
        double ret = y >= 0.0 ? y - x * (double)((int)(y / x)) : y + x * (double)((int)(-y / x) + 1);
        return ret;
    }

    public static float getDistanceBetweenPoints(LatLonPoint p1, LatLonPoint p2) {
        double lat1 = p1.getRadLat();
        double lon1 = p1.getRadLon();
        double lat2 = p2.getRadLat();
        double lon2 = p2.getRadLon();
        double d = 0.0;
        double tc = 0.0;
        double dlon_W = RhumbCalculator.mod(lon2 - lon1, Math.PI * 2);
        double dlon_E = RhumbCalculator.mod(lon1 - lon2, Math.PI * 2);
        tc = RhumbCalculator.getAzimuthBetweenPoints(p1, p2);
        d = Math.abs(lat1 - lat2) < Math.sqrt(1.0E-14) ? Math.min(dlon_W, dlon_E) * Math.cos(lat1) : Math.abs((lat2 - lat1) / Math.cos(tc));
        float dist = (float)(d * 10800.0 / Math.PI * 1855.3);
        return dist;
    }

    public static float getAzimuthBetweenPoints(LatLonPoint p1, LatLonPoint p2) {
        double lat1 = p1.getRadLat();
        double lon1 = p1.getRadLon();
        double lat2 = p2.getRadLat();
        double lon2 = p2.getRadLon();
        double tc = 0.0;
        double dlon_W = RhumbCalculator.mod(lon2 - lon1, Math.PI * 2);
        double dlon_E = RhumbCalculator.mod(lon1 - lon2, Math.PI * 2);
        double dphi = Math.log((1.0 + Math.sin(lat2)) / Math.cos(lat2)) - Math.log((1.0 + Math.sin(lat1)) / Math.cos(lat1));
        tc = dlon_W < dlon_E ? RhumbCalculator.mod(Math.atan2(-dlon_W, dphi), Math.PI * 2) : RhumbCalculator.mod(Math.atan2(dlon_E, dphi), Math.PI * 2);
        return (float)tc;
    }
}

