/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.proj;

import com.bbn.openmap.proj.BasicProjectionLoader;
import com.bbn.openmap.proj.Cartesian;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.proj.ProjectionException;
import com.bbn.openmap.proj.ProjectionLoader;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.awt.geom.Point2D;
import java.util.Properties;

public class CartesianLoader
extends BasicProjectionLoader
implements ProjectionLoader {
    public static final String TopLimitProperty = "topLimit";
    public static final String BottomLimitProperty = "bottomLimit";
    public static final String RightLimitProperty = "rightLimit";
    public static final String LeftLimitProperty = "leftLimit";
    public static final String AnchorXProperty = "anchorX";
    public static final String AnchorYProperty = "anchorY";
    protected double leftLimit = Double.NEGATIVE_INFINITY;
    protected double rightLimit = Double.POSITIVE_INFINITY;
    protected double topLimit = Double.POSITIVE_INFINITY;
    protected double bottomLimit = Double.NEGATIVE_INFINITY;
    protected Point2D limitAnchorPoint;

    public CartesianLoader() {
        super(Cartesian.class, "Cartesian", "Cartesian projection for displaying projected data.");
    }

    public Projection create(Properties props) throws ProjectionException {
        try {
            Point2D center = (Point2D)props.get("CENTER");
            float scale = PropUtils.floatFromProperties(props, "SCALE", 1.0E7f);
            int height = PropUtils.intFromProperties(props, "HEIGHT", 100);
            int width = PropUtils.intFromProperties(props, "WIDTH", 100);
            Cartesian proj = new Cartesian(center, scale, width, height);
            proj.setLimits(this.topLimit, this.bottomLimit, this.leftLimit, this.rightLimit, this.limitAnchorPoint);
            return proj;
        }
        catch (Exception e) {
            if (Debug.debugging("proj")) {
                Debug.output("CartesianLoader: problem creating Cartesian projection " + e.getMessage());
            }
            throw new ProjectionException("CartesianLoader: problem creating Cartesian projection");
        }
    }

    public void setProperties(String prefix, Properties props) {
        super.setProperties(prefix, props);
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.leftLimit = PropUtils.doubleFromProperties(props, prefix + LeftLimitProperty, Double.NEGATIVE_INFINITY);
        this.rightLimit = PropUtils.doubleFromProperties(props, prefix + RightLimitProperty, Double.POSITIVE_INFINITY);
        this.topLimit = PropUtils.doubleFromProperties(props, prefix + TopLimitProperty, Double.POSITIVE_INFINITY);
        this.bottomLimit = PropUtils.doubleFromProperties(props, prefix + BottomLimitProperty, Double.NEGATIVE_INFINITY);
        double x = PropUtils.doubleFromProperties(props, prefix + AnchorXProperty, Double.POSITIVE_INFINITY);
        double y = PropUtils.doubleFromProperties(props, prefix + AnchorYProperty, Double.POSITIVE_INFINITY);
        if (x != Double.POSITIVE_INFINITY && y != Double.POSITIVE_INFINITY) {
            this.limitAnchorPoint = new Point2D.Double(x, y);
        }
    }

    public Properties getProperties(Properties props) {
        props = super.getProperties(props);
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        String x = "";
        String y = "";
        String top = "";
        String bottom = "";
        String left = "";
        String right = "";
        if (this.leftLimit != Double.NEGATIVE_INFINITY) {
            left = Double.toString(this.leftLimit);
        }
        if (this.topLimit != Double.POSITIVE_INFINITY) {
            top = Double.toString(this.topLimit);
        }
        if (this.rightLimit != Double.POSITIVE_INFINITY) {
            right = Double.toString(this.rightLimit);
        }
        if (this.bottomLimit != Double.NEGATIVE_INFINITY) {
            bottom = Double.toString(this.bottomLimit);
        }
        props.put(prefix + TopLimitProperty, top);
        props.put(prefix + BottomLimitProperty, bottom);
        props.put(prefix + RightLimitProperty, right);
        props.put(prefix + LeftLimitProperty, left);
        if (this.limitAnchorPoint != null) {
            x = Double.toString(this.limitAnchorPoint.getX());
            y = Double.toString(this.limitAnchorPoint.getY());
        }
        props.put(prefix + AnchorXProperty, x);
        props.put(prefix + AnchorYProperty, y);
        return props;
    }

    public Properties getPropertyInfo(Properties props) {
        props = super.getPropertyInfo(props);
        PropUtils.setI18NPropertyInfo(this.i18n, props, CartesianLoader.class, LeftLimitProperty, "Left Limit", "Coordinate limit for the left side of the map.", null);
        PropUtils.setI18NPropertyInfo(this.i18n, props, CartesianLoader.class, RightLimitProperty, "Right Limit", "Coordinate limit for the right side of the map.", null);
        PropUtils.setI18NPropertyInfo(this.i18n, props, CartesianLoader.class, TopLimitProperty, "Top Limit", "Coordinate limit for the top of the map.", null);
        PropUtils.setI18NPropertyInfo(this.i18n, props, CartesianLoader.class, BottomLimitProperty, "Bottom Limit", "Coordinate limit for the bottom of the map.", null);
        PropUtils.setI18NPropertyInfo(this.i18n, props, CartesianLoader.class, AnchorXProperty, "Anchor X", "Horizontal Coordinate for anchor point, used to hold projection against limits.", null);
        PropUtils.setI18NPropertyInfo(this.i18n, props, CartesianLoader.class, AnchorYProperty, "Anchor Y", "Horizontal Coordinate for anchor point, used to hold projection against limits.", null);
        props.put("initProperties", "prettyName description topLimit bottomLimit rightLimit leftLimit anchorX anchorY");
        return props;
    }

    public double getBottomLimit() {
        return this.bottomLimit;
    }

    public void setBottomLimit(double bottomLimit) {
        this.bottomLimit = bottomLimit;
    }

    public double getLeftLimit() {
        return this.leftLimit;
    }

    public void setLeftLimit(double leftLimit) {
        this.leftLimit = leftLimit;
    }

    public Point2D getLimitAnchorPoint() {
        return this.limitAnchorPoint;
    }

    public void setLimitAnchorPoint(Point2D limitAnchorPoint) {
        this.limitAnchorPoint = limitAnchorPoint;
    }

    public double getRightLimit() {
        return this.rightLimit;
    }

    public void setRightLimit(double rightLimit) {
        this.rightLimit = rightLimit;
    }

    public double getTopLimit() {
        return this.topLimit;
    }

    public void setTopLimit(double topLimit) {
        this.topLimit = topLimit;
    }
}

