/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics.awt;

import com.bbn.openmap.omGraphics.awt.ShapeDecoration;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;

public abstract class AbstractShapeDecoration
implements ShapeDecoration {
    private float width;
    private float length;
    private int orientation;
    private Stroke stroke;
    private Paint paint;
    private Stroke saveStroke;
    private Paint savePaint;

    public AbstractShapeDecoration(float length, float width, int orientation) {
        this.length = length;
        this.width = width;
        this.orientation = orientation;
    }

    public float getLength() {
        return this.length;
    }

    public void setLength(float length) {
        this.length = length;
    }

    public float getWidth() {
        return this.width;
    }

    public void setWidth(float width) {
        this.width = width;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
    }

    public void revert() {
        this.orientation = this.orientation == 1 ? 2 : 1;
    }

    public Paint getPaint() {
        return this.paint;
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public void setPaint(Paint paint) {
        this.paint = paint;
    }

    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
    }

    protected void setGraphics(Graphics g) {
        Graphics2D g2D = (Graphics2D)g;
        this.saveStroke = g2D.getStroke();
        this.savePaint = g2D.getPaint();
        if (this.stroke != null) {
            g2D.setStroke(this.stroke);
        }
        if (this.paint != null) {
            g2D.setPaint(this.paint);
        }
    }

    protected void restoreGraphics(Graphics g) {
        Graphics2D g2D = (Graphics2D)g;
        g2D.setStroke(this.saveStroke);
        g2D.setPaint(this.savePaint);
    }
}

