/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics;

import com.bbn.openmap.omGraphics.OMGeometry;
import com.bbn.openmap.omGraphics.OMGeometryList;
import com.bbn.openmap.omGraphics.OMList;
import com.bbn.openmap.proj.Projection;
import java.awt.geom.GeneralPath;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OMAreaList
extends OMGeometryList
implements Serializable {
    public OMAreaList() {
        super(10);
        this.init();
    }

    public OMAreaList(int initialCapacity) {
        super(initialCapacity);
        this.init();
    }

    public OMAreaList(List<OMGeometry> list) {
        this.addAll((Collection<? extends OMGeometry>)list);
        this.init();
    }

    protected void init() {
        this.setVague(true);
        this.setTraverseMode(0);
        this.setConnectParts(true);
    }

    @Override
    public synchronized boolean generate(Projection p, boolean forceProjectAll) {
        boolean isGenerated = super.generate(p, forceProjectAll);
        if (this.shape != null) {
            this.shape.closePath();
        }
        return isGenerated;
    }

    @Override
    protected void updateShape(OMGeometry geometry, Projection p, boolean forceProject) {
        if (forceProject) {
            geometry.generate(p);
        } else {
            geometry.regenerate(p);
        }
        if (geometry.isVisible()) {
            GeneralPath gp = geometry.getShape();
            if (gp == null) {
                return;
            }
            this.setShape(OMAreaList.appendShapeEdge(this.shape, gp, this.connectParts));
            geometry.setShape(null);
        }
    }

    @Override
    public synchronized OMList.OMDist<OMGeometry> findClosest(double x, double y, float limit, boolean resetSelect) {
        OMList.OMDist<OMGeometry> omd = new OMList.OMDist<OMGeometry>();
        float currentDistance = Float.MAX_VALUE;
        if (!this.isVisible()) {
            omd.omg = null;
        } else {
            if (resetSelect) {
                this.deselect();
            }
            currentDistance = this._distance(x, y);
        }
        if (currentDistance < limit) {
            omd.omg = this;
            omd.d = currentDistance;
        }
        return omd;
    }
}

