/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.location.db;

import com.bbn.openmap.layer.location.AbstractLocationHandler;
import com.bbn.openmap.layer.location.ByteRasterLocation;
import com.bbn.openmap.layer.location.Location;
import com.bbn.openmap.layer.location.LocationCBMenuItem;
import com.bbn.openmap.layer.location.LocationHandler;
import com.bbn.openmap.layer.location.LocationMenuItem;
import com.bbn.openmap.layer.location.db.LocationData;
import com.bbn.openmap.layer.location.db.RawDataRecordSet;
import com.bbn.openmap.layer.location.db.RecordSet;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.util.PropUtils;
import com.bbn.openmap.util.quadtree.QuadTree;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBLocationHandler
extends AbstractLocationHandler
implements LocationHandler,
ActionListener {
    protected QuadTree quadtree = null;
    protected String jdbcString = null;
    public static final String jdbcStringProperty = "jdbcString";
    protected String jdbcDriver = null;
    public static final String jdbcDriverProperty = "jdbcDriver";
    protected String userName = null;
    protected String userPassword = null;
    public static final String userNameProperty = "userName";
    public static final String userPasswordProperty = "userPassword";
    public static final String locationQueryStringProperty = "locationQueryString";
    protected String locationQueryString = null;
    protected Properties props;
    protected Box box = null;

    @Override
    public void setProperties(String prefix, Properties properties) {
        super.setProperties(prefix, properties);
        prefix = this.getPropertyPrefix();
        prefix = prefix != null ? prefix + "." : "";
        this.props = properties;
        this.jdbcString = properties.getProperty(prefix + jdbcStringProperty);
        this.jdbcDriver = properties.getProperty(prefix + jdbcDriverProperty);
        this.userName = properties.getProperty(prefix + userNameProperty);
        this.userPassword = properties.getProperty(prefix + userPasswordProperty);
        this.locationQueryString = properties.getProperty(prefix + locationQueryStringProperty);
    }

    @Override
    public Properties getProperties(Properties props) {
        props = super.getProperties(props);
        String prefix = this.getPropertyPrefix();
        prefix = prefix != null ? prefix + "." : "";
        props.put(prefix + "class", this.getClass().getName());
        props.put(prefix + jdbcStringProperty, PropUtils.unnull(this.jdbcString));
        props.put(prefix + jdbcDriverProperty, PropUtils.unnull(this.jdbcDriver));
        props.put(prefix + userNameProperty, PropUtils.unnull(this.userName));
        props.put(prefix + userPasswordProperty, PropUtils.unnull(this.userPassword));
        props.put(prefix + locationQueryStringProperty, PropUtils.unnull(this.locationQueryString));
        props.put(prefix + "rawDataTableName", PropUtils.unnull(props.getProperty(prefix + "rawDataTableName")));
        props.put(prefix + "rawDataColumnName", PropUtils.unnull(props.getProperty(prefix + "rawDataColumnName")));
        props.put(prefix + "rawDataKeyColumnName", PropUtils.unnull(props.getProperty(prefix + "rawDataKeyColumnName")));
        return props;
    }

    @Override
    public Properties getPropertyInfo(Properties list) {
        list = super.getPropertyInfo(list);
        list.put("class.editor", "com.bbn.openmap.util.propertyEditor.NonEditablePropertyEditor");
        list.put(jdbcStringProperty, "JDBC login string");
        list.put(jdbcDriverProperty, "JDBC driver class name");
        list.put(userNameProperty, "User name");
        list.put(userPasswordProperty, "User password");
        list.put(locationQueryStringProperty, "Select statement that the data object needs.");
        list.put("rawDataTableName", "The name of the table in the database that holds the images.");
        list.put("rawDataColumnName", "The name of the column in the table in the database that holds the name (key) of the image.");
        list.put("rawDataKeyColumnName", "The name of the column in the table in the database that holds the raw image bytes.");
        return list;
    }

    @Override
    public void reloadData() {
        this.quadtree = this.createData();
    }

    protected QuadTree createData() {
        QuadTree qt = new QuadTree(90.0f, -180.0f, -90.0f, 180.0f, 100, 50.0f);
        if (this.locationQueryString == null) {
            return qt;
        }
        try {
            if (this.jdbcDriver != null) {
                Class.forName(this.getJdbcDriver());
            }
            Connection connection = DriverManager.getConnection(this.getJdbcString(), this.getUserName(), this.getUserPassword());
            RawDataRecordSet gifdataRS = new RawDataRecordSet(connection, this.getPropertyPrefix(), this.props);
            RecordSet locationdataRS = new RecordSet(connection, this.locationQueryString);
            while (locationdataRS.next()) {
                LocationData ld = new LocationData(locationdataRS);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("DBLocationHandler:  location information:\n" + ld);
                }
                byte[] bytearr = gifdataRS.getRawData(ld.getGraphicName());
                float lat = ld.getLatitude();
                float lon = ld.getLongitude();
                ByteRasterLocation loc = new ByteRasterLocation((double)lat, (double)lon, ld.getCityName(), bytearr);
                loc.setLocationHandler(this);
                loc.setShowName(this.isShowNames());
                loc.setShowLocation(this.isShowLocations());
                loc.setLocationPaint(this.getLocationColor());
                loc.getLabel().setLinePaint(this.getNameColor());
                loc.setDetails(ld.getCityName() + " is at lat: " + lat + ", lon: " + lon);
                qt.put(lat, lon, loc);
            }
            locationdataRS.close();
            connection.close();
        }
        catch (SQLException sqlE) {
            logger.warning("DBLocationHandler:SQL Exception: " + sqlE.getMessage());
            sqlE.printStackTrace();
        }
        catch (ClassNotFoundException cnfE) {
            logger.warning("DBLocationHandler: Class not found Exception: " + cnfE);
        }
        return qt;
    }

    public String getJdbcString() {
        return this.jdbcString;
    }

    public String getJdbcDriver() {
        return this.jdbcDriver;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getUserPassword() {
        return this.userPassword;
    }

    public Properties getLocationProperties() {
        return this.props;
    }

    @Override
    public OMGraphicList get(float nwLat, float nwLon, float seLat, float seLon, OMGraphicList graphicList) {
        if (graphicList == null) {
            graphicList = new OMGraphicList();
            graphicList.setTraverseMode(1);
        }
        if (this.quadtree == null) {
            logger.fine("DBLocationHandler: Figuring out the locations and names! (This is a one-time operation!)");
            this.quadtree = this.createData();
        }
        if (this.quadtree != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("DBLocationHandler|DBLocationHandler.get() ul.lon = " + nwLon + " lr.lon = " + seLon + " delta = " + (seLon - nwLon));
            }
            Vector vec = new Vector();
            this.quadtree.get(nwLat, nwLon, seLat, seLon, vec);
            graphicList.addAll(vec);
        }
        return graphicList;
    }

    @Override
    public List<Component> getItemsForPopupMenu(Location loc) {
        ArrayList<Component> menuItems = new ArrayList<Component>();
        menuItems.add(new LocationCBMenuItem("Always Show Name", loc));
        menuItems.add(new LocationMenuItem("Show Details", loc));
        return menuItems;
    }

    @Override
    public Component getGUI() {
        if (this.box == null) {
            JCheckBox showDBLocationCheck = new JCheckBox("Show Locations", this.isShowLocations());
            showDBLocationCheck.setActionCommand("showLocations");
            showDBLocationCheck.addActionListener(this);
            JCheckBox showNameCheck = new JCheckBox("Show Location Names", this.isShowNames());
            showNameCheck.setActionCommand("showNames");
            showNameCheck.addActionListener(this);
            JButton rereadFilesButton = new JButton("Reload Data From Source");
            rereadFilesButton.setActionCommand("readData");
            rereadFilesButton.addActionListener(this);
            this.box = Box.createVerticalBox();
            this.box.add(showDBLocationCheck);
            this.box.add(showNameCheck);
            this.box.add(rereadFilesButton);
        }
        return this.box;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd == "showLocations") {
            JCheckBox locationCheck = (JCheckBox)e.getSource();
            this.setShowLocations(locationCheck.isSelected());
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("DBLocationHandler::actionPerformed showLocations is " + this.isShowLocations());
            }
            this.getLayer().repaint();
        } else if (cmd == "showNames") {
            JCheckBox namesCheck = (JCheckBox)e.getSource();
            this.setShowNames(namesCheck.isSelected());
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("DBLocationHandler::actionPerformed showNames is " + this.isShowNames());
            }
            this.getLayer().repaint();
        } else if (cmd == "readData") {
            logger.fine("DBLocationHandler: Re-reading Locations file");
            this.quadtree = null;
            this.getLayer().doPrepare();
        } else {
            logger.warning("DBLocationHandler: Unknown action command \"" + cmd + "\" in actionPerformed().");
        }
    }
}

