/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.gui;

import com.bbn.openmap.MouseDelegator;
import com.bbn.openmap.event.MapMouseMode;
import com.bbn.openmap.gui.OMToolComponent;
import com.bbn.openmap.util.Debug;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class MouseModePanel
extends OMToolComponent
implements Serializable,
ActionListener,
PropertyChangeListener {
    public static final transient String mouseModeCmd = "setMouseMode";
    public static final transient String newMouseModeCmd = "newMouseMode";
    public static final transient String defaultKey = "mousemodepanel";
    protected transient JButton titleButton;
    protected transient JPopupMenu rbs = null;
    protected transient MouseDelegator mouseDelegator;
    protected transient TitledBorder border = null;
    protected transient Dimension dim;

    public MouseModePanel() {
        this.setKey(defaultKey);
    }

    public MouseModePanel(MouseDelegator md) {
        this();
        this.setMouseDelegator(md);
    }

    public void setMouseDelegator(MouseDelegator md) {
        if (this.mouseDelegator != null) {
            this.mouseDelegator.removePropertyChangeListener(this);
            this.setPanel(null);
        }
        this.mouseDelegator = md;
        this.setLayout(new BoxLayout(this, 0));
        if (this.mouseDelegator == null) {
            return;
        }
        this.mouseDelegator.addPropertyChangeListener(this);
        this.setPanel(this.mouseDelegator);
    }

    public MouseDelegator getMouseDelegator() {
        return this.mouseDelegator;
    }

    protected void setPanel(MouseDelegator md) {
        if (this.titleButton != null) {
            this.remove(this.titleButton);
        }
        this.titleButton = new JButton();
        this.titleButton.addActionListener(this);
        String activeMode = md.getActiveMouseModeID();
        MapMouseMode[] modes = md.getMouseModes();
        this.rbs = new JPopupMenu("Mouse Modes");
        this.dim = this.titleButton.getMinimumSize();
        for (int i = 0; i < modes.length; ++i) {
            JMenuItem rb = new JMenuItem(modes[i].getPrettyName());
            rb.addActionListener(new MouseModeButtonListener(modes[i].getID(), this));
            rb.setBorderPainted(false);
            if (Debug.debugging("mousemode")) {
                Debug.output("MouseModePanel.setPanel(): Adding " + modes[i].getID() + " mode to menu with label: " + rb.getName());
            }
            if (activeMode.equals(modes[i].getID())) {
                if (Debug.debugging("mousemode")) {
                    Debug.output("MouseModePanel.setPanel: Setting " + activeMode + " to active");
                }
                rb.setSelected(true);
                this.titleButton.setText(modes[i].getPrettyName());
            }
            this.rbs.add(rb);
            rb.setVisible(modes[i].isVisible());
        }
        this.setMinimumSize(this.dim);
        if (modes.length > 0) {
            this.border = new TitledBorder(new EtchedBorder(), "Mouse Mode");
            this.setBorder(this.border);
        }
        this.titleButton.setActionCommand(mouseModeCmd);
        this.titleButton.setBorderPainted(false);
        this.add(this.titleButton);
        this.setPreferredSize(new Dimension(140, 45));
        this.revalidate();
    }

    public void actionPerformed(ActionEvent e) {
        if (this.mouseDelegator == null) {
            return;
        }
        String command = e.getActionCommand();
        if (command.equals(mouseModeCmd)) {
            Point loc = this.titleButton.getLocation(new Point(0, 0));
            this.rbs.show(this.titleButton, loc.x, loc.y);
        } else if (command.equals(newMouseModeCmd)) {
            JMenuItem rb = (JMenuItem)e.getSource();
            if (Debug.debugging("mousemode")) {
                Debug.output("MouseModePanel.actionPerformed: " + rb.getName());
            }
            this.mouseDelegator.setActiveMouseModeWithID(rb.getName());
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName() == "NewActiveMouseMode") {
            String mmID = ((MapMouseMode)evt.getNewValue()).getPrettyName();
            if (Debug.debugging("mousemode")) {
                Debug.output("propertyChange: action mode property " + mmID);
            }
            this.titleButton.setText(mmID);
        } else if (evt.getPropertyName() == "NewListOfMouseModes") {
            Debug.message("mousemode", "propertyChange: mouse modes property");
            this.rbs.removeAll();
            this.setPanel(this.mouseDelegator);
        }
    }

    public void findAndInit(Object someObj) {
        if (someObj instanceof MouseDelegator) {
            Debug.message(defaultKey, "MouseModePanel found a MouseDelegator.");
            this.setMouseDelegator((MouseDelegator)someObj);
        }
    }

    public void findAndUndo(Object someObj) {
        if (someObj instanceof MouseDelegator) {
            Debug.message(defaultKey, "MouseModePanel removing MouseDelegator.");
            if (someObj == this.getMouseDelegator()) {
                this.setMouseDelegator(null);
            }
        }
    }

    public static class MouseModeButtonListener
    implements ActionListener {
        String mmid = null;
        MouseModePanel mouseModePanel = null;

        public MouseModeButtonListener(String id, MouseModePanel mmp) {
            this.mmid = id;
            this.mouseModePanel = mmp;
        }

        public void actionPerformed(ActionEvent ae) {
            MouseDelegator md;
            if (this.mouseModePanel != null && (md = this.mouseModePanel.getMouseDelegator()) != null) {
                md.setActiveMouseModeWithID(this.mmid);
            }
        }
    }
}

