/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.gui;

import com.bbn.openmap.Layer;
import com.bbn.openmap.LayerHandler;
import com.bbn.openmap.event.LayerEvent;
import com.bbn.openmap.event.LayerListener;
import com.bbn.openmap.gui.AbstractOpenMapMenu;
import com.bbn.openmap.gui.LayerAddPanel;
import com.bbn.openmap.gui.LayersPanel;
import com.bbn.openmap.util.Debug;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyVetoException;
import java.io.Serializable;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;

public class LayersMenu
extends AbstractOpenMapMenu
implements Serializable,
LayerListener {
    public static final transient int LAYERS_ON_OFF = 1;
    public static final transient int PALETTES_ON_OFF = 2;
    protected int menuType = -1;
    protected transient LayerHandler layerHandler;
    protected transient LayersPanel layersPanel;
    protected transient JMenuItem edit = null;
    public static final String defaultEditLayersButtonTitle = "Edit Layers...";
    protected transient String editLayersButtonTitle = "Edit Layers...";
    protected transient JMenuItem add = null;
    protected transient String addLayersButtonTitle = "Add Layers...";

    public LayersMenu() {
        this((LayerHandler)null);
    }

    public LayersMenu(LayerHandler lHandler) {
        this(lHandler, "Layers", 1);
    }

    public LayersMenu(LayerHandler lHandler, String menuName, int menuType) {
        this.menuType = menuType;
        this.setText(menuName);
        this.layerHandler = lHandler;
        if (this.layerHandler != null) {
            this.setLayers(this.layerHandler.getLayers());
        }
    }

    public void setLayerHandler(LayerHandler lh) {
        if (this.layerHandler != null) {
            this.layerHandler.removeLayerListener(this);
        }
        this.layerHandler = lh;
        if (this.layerHandler != null) {
            this.layerHandler.addLayerListener(this);
        } else {
            this.setLayers(new Layer[0]);
        }
    }

    public LayerHandler getLayerHandler() {
        return this.layerHandler;
    }

    protected void setLayersPanel(LayersPanel lp) {
        this.layersPanel = lp;
    }

    protected LayersPanel getLayersPanel() {
        return this.layersPanel;
    }

    public void setEditLayersButtonTitle(String buttonTitle) {
        this.editLayersButtonTitle = buttonTitle;
    }

    public String getEditLayersButtonTitle() {
        return this.editLayersButtonTitle;
    }

    public void setEdit(JMenuItem e) {
        this.edit = e;
        if (this.getLayerHandler() != null) {
            this.setLayers(this.getLayerHandler().getLayers());
        }
    }

    public void setAdd(JMenuItem a) {
        this.add = a;
        if (this.getLayerHandler() != null) {
            this.setLayers(this.getLayerHandler().getLayers());
        }
    }

    public JMenuItem getEdit() {
        return this.edit;
    }

    public void setLayers(LayerEvent evt) {
        Layer[] layers = evt.getLayers();
        int type = evt.getType();
        if (type == 403) {
            this.setLayers(layers);
        }
    }

    public void setLayers(Layer[] inLayers) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.setLayersFromEDT(inLayers);
        } else {
            SwingUtilities.invokeLater(new MyWorker(inLayers));
        }
    }

    protected void setLayersFromEDT(Layer[] inLayers) {
        this.removeAll();
        if (inLayers == null) {
            if (Debug.debugging("layersmenu")) {
                Debug.error("LayersMenu.setLayers(): Layers are null.");
            }
        } else {
            for (int i = 0; i < inLayers.length; ++i) {
                LayerCheckBoxMenuItem cbs = new LayerCheckBoxMenuItem(inLayers[i]);
                this.add(cbs);
            }
        }
        if (this.edit != null) {
            this.add(new JSeparator());
            this.add(this.edit);
        }
        if (this.add != null) {
            this.add(this.add);
        }
    }

    public void removeAll() {
        Component[] components = this.getMenuComponents();
        if (components.length > 0) {
            Debug.message("layersmenu", "LayersMenu.removeAll(): purging menu");
        }
        for (int i = 0; i < components.length; ++i) {
            if (!(components[i] instanceof LayerCheckBoxMenuItem)) continue;
            ((LayerCheckBoxMenuItem)components[i]).cleanup();
        }
        super.removeAll();
    }

    public synchronized void updateLayerLabels() {
        if (this.layerHandler != null) {
            this.setLayers(this.layerHandler.getLayers());
        }
    }

    public void setupEditLayersButton(LayersPanel lp) {
        JMenuItem button = new JMenuItem(this.i18n.get(LayersMenu.class, "editLayersButtonTitle", this.editLayersButtonTitle));
        button.setActionCommand("edit");
        button.addActionListener(lp.getActionListener());
        this.setEdit(button);
        this.setLayersPanel(lp);
    }

    public void setupLayerAddButton(LayerAddPanel menu) {
        LayerAddPanel lap = menu;
        JMenuItem button = new JMenuItem(this.i18n.get(LayersMenu.class, "addLayersButtonTitle", this.addLayersButtonTitle));
        button.setActionCommand("add");
        button.addActionListener(lap);
        this.setAdd(button);
        this.add(button);
    }

    public void findAndInit(Object someObj) {
        if (someObj instanceof LayerHandler) {
            Debug.message("bc", "LayersMenu found a LayerHandler");
            this.setLayerHandler((LayerHandler)someObj);
        } else if (someObj instanceof LayersPanel) {
            this.setupEditLayersButton((LayersPanel)someObj);
        } else if (someObj instanceof LayerAddPanel) {
            this.setupLayerAddButton((LayerAddPanel)someObj);
        }
    }

    public void findAndUndo(Object someObj) {
        if (someObj instanceof LayerHandler) {
            LayerHandler lh = (LayerHandler)someObj;
            if (lh != this.getLayerHandler()) {
                Debug.message("bc", "LayersMenu asked to remove LayerHandler that is not the same as what is currently held - ignoring request.");
                return;
            }
            Debug.message("bc", "LayersMenu.childrenRemoved: removing LayerHandler");
            this.setLayerHandler(null);
            this.setEdit(null);
        }
        if (someObj instanceof LayersPanel) {
            LayersPanel lp = (LayersPanel)someObj;
            if (lp != this.getLayersPanel()) {
                Debug.message("bc", "LayersMenu asked to remove LayersPanel that is not the same as what is currently held - ignoring request.");
                return;
            }
            Debug.message("bc", "LayersMenu.childrenRemoved: removing LayersPanel");
            this.setLayersPanel(null);
            this.setEdit(null);
        }
    }

    public void fireVetoableChange(String name, Object oldValue, Object newValue) throws PropertyVetoException {
        super.fireVetoableChange(name, oldValue, newValue);
        this.beanContextChildSupport.fireVetoableChange(name, oldValue, newValue);
    }

    class MyWorker
    implements Runnable {
        private Layer[] layers;

        public MyWorker(Layer[] inLayers) {
            this.layers = (Layer[])inLayers.clone();
        }

        public void run() {
            try {
                LayersMenu.this.setLayersFromEDT(this.layers);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    class LayerCheckBoxMenuItem
    extends JCheckBoxMenuItem
    implements ActionListener,
    ComponentListener {
        Layer layer;

        LayerCheckBoxMenuItem(Layer aLayer) {
            if (aLayer == null) {
                throw new IllegalArgumentException("null Layer");
            }
            this.layer = aLayer;
            this.setText(this.layer.getName());
            this.setState(this.layer.isVisible());
            this.addActionListener(this);
            this.layer.addComponentListener(this);
        }

        public Layer getLayer() {
            return this.layer;
        }

        public void cleanup() {
            this.layer.removeComponentListener(this);
            this.removeActionListener(this);
            this.layer = null;
        }

        protected void showPalette() {
            this.layer.showPalette();
        }

        protected void hidePalette() {
            this.layer.hidePalette();
        }

        public void componentResized(ComponentEvent e) {
        }

        public void componentMoved(ComponentEvent e) {
        }

        public void componentShown(ComponentEvent e) {
            if (e.getComponent() == this.layer) {
                if (!this.getState() && LayersMenu.this.menuType == 1) {
                    this.setState(true);
                    if (Debug.debugging("layersmenu")) {
                        Debug.output("layersmenu.LCBMI: layer " + this.layer.getName() + " is now visible.");
                    }
                }
            } else if (e.getComponent() == this.layer.getPalette() && LayersMenu.this.menuType == 2) {
                this.setState(true);
            }
        }

        public void componentHidden(ComponentEvent e) {
            if (e.getComponent() == this.layer) {
                if (this.getState() && LayersMenu.this.menuType == 1) {
                    this.setState(false);
                    if (Debug.debugging("layersmenu")) {
                        Debug.output("layersmenu.LCBMI: layer " + this.layer.getName() + " is now hidden.");
                    }
                }
            } else if (e.getComponent() == this.layer.getPalette() && LayersMenu.this.menuType == 2) {
                this.setState(false);
            }
        }

        public void actionPerformed(ActionEvent e) {
            if (!this.equals(e.getSource())) {
                Debug.error("Wiring is hopelessly wrong in LayersMenu");
            }
            switch (LayersMenu.this.menuType) {
                case 1: {
                    LayersMenu.this.layerHandler.turnLayerOn(this.getState(), this.layer);
                    break;
                }
                case 2: {
                    if (this.getState()) {
                        this.showPalette();
                        break;
                    }
                    this.hidePalette();
                    break;
                }
                default: {
                    System.err.println("LayersMenu: unknown menuType!");
                }
            }
        }
    }
}

