/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.dataAccess.shape;

import com.bbn.openmap.OMComponent;
import com.bbn.openmap.dataAccess.shape.DbfTableModel;
import com.bbn.openmap.dataAccess.shape.ShapeConstants;
import com.bbn.openmap.io.FormatException;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.util.PropUtils;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbfTableModelFactory
extends OMComponent
implements ShapeConstants {
    public static Logger logger = Logger.getLogger("com.bbn.openmap.dataAccess.shape.DbfTableModelFactory");
    public static final String ColumnsProperty = "columns";
    public static final String DefinitionProperty = "definition";
    public static final String DefaultValueProperty = "default";
    protected ArrayList<Column> columns;

    public void setColumns(ArrayList<Column> cols) {
        this.columns = cols;
    }

    public ArrayList<Column> getColumns() {
        return this.columns;
    }

    @Override
    public void setProperties(String prefix, Properties props) {
        super.setProperties(prefix, props);
        logger.fine("parsing properties");
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        String markerList = props.getProperty(prefix + ColumnsProperty);
        Vector<String> colStrings = PropUtils.parseSpacedMarkers(markerList);
        this.columns = new ArrayList(colStrings.size());
        for (String colString : colStrings) {
            String colDef = props.getProperty(prefix + colString + "." + DefinitionProperty);
            if (colDef == null) continue;
            try {
                Column col = new Column(colDef);
                col.setDefaultValue(props.getProperty(prefix + colString + "." + DefaultValueProperty, ""));
                this.columns.add(col);
                logger.fine("parsed: " + col);
            }
            catch (FormatException fe) {
                logger.warning("For column: " + colString + ", def: " + colDef + ": " + fe.getMessage());
            }
        }
    }

    @Override
    public Properties getProperties(Properties props) {
        props = super.getProperties(props);
        return props;
    }

    @Override
    public Properties getPropertyInfo(Properties props) {
        props = super.getPropertyInfo(props);
        return props;
    }

    public DbfTableModel createDbfTableModel() {
        DbfTableModel dbf = null;
        if (this.columns != null) {
            dbf = new DbfTableModel(this.getNumColumns());
            int i = 0;
            for (Column col : this.columns) {
                dbf.setColumnName(i, col.name);
                dbf.setDecimalCount(i, col.decimalCount);
                dbf.setLength(i, col.length);
                dbf.setType(i, col.type);
                ++i;
            }
        }
        return dbf;
    }

    public ArrayList<Object> getNewDefaultRow() {
        ArrayList<Object> row = new ArrayList<Object>(this.getNumColumns());
        if (this.columns != null) {
            for (Column col : this.columns) {
                row.add(col.defaultValue);
            }
        }
        return row;
    }

    public int getNumColumns() {
        return this.columns != null ? this.columns.size() : 0;
    }

    public DbfTableModel createDbf(OMGraphicList omgl) {
        DbfTableModel dbf = this.createDbfTableModel();
        if (dbf != null) {
            omgl.putAttribute("DBF_ATTRIBUTE", dbf);
            for (int i = 0; i < omgl.size(); ++i) {
                dbf.addRecord(this.getNewDefaultRow());
            }
        }
        return dbf;
    }

    public class Column {
        protected String name;
        protected byte type;
        protected byte decimalCount;
        protected int length;
        protected Object defaultValue;

        public Column(String definition) throws FormatException {
            StringTokenizer tok = new StringTokenizer(definition, ",");
            try {
                this.name = tok.nextToken().trim();
                this.type = (byte)tok.nextToken().trim().toUpperCase().charAt(0);
                if (!DbfTableModel.isValidType(this.type)) {
                    throw new FormatException("Type is not valid: " + this.type);
                }
                this.length = Integer.parseInt(tok.nextToken().trim());
                if (DbfTableModel.isNumericalType(this.type)) {
                    this.decimalCount = Byte.parseByte(tok.nextToken().trim());
                }
            }
            catch (Exception e) {
                throw new FormatException(e.getMessage());
            }
        }

        public Column(String n, byte t, byte dc, int l, Object dv) {
            this.name = n;
            this.type = t;
            this.decimalCount = dc;
            this.length = l;
            this.defaultValue = dv;
        }

        public String getName() {
            return this.name;
        }

        public byte getType() {
            return this.type;
        }

        public byte getDecimalCount() {
            return this.decimalCount;
        }

        public int getLength() {
            return this.length;
        }

        public void setDefaultValue(String defaultVal) {
            if (DbfTableModel.isNumericalType(this.type)) {
                try {
                    this.defaultValue = new Double(defaultVal);
                }
                catch (NumberFormatException nfe) {
                    logger.warning("can't parse default value for " + this.name + ", setting to 0");
                    this.defaultValue = new Double(0.0);
                }
            } else {
                this.defaultValue = defaultVal;
            }
        }

        public Object getDefaultValue() {
            return this.defaultValue;
        }

        public String toString() {
            return this.name + "," + (char)this.type + "," + this.length + (DbfTableModel.isNumericalType(this.type) ? "," + this.decimalCount : "") + ", dv: " + this.defaultValue;
        }
    }
}

