/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap;

public class MoreMath {
    public static final transient float TWO_PI = (float)Math.PI * 2;
    public static final transient double TWO_PI_D = Math.PI * 2;
    public static final transient float HALF_PI = 1.5707964f;
    public static final transient double HALF_PI_D = 1.5707963267948966;

    private MoreMath() {
    }

    public static final boolean approximately_equal(double a, double b, double epsilon) {
        return Math.abs(a - b) <= epsilon;
    }

    public static final boolean approximately_equal(float a, float b, float epsilon) {
        return Math.abs(a - b) <= epsilon;
    }

    public static final float asinh(float x) {
        return (float)Math.log((double)x + Math.sqrt(x * x + 1.0f));
    }

    public static final double asinh(double x) {
        return Math.log(x + Math.sqrt(x * x + 1.0));
    }

    public static final float sinh(float x) {
        return (float)(Math.pow(Math.E, x) - Math.pow(Math.E, -x)) / 2.0f;
    }

    public static final double sinh(double x) {
        return (Math.pow(Math.E, x) - Math.pow(Math.E, -x)) / 2.0;
    }

    public static final int sign(short x) {
        return x < 0 ? -1 : 1;
    }

    public static final int sign(int x) {
        return x < 0 ? -1 : 1;
    }

    public static final int sign(long x) {
        return x < 0L ? -1 : 1;
    }

    public static final int sign(float x) {
        return x < 0.0f ? -1 : 1;
    }

    public static final int sign(double x) {
        return x < 0.0 ? -1 : 1;
    }

    public static final boolean odd(short x) {
        return !MoreMath.even(x);
    }

    public static final boolean odd(int x) {
        return !MoreMath.even(x);
    }

    public static final boolean odd(long x) {
        return !MoreMath.even(x);
    }

    public static final boolean even(short x) {
        return (x & 1) == 0;
    }

    public static final boolean even(int x) {
        return (x & 1) == 0;
    }

    public static final boolean even(long x) {
        return (x & 1L) == 0L;
    }

    public static final int signedToInt(byte b) {
        return b & 0xFF;
    }

    public static final int signedToInt(short w) {
        return w & 0xFFFF;
    }

    public static final long signedToLong(int x) {
        return (long)x & 0xFFFFFFFFL;
    }

    public static final int wordToByte(int w) {
        return w >> 8;
    }

    public static final short BuildShortBE(byte[] bytevec, int offset) {
        return (short)(bytevec[0 + offset] << 8 | MoreMath.signedToInt(bytevec[1 + offset]));
    }

    public static final short BuildShortLE(byte[] bytevec, int offset) {
        return (short)(bytevec[1 + offset] << 8 | MoreMath.signedToInt(bytevec[0 + offset]));
    }

    public static final short BuildShort(byte[] bytevec, int offset, boolean MSBFirst) {
        if (MSBFirst) {
            return MoreMath.BuildShortBE(bytevec, offset);
        }
        return MoreMath.BuildShortLE(bytevec, offset);
    }

    public static final short BuildShortBE(byte[] bytevec, boolean MSBFirst) {
        return MoreMath.BuildShortBE(bytevec, 0);
    }

    public static final short BuildShortLE(byte[] bytevec, boolean MSBFirst) {
        return MoreMath.BuildShortLE(bytevec, 0);
    }

    public static final short BuildShort(byte[] bytevec, boolean MSBFirst) {
        return MoreMath.BuildShort(bytevec, 0, MSBFirst);
    }

    public static final int BuildIntegerBE(byte[] bytevec, int offset) {
        return bytevec[0 + offset] << 24 | MoreMath.signedToInt(bytevec[1 + offset]) << 16 | MoreMath.signedToInt(bytevec[2 + offset]) << 8 | MoreMath.signedToInt(bytevec[3 + offset]);
    }

    public static final int BuildIntegerLE(byte[] bytevec, int offset) {
        return bytevec[3 + offset] << 24 | MoreMath.signedToInt(bytevec[2 + offset]) << 16 | MoreMath.signedToInt(bytevec[1 + offset]) << 8 | MoreMath.signedToInt(bytevec[0 + offset]);
    }

    public static final int BuildInteger(byte[] bytevec, int offset, boolean MSBFirst) {
        if (MSBFirst) {
            return MoreMath.BuildIntegerBE(bytevec, offset);
        }
        return MoreMath.BuildIntegerLE(bytevec, offset);
    }

    public static final int BuildIntegerBE(byte[] bytevec) {
        return MoreMath.BuildIntegerBE(bytevec, 0);
    }

    public static final int BuildIntegerLE(byte[] bytevec) {
        return MoreMath.BuildIntegerLE(bytevec, 0);
    }

    public static final int BuildInteger(byte[] bytevec, boolean MSBFirst) {
        if (MSBFirst) {
            return MoreMath.BuildIntegerBE(bytevec, 0);
        }
        return MoreMath.BuildIntegerLE(bytevec, 0);
    }

    public static final long BuildLongBE(byte[] bytevec, int offset) {
        return (long)MoreMath.signedToInt(bytevec[0 + offset]) << 56 | (long)MoreMath.signedToInt(bytevec[1 + offset]) << 48 | (long)MoreMath.signedToInt(bytevec[2 + offset]) << 40 | (long)MoreMath.signedToInt(bytevec[3 + offset]) << 32 | (long)MoreMath.signedToInt(bytevec[4 + offset]) << 24 | (long)MoreMath.signedToInt(bytevec[5 + offset]) << 16 | (long)MoreMath.signedToInt(bytevec[6 + offset]) << 8 | (long)MoreMath.signedToInt(bytevec[7 + offset]);
    }

    public static final long BuildLongLE(byte[] bytevec, int offset) {
        return (long)MoreMath.signedToInt(bytevec[7 + offset]) << 56 | (long)MoreMath.signedToInt(bytevec[6 + offset]) << 48 | (long)MoreMath.signedToInt(bytevec[5 + offset]) << 40 | (long)MoreMath.signedToInt(bytevec[4 + offset]) << 32 | (long)MoreMath.signedToInt(bytevec[3 + offset]) << 24 | (long)MoreMath.signedToInt(bytevec[2 + offset]) << 16 | (long)MoreMath.signedToInt(bytevec[1 + offset]) << 8 | (long)MoreMath.signedToInt(bytevec[0 + offset]);
    }

    public static final long BuildLong(byte[] bytevec, int offset, boolean MSBFirst) {
        if (MSBFirst) {
            return MoreMath.BuildLongBE(bytevec, offset);
        }
        return MoreMath.BuildLongLE(bytevec, offset);
    }

    public static final long BuildLongBE(byte[] bytevec) {
        return MoreMath.BuildLongBE(bytevec, 0);
    }

    public static final long BuildLongLE(byte[] bytevec) {
        return MoreMath.BuildLongLE(bytevec, 0);
    }

    public static final long BuildLong(byte[] bytevec, boolean MSBFirst) {
        if (MSBFirst) {
            return MoreMath.BuildLongBE(bytevec, 0);
        }
        return MoreMath.BuildLongLE(bytevec, 0);
    }
}

