/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.time;

import com.bbn.openmap.PropertyConsumer;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimerRateHolder
implements PropertyConsumer,
Serializable {
    public static final String DEFAULT_PACE_BASELINE_VALUE = "00:00:00";
    public static final String DEFAULT_PACE_FORMAT = "HH:mm:ss";
    public static final String TimerRatesProperty = "timerRates";
    public static final String PaceFormatProperty = "paceFormat";
    public static final String PaceBaselineProperty = "paceBaseline";
    public static final String ClockIntervalProperty = "clockIntervalMillis";
    public static final String PaceProperty = "pace";
    protected String label;
    protected long clockInterval;
    protected long pace;
    protected SimpleDateFormat paceFormat;
    protected String paceZero;
    protected boolean valid = false;
    protected String propPrefix;

    public TimerRateHolder() {
        this.paceFormat = new SimpleDateFormat(DEFAULT_PACE_FORMAT);
        this.paceZero = DEFAULT_PACE_BASELINE_VALUE;
    }

    public TimerRateHolder(SimpleDateFormat simpleDateFormat, String dpz) {
        this.paceFormat = simpleDateFormat;
        this.paceZero = dpz;
    }

    public void setLabel(String lab) {
        this.label = lab;
    }

    public String getLabel() {
        return this.label;
    }

    public void setPace(long pace) {
        this.pace = pace;
    }

    public long getPace() {
        return this.pace;
    }

    public void setClockInterval(long cli) {
        this.clockInterval = cli;
    }

    public long getClockInterval() {
        return this.clockInterval;
    }

    public String toString() {
        return "TimePanel.TimerRateHolder [" + this.label + ", clock:" + this.clockInterval + ", pace:" + this.pace + "] (" + this.valid + ")";
    }

    @Override
    public void setProperties(Properties props) {
        this.setProperties(null, props);
    }

    @Override
    public void setProperties(String prefix, Properties props) {
        this.propPrefix = prefix;
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        try {
            this.label = props.getProperty(prefix + "prettyName");
            this.clockInterval = PropUtils.longFromProperties(props, prefix + ClockIntervalProperty, -1L);
            String paceString = props.getProperty(prefix + PaceProperty);
            this.pace = this.paceFormat.parse(paceString).getTime() - this.paceFormat.parse(this.paceZero).getTime();
            this.valid = true;
        }
        catch (NullPointerException npe) {
            Debug.error("TimerRateHolder caught NPE: " + npe.getMessage());
        }
        catch (ParseException pe) {
            Debug.error("TimerRateHolder parse exception: " + pe.getMessage());
        }
    }

    @Override
    public Properties getProperties(Properties props) {
        return props;
    }

    @Override
    public Properties getPropertyInfo(Properties props) {
        return props;
    }

    @Override
    public String getPropertyPrefix() {
        return this.propPrefix;
    }

    @Override
    public void setPropertyPrefix(String p) {
        this.propPrefix = p;
    }

    public static List<TimerRateHolder> getTimerRateHolders(String prefix, Properties properties) {
        String timerRatesString;
        LinkedList<TimerRateHolder> timerRateHolders = new LinkedList<TimerRateHolder>();
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        String paceFormatString = properties.getProperty(prefix + PaceFormatProperty, DEFAULT_PACE_FORMAT);
        String paceBaselineString = properties.getProperty(prefix + PaceBaselineProperty, DEFAULT_PACE_BASELINE_VALUE);
        SimpleDateFormat paceFormat = new SimpleDateFormat(paceFormatString);
        if (Debug.debugging("timerrateholder")) {
            Debug.output("TimerRateHolder timer rate pace pattern: " + paceFormatString);
        }
        if ((timerRatesString = properties.getProperty(prefix + TimerRatesProperty)) != null) {
            if (Debug.debugging("timerrateholder")) {
                Debug.output("TimerRateHolder reading timer rates: " + timerRatesString);
            }
            Vector<String> rates = PropUtils.parseSpacedMarkers(timerRatesString);
            for (String ratePrefix : rates) {
                TimerRateHolder trh = new TimerRateHolder(paceFormat, paceBaselineString);
                trh.setProperties(prefix + ratePrefix, properties);
                if (trh.valid) {
                    timerRateHolders.add(trh);
                    if (!Debug.debugging("timerrateholder")) continue;
                    Debug.output("TimerRateHolder adding " + trh);
                    continue;
                }
                if (!Debug.debugging("timerrateholder")) continue;
                Debug.output("TimerRateHolder NOT adding " + ratePrefix);
            }
        }
        return timerRateHolders;
    }
}

