/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.proj.coords;

import com.bbn.openmap.proj.ProjMath;
import com.bbn.openmap.proj.coords.LatLonPoint;

public class NedFrame {
    protected float x;
    protected float y;
    protected float z;

    public NedFrame() {
        this.x = 0.0f;
        this.y = 0.0f;
        this.z = 0.0f;
    }

    public NedFrame(float x, float y, float z, double lat, double lon) {
        double[] ecef = new double[3];
        double[] ned = new double[3];
        double latitude = ProjMath.degToRad(lat);
        double longitude = ProjMath.degToRad(lon);
        ecef[0] = x;
        ecef[1] = y;
        ecef[2] = z;
        this.ecef2ned(ned, latitude, longitude, ecef);
        this.x = (float)ned[0];
        this.y = (float)ned[1];
        this.z = (float)ned[2];
    }

    public NedFrame(double[] ecefVector, LatLonPoint llpt) {
        double[] ecef = new double[3];
        double[] ned = new double[3];
        double lat_ = llpt.getY();
        double lon_ = llpt.getX();
        double latitude = ProjMath.degToRad(lat_);
        double longitude = ProjMath.degToRad(lon_);
        ecef[0] = ecefVector[0];
        ecef[1] = ecefVector[1];
        ecef[2] = ecefVector[2];
        this.ecef2ned(ned, latitude, longitude, ecef);
        this.x = (float)ned[0];
        this.y = (float)ned[1];
        this.z = (float)ned[2];
    }

    public double[] toGeocentricFrame(LatLonPoint llpt) {
        double[] ecef = new double[3];
        double[] ned = new double[3];
        double lat_ = llpt.getY();
        double lon_ = llpt.getX();
        double latitude = ProjMath.degToRad(lat_);
        double longitude = ProjMath.degToRad(lon_);
        this.ned2ecef(ned, latitude, longitude, ecef);
        return ecef;
    }

    public void ecef2ned(double[] ned, double latitude, double longitude, double[] ecef) {
        double[][] temp = new double[3][3];
        double clat = Math.cos(latitude);
        double clon = Math.cos(longitude);
        double slat = Math.sin(latitude);
        double slon = Math.sin(longitude);
        temp[0][0] = -slat * clon;
        temp[0][1] = -slat * slon;
        temp[0][2] = clat;
        temp[1][0] = -slon;
        temp[1][1] = clon;
        temp[1][2] = 0.0;
        temp[2][0] = -clat * clon;
        temp[2][1] = -clat * slon;
        temp[2][2] = -slat;
        for (int j = 0; j < 3; ++j) {
            ned[j] = 0.0;
            for (int i = 0; i < 3; ++i) {
                int n = j;
                ned[n] = ned[n] + temp[j][i] * ecef[i];
            }
        }
    }

    public void ned2ecef(double[] ned, double latitude, double longitude, double[] ecef) {
        double[][] temp = new double[3][3];
        double clat = Math.cos(latitude);
        double clon = Math.cos(longitude);
        double slat = Math.sin(latitude);
        double slon = Math.sin(longitude);
        ned[0] = this.x;
        ned[1] = this.y;
        ned[2] = this.z;
        temp[0][0] = -slat * clon;
        temp[1][0] = -slat * slon;
        temp[2][0] = clat;
        temp[0][1] = -slon;
        temp[1][1] = clon;
        temp[2][1] = 0.0;
        temp[0][2] = -clat * clon;
        temp[1][2] = -clat * slon;
        temp[2][2] = -slat;
        for (int j = 0; j < 3; ++j) {
            ecef[j] = 0.0;
            for (int i = 0; i < 3; ++i) {
                int n = j;
                ecef[n] = ecef[n] + temp[j][i] * ned[i];
            }
        }
    }

    public NedFrame(NedFrame nedpt) {
        this.x = nedpt.x;
        this.y = nedpt.y;
        this.z = nedpt.z;
    }

    public String toString() {
        return "NedFrame[N=" + this.x + ",E=" + this.y + ",D=" + this.z + "]";
    }

    public void setX(float pX) {
        this.x = pX;
    }

    public void setY(float pY) {
        this.y = pY;
    }

    public void setZ(float pZ) {
        this.z = pZ;
    }

    public void setXYZ(float v1, float v2, float v3) {
        this.x = v1;
        this.y = v2;
        this.z = v3;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getZ() {
        return this.z;
    }

    public double toSpeed() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public double toHeading() {
        double radians = Math.atan2(this.y, this.x);
        double degrees = Math.toDegrees(radians);
        if (degrees < 0.0) {
            degrees += degrees + 360.0;
        }
        return degrees;
    }
}

