/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.proj;

import com.bbn.openmap.MoreMath;
import com.bbn.openmap.proj.Azimuth;
import com.bbn.openmap.proj.GreatCircle;
import com.bbn.openmap.proj.ProjMath;
import com.bbn.openmap.proj.coords.LatLonPoint;
import com.bbn.openmap.util.Debug;
import java.awt.Graphics;
import java.awt.geom.Point2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Gnomonic
extends Azimuth {
    public static final transient String GnomonicName = "Gnomonic";
    protected double hy;
    protected double wx;
    protected double cosCtrLat;
    protected double sinCtrLat;
    public static final transient double epsilon = 1.0E-4;
    public static final transient double HEMISPHERE_EDGE = 1.3962634015954636;
    public static final transient double hPrime = 1.0 / Math.pow(Math.cos(1.3962634015954636), 2.0);
    protected static final float NORTH_BOUNDARY = 1.5706964f;
    protected static final float SOUTH_BOUNDARY = -1.5706964f;

    public Gnomonic(LatLonPoint center, float scale, int width, int height) {
        super(center, scale, width, height);
        this.setMinScale(1000.0f);
    }

    @Override
    public String toString() {
        return "Gnomonic[" + super.toString();
    }

    @Override
    protected void init() {
        super.init();
        this.minscale = (float)Math.ceil(2.0 * hPrime * this.planetPixelRadius / 2.147483647E9);
        if (this.minscale < 1.0) {
            this.minscale = 1.0;
        }
        this.XSCALE_THRESHOLD = (int)(this.planetPixelRadius * 2.0 * hPrime / 64000.0);
    }

    @Override
    protected void computeParameters() {
        Debug.message("proj", "Gnomonic.computeParameters()");
        super.computeParameters();
        double d = this.maxscale = this.width < this.height ? (double)((float)(this.planetPixelRadius * 2.0 * hPrime) / (float)this.width) : (double)((float)(this.planetPixelRadius * 2.0 * hPrime) / (float)this.height);
        if (this.maxscale < this.minscale) {
            this.maxscale = this.minscale;
        }
        if (this.scale > this.maxscale) {
            this.scale = this.maxscale;
        }
        this.scaled_radius = this.planetPixelRadius / this.scale;
        this.world.x = (int)(this.planetPixelRadius * 2.0 * hPrime / this.scale);
        this.cosCtrLat = Math.cos(this.centerY);
        this.sinCtrLat = Math.sin(this.centerY);
        this.hy = this.height / 2;
        this.wx = this.width / 2;
    }

    @Override
    public void drawBackground(Graphics g) {
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    @Override
    public double normalizeLatitude(double lat) {
        if (lat > 1.5706963539123535) {
            return 1.5706963539123535;
        }
        if (lat < -1.5706963539123535) {
            return -1.5706963539123535;
        }
        return lat;
    }

    public static final float hemisphere_distance(float phi1, float lambda0, float phi, float lambda) {
        return GreatCircle.sphericalDistance(phi1, lambda0, phi, lambda);
    }

    public static final double hemisphere_distance(double phi1, double lambda0, double phi, double lambda) {
        return GreatCircle.sphericalDistance(phi1, lambda0, phi, lambda);
    }

    public static final boolean hemisphere_clip(float phi1, float lambda0, float phi, float lambda) {
        return (double)GreatCircle.sphericalDistance(phi1, lambda0, phi, lambda) <= 1.3962634015954636;
    }

    public static final boolean hemisphere_clip(double phi1, double lambda0, double phi, double lambda) {
        return GreatCircle.sphericalDistance(phi1, lambda0, phi, lambda) <= 1.3962634015954636;
    }

    private Point2D edge_point(Point2D p, double current_azimuth) {
        double c = 1.3962634015954636;
        LatLonPoint tmpll = GreatCircle.sphericalBetween(this.centerY, this.centerX, c, current_azimuth);
        double phi = tmpll.getRadLat();
        double lambda = tmpll.getRadLon();
        double kPrime = 1.0 / Math.cos(c);
        double cosPhi = Math.cos(phi);
        double sinPhi = Math.sin(phi);
        double lambdaMinusCtrLon = lambda - this.centerX;
        double cosLambdaMinusCtrLon = Math.cos(lambdaMinusCtrLon);
        double sinLambdaMinusCtrLon = Math.sin(lambdaMinusCtrLon);
        double x = this.scaled_radius * kPrime * cosPhi * sinLambdaMinusCtrLon + this.wx;
        double y = this.hy - this.scaled_radius * kPrime * (this.cosCtrLat * sinPhi - this.sinCtrLat * cosPhi * cosLambdaMinusCtrLon);
        p.setLocation(x, y);
        return p;
    }

    @Override
    public boolean isPlotable(double lat, double lon) {
        lat = this.normalizeLatitude(ProjMath.degToRad(lat));
        lon = Gnomonic.wrapLongitude(ProjMath.degToRad(lon));
        return Gnomonic.hemisphere_clip(this.centerY, this.centerX, lat, lon);
    }

    protected Point2D _forward(float phi, float lambda, Point2D p, Azimuth.AzimuthVar azVar) {
        return this._forward((double)phi, (double)lambda, p, azVar);
    }

    @Override
    protected Point2D _forward(double phi, double lambda, Point2D p, Azimuth.AzimuthVar azVar) {
        double c = Gnomonic.hemisphere_distance(this.centerY, this.centerX, phi, lambda);
        if (c > 1.3962634015954636) {
            double az = GreatCircle.sphericalAzimuth(this.centerY, this.centerX, phi, lambda);
            if (azVar != null) {
                azVar.invalid_forward = true;
                azVar.current_azimuth = (float)az;
            }
            return this.edge_point(p, az);
        }
        double kPrime = 1.0 / Math.cos(c);
        double cosPhi = Math.cos(phi);
        double sinPhi = Math.sin(phi);
        double lambdaMinusCtrLon = lambda - this.centerX;
        double cosLambdaMinusCtrLon = Math.cos(lambdaMinusCtrLon);
        double sinLambdaMinusCtrLon = Math.sin(lambdaMinusCtrLon);
        double x = this.scaled_radius * kPrime * cosPhi * sinLambdaMinusCtrLon + this.wx;
        double y = this.hy - this.scaled_radius * kPrime * (this.cosCtrLat * sinPhi - this.sinCtrLat * cosPhi * cosLambdaMinusCtrLon);
        p.setLocation(x, y);
        return p;
    }

    @Override
    public <T extends Point2D> T inverse(double x, double y, T llp) {
        double rho;
        if (llp == null) {
            llp = new LatLonPoint.Double();
        }
        if ((rho = Math.sqrt((x -= this.wx) * x + (y = this.hy - y) * y)) == 0.0) {
            Debug.message("proj", "Gnomonic.inverse: center!");
            ((Point2D)llp).setLocation(ProjMath.radToDeg(this.centerX), ProjMath.radToDeg(this.centerY));
            return (T)llp;
        }
        double c = Math.atan2(rho, this.scaled_radius);
        double cosC = Math.cos(c);
        double sinC = Math.sin(c);
        double lat = Math.asin(cosC * this.sinCtrLat + y * sinC * (this.cosCtrLat / rho));
        double lon = this.centerX + Math.atan2(x * sinC, rho * this.cosCtrLat * cosC - y * this.sinCtrLat * sinC);
        if (Double.isNaN(lat) || Double.isNaN(lon)) {
            Debug.message("proj", "Gnomonic.inverse(): outer space!");
            lat = this.centerY;
            lon = this.centerX;
        }
        ((Point2D)llp).setLocation(Math.toDegrees(Gnomonic.wrapLongitude(lon)), Math.toDegrees(this.normalizeLatitude(lat)));
        return (T)llp;
    }

    public boolean overEquator() {
        LatLonPoint.Float llN = new LatLonPoint.Float();
        this.inverse(this.width / 2, 0.0, llN);
        LatLonPoint.Float llS = new LatLonPoint.Float();
        this.inverse(this.width / 2, this.height, llS);
        return MoreMath.sign(((Point2D)llN).getY()) != MoreMath.sign(((Point2D)llS).getY());
    }

    @Override
    public LatLonPoint getUpperLeft() {
        double lon;
        double lat;
        LatLonPoint.Double tmp = new LatLonPoint.Double();
        if (this.overNorthPole()) {
            lat = 1.5707963705062866;
            lon = -3.1415927410125732;
        } else if (this.overSouthPole()) {
            lon = -3.1415927410125732;
            if (this.overEquator()) {
                this.inverse(this.width / 2, 0.0, tmp);
                lat = ((LatLonPoint)tmp).getRadLat();
            } else {
                this.inverse(0.0, 0.0, tmp);
                lat = ((LatLonPoint)tmp).getRadLat();
            }
        } else if (((LatLonPoint)tmp).getRadLat() >= 0.0) {
            this.inverse(0.0, 0.0, tmp);
            lon = ((LatLonPoint)tmp).getRadLon();
            this.inverse(this.width / 2, 0.0, tmp);
            lat = ((LatLonPoint)tmp).getRadLat();
        } else {
            this.inverse(0.0, this.height, tmp);
            lon = ((LatLonPoint)tmp).getRadLon();
            if (this.overEquator()) {
                this.inverse(this.width / 2, 0.0, tmp);
                lat = ((LatLonPoint)tmp).getRadLat();
            } else {
                this.inverse(0.0, 0.0, tmp);
                lat = ((LatLonPoint)tmp).getRadLat();
            }
        }
        ((LatLonPoint)tmp).setLatLon(lat, lon, true);
        return tmp;
    }

    @Override
    public LatLonPoint getLowerRight() {
        double lat;
        double lon;
        LatLonPoint.Double tmp = new LatLonPoint.Double();
        if (this.overNorthPole()) {
            lon = 3.1415927410125732;
            if (this.overEquator()) {
                this.inverse(this.width / 2, this.height, tmp);
                lat = ((LatLonPoint)tmp).getRadLat();
            } else {
                this.inverse(this.width, this.height, tmp);
                lat = ((LatLonPoint)tmp).getRadLat();
            }
        } else if (this.overSouthPole()) {
            lat = -1.5707963705062866;
            lon = 3.1415927410125732;
        } else if (((LatLonPoint)tmp).getRadLat() >= 0.0) {
            this.inverse(this.width, 0.0, tmp);
            lon = ((LatLonPoint)tmp).getRadLon();
            if (this.overEquator()) {
                this.inverse(this.width / 2, this.height, tmp);
                lat = ((LatLonPoint)tmp).getRadLat();
            } else {
                this.inverse(this.width, this.height, tmp);
                lat = ((LatLonPoint)tmp).getRadLat();
            }
        } else {
            this.inverse(this.width, this.height, tmp);
            lon = ((LatLonPoint)tmp).getRadLon();
            this.inverse(this.width / 2, this.height, tmp);
            lat = ((LatLonPoint)tmp).getRadLat();
        }
        ((LatLonPoint)tmp).setLatLon(lat, lon, true);
        return tmp;
    }

    @Override
    public String getName() {
        return GnomonicName;
    }
}

