/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics;

import com.bbn.openmap.omGraphics.OMAbstractLine;
import com.bbn.openmap.omGraphics.OMGeometry;
import com.bbn.openmap.omGraphics.geom.NonRegional;
import com.bbn.openmap.omGraphics.util.ArcCalc;
import com.bbn.openmap.proj.GeoProj;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.proj.coords.LatLonPoint;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.DeepCopyUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.ArrayList;

public class OMLine
extends OMAbstractLine
implements Serializable,
NonRegional {
    protected transient boolean isPolyline = false;
    protected double[] latlons = null;
    protected int[] pts = null;
    protected ArcCalc arc = null;
    public static final int STRAIGHT_LINE = 0;
    public static final int CURVED_LINE = 1;

    public OMLine() {
        super(0, 0, 0);
    }

    public OMLine(double lat_1, double lon_1, double lat_2, double lon_2, int lineType) {
        this(lat_1, lon_1, lat_2, lon_2, lineType, -1);
    }

    public OMLine(double lat_1, double lon_1, double lat_2, double lon_2, int lineType, int nsegs) {
        super(1, lineType, 0);
        this.latlons = new double[4];
        this.latlons[0] = lat_1;
        this.latlons[2] = lat_2;
        this.latlons[1] = lon_1;
        this.latlons[3] = lon_2;
        this.nsegs = nsegs;
    }

    public OMLine(int x1, int y1, int x2, int y2) {
        super(2, 1, 0);
        this.pts = new int[4];
        this.pts[0] = x1;
        this.pts[1] = y1;
        this.pts[2] = x2;
        this.pts[3] = y2;
    }

    public OMLine(double lat_1, double lon_1, int x1, int y1, int x2, int y2) {
        super(3, 1, 0);
        this.latlons = new double[4];
        this.pts = new int[4];
        this.latlons[0] = lat_1;
        this.latlons[1] = lon_1;
        this.pts[0] = x1;
        this.pts[1] = y1;
        this.pts[2] = x2;
        this.pts[3] = y2;
    }

    public void setLL(double[] lls) {
        this.latlons = lls;
        this.setNeedToRegenerate(true);
    }

    public double[] getLL() {
        return this.latlons;
    }

    public void setPts(int[] xys) {
        this.pts = xys;
        this.setNeedToRegenerate(true);
    }

    public int[] getPts() {
        return this.pts;
    }

    public boolean isPolyline() {
        return this.isPolyline;
    }

    public void setNumSegs(int nsegs) {
        this.nsegs = nsegs;
    }

    public int getNumSegs() {
        return this.nsegs;
    }

    public void setArc(ArcCalc ac) {
        this.arc = ac;
    }

    public ArcCalc getArc() {
        return this.arc;
    }

    public boolean generate(Projection proj) {
        this.setNeedToRegenerate(true);
        if (proj == null) {
            Debug.message("omgraphic", "OMLine: null projection in generate!");
            return false;
        }
        this.isPolyline = false;
        this.initLabelingDuringGenerate();
        GeneralPath projectedShape = null;
        switch (this.renderType) {
            case 2: {
                if (this.pts == null) {
                    return false;
                }
                if (this.arc != null) {
                    this.xpoints = new float[1][];
                    this.ypoints = new float[1][];
                    this.arc.generate(this.pts[0], this.pts[1], this.pts[2], this.pts[3]);
                    this.xpoints[0] = this.arc.getXPoints();
                    this.ypoints[0] = this.arc.getYPoints();
                } else {
                    this.xpoints = new float[1][2];
                    this.ypoints = new float[1][2];
                    this.xpoints[0][0] = this.pts[0];
                    this.ypoints[0][0] = this.pts[1];
                    this.xpoints[0][1] = this.pts[2];
                    this.ypoints[0][1] = this.pts[3];
                }
                projectedShape = OMLine.createShape(this.xpoints[0], this.ypoints[0], false);
                break;
            }
            case 3: {
                if (this.pts == null || this.latlons == null || !proj.isPlotable(this.latlons[0], this.latlons[1])) {
                    this.setNeedToRegenerate(true);
                    return false;
                }
                Point p1 = (Point)proj.forward(this.latlons[0], this.latlons[1], (Point2D)new Point());
                if (this.arc != null) {
                    this.xpoints = new float[1][];
                    this.ypoints = new float[1][];
                    this.arc.generate(p1.x + this.pts[0], p1.y + this.pts[1], p1.x + this.pts[2], p1.y + this.pts[3]);
                    this.xpoints[0] = this.arc.getXPoints();
                    this.ypoints[0] = this.arc.getYPoints();
                } else {
                    this.xpoints = new float[1][2];
                    this.ypoints = new float[1][2];
                    this.xpoints[0][0] = p1.x + this.pts[0];
                    this.ypoints[0][0] = p1.y + this.pts[1];
                    this.xpoints[0][1] = p1.x + this.pts[2];
                    this.ypoints[0][1] = p1.y + this.pts[3];
                }
                projectedShape = OMLine.createShape(this.xpoints[0], this.ypoints[0], false);
                break;
            }
            case 1: {
                if (this.latlons == null) {
                    this.setNeedToRegenerate(true);
                    return false;
                }
                if (this.arc != null) {
                    Point p1 = (Point)proj.forward(this.latlons[0], this.latlons[1], (Point2D)new Point());
                    Point p2 = (Point)proj.forward(this.latlons[2], this.latlons[3], (Point2D)new Point());
                    this.xpoints = new float[1][];
                    this.ypoints = new float[1][];
                    this.arc.generate(p1.x, p1.y, p2.x, p2.y);
                    this.xpoints[0] = this.arc.getXPoints();
                    this.ypoints[0] = this.arc.getYPoints();
                    projectedShape = OMLine.createShape(this.xpoints[0], this.ypoints[0], false);
                    this.isPolyline = true;
                    break;
                }
                ArrayList<float[]> lines = null;
                lines = proj instanceof GeoProj ? ((GeoProj)proj).forwardLine(new LatLonPoint.Double(this.latlons[0], this.latlons[1]), new LatLonPoint.Double(this.latlons[2], this.latlons[3]), this.lineType, this.nsegs) : proj.forwardLine(new Point2D.Double(this.latlons[1], this.latlons[0]), new Point2D.Double(this.latlons[3], this.latlons[2]));
                int size = lines.size();
                this.xpoints = new float[size / 2][0];
                this.ypoints = new float[this.xpoints.length][0];
                int i = 0;
                int j = 0;
                while (i < size) {
                    float[] xps = lines.get(i);
                    float[] yps = lines.get(i + 1);
                    this.xpoints[j] = xps;
                    this.ypoints[j] = yps;
                    GeneralPath gp = OMLine.createShape(xps, yps, false);
                    projectedShape = OMLine.appendShapeEdge(projectedShape, gp, false);
                    i += 2;
                    ++j;
                }
                this.isPolyline = this.lineType != 1;
                break;
            }
            case 0: {
                System.err.println("OMLine.generate: invalid RenderType");
                this.setNeedToRegenerate(true);
                return false;
            }
        }
        this.setShape(projectedShape);
        this.setLabelLocation(projectedShape);
        if (this.arrowhead != null) {
            this.arrowhead.generate(this);
        }
        if (this.arc != null) {
            this.arc.generate(proj);
        }
        this.setNeedToRegenerate(false);
        return true;
    }

    public void render(Graphics g) {
        if (!this.isRenderable(this.getShape())) {
            return;
        }
        if (this.arrowhead != null && this.isMatted() && g instanceof Graphics2D && this.stroke instanceof BasicStroke) {
            ((Graphics2D)g).setStroke(new BasicStroke(((BasicStroke)this.stroke).getLineWidth() + 2.0f));
            this.setGraphicsColor(g, Color.black);
            this.arrowhead.render(g);
        }
        super.render(g);
        if (this.arrowhead != null) {
            this.setGraphicsForEdge(g);
            this.arrowhead.render(g);
        }
        if (this.arc != null) {
            this.arc.render(g);
        }
    }

    public boolean shouldRenderFill() {
        return false;
    }

    public boolean contains(double x, double y) {
        if (this.shouldRenderFill()) {
            return super.contains(x, y);
        }
        return this.distance(x, y) == 0.0f;
    }

    public void restore(OMGeometry source) {
        super.restore(source);
        if (source instanceof OMLine) {
            OMLine line = (OMLine)source;
            this.latlons = DeepCopyUtil.deepCopy(line.latlons);
            this.pts = DeepCopyUtil.deepCopy(line.pts);
            this.arc = line.arc != null ? new ArcCalc(line.arc.getArcAngle(), line.arc.isArcUp()) : null;
        }
    }
}

