/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics;

import com.bbn.openmap.omGraphics.OMGeometry;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.grid.GridData;
import com.bbn.openmap.omGraphics.grid.OMGridData;
import com.bbn.openmap.omGraphics.grid.OMGridGenerator;
import com.bbn.openmap.omGraphics.grid.OMGridObjects;
import com.bbn.openmap.proj.Length;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.geom.Point2D;

public class OMGrid
extends OMGraphicList {
    protected double orientation;
    protected int rows;
    protected int columns;
    protected double latitude;
    protected double longitude;
    protected double verticalResolution;
    protected double horizontalResolution;
    public GridData data;
    protected OMGridObjects gridObjects = null;
    protected Point point = null;
    public Point point1 = null;
    public Point point2 = null;
    public int height = 0;
    public int width = 0;
    public static final int GRID_NULL = -32767;
    protected OMGridGenerator generator = null;
    public static final boolean COLUMN_MAJOR = true;
    public static final boolean ROW_MAJOR = false;
    protected boolean major = true;
    protected Length units = null;

    public OMGrid() {
    }

    public OMGrid(double lat, double lon, double vResolution, double hResolution, int[][] data) {
        this.setRenderType(1);
        this.set(lat, lon, 0, 0, vResolution, hResolution, data);
    }

    public OMGrid(int x, int y, double vResolution, double hResolution, int[][] data) {
        this.setRenderType(2);
        this.set(0.0, 0.0, x, y, vResolution, hResolution, data);
    }

    public OMGrid(double lat, double lon, int x, int y, double vResolution, double hResolution, int[][] data) {
        this.setRenderType(3);
        this.set(lat, lon, x, y, vResolution, hResolution, data);
    }

    public OMGrid(double lat, double lon, double vResolution, double hResolution, GridData data) {
        this.setRenderType(1);
        this.set(lat, lon, 0, 0, vResolution, hResolution, data);
    }

    public OMGrid(int x, int y, double vResolution, double hResolution, GridData data) {
        this.setRenderType(2);
        this.set(0.0, 0.0, x, y, vResolution, hResolution, data);
    }

    public OMGrid(double lat, double lon, int x, int y, double vResolution, double hResolution, GridData data) {
        this.setRenderType(3);
        this.set(lat, lon, x, y, vResolution, hResolution, data);
    }

    protected void set(double lat, double lon, int x, int y, double vResolution, double hResolution, int[][] data) {
        this.set(lat, lon, x, y, vResolution, hResolution, new OMGridData.Int(data));
    }

    protected void set(double lat, double lon, int x, int y, double vResolution, double hResolution, GridData data) {
        this.latitude = lat;
        this.longitude = lon;
        this.point = new Point(x, y);
        this.verticalResolution = vResolution;
        this.horizontalResolution = hResolution;
        this.setData(data);
    }

    public void setRows(int rows) {
    }

    public int getRows() {
        if (this.data != null) {
            return this.data.getNumRows();
        }
        return 0;
    }

    public void setLatitude(double lat) {
        if (this.latitude == lat) {
            return;
        }
        this.latitude = lat;
        this.setNeedToRegenerate(true);
    }

    public double getLatitude() {
        return this.latitude;
    }

    public void setLongitude(double lon) {
        if (this.longitude == lon) {
            return;
        }
        this.longitude = lon;
        this.setNeedToRegenerate(true);
    }

    public double getLongitude() {
        return this.longitude;
    }

    public Point getPoint() {
        return this.point;
    }

    public void setColumns(int columns) {
    }

    public int getColumns() {
        if (this.data != null) {
            return this.data.getNumColumns();
        }
        return 0;
    }

    public void setMajor(boolean maj) {
        if (this.data != null && maj != this.data.getMajor()) {
            this.data.setMajor(maj);
        }
    }

    public boolean getMajor() {
        if (this.data != null) {
            return this.data.getMajor();
        }
        return this.major;
    }

    public void setOrientation(double orient) {
        this.orientation = orient;
    }

    public double getOrientation() {
        return this.orientation;
    }

    public void setData(int[][] data) {
        this.setData(new OMGridData.Int(data));
    }

    public void setData(GridData data) {
        this.data = data;
    }

    public GridData getData() {
        return this.data;
    }

    public void setGridObjects(OMGridObjects someGridObjs) {
        this.gridObjects = someGridObjs;
    }

    public OMGridObjects getGridObjects() {
        return this.gridObjects;
    }

    public void setGenerator(OMGridGenerator aGenerator) {
        this.generator = aGenerator;
    }

    public OMGridGenerator getGenerator() {
        return this.generator;
    }

    public void setVerticalResolution(double vRes) {
        this.verticalResolution = vRes;
    }

    public double getVerticalResolution() {
        return this.verticalResolution;
    }

    public void setHorizontalResolution(double hRes) {
        this.horizontalResolution = hRes;
    }

    public double getHorizontalResolution() {
        return this.horizontalResolution;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setUnits(Length length) {
        this.units = length;
    }

    public Length getUnits() {
        return this.units;
    }

    public synchronized boolean generate(Projection proj) {
        int columns = this.getColumns();
        int rows = this.getRows();
        super.clear();
        this.setShape(null);
        if (this.renderType == 1) {
            double rightLon = this.longitude + (double)columns * this.horizontalResolution;
            double upLat = this.latitude + (double)rows * this.verticalResolution;
            this.point1 = (Point)proj.forward(upLat, this.longitude, (Point2D)new Point());
            this.point2 = (Point)proj.forward(this.latitude, rightLon, (Point2D)new Point());
            this.height = this.point2.y - this.point1.y;
            this.width = this.point2.x - this.point1.x;
            if (Debug.debugging("grid")) {
                Debug.output("OMGrid.generate:  height = " + this.height + ", width = " + this.width);
            }
        } else if (this.renderType == 2 || this.renderType == 3) {
            this.width = (int)Math.round((double)columns * this.horizontalResolution);
            this.height = (int)Math.round((double)rows * this.verticalResolution);
            if (this.renderType == 3) {
                double upLat = this.latitude + (double)columns * this.verticalResolution;
                this.point1 = (Point)proj.forward(upLat, this.longitude, (Point2D)new Point());
                this.point1.x += this.point.x;
                this.point1.y += this.point.y;
            } else {
                this.point1 = this.point;
            }
            this.point2 = new Point(this.point1.x + this.width, this.point1.y + this.height);
        } else {
            return false;
        }
        if (Debug.debugging("grid")) {
            Debug.output("OMGrid generated grid, at " + this.point1 + " and " + this.point2 + " with height " + this.height + " and width " + this.width);
        }
        this.setShape();
        if (this.generator != null && this.generator.needGenerateToRender()) {
            this.add(this.generator.generate(this, proj));
        } else if (this.gridObjects != null) {
            this.add(this.generateGridObjects(proj));
        }
        this.setNeedToRegenerate(false);
        return true;
    }

    public void setShape() {
        int w = this.width;
        int h = this.height;
        this.setShape(OMGrid.createBoxShape(this.point1.x, this.point1.y, w, h));
    }

    public void render(Graphics g) {
        if (this.generator != null && (this.needToRegenerate && this.generator.needGenerateToRender() || !this.isVisible())) {
            Debug.message("grid", "OMGrid: need to generate or is not visible!");
            return;
        }
        super.render(g);
    }

    public OMGraphic generateGridObjects(Projection proj) {
        OMGraphicList graphiclist = new OMGraphicList();
        GridData gd = this.getData();
        if (gd instanceof GridData.Int) {
            GridData.Int gdi = (GridData.Int)gd;
            Point pt = new Point();
            boolean major = gdi.getMajor();
            int[][] data = gdi.getData();
            for (int x = 0; x < data.length; ++x) {
                for (int y = 0; y < data[0].length; ++y) {
                    if (major) {
                        if (this.renderType == 1) {
                            pt = (Point)proj.forward(this.latitude + (double)y * this.verticalResolution, this.longitude + (double)x * this.horizontalResolution, (Point2D)pt);
                        } else {
                            pt.y = this.point1.y + (int)((double)y * this.verticalResolution);
                            pt.x = this.point1.x + (int)((double)x * this.horizontalResolution);
                        }
                    } else if (this.renderType == 1) {
                        pt = (Point)proj.forward(this.latitude + (double)x * this.verticalResolution, this.longitude + (double)y * this.horizontalResolution, (Point2D)pt);
                    } else {
                        pt.y = this.point1.y + (int)((double)x * this.verticalResolution);
                        pt.x = this.point1.x + (int)((double)y * this.horizontalResolution);
                    }
                    if (pt.x < 0 && pt.x > proj.getWidth() || pt.y < 0 && pt.y > proj.getHeight()) continue;
                    graphiclist.add(this.gridObjects.generate(data[x][y], proj));
                }
            }
        }
        return graphiclist;
    }

    public Object valueAt(double lat, double lon, Projection proj) {
        int lat_index = -1;
        int lon_index = -1;
        if (this.renderType == 1) {
            lat_index = (int)Math.round((lat - this.latitude) / this.verticalResolution);
            lon_index = (int)Math.round((lon - this.longitude) / this.horizontalResolution);
        } else if (this.renderType == 2 || this.renderType == 3) {
            if (this.getNeedToRegenerate()) {
                if (proj == null) {
                    return null;
                }
                this.generate(proj);
            }
            Point pt = (Point)proj.forward(lat, lon, (Point2D)new Point());
            lat_index = (int)Math.round((double)(pt.y - this.point1.y) / this.verticalResolution);
            lon_index = (int)Math.round((double)(pt.x - this.point1.x) / this.horizontalResolution);
        }
        GridData gd = this.getData();
        if (!(gd == null || lat_index < 0 && lat_index >= this.rows || lon_index < 0 && lon_index >= this.columns)) {
            Object obj = null;
            obj = this.major ? gd.get(lon_index, lat_index) : gd.get(lat_index, lon_index);
            return obj;
        }
        return null;
    }

    public int interpValueAt(double lat, double lon, Projection proj) {
        double lat_index = -1.0;
        double lon_index = -1.0;
        GridData gridData = this.getData();
        if (!(gridData instanceof GridData.Int)) {
            Debug.error("OMGrid.interpValueAt only works for integer data.");
            return 0;
        }
        int[][] data = ((GridData.Int)gridData).getData();
        boolean major = gridData.getMajor();
        if (this.renderType == 1) {
            lat_index = (lat - this.latitude) / this.verticalResolution;
            lon_index = (lon - this.longitude) / this.horizontalResolution;
        } else if (this.renderType == 2 || this.renderType == 3) {
            if (this.getNeedToRegenerate()) {
                if (proj == null) {
                    return -32767;
                }
                this.generate(proj);
            }
            Point pt = (Point)proj.forward(lat, lon, (Point2D)new Point());
            lat_index = (double)(pt.y - this.point1.y) / this.verticalResolution;
            lon_index = (double)(pt.x - this.point1.x) / this.horizontalResolution;
        }
        if ((lat_index >= 0.0 || lat_index < (double)this.rows) && (lon_index >= 0.0 || lon_index < (double)this.columns)) {
            int lr;
            int ll;
            int ur;
            int ul;
            int lflon_index = (int)Math.floor(lon_index);
            int lclon_index = (int)Math.ceil(lon_index);
            int lflat_index = (int)Math.floor(lat_index);
            int lclat_index = (int)Math.ceil(lat_index);
            if (Debug.debugging("grid")) {
                System.out.println("***Elevation Map***");
                for (int l = lclat_index + 5; l > lflat_index - 5; --l) {
                    System.out.println();
                    for (int k = lflon_index - 5; k < lclon_index + 5; ++k) {
                        if (l < 0 && l >= this.rows || k < 0 && k >= this.columns) continue;
                        if (major) {
                            System.out.print(data[k][l] + " ");
                            continue;
                        }
                        System.out.print(data[l][k] + " ");
                    }
                }
                System.out.println();
                System.out.println();
            }
            if (major) {
                ul = data[lflon_index][lclat_index];
                ur = data[lclon_index][lclat_index];
                ll = data[lflon_index][lclat_index];
                lr = data[lclon_index][lclat_index];
            } else {
                ul = data[lclat_index][lflon_index];
                ur = data[lclat_index][lclon_index];
                ll = data[lclat_index][lflon_index];
                lr = data[lclat_index][lclon_index];
            }
            double answer = this.resolve_four_points(ul, ur, lr, ll, lat_index, lon_index);
            return (int)Math.round(answer);
        }
        return -32767;
    }

    private double resolve_four_points(int ul, int ur, int lr, int ll, double lat_index, double lon_index) {
        double top_avg = (lon_index - (double)new Double(Math.floor(lon_index)).floatValue()) * (double)(ur - ul) + (double)ul;
        double bottom_avg = (lon_index - (double)new Double(Math.floor(lon_index)).floatValue()) * (double)(lr - ll) + (double)ll;
        double right_avg = (lat_index - (double)new Double(Math.floor(lat_index)).floatValue()) * (double)(ur - lr) + (double)lr;
        double left_avg = (lat_index - (double)new Double(Math.floor(lat_index)).floatValue()) * (double)(ul - ll) / 100.0 + (double)ll;
        double lon_avg = (lat_index - (double)new Double(Math.floor(lat_index)).floatValue()) * (top_avg - bottom_avg) + bottom_avg;
        double lat_avg = (lon_index - (double)new Double(Math.floor(lon_index)).floatValue()) * (right_avg - left_avg) + left_avg;
        double result = (lon_avg + lat_avg) / 2.0;
        return result;
    }

    public void restore(OMGeometry source) {
        super.restore(source);
        if (source instanceof OMGrid) {
            OMGrid grid = (OMGrid)source;
            this.orientation = grid.orientation;
            this.rows = grid.rows;
            this.columns = grid.columns;
            this.latitude = grid.latitude;
            this.longitude = grid.longitude;
            this.verticalResolution = grid.verticalResolution;
            this.horizontalResolution = grid.horizontalResolution;
            this.height = grid.height;
            this.width = grid.width;
            this.major = grid.major;
            this.units = grid.units;
            if (grid.data != null) {
                this.data = grid.data.deepCopy();
            }
            if (grid.point != null) {
                this.point = new Point(grid.point);
            }
            if (grid.point1 != null) {
                this.point1 = new Point(grid.point1);
            }
            if (grid.point2 != null) {
                this.point2 = new Point(grid.point2);
            }
            if (grid.gridObjects != null) {
                this.gridObjects = grid.gridObjects;
            }
            if (grid.generator != null) {
                this.generator = grid.generator;
            }
        }
    }
}

