/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics;

import com.bbn.openmap.omGraphics.OMGeometry;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicAdapter;
import com.bbn.openmap.proj.Cylindrical;
import com.bbn.openmap.proj.GeoProj;
import com.bbn.openmap.proj.Length;
import com.bbn.openmap.proj.ProjMath;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.proj.coords.LatLonPoint;
import com.bbn.openmap.util.Debug;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OMArc
extends OMGraphicAdapter
implements OMGraphic {
    protected double x1 = 0.0;
    protected double y1 = 0.0;
    protected double off_x = 0.0;
    protected double off_y = 0.0;
    protected Point2D center;
    protected double radius = 0.0;
    protected double width = 0.0;
    protected double height = 0.0;
    protected double start = 0.0;
    protected double extent = 360.0;
    protected int arcType = 0;
    private transient GeneralPath polarShapeLine = null;
    private transient boolean correctFill = false;
    private transient boolean correctPolar = false;
    protected int nverts;
    protected double rotationAngle = 0.0;

    public OMArc() {
        super(0, 0, 0);
    }

    public OMArc(double latPoint, double lonPoint, int w, int h, double s, double e) {
        this(latPoint, lonPoint, 0, 0, w, h, s, e);
    }

    public OMArc(int x1, int y1, int w, int h, double s, double e) {
        super(2, 0, 0);
        this.x1 = x1;
        this.y1 = y1;
        this.width = w;
        this.height = h;
        this.start = s;
        this.extent = e;
    }

    public OMArc(double latPoint, double lonPoint, int offset_x1, int offset_y1, int w, int h, double s, double e) {
        super(3, 0, 0);
        this.center = new LatLonPoint.Double(latPoint, lonPoint);
        this.off_x = offset_x1;
        this.off_y = offset_y1;
        this.width = w;
        this.height = h;
        this.start = s;
        this.extent = e;
    }

    public OMArc(double latPoint, double lonPoint, double radius, double s, double e) {
        this(new LatLonPoint.Double(latPoint, lonPoint), radius, Length.DECIMAL_DEGREE, -1, s, e);
    }

    public OMArc(double latPoint, double lonPoint, double radius, Length units, double s, double e) {
        this(new LatLonPoint.Double(latPoint, lonPoint), radius, units, -1, s, e);
    }

    public OMArc(double latPoint, double lonPoint, double radius, Length units, int nverts, double s, double e) {
        this(new LatLonPoint.Double(latPoint, lonPoint), radius, units, nverts, s, e);
    }

    public OMArc(LatLonPoint center, double radius, Length units, int nverts, double s, double e) {
        super(1, 0, 0);
        this.radius = units.toRadians(radius);
        this.center = center;
        this.nverts = nverts;
        this.start = s;
        this.extent = e;
    }

    public int getX() {
        return (int)this.x1;
    }

    public int getY() {
        return (int)this.y1;
    }

    public int getOffX() {
        return (int)this.off_x;
    }

    public int getOffY() {
        return (int)this.off_y;
    }

    public LatLonPoint getLatLon() {
        return LatLonPoint.getDouble(this.center);
    }

    public double getRadius() {
        return Length.DECIMAL_DEGREE.fromRadians(this.radius);
    }

    public int getWidth() {
        return (int)this.width;
    }

    public int getHeight() {
        return (int)this.height;
    }

    public double getStartAngle() {
        return this.start;
    }

    public double getExtentAngle() {
        return this.extent;
    }

    public int getNumVerts() {
        return this.nverts;
    }

    public void setX(int value) {
        if ((int)this.x1 == value) {
            return;
        }
        this.x1 = value;
        this.setNeedToRegenerate(true);
    }

    public void setY(int value) {
        if ((int)this.y1 == value) {
            return;
        }
        this.y1 = value;
        this.setNeedToRegenerate(true);
    }

    public void setOffX(int value) {
        if (this.off_x == (double)value) {
            return;
        }
        this.off_x = value;
        this.setNeedToRegenerate(true);
    }

    public void setOffY(int value) {
        if (this.off_y == (double)value) {
            return;
        }
        this.off_y = value;
        this.setNeedToRegenerate(true);
    }

    public void setLatLon(double lat, double lon) {
        this.setCenter(new LatLonPoint.Double(lat, lon));
    }

    public void setCenter(LatLonPoint p) {
        if (p.equals(this.center)) {
            return;
        }
        this.center = p;
        this.setNeedToRegenerate(true);
    }

    public Point2D getCenter() {
        return this.center;
    }

    public void setRadius(double radius) {
        this.radius = Length.DECIMAL_DEGREE.toRadians(radius);
        this.setNeedToRegenerate(true);
    }

    public void setRadius(double radius, Length units) {
        this.radius = units.toRadians(radius);
        this.setNeedToRegenerate(true);
    }

    public void setWidth(int value) {
        if (this.width == (double)value) {
            return;
        }
        this.width = value;
        this.setNeedToRegenerate(true);
    }

    public void setHeight(int value) {
        if (this.height == (double)value) {
            return;
        }
        this.height = value;
        this.setNeedToRegenerate(true);
    }

    public void setStart(double value) {
        if (this.start == value) {
            return;
        }
        this.start = value;
        this.setNeedToRegenerate(true);
    }

    public void setExtent(double value) {
        if (this.extent == value) {
            return;
        }
        this.extent = value;
        this.setNeedToRegenerate(true);
    }

    public void setNumVerts(int nverts) {
        this.nverts = nverts;
    }

    public void setArcType(int type) {
        this.arcType = type == 2 || type == 1 ? type : 0;
    }

    public int getArcType() {
        return this.arcType;
    }

    public void setRotationAngle(double angle) {
        this.rotationAngle = angle;
        this.setNeedToRegenerate(true);
    }

    public double getRotationAngle() {
        return this.rotationAngle;
    }

    @Override
    public void setNeedToRegenerate(boolean value) {
        super.setNeedToRegenerate(value);
        if (value) {
            this.polarShapeLine = null;
            this.correctFill = false;
        }
    }

    public boolean getPolarCorrection() {
        return this.correctPolar;
    }

    public void setPolarCorrection(boolean value) {
        this.correctPolar = value;
        this.setNeedToRegenerate(true);
    }

    protected boolean shouldCenterBeInShape() {
        return this.arcType == 2;
    }

    @Override
    public boolean generate(Projection proj) {
        this.polarShapeLine = null;
        this.correctFill = false;
        this.setNeedToRegenerate(true);
        if (proj == null) {
            Debug.message("omgraphic", "OMArc: null projection in generate!");
            return false;
        }
        GeneralPath projectedShape = null;
        switch (this.renderType) {
            case 3: {
                if (!proj.isPlotable(this.center)) {
                    this.setNeedToRegenerate(true);
                    return false;
                }
                Point2D p1 = proj.forward(this.center, new Point2D.Double());
                this.x1 = p1.getX() + this.off_x;
                this.y1 = p1.getY() + this.off_y;
            }
            case 2: {
                double x = this.x1 - this.width / 2.0;
                double y = this.y1 - this.height / 2.0;
                Shape arcShape = this.createArcShape(x, y, this.width, this.height);
                AffineTransform af = null;
                if (this.rotationAngle != 0.0) {
                    af = new AffineTransform();
                    af.rotate(this.rotationAngle, this.x1, this.y1);
                }
                PathIterator pi = arcShape.getPathIterator(af);
                projectedShape = new GeneralPath();
                projectedShape.append(pi, false);
                break;
            }
            case 1: {
                GeneralPath specialCaseShape = null;
                if (proj instanceof GeoProj) {
                    LatLonPoint llCenter = LatLonPoint.getDouble(this.center);
                    Point2D p = proj.forward(llCenter.getY(), llCenter.getX(), (Point2D)new Point2D.Double());
                    this.x1 = p.getX();
                    this.y1 = p.getY();
                    ArrayList<float[]> coordLists = this.getCoordLists((GeoProj)proj, llCenter, this.radius, this.nverts);
                    int size = coordLists.size();
                    for (int i = 0; i < size; i += 2) {
                        float[] xpoints = coordLists.get(i);
                        float[] ypoints = coordLists.get(i + 1);
                        GeneralPath gp = OMArc.createShape(xpoints, ypoints, this.arcType != 0 || this.arcType == 0 && !this.isClear(this.fillPaint));
                        projectedShape = OMArc.appendShapeEdge(projectedShape, gp, false);
                        boolean bl = this.correctFill = proj instanceof Cylindrical && (this.shouldCenterBeInShape() && projectedShape != null && !projectedShape.contains(this.x1, this.y1) || this.correctPolar);
                        if (!this.correctFill) continue;
                        float[][] alts = this.doPolarFillCorrection(xpoints, ypoints, llCenter.getRadLat() > 0.0 ? -1 : proj.getWidth() + 1);
                        int gp2length = alts[0].length - 2;
                        GeneralPath gp1 = OMArc.createShape(alts[0], alts[1], true);
                        GeneralPath gp2 = OMArc.createShape(alts[0], alts[1], 0, gp2length, false);
                        if (specialCaseShape == null || this.polarShapeLine == null) {
                            specialCaseShape = gp1;
                            this.polarShapeLine = gp2;
                            continue;
                        }
                        specialCaseShape.append(gp1, false);
                        this.polarShapeLine.append(gp2, false);
                    }
                } else {
                    double degRadius = Math.toDegrees(this.radius);
                    specialCaseShape = new GeneralPath(proj.forwardShape(new Arc2D.Double(this.center.getX() - degRadius, this.center.getY() - degRadius, 2.0 * degRadius, 2.0 * degRadius, this.start, this.extent, this.arcType)));
                }
                if (specialCaseShape == null) break;
                projectedShape = specialCaseShape;
                break;
            }
            case 0: {
                System.err.println("OMArc.generate(): invalid RenderType");
                return false;
            }
        }
        this.setShape(projectedShape);
        this.setNeedToRegenerate(false);
        return true;
    }

    protected Shape createArcShape(double x, double y, double fwidth, double fheight) {
        return new Arc2D.Double(x, y, fwidth, fheight, this.start, this.extent, this.arcType);
    }

    protected ArrayList<float[]> getCoordLists(GeoProj proj, LatLonPoint center, double radius, int nverts) {
        int at = this.arcType == 0 && !this.isClear(this.fillPaint) ? 1 : this.arcType;
        return proj.forwardArc(center, true, radius, nverts, ProjMath.degToRad(this.start), ProjMath.degToRad(this.extent), at);
    }

    public GeneralPath getPolarShapeLine() {
        return this.polarShapeLine;
    }

    private float[][] doPolarFillCorrection(float[] xpoints, float[] ypoints, int y1) {
        float[][] ret = new float[2][];
        int len = xpoints.length;
        float[] alt_xpts = new float[len + 2];
        float[] alt_ypts = new float[len + 2];
        System.arraycopy(xpoints, 0, alt_xpts, 0, len);
        System.arraycopy(ypoints, 0, alt_ypts, 0, len);
        alt_xpts[len] = alt_xpts[len - 1];
        alt_xpts[len + 1] = alt_xpts[0];
        alt_ypts[len] = y1;
        alt_ypts[len + 1] = alt_ypts[len];
        ret[0] = alt_xpts;
        ret[1] = alt_ypts;
        return ret;
    }

    @Override
    public void render(Graphics g) {
        if (!this.correctFill) {
            super.render(g);
        } else {
            GeneralPath s = this.getShape();
            if (!this.isRenderable(s)) {
                return;
            }
            if (this.shouldRenderFill()) {
                this.setGraphicsForFill(g);
                this.fill(g, s);
                if (this.textureMask != null && this.textureMask != this.fillPaint) {
                    this.setGraphicsColor(g, this.textureMask);
                    this.fill(g, s);
                }
            }
            if (this.shouldRenderEdge()) {
                this.setGraphicsForEdge(g);
                ((Graphics2D)g).draw(this.polarShapeLine);
            }
        }
    }

    @Override
    public Object clone() {
        OMArc clone = (OMArc)super.clone();
        clone.setNeedToRegenerate(true);
        if (this.center != null) {
            clone.center = (LatLonPoint)this.center.clone();
        }
        return clone;
    }

    @Override
    public void restore(OMGeometry source) {
        super.restore(source);
        if (source instanceof OMArc) {
            OMArc arc = (OMArc)source;
            this.x1 = arc.x1;
            this.y1 = arc.y1;
            this.off_x = arc.off_x;
            this.off_y = arc.off_y;
            Point2D center = arc.getCenter();
            if (center != null) {
                this.center = new LatLonPoint.Double(center);
            }
            this.radius = arc.radius;
            this.width = arc.width;
            this.height = arc.height;
            this.start = arc.start;
            this.extent = arc.extent;
            this.arcType = arc.arcType;
            this.nverts = arc.nverts;
            this.rotationAngle = arc.rotationAngle;
        }
    }
}

