/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.vpf;

import com.bbn.openmap.io.FormatException;
import com.bbn.openmap.layer.vpf.AreaTable;
import com.bbn.openmap.layer.vpf.CoordFloatString;
import com.bbn.openmap.layer.vpf.CoverageTable;
import com.bbn.openmap.layer.vpf.EdgeTable;
import com.bbn.openmap.layer.vpf.LayerGraphicWarehouseSupport;
import com.bbn.openmap.layer.vpf.MutableInt;
import com.bbn.openmap.layer.vpf.NodeTable;
import com.bbn.openmap.layer.vpf.TextTable;
import com.bbn.openmap.omGraphics.OMPoint;
import com.bbn.openmap.omGraphics.OMPoly;
import com.bbn.openmap.omGraphics.OMText;
import com.bbn.openmap.proj.coords.LatLonPoint;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VPFLayerDCWWarehouse
extends LayerGraphicWarehouseSupport {
    public static final String AreaTypeExcludeProperty = "areaTypeExclude";
    public static final String LineTypeExcludeProperty = "lineTypeExclude";
    public static final String TextTypeExcludeProperty = "textTypeExclude";
    protected int[] areaTypeExcludes = null;
    protected int[] lineTypeExcludes = null;
    protected int[] textTypeExcludes = null;
    protected boolean DEBUG = Debug.debugging("DCW");

    @Override
    public void setProperties(String prefix, Properties props) {
        super.setProperties(prefix, props);
        String realPrefix = PropUtils.getScopedPropertyPrefix(prefix);
        String list = props.getProperty(realPrefix + AreaTypeExcludeProperty);
        this.areaTypeExcludes = list != null ? this.getNumbersFromPropertyList(list) : this.getNumbersFromPropertyList("0 2");
        if (this.DEBUG) {
            Debug.output("Excluding area types: " + this.getDebugNumbers(this.areaTypeExcludes));
        }
        if ((list = props.getProperty(realPrefix + LineTypeExcludeProperty)) != null) {
            this.lineTypeExcludes = this.getNumbersFromPropertyList(list);
        }
        if (this.DEBUG) {
            Debug.output("Excluding area types: " + this.getDebugNumbers(this.lineTypeExcludes));
        }
        if ((list = props.getProperty(realPrefix + TextTypeExcludeProperty)) != null) {
            this.textTypeExcludes = this.getNumbersFromPropertyList(list);
        }
        if (this.DEBUG) {
            Debug.output("Excluding area types: " + this.getDebugNumbers(this.textTypeExcludes));
        }
    }

    protected String getDebugNumbers(int[] arr) {
        StringBuffer strBuf = new StringBuffer();
        if (arr != null) {
            for (int i : arr) {
                strBuf.append(i).append(" ");
            }
        }
        return strBuf.toString();
    }

    protected int[] getNumbersFromPropertyList(String list) {
        ArrayList<Integer> realList = new ArrayList<Integer>();
        Vector<String> excludes = PropUtils.parseSpacedMarkers(list);
        for (String number : excludes) {
            try {
                realList.add(Integer.valueOf(number));
            }
            catch (NumberFormatException nfe) {}
        }
        int[] numbers = null;
        if (!realList.isEmpty()) {
            numbers = new int[realList.size()];
            int count = 0;
            for (Integer realInt : realList) {
                numbers[count++] = realInt;
            }
        }
        return numbers;
    }

    protected boolean onList(int[] list, int num) {
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                if (num != list[i]) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public List<String> getFeatures() {
        return Collections.emptyList();
    }

    @Override
    public void createArea(CoverageTable covtable, AreaTable areatable, List<Object> facevec, LatLonPoint ll1, LatLonPoint ll2, double dpplat, double dpplon) {
        ArrayList<CoordFloatString> ipts = new ArrayList<CoordFloatString>();
        if (this.areaTypeExcludes != null) {
            MutableInt areatype = new MutableInt(-1);
            if (this.onList(this.areaTypeExcludes, areatype.value)) {
                return;
            }
        }
        int totalSize = 0;
        try {
            totalSize = areatable.computeEdgePoints(facevec, ipts);
        }
        catch (FormatException f) {
            Debug.output("FormatException in computeEdgePoints: " + f);
            return;
        }
        if (totalSize == 0) {
            return;
        }
        OMPoly py = VPFLayerDCWWarehouse.createAreaOMPoly(ipts, totalSize, ll1, ll2, dpplat, dpplon, covtable.doAntarcticaWorkaround);
        this.drawingAttributes.setTo(py);
        py.setLinePaint(py.getFillPaint());
        py.setSelectPaint(py.getFillPaint());
        this.graphics.add(py);
    }

    @Override
    public void createEdge(CoverageTable covtable, EdgeTable edgetable, List<Object> edgevec, LatLonPoint ll1, LatLonPoint ll2, double dpplat, double dpplon, CoordFloatString coords) {
        if (this.lineTypeExcludes != null) {
            MutableInt lineType = new MutableInt(-1);
            if (this.onList(this.lineTypeExcludes, lineType.value)) {
                return;
            }
        }
        OMPoly py = VPFLayerDCWWarehouse.createEdgeOMPoly(coords, ll1, ll2, dpplat, dpplon);
        this.drawingAttributes.setTo(py);
        py.setIsPolygon(false);
        this.graphics.add(py);
    }

    @Override
    public void createText(CoverageTable covtable, TextTable texttable, List<Object> textvec, double latitude, double longitude, String text) {
        if (this.textTypeExcludes != null) {
            MutableInt textType = new MutableInt(-1);
            if (this.onList(this.textTypeExcludes, textType.value)) {
                return;
            }
        }
        OMText txt = VPFLayerDCWWarehouse.createOMText(text, latitude, longitude);
        this.drawingAttributes.setTo(txt);
        this.graphics.add(txt);
    }

    @Override
    public void createNode(CoverageTable c, NodeTable t, List<Object> nodeprim, double latitude, double longitude, boolean isEntityNode) {
        OMPoint pt = VPFLayerDCWWarehouse.createOMPoint(latitude, longitude);
        this.drawingAttributes.setTo(pt);
        this.graphics.add(pt);
    }
}

