/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.link;

import com.bbn.openmap.layer.link.Link;
import com.bbn.openmap.layer.link.LinkGraphicConstants;
import com.bbn.openmap.layer.link.LinkPropertiesConstants;
import com.bbn.openmap.layer.link.LinkUtil;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.util.ColorFactory;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;

public class LinkProperties
extends Properties
implements LinkPropertiesConstants,
LinkGraphicConstants {
    public static final LinkProperties EMPTY_PROPERTIES = new LinkProperties(){

        public Object put(Object obj1, Object obj2) {
            return null;
        }

        public void putAll(Map map) {
        }
    };
    protected Boolean reuseProperties;
    protected Hashtable renderAttributesCache = new Hashtable();

    public LinkProperties() {
    }

    public LinkProperties(LinkProperties settings) {
        super(settings);
    }

    public LinkProperties(String keyString, String valueString) {
        this.setProperty(keyString, valueString);
    }

    public LinkProperties(Link link) throws IOException {
        this.read(link.dis);
    }

    public LinkProperties(DataInput dis) throws IOException {
        this.read(dis);
    }

    public Boolean getReuseProperties() {
        return this.reuseProperties;
    }

    public void setReuseProperties(Boolean reuseProperties) {
        this.reuseProperties = reuseProperties;
    }

    public synchronized Object setProperty(String key, String value) {
        return this.put(key, value);
    }

    public void write(Link link) throws IOException {
        this.write(link.dos);
    }

    public void write(DataOutputStream dos) throws IOException {
        dos.writeInt((this.size() + 1) * 2);
        dos.writeInt("p".length());
        dos.writeChars("p");
        if (this.reuseProperties == Boolean.TRUE) {
            dos.writeInt("R".length());
            dos.writeChars("R");
        } else {
            dos.writeInt("C".length());
            dos.writeChars("C");
        }
        Enumeration<?> e = this.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = this.getProperty(key);
            dos.writeInt(key.length());
            dos.writeChars(key);
            dos.writeInt(value.length());
            dos.writeChars(value);
        }
    }

    public void read(DataInput dis) throws IOException {
        int numArgs = dis.readInt();
        if (numArgs > 0) {
            this.readArgs(numArgs, dis);
        }
    }

    public void readArgs(int numArgs, DataInput dis) throws IOException {
        String[] argStrings = new String[numArgs];
        for (int i = 0; i < numArgs; i += 2) {
            int argLength = dis.readInt();
            if (i == 0 && argLength == 1 && dis.readChar() == 'p') {
                argLength = dis.readInt();
                if (argLength != 1 || dis.readChar() != 'C') continue;
                this.clear();
                continue;
            }
            argStrings[i] = LinkUtil.readString(dis, argLength);
            argLength = dis.readInt();
            argStrings[i + 1] = LinkUtil.readString(dis, argLength);
            this.put(argStrings[i], argStrings[i + 1]);
        }
        if (Debug.debugging("linkdetail")) {
            System.out.println("LinkProperties | Read:  " + this);
        }
    }

    public static LinkProperties read(DataInput dis, LinkProperties props) throws IOException {
        int numArgs = dis.readInt();
        if (numArgs == 0) {
            return EMPTY_PROPERTIES;
        }
        if (props == null) {
            props = new LinkProperties();
        }
        props.readArgs(numArgs, dis);
        return props;
    }

    public static LinkProperties loadPropertiesIntoOMGraphic(DataInput dis, OMGraphic omg, LinkProperties propertiesBuffer) throws IOException {
        LinkProperties readProperties = (LinkProperties)LinkProperties.read(dis, propertiesBuffer).clone();
        readProperties.setProperties(omg);
        return readProperties;
    }

    public void setProperties(OMGraphic omg) {
        if (omg == null) {
            return;
        }
        omg.setLinePaint(this.getPaint("lc", "FF000000"));
        omg.setFillPaint(this.getFillPaint());
        omg.setSelectPaint(this.getPaint("hc", "FF000000"));
        omg.setStroke(this.getStroke());
        if (this != EMPTY_PROPERTIES) {
            omg.setAppObject(this);
        }
    }

    public Stroke getStroke() {
        int lineWidth = PropUtils.intFromProperties(this, "lw", 1);
        String strokeString = this.getProperty("ls");
        int cap = 2;
        int join = 0;
        float miterLimit = 10.0f;
        float dashPhase = 0.0f;
        Stroke stroke = null;
        float[] dash = null;
        String strokeCode = "stroke" + lineWidth + strokeString;
        stroke = (Stroke)this.renderAttributesCache.get(strokeCode);
        if (stroke != null) {
            return stroke;
        }
        if (strokeString != null) {
            if (strokeString.equalsIgnoreCase("LD")) {
                dash = new float[]{10.0f, 10.0f};
            } else if (strokeString.equalsIgnoreCase("DA")) {
                dash = new float[]{6.0f, 6.0f};
            } else if (strokeString.equalsIgnoreCase("D")) {
                dash = new float[]{3.0f, 6.0f};
            } else if (strokeString.equalsIgnoreCase("DAD")) {
                dash = new float[]{6.0f, 6.0f, 3.0f, 6.0f};
            } else if (strokeString.equalsIgnoreCase("DADD")) {
                dash = new float[]{6.0f, 6.0f, 3.0f, 6.0f, 3.0f, 6.0f};
            }
            if (dash != null) {
                stroke = new BasicStroke(lineWidth, cap, join, miterLimit, dash, dashPhase);
            }
        }
        if (stroke == null) {
            stroke = new BasicStroke(lineWidth);
        }
        this.renderAttributesCache.put(strokeCode, stroke);
        return stroke;
    }

    public Paint getPaint(String paintProperty, String defaultPaintString) {
        Paint paint = null;
        String paintKey = "paint" + this.getProperty(paintProperty);
        if (paintProperty != null) {
            paint = (Paint)this.renderAttributesCache.get(paintKey);
            if (paint == null) {
                paint = (Paint)this.renderAttributesCache.get("paint" + defaultPaintString);
            }
            if (paint != null) {
                return paint;
            }
        }
        paint = paintProperty != null && defaultPaintString != null ? ColorFactory.parseColorFromProperties(this, paintProperty, defaultPaintString, true) : Color.black;
        this.renderAttributesCache.put(paintKey, paint);
        return paint;
    }

    public Paint getFillPaint() {
        Paint fillPaint = this.getPaint("fc", "00000000");
        String fillPatternString = this.getProperty("fp");
        if (fillPatternString == null || fillPatternString.equalsIgnoreCase("S")) {
            return fillPaint;
        }
        String fillPaintString = this.getProperty("fc");
        String texturePaintKey = "fill" + fillPaintString + fillPatternString;
        if (fillPaintString == null) {
            fillPaint = Color.black;
            TexturePaint ret = (TexturePaint)this.renderAttributesCache.get("fill" + fillPaint + fillPatternString);
            if (ret != null) {
                return ret;
            }
            ret = (TexturePaint)this.renderAttributesCache.get(texturePaintKey);
            if (ret != null) {
                return ret;
            }
        }
        BufferedImage bi = new BufferedImage(8, 8, 2);
        Graphics2D big = bi.createGraphics();
        big.setColor(new Color(0, true));
        big.fillRect(0, 0, 8, 8);
        big.setPaint(fillPaint);
        if (fillPatternString.equalsIgnoreCase("H")) {
            big.draw(new Line2D.Double(0.0, 0.0, 7.0, 0.0));
            big.draw(new Line2D.Double(0.0, 4.0, 7.0, 4.0));
        } else if (fillPatternString.equalsIgnoreCase("V")) {
            big.draw(new Line2D.Double(0.0, 0.0, 0.0, 7.0));
            big.draw(new Line2D.Double(4.0, 0.0, 4.0, 7.0));
        } else if (fillPatternString.equalsIgnoreCase("C")) {
            big.draw(new Line2D.Double(0.0, 0.0, 7.0, 0.0));
            big.draw(new Line2D.Double(0.0, 4.0, 7.0, 4.0));
            big.draw(new Line2D.Double(0.0, 0.0, 0.0, 7.0));
            big.draw(new Line2D.Double(4.0, 0.0, 4.0, 7.0));
        } else if (fillPatternString.equalsIgnoreCase("DC")) {
            big.draw(new Line2D.Double(0.0, 0.0, 7.0, 7.0));
            big.draw(new Line2D.Double(0.0, 4.0, 3.0, 7.0));
            big.draw(new Line2D.Double(4.0, 0.0, 7.0, 3.0));
            big.draw(new Line2D.Double(0.0, 7.0, 7.0, 0.0));
            big.draw(new Line2D.Double(0.0, 3.0, 3.0, 0.0));
            big.draw(new Line2D.Double(4.0, 7.0, 7.0, 4.0));
        } else if (fillPatternString.equalsIgnoreCase("BD")) {
            big.draw(new Line2D.Double(0.0, 0.0, 7.0, 7.0));
            big.draw(new Line2D.Double(0.0, 4.0, 3.0, 7.0));
            big.draw(new Line2D.Double(4.0, 0.0, 7.0, 3.0));
        } else if (fillPatternString.equalsIgnoreCase("FD")) {
            big.draw(new Line2D.Double(0.0, 7.0, 7.0, 0.0));
            big.draw(new Line2D.Double(0.0, 3.0, 3.0, 0.0));
            big.draw(new Line2D.Double(4.0, 7.0, 7.0, 4.0));
        } else {
            big.fillRect(0, 0, 8, 8);
        }
        Rectangle r = new Rectangle(0, 0, 8, 8);
        TexturePaint texturePaint = new TexturePaint(bi, r);
        this.renderAttributesCache.put(texturePaintKey, texturePaint);
        return texturePaint;
    }
}

