/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.gui.time;

import com.bbn.openmap.LayerHandler;
import com.bbn.openmap.MapBean;
import com.bbn.openmap.MapHandler;
import com.bbn.openmap.MouseDelegator;
import com.bbn.openmap.event.SelectMouseMode;
import com.bbn.openmap.gui.BasicMapPanel;
import com.bbn.openmap.gui.time.ITimeBoundsUserActionsListener;
import com.bbn.openmap.gui.time.TimeSliderLayer;
import com.bbn.openmap.proj.Cartesian;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Point2D;
import javax.swing.BorderFactory;

public class TimeSliderPanel
extends BasicMapPanel {
    protected TimeSliderLayer timeSliderLayer;

    public TimeSliderPanel(boolean realTimeMode) {
        super(true);
        this.setLayout(new BorderLayout());
        Cartesian cartesian = new Cartesian(new Point2D.Double(), 300000.0f, 600, 20);
        MapBean mapBean = this.getMapBean();
        mapBean.setProjection(cartesian);
        mapBean.setMinimumSize(new Dimension(10, 20));
        mapBean.setBorder(BorderFactory.createEmptyBorder());
        mapBean.setBckgrnd(this.getBackground());
        MapHandler mh = this.getMapHandler();
        mh.add(new LayerHandler());
        mh.add(new MouseDelegator());
        mh.add(new TimeSliderMouseMode());
        this.timeSliderLayer = new TimeSliderLayer(realTimeMode);
        mh.add(this.timeSliderLayer);
        mh.add(this.timeSliderLayer.getTimeLabels());
    }

    public TimeSliderLayer getTimeSliderLayer() {
        return this.timeSliderLayer;
    }

    public void setTimeSliderLayer(TimeSliderLayer timeSliderLayer) {
        this.timeSliderLayer = timeSliderLayer;
    }

    public void addTimeBoundsUserActionsListener(ITimeBoundsUserActionsListener timeBoundsUserActionsListener) {
        this.timeSliderLayer.addTimeBoundsUserActionsListener(timeBoundsUserActionsListener);
    }

    public void removeTimeBoundsUserActionsListener(ITimeBoundsUserActionsListener timeBoundsUserActionsListener) {
        this.timeSliderLayer.removeTimeBoundsUserActionsListener(timeBoundsUserActionsListener);
    }

    public void setUserHasChangedScale(boolean userHasChangedScale) {
        this.timeSliderLayer.setUserHasChangedScale(userHasChangedScale);
    }

    public static class TimeSliderMouseMode
    extends SelectMouseMode {
        public void mouseWheelMoved(MouseWheelEvent e) {
        }
    }
}

