/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.gui;

import com.bbn.openmap.Environment;
import com.bbn.openmap.I18n;
import com.bbn.openmap.Layer;
import com.bbn.openmap.LayerHandler;
import com.bbn.openmap.layer.SinkLayer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.Serializable;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;

public class LayerPane
extends JPanel
implements Serializable,
ActionListener,
ComponentListener {
    public static Logger logger = Logger.getLogger("com.bbn.openmap.gui.LayerPane");
    protected transient AbstractButton onoffButton;
    protected transient AbstractButton paletteButton;
    protected transient JToggleButton layerName;
    protected transient boolean selected;
    protected transient Layer layer;
    protected transient LayerHandler layerHandler;
    protected static transient URL url1 = LayerPane.class.getResource("PaletteOff.gif");
    protected static transient ImageIcon paletteIcon = new ImageIcon(url1, "Palette");
    protected static transient URL url2 = LayerPane.class.getResource("PaletteOn.gif");
    protected static transient ImageIcon paletteOnIcon = new ImageIcon(url2, "Palette on");
    protected static transient URL url3 = LayerPane.class.getResource("BulbOn.gif");
    protected static transient ImageIcon layerOnIcon = new ImageIcon(url3, "Layer selected");
    protected static transient URL url4 = LayerPane.class.getResource("BulbOff.gif");
    protected static transient ImageIcon layerOffIcon = new ImageIcon(url4, "Layer not selected");
    public static final transient String showPaletteCmd = "showPalette";
    public static final transient String toggleLayerCmd = "toggleLayerCmd";
    protected Color offColor;
    protected Color onColor = new Color(-16750900);
    protected I18n i18n = Environment.getI18n();

    public LayerPane(Layer layer, LayerHandler layerHandler, ButtonGroup bg) {
        this.layer = layer;
        this.setLayerHandler(layerHandler);
        this.createGUI(bg);
        layer.addComponentListener(this);
    }

    protected void createGUI(ButtonGroup bg) {
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(gridbag);
        this.layerName = new JToggleButton(this.layer.getName());
        this.layerName.setBorderPainted(false);
        this.layerName.addActionListener(this);
        this.offColor = this.layerName.getBackground();
        this.layerName.setToolTipText(this.i18n.get(LayerPane.class, "layerName.tooltip", "Click to select layer"));
        this.layerName.setHorizontalAlignment(2);
        bg.add(this.layerName);
        c.gridy = 0;
        c.gridx = -1;
        c.anchor = 17;
        c.insets = new Insets(0, 0, 0, 0);
        this.onoffButton = this.getOnOffButton();
        gridbag.setConstraints(this.onoffButton, c);
        this.add(this.onoffButton);
        this.paletteButton = this.getPaletteButton();
        gridbag.setConstraints(this.paletteButton, c);
        this.add(this.paletteButton);
        c.weightx = 1.0;
        c.fill = 2;
        gridbag.setConstraints(this.layerName, c);
        this.add(this.layerName);
    }

    protected AbstractButton createOnOffButton() {
        return new JCheckBox(layerOffIcon);
    }

    protected AbstractButton getOnOffButton() {
        AbstractButton onoffButton = this.createOnOffButton();
        onoffButton.setSelectedIcon(layerOnIcon);
        onoffButton.setActionCommand(toggleLayerCmd);
        onoffButton.addActionListener(this);
        String interString = this.i18n.get(LayerPane.class, "onoffButton.tooltip", "Turn \"{0}\" layer on/off", (Object)this.layer.getName());
        onoffButton.setToolTipText(interString);
        onoffButton.setSelected(this.layer.isVisible());
        return onoffButton;
    }

    protected AbstractButton createPaletteButton() {
        return new JCheckBox(paletteIcon);
    }

    protected AbstractButton getPaletteButton() {
        String interString;
        AbstractButton paletteButton = this.createPaletteButton();
        paletteButton.setSelectedIcon(paletteOnIcon);
        paletteButton.setBorderPainted(false);
        if (!this.layer.hasGUI()) {
            interString = this.i18n.get(LayerPane.class, "paletteButton.noPaletteAvailable.tooltip", "No tools available for \"{0}\" layer", (Object)this.layer.getName());
            paletteButton.setEnabled(false);
        } else {
            interString = this.i18n.get(LayerPane.class, "paletteButton.paletteAvailable.tooltip", "Display tools for \"{0}\" layer", (Object)this.layer.getName());
        }
        paletteButton.setToolTipText(interString);
        paletteButton.setActionCommand(showPaletteCmd);
        paletteButton.addActionListener(this);
        return paletteButton;
    }

    protected LayerPane(String title) {
        this.layer = SinkLayer.getSharedInstance();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(gridbag);
        JSeparator sep = new JSeparator();
        sep.setToolTipText(title);
        c.anchor = 17;
        c.weightx = 1.0;
        c.fill = 2;
        gridbag.setConstraints(sep, c);
        this.add(sep);
    }

    public void setLayerHandler(LayerHandler in_layerHandler) {
        this.layerHandler = in_layerHandler;
    }

    protected LayerHandler getLayerHandler() {
        return this.layerHandler;
    }

    public void cleanup(ButtonGroup bg) {
        if (bg != null) {
            bg.remove(this.layerName);
        }
        this.cleanup();
    }

    public void cleanup() {
        this.layerName.setSelected(false);
        if (this.layer != null) {
            this.layer.setPaletteVisible(false);
            this.layer.removeComponentListener(this);
        }
        if (this.onoffButton != null) {
            this.onoffButton.removeActionListener(this);
        }
        if (this.paletteButton != null) {
            this.paletteButton.removeActionListener(this);
        }
        this.layerName = null;
        this.layer = null;
        this.layerHandler = null;
        this.removeAll();
    }

    public Dimension getPreferredSize() {
        return new Dimension(200, 32);
    }

    public Dimension getMinimumSize() {
        return new Dimension(100, 20);
    }

    public boolean isLayerOn() {
        return this.onoffButton.isSelected();
    }

    public void setLayerOn(boolean value) {
        this.onoffButton.setSelected(value);
    }

    public boolean isPaletteOn() {
        return this.paletteButton.isSelected();
    }

    public void setPaletteOn(boolean value) {
        this.paletteButton.setSelected(value);
    }

    public boolean isSelected() {
        return this.layerName.isSelected();
    }

    public void setSelected(boolean select) {
        String command;
        String string = command = select ? "LayerSelected" : "LayerDeselected";
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("LayerPane for " + this.getLayer().getName() + " " + command + ", firing event");
        }
        if (select) {
            this.setBorder(BorderFactory.createLoweredBevelBorder());
        } else {
            this.setBorder(null);
        }
        this.firePropertyChange(command, null, this.getLayer());
    }

    public Layer getLayer() {
        return this.layer;
    }

    public void updateLayerLabel() {
        this.layerName.setText(this.getLayer().getName());
    }

    protected void showPalette() {
        this.layer.showPalette();
        this.setPaletteOn(true);
    }

    protected void hidePalette() {
        this.layer.hidePalette();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.paletteButton)) {
            this.layerName.doClick();
            this.showPalette();
        } else if (e.getSource().equals(this.onoffButton)) {
            this.layerName.doClick();
            if (this.layerHandler != null) {
                logger.fine("LayerPane|actionPerformed calling layerHandler.turnLayerOn()");
                this.layerHandler.turnLayerOn(this.onoffButton.isSelected(), this.layer);
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Layer " + this.layer.getName() + (this.layer.isVisible() ? " is visible." : " is NOT visible"));
            }
        } else if (e.getSource().equals(this.layerName)) {
            this.setSelected(this.layerName.isSelected());
        }
    }

    public void componentResized(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
        Component comp;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("layer pane for " + this.layer.getName() + " receiving componentShown event");
        }
        if ((comp = e.getComponent()) != null) {
            if (comp == this.layer) {
                if (!this.isLayerOn()) {
                    this.setLayerOn(true);
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("layer " + this.layer.getName() + " is now visible.");
                    }
                }
            } else if (comp == this.layer.getPalette()) {
                this.setPaletteOn(true);
            }
        }
    }

    public void componentHidden(ComponentEvent e) {
        Component comp;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("layer pane for " + this.layer.getName() + " receiving componentHidden event");
        }
        if ((comp = e.getComponent()) == this.layer) {
            if (this.isLayerOn()) {
                this.setLayerOn(false);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("layer " + this.layer.getName() + " is now hidden.");
                }
            }
        } else if (comp == this.layer.getPalette()) {
            this.setPaletteOn(false);
        } else if (comp == null && logger.isLoggable(Level.FINE)) {
            logger.fine("layer " + this.layer.getName() + " is now hidden.");
        }
    }

    public static LayerPane getBackgroundLayerSeparator(String title) {
        return new LayerPane(title);
    }
}

