/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.gui;

import com.bbn.openmap.BufferedLayerMapBean;
import com.bbn.openmap.Environment;
import com.bbn.openmap.MapBean;
import com.bbn.openmap.MapHandler;
import com.bbn.openmap.PropertyHandler;
import com.bbn.openmap.gui.MapPanel;
import com.bbn.openmap.gui.MapPanelChild;
import com.bbn.openmap.gui.OMComponentPanel;
import com.bbn.openmap.gui.menu.MenuList;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.proj.ProjectionFactory;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicMapPanel
extends OMComponentPanel
implements MapPanel {
    public static Logger logger = Logger.getLogger("com.bbn.openmap.gui.MapPanel");
    public static final String SET_NAME_PROPERTY = "setName";
    protected MapHandler mapHandler;
    protected MapBean mapBean;
    protected PropertyHandler propertyHandler;
    protected MenuList menuList;
    protected boolean setName = false;

    public BasicMapPanel() {
        this(new PropertyHandler(new Properties()), false);
    }

    public BasicMapPanel(boolean delayCreation) {
        this((PropertyHandler)null, delayCreation);
    }

    public BasicMapPanel(PropertyHandler propertyHandler) {
        this(propertyHandler, false);
    }

    public BasicMapPanel(PropertyHandler propertyHandler, boolean delayCreation) {
        MapHandler mh = this.getMapHandler();
        mh.add(this);
        this.setPropertyHandler(propertyHandler);
        if (!delayCreation) {
            this.create();
        }
    }

    @Override
    public void setProperties(String prefix, Properties props) {
        String scopedPrefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.setSetName(PropUtils.booleanFromProperties(props, scopedPrefix + SET_NAME_PROPERTY, this.isSetName()));
        if (this.isSetName()) {
            super.setProperties(prefix, props);
        }
    }

    public void create() {
        this.setLayout(this.createLayoutManager());
        this.createComponents();
    }

    protected LayoutManager createLayoutManager() {
        return new BorderLayout();
    }

    protected void addMapBeanToPanel(MapBean map) {
        this.add((Component)map, "Center");
    }

    protected void createComponents() {
        PropertyHandler ph = this.getPropertyHandler();
        MapBean mb = this.getMapBean();
        MapHandler mh = this.getMapHandler();
        ph.createComponents(this.getMapHandler());
        ProjectionFactory obj = mh.get(ProjectionFactory.class);
        if (obj == null) {
            Debug.message("basic", "BasicMapPanel adding ProjectionFactory and projections to MapHandler since there are none to be found.");
            mh.add(ProjectionFactory.loadDefaultProjections());
        }
        mb.setProjection(mb.getProjectionFactory().getDefaultProjectionFromEnvironment(Environment.getInstance()));
        mb.setBckgrnd(Environment.getCustomBackgroundColor());
    }

    @Override
    public MapBean getMapBean() {
        if (this.mapBean == null) {
            this.setMapBean(BasicMapPanel.createMapBean());
        }
        return this.mapBean;
    }

    public void setMapBean(MapBean bean) {
        if (bean == null && this.mapBean != null) {
            this.getMapHandler().remove(this.mapBean);
        }
        this.mapBean = bean;
        if (this.mapBean != null) {
            this.getMapHandler().add(this.mapBean);
            this.addMapBeanToPanel(this.mapBean);
        }
    }

    public PropertyHandler getPropertyHandler() {
        if (this.propertyHandler == null) {
            this.setPropertyHandler(new PropertyHandler());
        }
        return this.propertyHandler;
    }

    public void setPropertyHandler(PropertyHandler handler) {
        this.propertyHandler = handler;
        if (handler != null) {
            this.getMapHandler().add(handler);
            this.setProperties(handler.getPropertyPrefix(), handler.getProperties());
        }
    }

    @Override
    public MapHandler getMapHandler() {
        if (this.mapHandler == null) {
            this.mapHandler = new MapHandler();
        }
        return this.mapHandler;
    }

    @Override
    public JMenuBar getMapMenuBar() {
        if (this.menuList != null) {
            return this.menuList.getMenuBar();
        }
        return null;
    }

    @Override
    public JMenu getMapMenu() {
        if (this.menuList != null) {
            return this.menuList.getMenu();
        }
        return null;
    }

    public void addMapComponent(Object mapComponent) {
        if (mapComponent != null) {
            this.getMapHandler().add(mapComponent);
        }
    }

    public boolean removeMapComponent(Object mapComponent) {
        if (mapComponent != null) {
            return this.getMapHandler().remove(mapComponent);
        }
        return true;
    }

    public Object getMapComponentByType(Class<?> c) {
        return this.getMapHandler().get(c);
    }

    public Collection<?> getMapComponentsByType(Class<?> c) {
        return this.getMapHandler().getAll(c);
    }

    public Object getMapComponent(String prefix) {
        return this.getPropertyHandler().get(prefix);
    }

    @Override
    public void findAndInit(Object someObj) {
        if (someObj instanceof MapPanelChild && someObj instanceof Component) {
            boolean makeMyChild;
            String parentName = ((MapPanelChild)someObj).getParentName();
            boolean hasNamedParent = parentName != null && parentName.trim().length() != 0;
            String myName = this.getPropertyPrefix();
            boolean hasName = myName != null && myName.trim().length() != 0;
            boolean bl = makeMyChild = hasName && hasNamedParent && myName.equalsIgnoreCase(parentName) || !hasName && !hasNamedParent;
            if (makeMyChild) {
                if (Debug.debugging("basic")) {
                    Debug.output("MapPanel: adding " + someObj.getClass().getName());
                }
                MapPanelChild mpc = (MapPanelChild)someObj;
                this.addMapPanelChild(mpc);
                this.invalidate();
            } else if (logger.isLoggable(Level.FINE)) {
                logger.fine("MapPanel with name: " + myName + " not adding child (" + someObj.getClass().getName() + ") looking for: " + parentName);
            }
        }
        if (someObj instanceof MenuList) {
            this.menuList = (MenuList)someObj;
        }
    }

    protected void addMapPanelChild(MapPanelChild mpc) {
        this.add((Component)((Object)mpc), mpc.getPreferredLocation());
    }

    @Override
    public void findAndUndo(Object someObj) {
        if (someObj instanceof MapPanelChild && someObj instanceof Component) {
            if (Debug.debugging("basic")) {
                Debug.output("MapPanel: removing " + someObj.getClass().getName());
            }
            this.remove((Component)someObj);
            this.invalidate();
        }
        if (someObj instanceof MenuList && this.menuList == someObj) {
            this.menuList = null;
        }
        if (this.equals(someObj)) {
            this.dispose();
        }
    }

    @Override
    public void dispose() {
        this.setMapBean(null);
        this.setLayout(null);
        this.removeAll();
    }

    public static MapBean createMapBean() {
        int envWidth = Environment.getInteger("openmap.Width", 640);
        int envHeight = Environment.getInteger("openmap.Height", 480);
        if (envWidth <= 0 || envHeight <= 0) {
            Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
            if (envWidth <= 0) {
                envWidth = (int)d.getWidth();
            }
            if (envHeight <= 0) {
                envHeight = (int)d.getHeight();
            }
        }
        Projection proj = new ProjectionFactory().getDefaultProjectionFromEnvironment(Environment.getInstance());
        if (Debug.debugging("mappanel")) {
            Debug.output("MapPanel: creating MapBean with initial projection " + proj);
        }
        return BasicMapPanel.createMapBean(proj, new BevelBorder(1));
    }

    public static MapBean createMapBean(Projection proj, Border border) {
        BufferedLayerMapBean mapBeano = new BufferedLayerMapBean();
        mapBeano.setBorder(border);
        mapBeano.setProjection(proj);
        mapBeano.setPreferredSize(new Dimension(proj.getWidth(), proj.getHeight()));
        return mapBeano;
    }

    public Properties getProperties() {
        return this.getPropertyHandler().getProperties();
    }

    public boolean removeProperty(String property) {
        return this.getPropertyHandler().removeProperty(property);
    }

    public void addProperty(String property, String value) {
        this.getPropertyHandler().addProperty(property, value);
    }

    public void addProperties(URL urlToProperties) {
        this.getPropertyHandler().addProperties(urlToProperties);
    }

    public void addProperties(String propFile) throws MalformedURLException {
        this.getPropertyHandler().addProperties(propFile);
    }

    public void removeMarker(String property, String marker) {
        this.getPropertyHandler().removeMarker(property, marker);
    }

    public void addProperties(Properties p) {
        this.getPropertyHandler().addProperties(p);
    }

    public void appendProperty(String property, Properties src) {
        this.getPropertyHandler().appendProperty(property, src);
    }

    public void appendProperty(String property, String value) {
        this.getPropertyHandler().appendProperty(property, value);
    }

    public void prependProperty(String property, Properties src) {
        this.getPropertyHandler().prependProperty(property, src);
    }

    public void prependProperty(String property, String value) {
        this.getPropertyHandler().prependProperty(property, value);
    }

    public boolean isSetName() {
        return this.setName;
    }

    public void setSetName(boolean setName) {
        this.setName = setName;
    }
}

